/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.vo.User;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.KeyStore;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ProxyPasswordUtil {
    private static final byte[] bl_BYTES = "bl".getBytes();
    private static final char[] PWD = "HP6DorNBCf".toCharArray();
    private static final String PWD_ENCODING = "ISO-8859-1";

    public static char[] getProxyPassword(byte[] encryptedData) throws UnsupportedEncodingException, InvalidPasswordException, IOException {
        return ProxyPasswordUtil.getProxyPasswordAsString(encryptedData).toCharArray();
    }

    public static String getProxyPasswordAsString(byte[] encryptedData) throws UnsupportedEncodingException, InvalidPasswordException, IOException {
        return ProxyPasswordUtil.getAsString(ProxyPasswordUtil.decryptWithStaticPassword(encryptedData));
    }

    public static char[] getProxyPassword(User user, char[] loginPassword, byte[] encryptedData) throws UnsupportedEncodingException, InvalidPasswordException, IOException {
        if (ProxyPasswordUtil.isEncryptedWithLoginPassword(encryptedData)) {
            byte[] proxyPassword = ProxyPasswordUtil.decryptProxyPassword(loginPassword, encryptedData);
            return ProxyPasswordUtil.getAsString(proxyPassword).toCharArray();
        }
        byte[] proxyPassword = ProxyPasswordUtil.decryptWithStaticPassword(encryptedData);
        byte[] newEncryptedData = ProxyPasswordUtil.encryptProxyPassword(loginPassword, proxyPassword);
        user.setProxyPassword(newEncryptedData);
        user.save();
        return ProxyPasswordUtil.getAsString(proxyPassword).toCharArray();
    }

    public static String getProxyPasswordAsString(char[] loginPassword, byte[] encryptedData) throws UnsupportedEncodingException, InvalidPasswordException, IOException {
        return ProxyPasswordUtil.getAsString(ProxyPasswordUtil.decryptProxyPassword(loginPassword, encryptedData));
    }

    private static String getAsString(byte[] password) throws UnsupportedEncodingException {
        return new String(password, PWD_ENCODING);
    }

    public static boolean isEncryptedWithLoginPassword(byte[] encryptedData) {
        return encryptedData != null && encryptedData.length > 2 && encryptedData[0] == bl_BYTES[0] && encryptedData[1] == bl_BYTES[1];
    }

    public static byte[] encryptWithNewLoginPassword(char[] oldLoginPassword, char[] newLoginPassword, byte[] encryptedData) throws UnsupportedEncodingException, InvalidPasswordException, IOException {
        byte[] proxyPassword = ProxyPasswordUtil.decryptProxyPassword(oldLoginPassword, encryptedData);
        return ProxyPasswordUtil.encryptProxyPassword(newLoginPassword, proxyPassword);
    }

    public static byte[] encryptWithLoginPassword(char[] loginPassword, String proxyPassword) throws UnsupportedEncodingException, InvalidPasswordException, IOException {
        if (proxyPassword != null && proxyPassword.trim().length() > 0) {
            return ProxyPasswordUtil.encryptProxyPassword(loginPassword, ProxyPasswordUtil.getAsBytes(proxyPassword.trim()));
        }
        return null;
    }

    private static byte[] encryptProxyPassword(char[] loginPassword, byte[] proxyPassword) throws UnsupportedEncodingException, InvalidPasswordException, IOException {
        byte[] encryptedPwd = KeyStore.encryptData(proxyPassword, loginPassword);
        byte[] encryptedData = new byte[encryptedPwd.length + 2];
        encryptedData[0] = bl_BYTES[0];
        encryptedData[1] = bl_BYTES[1];
        for (int i = 0; i < encryptedPwd.length; ++i) {
            encryptedData[i + 2] = encryptedPwd[i];
        }
        return encryptedData;
    }

    private static byte[] decryptProxyPassword(char[] loginPassword, byte[] encryptedData) throws UnsupportedEncodingException, InvalidPasswordException {
        byte[] encryptedPwd = Arrays.copyOfRange(encryptedData, bl_BYTES.length, encryptedData.length);
        return KeyStore.decryptData(encryptedPwd, loginPassword);
    }

    public static byte[] encryptWithStaticPassword(String proxyPassword) throws UnsupportedEncodingException, InvalidPasswordException, IOException {
        if (proxyPassword != null && proxyPassword.trim().length() > 0) {
            return KeyStore.encryptData(ProxyPasswordUtil.getAsBytes(proxyPassword.trim()), PWD);
        }
        return null;
    }

    private static byte[] decryptWithStaticPassword(byte[] encryptedPwd) throws UnsupportedEncodingException, InvalidPasswordException {
        return KeyStore.decryptData(encryptedPwd, PWD);
    }

    private static byte[] getAsBytes(String password) throws UnsupportedEncodingException {
        if (password != null) {
            return password.getBytes(PWD_ENCODING);
        }
        return null;
    }
}

