/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.ProtocolListenerDS;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.BTF;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.ptk2.Action;
import de.businesslogics.format.ptk2.Result;
import io.ebean.Query;
import java.sql.Timestamp;
import java.util.List;

public class ProtocolUtil {
    private static final long ONE_DAY = 86400000L;
    private static final long THIRTY_DAYS = 2592000000L;

    private static Timestamp getMinTime(Timestamp sendTime) {
        return new Timestamp(sendTime.getTime() - 86400000L);
    }

    private static Timestamp getMinTimeDS(Timestamp sendTime) {
        return new Timestamp(sendTime.getTime() - 2592000000L);
    }

    private static Timestamp getMaxTime(Timestamp sendTime) {
        return new Timestamp(sendTime.getTime() + 2592000000L);
    }

    public static boolean hasHacEntries(DsOrderDetails dsOrderDetails) {
        return ProtocolUtil.hasHacEntries(dsOrderDetails.getBank(), dsOrderDetails.getFileType(), dsOrderDetails.getOrderId(), dsOrderDetails.getSubmissionDate());
    }

    private static boolean hasHacEntries(BankSettings bank, String generalizedOrderType, String orderNumber, Timestamp sendTime) {
        if (Util.isOrderType(generalizedOrderType)) {
            return HacEntry.countByOrderType(bank, generalizedOrderType, orderNumber, ProtocolUtil.getMinTime(sendTime), ProtocolUtil.getMaxTime(sendTime)) > 0;
        }
        return HacEntry.countByFileType(bank, generalizedOrderType, orderNumber, ProtocolUtil.getMinTime(sendTime), ProtocolUtil.getMaxTime(sendTime)) > 0;
    }

    public static Query<HacEntry> getHacEntries(Send send) {
        Query<HacEntry> fromOriginalSendType = ProtocolUtil.getHacEntries(send.getBank(), send.getBank().getCustomerId(), send.getOriginalSendType(), send.getOrderNumber(), send.getSent(), false);
        if (fromOriginalSendType.findCount() == 0 && Util.isOrderType(send.getOriginalSendType()) && send.getBTF() != null) {
            Query<HacEntry> fromBtf = ProtocolUtil.getHacEntries(send.getBank(), send.getBank().getCustomerId(), send.getBTF(), send.getOrderNumber(), send.getSent(), false);
            return fromBtf;
        }
        return fromOriginalSendType;
    }

    public static Query<HacEntry> getHacEntries(DsOrderDetails dsOrderDetails) {
        return ProtocolUtil.getHacEntries(dsOrderDetails.getBank(), dsOrderDetails.getCustomerId(), dsOrderDetails.getFileType(), dsOrderDetails.getOrderId(), dsOrderDetails.getSubmissionDate(), true);
    }

    private static Query<HacEntry> getHacEntries(BankSettings bank, String customerId, String generalizedOrderType, String orderNumber, Timestamp sendTime, boolean forDsOrderDetails) {
        BTF btf;
        Timestamp minTime = forDsOrderDetails ? ProtocolUtil.getMinTimeDS(sendTime) : ProtocolUtil.getMinTime(sendTime);
        Timestamp maxTime = ProtocolUtil.getMaxTime(sendTime);
        if (Util.isOrderType(generalizedOrderType)) {
            return HacEntry.queryByOrderType(bank, customerId, generalizedOrderType, orderNumber, minTime, maxTime);
        }
        Query<HacEntry> originalQuery = HacEntry.queryByFileType(bank, customerId, generalizedOrderType, orderNumber, minTime, maxTime);
        if (originalQuery.findCount() == 0 && (btf = BTF.fromString(generalizedOrderType)) != null) {
            ProtocolUtil.reduceMsgElements(btf);
            String reducedBtf = btf.toString();
            if (!reducedBtf.equals(generalizedOrderType)) {
                return HacEntry.queryByFileType(bank, customerId, reducedBtf, orderNumber, minTime, maxTime);
            }
        }
        return originalQuery;
    }

    public static Query<HacEntry> getHacEntries(DsOrderDetails dsOrderDetails, Integer action) {
        return ProtocolUtil.getHacEntries(dsOrderDetails.getBank(), dsOrderDetails.getCustomerId(), dsOrderDetails.getFileType(), dsOrderDetails.getOrderId(), dsOrderDetails.getSubmissionDate(), action, true);
    }

    private static Query<HacEntry> getHacEntries(BankSettings bank, String customerId, String generalizedOrderType, String orderNumber, Timestamp sendTime, Integer action, boolean forDsOrderDetails) {
        BTF btf;
        Timestamp minTime = forDsOrderDetails ? ProtocolUtil.getMinTimeDS(sendTime) : ProtocolUtil.getMinTime(sendTime);
        Timestamp maxTime = ProtocolUtil.getMaxTime(sendTime);
        if (Util.isOrderType(generalizedOrderType)) {
            return HacEntry.queryByOrderTypeAndAction(bank, customerId, generalizedOrderType, action, orderNumber, minTime, maxTime);
        }
        Query<HacEntry> originalQuery = HacEntry.queryByFileTypeAndAction(bank, customerId, generalizedOrderType, action, orderNumber, minTime, maxTime);
        if (originalQuery.findCount() == 0 && (btf = BTF.fromString(generalizedOrderType)) != null) {
            ProtocolUtil.reduceMsgElements(btf);
            String reducedBtf = btf.toString();
            if (!reducedBtf.equals(generalizedOrderType)) {
                return HacEntry.queryByFileTypeAndAction(bank, customerId, reducedBtf, action, orderNumber, minTime, maxTime);
            }
        }
        return originalQuery;
    }

    private static void reduceMsgElements(BTF btf) {
        String msgName = btf.getMsgName();
        int firstPos = msgName.indexOf(":");
        if (firstPos > 0) {
            msgName = msgName.substring(0, firstPos);
            btf.setMsgName(msgName);
        }
        btf.setMsgVariant(null);
        btf.setMsgVersion(null);
        btf.setMsgFormat(null);
    }

    public static boolean hasPtkEntries(DsOrderDetails dsOrderDetails) {
        return ProtocolUtil.hasPtkEntries(dsOrderDetails.getBank(), dsOrderDetails.getFileType(), dsOrderDetails.getOrderId(), dsOrderDetails.getSubmissionDate());
    }

    private static boolean hasPtkEntries(BankSettings bank, String generalizedOrderType, String orderNumber, Timestamp sendTime) {
        return PtkEntry.countByOrderType(bank, generalizedOrderType, orderNumber, ProtocolUtil.getMinTime(sendTime), ProtocolUtil.getMaxTime(sendTime)) > 0;
    }

    public static Query<PtkEntry> getPtkEntries(Send send) {
        return ProtocolUtil.getPtkEntries(send.getBank(), send.getOriginalSendType(), send.getOrderNumber(), send.getSent());
    }

    public static Query<PtkEntry> getPtkEntries(DsOrderDetails dsOrderDetails) {
        return ProtocolUtil.getPtkEntries(dsOrderDetails.getBank(), dsOrderDetails.getFileType(), dsOrderDetails.getOrderId(), dsOrderDetails.getSubmissionDate());
    }

    private static Query<PtkEntry> getPtkEntries(BankSettings bank, String generalizedOrderType, String orderNumber, Timestamp sendTime) {
        return PtkEntry.queryByOrderType(bank, generalizedOrderType, orderNumber, ProtocolUtil.getMinTime(sendTime), ProtocolUtil.getMaxTime(sendTime));
    }

    public static List<HacEntry> findHacEntriesWithTicket(Send send) {
        return ProtocolUtil.findHacEntriesWithAdditionalInfo(send.getBank(), send.getOriginalSendType(), send.getOrderNumber(), send.getSent(), HAC30Entry.Action.ORDER_HAC_FINAL_NEG.ordinal(), HAC30Entry.Action.ORDER_HAC_FINAL_POS.ordinal(), HAC30Entry.Action.ORDER_HAC_FINAL.ordinal());
    }

    private static List<HacEntry> findHacEntriesWithAdditionalInfo(BankSettings bank, String generalizedOrderType, String orderNumber, Timestamp sendTime, Integer ... actions) {
        if (Util.isOrderType(generalizedOrderType)) {
            return HacEntry.findEntriesWithAdditionalInfoByOrderType(bank, generalizedOrderType, orderNumber, ProtocolUtil.getMinTime(sendTime), ProtocolUtil.getMaxTime(sendTime), actions);
        }
        return HacEntry.findEntriesWithAdditionalInfoByFileType(bank, generalizedOrderType, orderNumber, ProtocolUtil.getMinTime(sendTime), ProtocolUtil.getMaxTime(sendTime), actions);
    }

    public static List<PtkEntry> findPtkEntriesWithTicket(Send send) {
        return PtkEntry.findByAction(send.getBank(), send.getOrderType(), send.getOrderNumber(), ProtocolUtil.getMinTime(send.getSent()), ProtocolUtil.getMaxTime(send.getSent()), Action.ACCOUNT_CHECK.getId(), Action.DISPLAY_CONTENT.getId(), Action.DS_FINISH.getId(), Action.ORDER_EXPIRATION.getId(), Action.SIGNATURE_CHECK.getId(), Action.SEND_FILE.getId(), Action.SEND_FILE_AND_SIGNATURE.getId());
    }

    public static Timestamp getAcceptanceTime(Send send) {
        BankSettings bank = send.getBank();
        String generalizedOrderType = send.getOriginalSendType();
        String orderNumber = send.getOrderNumber();
        Send.State state = send.getState();
        Timestamp minTime = ProtocolUtil.getMinTime(send.getSent());
        Timestamp maxTime = ProtocolUtil.getMaxTime(send.getSent());
        if (Util.isOrderType(generalizedOrderType)) {
            PtkEntry entry;
            List<HacEntry> hacEntries = HacEntry.findEntriesWithAdditionalInfoByOrderType(bank, generalizedOrderType, orderNumber, minTime, maxTime, HAC30Entry.Action.ORDER_HAC_FINAL_POS.ordinal());
            if (hacEntries.size() > 0) {
                return hacEntries.get(0).getHacTime();
            }
            List<PtkEntry> ptkEntries = PtkEntry.findByAction(bank, generalizedOrderType, orderNumber, minTime, maxTime, Action.DS_FINISH.getId());
            if (ptkEntries.size() > 0) {
                entry = ptkEntries.get(0);
                if (Result.DS_FINISH_OK.getId() == entry.getResult().intValue()) {
                    return entry.getPtkTime();
                }
            }
            if (Send.State.FINISHED_OK.equals((Object)state) && (ptkEntries = PtkEntry.findByAction(send.getBank(), send.getOrderType(), send.getOrderNumber(), minTime, maxTime, Action.SIGNATURE_CHECK.getId())).size() > 0) {
                entry = ptkEntries.get(0);
                if (Result.SIGNATURES_OK.getId() == entry.getResult().intValue()) {
                    return entry.getPtkTime();
                }
            }
            return null;
        }
        List<HacEntry> hacEntries = HacEntry.findEntriesWithAdditionalInfoByFileType(bank, generalizedOrderType, orderNumber, minTime, maxTime, HAC30Entry.Action.ORDER_HAC_FINAL.ordinal());
        if (hacEntries.size() > 0 && Send.State.FINISHED_OK.equals((Object)state)) {
            return hacEntries.get(0).getHacTime();
        }
        hacEntries = HacEntry.findEntriesWithAdditionalInfoByFileType(bank, generalizedOrderType, orderNumber, minTime, maxTime, HAC30Entry.Action.ORDER_HAC_FINAL_POS.ordinal());
        if (hacEntries.size() > 0) {
            return hacEntries.get(0).getHacTime();
        }
        return null;
    }

    public static void updateOrderStateByHac(Send sendItem) {
        List hacEntries = ProtocolUtil.getHacEntries(sendItem).findList();
        if (hacEntries != null && hacEntries.size() > 0) {
            Send.State oldState = sendItem.getState();
            sendItem.setState(null);
            sendItem.save();
            for (HacEntry vo : hacEntries) {
                HAC30Entry hac30Entry = ProtocolUtil.toHAC(vo);
                ProtocolUtil.updateOrderState(sendItem, hac30Entry);
            }
            Send.State newState = sendItem.getState();
            Util.logger.logInfo("Send order " + PaymentTypeUtil.geOrderIdentification(sendItem) + " state was updated from " + String.valueOf((Object)oldState) + " to " + String.valueOf((Object)newState));
        }
    }

    public static void updateOrderStateByHac(DsOrderDetails dsOrderDetails) {
        List hacEntries = ProtocolUtil.getHacEntries(dsOrderDetails).findList();
        if (hacEntries != null && hacEntries.size() > 0) {
            DsOrderDetails.State oldState = dsOrderDetails.getState();
            Timestamp oldSubmissionDate = dsOrderDetails.getSubmissionDate();
            dsOrderDetails.setState(null);
            dsOrderDetails.save();
            for (HacEntry vo : hacEntries) {
                ProtocolListenerDS.determineStateFromHacEntry(dsOrderDetails, vo);
                if (vo.getAction() == null || vo.getAction().intValue() != HAC30Entry.Action.FILE_UPLOAD.ordinal() || dsOrderDetails.getSubmissionDate() != null && dsOrderDetails.getSubmissionDate().compareTo(vo.getHacTime()) == 0) continue;
                dsOrderDetails.setSubmissionDate(vo.getHacTime());
            }
            dsOrderDetails.save();
            Util.logger.logInfo("DsOrderDetails " + dsOrderDetails.getFileType() + " " + dsOrderDetails.getOrderId() + " Updated state from " + String.valueOf((Object)oldState) + " to " + String.valueOf((Object)dsOrderDetails.getState()) + ". Updated submission date from " + String.valueOf(oldSubmissionDate) + " to " + String.valueOf(dsOrderDetails.getSubmissionDate()));
        }
    }

    public static void updateOrderState(Send sendItem, HAC30Entry hac) {
        List entries;
        HAC30Entry.ReasonCode reasonCode = null;
        if (hac.getRsn() != null) {
            reasonCode = HAC30Entry.ReasonCode.getByIsoCode(hac.getRsn());
        }
        if (reasonCode != null) {
            sendItem.setErrorCode(hac.getRsn());
        }
        if (hac.getAction() == HAC30Entry.Action.FILE_UPLOAD || hac.getAction() == HAC30Entry.Action.ES_UPLOAD) {
            if (reasonCode == HAC30Entry.ReasonCode.TRANSMISSION_SUCCESSFUL) {
                if (sendItem.getState() == null || sendItem.getState() == Send.State.SENT || sendItem.getState() == Send.State.NOT_CONFIRMED) {
                    sendItem.setState(Send.State.CONFIRMED);
                }
            } else if (!ProtocolUtil.isReferentialOrderType(hac.getOrderType())) {
                sendItem.setState(Send.State.FINISHED_ERROR);
            }
        } else if (hac.getAction() == HAC30Entry.Action.ES_VERIFICATION && reasonCode == HAC30Entry.ReasonCode.DATA_SIGN_REQUESTED) {
            sendItem.setState(Send.State.SIGNATURE_STILL_MISSING);
        } else if (hac.getAction() == HAC30Entry.Action.VEU_FORWARDING) {
            if (reasonCode == HAC30Entry.ReasonCode.TRANSFER_ORDER) {
                if (sendItem.getState() == null || sendItem.getState() == Send.State.SENT || sendItem.getState() == Send.State.CONFIRMED || sendItem.getState() == Send.State.SIGNATURE_STILL_MISSING) {
                    sendItem.setState(Send.State.WAITING_IN_DS);
                }
            } else {
                sendItem.setState(Send.State.FINISHED_ERROR);
            }
        } else if (hac.getAction() == HAC30Entry.Action.VEU_VERIFICATION_END && reasonCode == HAC30Entry.ReasonCode.ORDER_FORWARDED_FOR_POSTPROCESSING && (sendItem.getState() == null || sendItem.getState() == Send.State.SENT || sendItem.getState() == Send.State.CONFIRMED || sendItem.getState() == Send.State.WAITING_IN_DS || sendItem.getState() == Send.State.SIGNATURE_STILL_MISSING)) {
            sendItem.setState(Send.State.FINISHED_OK);
        } else if (hac.getAction() == HAC30Entry.Action.VEU_CANCEL_ORDER && reasonCode == HAC30Entry.ReasonCode.ORDER_CANCELLED && sendItem.getState() != Send.State.FINISHED_ERROR) {
            sendItem.setState(Send.State.CANCELED);
        } else if (hac.getAction() == HAC30Entry.Action.ORDER_HAC_FINAL_POS && sendItem.getState() != Send.State.CANCELED) {
            sendItem.setState(Send.State.FINISHED_OK);
        } else if (hac.getAction() == HAC30Entry.Action.ORDER_HAC_FINAL_NEG && sendItem.getState() != Send.State.CANCELED) {
            sendItem.setState(Send.State.FINISHED_ERROR);
        } else if (hac.getAction() == HAC30Entry.Action.ES_VERIFICATION && reasonCode == HAC30Entry.ReasonCode.NOT_ALLOWED_PAYMENT) {
            sendItem.setState(Send.State.FINISHED_ERROR);
        } else if (hac.getAction() == HAC30Entry.Action.ORDER_HAC_FINAL && (sendItem.getState() == null || sendItem.getState() == Send.State.SENT || sendItem.getState() == Send.State.CONFIRMED || sendItem.getState() == Send.State.WAITING_IN_DS || sendItem.getState() == Send.State.SIGNATURE_STILL_MISSING) && (entries = ProtocolUtil.getHacEntries(sendItem).findList()) != null && entries.size() > 0) {
            boolean allOK = true;
            for (HacEntry entry : entries) {
                Integer action = entry.getAction();
                if (HAC30Entry.Action.ORDER_HAC_FINAL.ordinal() == action.intValue() || HAC30Entry.isSuccess(action, entry.getReason())) continue;
                allOK = false;
                Util.logger.logWarning("Send order " + PaymentTypeUtil.geOrderIdentification(sendItem) + " was set to state FINISHED_ERROR because of HAC entry " + HAC30Entry.getSymbolicActionName(action) + " with reason " + entry.getReason());
            }
            if (allOK) {
                sendItem.setState(Send.State.FINISHED_OK);
            } else {
                sendItem.setState(Send.State.FINISHED_ERROR);
            }
        }
        sendItem.save();
    }

    public static boolean isReferentialOrderType(String orderType) {
        return "HVE".equals(orderType) || "HVS".equals(orderType);
    }

    public static HAC30Entry toHAC(HacEntry vo) {
        BTF btf = null;
        String fileFormat = vo.getFileType();
        if (BTFTranslator.isBTFString(fileFormat)) {
            btf = BTFTranslator.convertFromStringToBTF(fileFormat);
            fileFormat = null;
        }
        return new HAC30Entry(vo.getBank().getHostId(), HAC30Entry.Action.values()[vo.getAction()], vo.getCustomerId(), vo.getUserId(), vo.getOrderType(), vo.getOrderNumber(), vo.getReason(), fileFormat, btf, TimeStamp.toString(vo.getHacTime()), vo.getAdditionalInformation());
    }
}

