/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.ProtocolListener;
import de.businesslogics.banking.database.api.DatabaseConnection;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.format.iso20022.pain00200102.PSREngine;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.iso20022.pain00200103.HAC30Parser;
import de.businesslogics.format.ptk2.Action;
import de.businesslogics.format.ptk2.DSCancelResult;
import de.businesslogics.format.ptk2.OrderInfo;
import de.businesslogics.format.ptk2.PTKEntry;
import de.businesslogics.format.ptk2.PTKEnumeration;
import de.businesslogics.format.ptk2.PTKParser;
import de.businesslogics.format.ptk2.ResultInfo;
import de.businesslogics.format.ptk2.TransferResult;
import de.businesslogics.format.sepa.MultipleInputStream;
import de.businesslogics.persistence.DBType;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class ProtocolProcessing {
    private static final Pattern ORDERNUMBER = Pattern.compile("([A-Z0-9]{3})\\s([A-Z0-9]{4})\\s*");
    private final ProtocolListener[] listener;
    private final BankSettings bank;

    public ProtocolProcessing(BankSettings bank, ProtocolListener[] listener) {
        this.listener = listener;
        this.bank = bank;
    }

    public void parseHAC30(InputStream in) throws SAXException, IOException {
        MultipleInputStream xmlSplitter = new MultipleInputStream(in);
        final ArrayList entries = new ArrayList();
        final HashMap hacMap = new HashMap();
        do {
            HAC30Parser parser = new HAC30Parser(new HAC30Parser.Listener(){
                private Timestamp previous = null;

                @Override
                public void handle(HAC30Entry hac) {
                    Matcher m;
                    Timestamp hacTime;
                    try {
                        if (hac.getTimeStamp() != null) {
                            this.previous = hacTime = new Timestamp(hac.getTimeStamp().getTime());
                        } else {
                            hacTime = this.previous != null ? this.previous : new Timestamp(System.currentTimeMillis());
                        }
                    }
                    catch (ParseException p) {
                        hacTime = new Timestamp(System.currentTimeMillis());
                    }
                    if (DBType.MYSQL.equals((Object)DatabaseConnection.getInstance().getDbType()) || DBType.MSSQL.equals((Object)DatabaseConnection.getInstance().getDbType())) {
                        hacTime = new Timestamp(hacTime.getTime() / 1000L * 1000L);
                    }
                    String orderId = hac.getOrderIdString();
                    String orderType = hac.getOrderTypeString();
                    String btfString = hac.getBTFString();
                    String fileType = btfString != null ? btfString : hac.getFileFormat();
                    String customerId = hac.getPartnerID();
                    if (hac.getPartnerIDRef() != null) {
                        customerId = hac.getPartnerIDRef();
                    }
                    if (orderId == null && orderType == null && hac.getAction() == HAC30Entry.Action.ADDITIONAL && (m = ORDERNUMBER.matcher(hac.getAddtlInfs())).find()) {
                        orderType = m.group(1);
                        orderId = m.group(2);
                    }
                    if (!HacEntry.exists(ProtocolProcessing.this.bank, hacTime, hac.getAction().ordinal(), orderType, orderId, fileType, customerId, hac.getUserID())) {
                        HacEntry vo = new HacEntry();
                        vo.setAction(hac.getAction().ordinal());
                        vo.setAdditionalInformation(hac.getAddtlInfs());
                        vo.setBank(ProtocolProcessing.this.bank);
                        vo.setCustomerId(customerId);
                        vo.setFileType(fileType);
                        vo.setHacTime(hacTime);
                        vo.setOrderNumber(orderId);
                        vo.setOrderType(orderType);
                        vo.setReason(hac.getRsn());
                        vo.setUserId(hac.getUserID());
                        vo.save();
                        entries.add(vo);
                        hacMap.put(vo, hac);
                    }
                }
            });
            parser.parse(xmlSplitter);
        } while (xmlSplitter.reopen());
        entries.sort((vo1, vo2) -> vo1.getHacTime().compareTo(vo2.getHacTime()));
        for (HacEntry vo : entries) {
            for (ProtocolListener protocolListener : this.listener) {
                protocolListener.newHAC30(this.bank, (HAC30Entry)hacMap.get(vo), vo);
            }
        }
        for (ProtocolListener protocolListener : this.listener) {
            protocolListener.processingDone(this.bank);
        }
    }

    public void parsePTK(InputStream in) throws IOException, ParseException {
        this.parse(new PTKParser(in));
    }

    public void parsePSR(InputStream in) throws IOException, ParseException, SAXException {
        this.parse(new PSREngine(in));
    }

    public void parse(PTKEnumeration e) throws IOException, ParseException {
        PTKEntry entry = e.nextEntry();
        while (entry != null) {
            Matcher m;
            ResultInfo r;
            String orderType = null;
            String orderNumber = null;
            OrderInfo info = entry.getOrderInfo();
            if (entry.getResult() instanceof TransferResult) {
                r = (TransferResult)entry.getResult();
                if (((TransferResult)r).getReference() != null) {
                    info = ((TransferResult)r).getReference();
                }
            } else if (entry.getResult() instanceof DSCancelResult && ((DSCancelResult)(r = (DSCancelResult)entry.getResult())).getReference() != null) {
                info = ((DSCancelResult)r).getReference();
            }
            if (info != null) {
                orderType = info.getOrderType();
                orderNumber = info.getOrderNumber();
            }
            if (orderNumber == null && orderType == null && entry.getAction() == Action.ADDITIONAL_INFO && (m = ORDERNUMBER.matcher(entry.toString())).find()) {
                orderType = m.group(1);
                orderNumber = m.group(2);
            }
            if (!PtkEntry.exists(this.bank, new Timestamp(entry.getDate().getTime()), entry.getAction().getId(), orderType, orderNumber)) {
                PtkEntry vo = new PtkEntry();
                vo.setAction(entry.getAction().getId());
                vo.setBank(this.bank);
                vo.setData(this.toString(entry.getBlock()));
                vo.setPtkTime(new Timestamp(entry.getDate().getTime()));
                if (entry.getResult() != null && entry.getResult().getResult() != null) {
                    vo.setResult(entry.getResult().getResult().getId());
                }
                vo.setOrderNumber(orderNumber);
                vo.setOrderType(orderType);
                vo.save();
                for (ProtocolListener protocolListener : this.listener) {
                    protocolListener.newPTK(this.bank, entry, vo);
                }
            }
            entry = e.nextEntry();
        }
        for (ProtocolListener protocolListener : this.listener) {
            protocolListener.processingDone(this.bank);
        }
    }

    private String toString(List<String> l) {
        StringBuilder b = new StringBuilder();
        for (String string : l) {
            b.append(string);
            b.append('\n');
        }
        return b.toString();
    }
}

