/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.format.iso20022.pain00200103.Hac2Pdf;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.PDFException;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;

public final class ProtocolPrinter
implements Closeable {
    private final String protocolName;
    private final String title;
    private BLDocument document;
    private OutputStream pdfOutputStream;
    private BLFont ptkFont = BLFont.COURIER_SMALL;
    private Hac2Pdf hacTable;
    private boolean receivedPtkEntry;
    private boolean receivedHacEntry;

    public ProtocolPrinter(String protocolName, String title) {
        this.protocolName = protocolName;
        this.title = title;
    }

    public File createDocument(Locale locale, boolean showOrderNumbers, boolean withLogo) throws PDFException, IOException {
        File dest = Util.createTempFile(this.protocolName, ".pdf", true);
        this.pdfOutputStream = new FileOutputStream(dest);
        this.document = Util.createBLDocument(this.pdfOutputStream, BLDocument.PageLayout.A4, this.title, withLogo, locale);
        this.document.addHeadline(this.title, BLFont.FONT_BOLD, null, 20.0f);
        this.hacTable = new Hac2Pdf(showOrderNumbers, locale);
        return dest;
    }

    public void addPtk(PtkEntry ptk) throws PDFException {
        if (this.document == null || ptk == null) {
            return;
        }
        if (this.receivedPtkEntry) {
            this.document.addNewLine();
        }
        this.document.addTextln(ptk.getData(), this.ptkFont);
        this.receivedPtkEntry = true;
    }

    public void addHac(HacEntry hac) throws PDFException {
        if (this.hacTable == null || hac == null) {
            return;
        }
        this.hacTable.addEntry(ProtocolUtil.toHAC(hac));
        this.receivedHacEntry = true;
    }

    @Override
    public void close() throws IOException {
        PDFException exception;
        block10: {
            exception = null;
            if (this.receivedHacEntry && this.hacTable != null && this.document != null) {
                try {
                    this.document.addTable(this.hacTable.getHacTable());
                }
                catch (PDFException e) {
                    exception = e;
                }
            }
            if (this.document != null) {
                try {
                    this.document.close();
                }
                catch (PDFException e) {
                    exception = e;
                }
            }
            if (this.pdfOutputStream != null) {
                try {
                    this.pdfOutputStream.close();
                }
                catch (IOException e) {
                    if (exception != null) break block10;
                    throw e;
                }
            }
        }
        if (exception != null) {
            throw new IOException("Failed to add HAC table to document!", exception);
        }
    }
}

