/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.ProtocolListener;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.DsSigningInfo;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.ds.LocalDSUtil;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.ptk2.Action;
import de.businesslogics.format.ptk2.DSCancelResult;
import de.businesslogics.format.ptk2.DSFinishResult;
import de.businesslogics.format.ptk2.DSSignatureResult;
import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ptk2.PTKEntry;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.format.ptk2.SignatureResult;
import de.businesslogics.format.ptk2.TransferResult;
import de.businesslogics.format.ptk2.UserInfo;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.List;
import java.util.Locale;

public class ProtocolListenerDS
implements ProtocolListener {
    private static final long DIFF_IN_MILLIS_FOR_SIGNATURE_CHECK = 10000L;
    private static final String[] technicalOrderTypes = new String[]{"INI", "HIA", "H3K", "HSA", "PUB", "HCA", "HCS", "SPR", "HVE", "HVS"};

    @Override
    public void newPTK(BankSettings bank, PTKEntry ptk, PtkEntry vo) {
        if (vo.getOrderType() == null || vo.getOrderNumber() == null) {
            return;
        }
        DsOrderDetails dsOrderDetails = LocalDSUtil.findOrderForInfo(vo.getBank(), null, vo.getOrderType(), vo.getOrderNumber(), vo.getPtkTime(), vo.getBank().getCustomerId());
        if (dsOrderDetails == null && (dsOrderDetails = this.createOrderDetailsFromPtk(vo, ptk)) == null) {
            return;
        }
        this.determineStateFromPtkEntry(dsOrderDetails, ptk);
        this.checkOriginatorInfo(ptk, vo, dsOrderDetails);
        this.checkSignerInfo(ptk, vo, dsOrderDetails);
        this.checkDsType(ptk, vo, dsOrderDetails);
        dsOrderDetails.save();
    }

    @Override
    public void newHAC30(BankSettings bank, HAC30Entry hac, HacEntry vo) {
        if (vo.getOrderType() == null && vo.getFileType() == null || vo.getOrderNumber() == null) {
            return;
        }
        if (HAC30Entry.Action.ES_UPLOAD.equals((Object)hac.getAction()) && ProtocolUtil.isReferentialOrderType(hac.getOrderType())) {
            return;
        }
        DsOrderDetails dsOrderDetails = LocalDSUtil.findOrderForInfo(vo.getBank(), vo.getFileType(), vo.getOrderType(), vo.getOrderNumber(), vo.getHacTime(), vo.getCustomerId());
        if (dsOrderDetails == null && (dsOrderDetails = this.createOrderDetailsFromHac(vo)) == null) {
            return;
        }
        ProtocolListenerDS.determineStateFromHacEntry(dsOrderDetails, vo);
        this.checkOriginatorInfo(hac, vo, dsOrderDetails);
        this.checkSignerInfo(hac, vo, dsOrderDetails);
        this.checkDsType(vo, dsOrderDetails);
        if (hac.getAddtlInfs() != null) {
            if (HAC30Entry.Action.FILE_UPLOAD.equals((Object)hac.getAction())) {
                String s = hac.getAddtlInfs().trim();
                if (!s.isEmpty()) {
                    dsOrderDetails.setAdditionalOrderInfo(hac.getAddtlInfs());
                }
            } else {
                this.handleTicket(hac.getAddtlInfs(), dsOrderDetails);
            }
        }
        dsOrderDetails.save();
    }

    @Override
    public void processingDone(BankSettings bank) {
    }

    public DsOrderDetails createOrderDetailsFromPtk(PtkEntry vo, PTKEntry entry) {
        if (Action.ADDITIONAL_INFO.equals(entry.getAction())) {
            return null;
        }
        if (ProtocolListenerDS.isTechnicalOrderType(vo.getOrderType())) {
            return null;
        }
        DsOrderDetails orderDetails = new DsOrderDetails();
        orderDetails.setBank(vo.getBank());
        orderDetails.setPmtType(SendParameters.getPmtType(vo.getBank(), vo.getOrderType()));
        orderDetails.setFileType(vo.getOrderType());
        orderDetails.setOrderId(vo.getOrderNumber());
        orderDetails.setSubmissionDate(vo.getPtkTime());
        orderDetails.setCustomerId(vo.getBank().getCustomerId());
        orderDetails.setNumSigDone(0);
        orderDetails.setNumSigRequired(1);
        List<Send> list = Send.findByOrderDetails(vo.getBank(), orderDetails.getFileType(), orderDetails.getOrderId(), orderDetails.getSubmissionDate());
        if (list != null && list.size() == 1) {
            orderDetails.setUserName(list.get(0).getSender());
        }
        if (entry.getAction() == Action.DS_CANCEL) {
            orderDetails.setType(DsOrderDetails.Type.REJECTED);
        } else {
            orderDetails.setType(DsOrderDetails.Type.SIGNED);
        }
        return orderDetails;
    }

    public DsOrderDetails createOrderDetailsFromHac(HacEntry vo) {
        if (ProtocolListenerDS.isTechnicalOrderType(vo.getOrderType())) {
            return null;
        }
        DsOrderDetails orderDetails = new DsOrderDetails();
        String transferType = vo.getGeneralizedOrderType();
        orderDetails.setBank(vo.getBank());
        orderDetails.setPmtType(SendParameters.getPmtType(vo.getBank(), transferType));
        orderDetails.setFileType(transferType);
        orderDetails.setOrderId(vo.getOrderNumber());
        orderDetails.setSubmissionDate(vo.getHacTime());
        if (vo.getCustomerId() == null) {
            orderDetails.setCustomerId(vo.getBank().getCustomerId());
        } else {
            orderDetails.setCustomerId(vo.getCustomerId());
        }
        orderDetails.setNumSigDone(0);
        orderDetails.setNumSigRequired(1);
        List<Send> list = Send.findByOrderDetails(vo.getBank(), orderDetails.getFileType(), orderDetails.getOrderId(), orderDetails.getSubmissionDate());
        if (list != null && list.size() == 1) {
            orderDetails.setUserName(list.get(0).getSender());
        }
        if (vo.getAction().intValue() == HAC30Entry.Action.VEU_CANCEL_ORDER.ordinal()) {
            orderDetails.setType(DsOrderDetails.Type.REJECTED);
        } else {
            orderDetails.setType(DsOrderDetails.Type.SIGNED);
        }
        return orderDetails;
    }

    public static boolean isTechnicalOrderType(String orderType) {
        for (String technicalOrderType : technicalOrderTypes) {
            if (!technicalOrderType.equals(orderType)) continue;
            return true;
        }
        return false;
    }

    private void determineStateFromPtkEntry(DsOrderDetails dsOrderDetails, PTKEntry entry) {
        DsOrderDetails.State newState = null;
        if (entry.getAction() == null || entry.getResult() == null) {
            return;
        }
        if (entry.getAction() == Action.DS_FINISH) {
            newState = entry.getResult().isSuccess() ? DsOrderDetails.State.FINISHED : DsOrderDetails.State.FINISHED_ERROR;
        } else if (entry.getAction() == Action.SEND_FILE || entry.getAction() == Action.SEND_FILE_AND_SIGNATURE) {
            newState = entry.getResult().isSuccess() ? DsOrderDetails.State.CONFIRMED : DsOrderDetails.State.FINISHED_ERROR;
        } else if (entry.getAction() == Action.SIGNATURE_CHECK) {
            newState = entry.getResult().isSuccess() ? DsOrderDetails.State.FINISHED_FINAL : DsOrderDetails.State.FINISHED_ERROR;
        } else if (entry.getAction() == Action.DS_SIGNATURE) {
            if (!entry.getResult().isSuccess()) {
                newState = DsOrderDetails.State.FINISHED_ERROR;
            }
        } else if (entry.getAction() == Action.DS_ENTRY) {
            newState = !entry.getResult().isSuccess() ? DsOrderDetails.State.FINISHED_ERROR : DsOrderDetails.State.WAITING;
        } else if (entry.getAction() == Action.DS_CANCEL) {
            newState = !entry.getResult().isSuccess() ? DsOrderDetails.State.FINISHED_ERROR : DsOrderDetails.State.CANCELLED;
        } else if (entry.getAction() == Action.ACCOUNT_CHECK && !entry.getResult().isSuccess()) {
            newState = DsOrderDetails.State.FINISHED_ERROR;
        } else if (entry.getAction() == Action.DISPLAY_CONTENT && !entry.getResult().isSuccess()) {
            newState = DsOrderDetails.State.FINISHED_ERROR;
        } else if (entry.getAction() == Action.ORDER_EXPIRATION) {
            newState = DsOrderDetails.State.FINISHED_ERROR;
        }
        Result r = entry.getResult().getResult();
        if (r != null) {
            dsOrderDetails.setErrorCode(String.valueOf(r.getId()));
        }
        if (newState != null) {
            if (newState.equals((Object)DsOrderDetails.State.CONFIRMED) && dsOrderDetails.getState() != null && dsOrderDetails.getState().equals((Object)DsOrderDetails.State.WAITING)) {
                return;
            }
            if (newState == DsOrderDetails.State.FINISHED_FINAL) {
                dsOrderDetails.setState(newState);
            } else if (dsOrderDetails.getState() == null) {
                dsOrderDetails.setState(newState);
            } else if (dsOrderDetails.getState() != DsOrderDetails.State.FINISHED_ERROR && dsOrderDetails.getState() != DsOrderDetails.State.FINISHED_FINAL) {
                if (dsOrderDetails.getState() == DsOrderDetails.State.FINISHED) {
                    if (newState == DsOrderDetails.State.FINISHED_ERROR) {
                        dsOrderDetails.setState(newState);
                    }
                } else {
                    dsOrderDetails.setState(newState);
                }
            }
        }
    }

    public static void determineStateFromHacEntry(DsOrderDetails dsOrderDetails, HacEntry entry) {
        HAC30Entry.ReasonCode hacReason;
        DsOrderDetails.State currentState = null;
        HAC30Entry.Action hacAction = null;
        if (entry.getAction() != null) {
            for (HAC30Entry.Action action : HAC30Entry.Action.values()) {
                if (entry.getAction().intValue() != action.ordinal()) continue;
                hacAction = action;
                break;
            }
        }
        if (entry.getReason() != null) {
            hacReason = HAC30Entry.ReasonCode.getByIsoCode(entry.getReason());
            dsOrderDetails.setErrorCode(entry.getReason());
        } else {
            hacReason = null;
        }
        if (hacAction == HAC30Entry.Action.ORDER_HAC_FINAL_POS && dsOrderDetails.getState() != DsOrderDetails.State.CANCELLED) {
            currentState = DsOrderDetails.State.FINISHED;
        } else if (hacAction == HAC30Entry.Action.ORDER_HAC_FINAL_NEG && dsOrderDetails.getState() != DsOrderDetails.State.CANCELLED) {
            currentState = DsOrderDetails.State.FINISHED_ERROR;
        } else if (hacAction == HAC30Entry.Action.FILE_UPLOAD || hacAction == HAC30Entry.Action.ES_UPLOAD) {
            currentState = hacReason == HAC30Entry.ReasonCode.TRANSMISSION_SUCCESSFUL ? DsOrderDetails.State.CONFIRMED : DsOrderDetails.State.FINISHED_ERROR;
        } else if (hacAction == HAC30Entry.Action.VEU_CANCEL_ORDER && hacReason == HAC30Entry.ReasonCode.ORDER_CANCELLED) {
            currentState = DsOrderDetails.State.CANCELLED;
        } else if (hacAction == HAC30Entry.Action.VEU_FORWARDING) {
            currentState = DsOrderDetails.State.WAITING;
        } else if (hacAction == HAC30Entry.Action.VEU_VERIFICATION) {
            currentState = DsOrderDetails.State.WAITING;
        } else if (hacAction == HAC30Entry.Action.VEU_VERIFICATION_END) {
            currentState = DsOrderDetails.State.FINISHED;
        } else if (hacAction == HAC30Entry.Action.ES_VERIFICATION) {
            if (hacReason != HAC30Entry.ReasonCode.ELECTRONIC_SIGNATURES_CORRECT) {
                currentState = DsOrderDetails.State.FINISHED_ERROR;
            } else if (dsOrderDetails.getState() == DsOrderDetails.State.FINISHED) {
                currentState = DsOrderDetails.State.FINISHED_FINAL;
            }
        } else if (hacAction == HAC30Entry.Action.ADDITIONAL && hacReason == HAC30Entry.ReasonCode.ORDER_REJECTED) {
            currentState = DsOrderDetails.State.FINISHED_ERROR;
        }
        if (currentState != null) {
            if (currentState == DsOrderDetails.State.FINISHED_FINAL) {
                dsOrderDetails.setState(DsOrderDetails.State.FINISHED_FINAL);
            } else if (dsOrderDetails.getState() == null) {
                dsOrderDetails.setState(currentState);
            } else if (dsOrderDetails.getState() != DsOrderDetails.State.FINISHED_ERROR && dsOrderDetails.getState() != DsOrderDetails.State.FINISHED_FINAL) {
                if (dsOrderDetails.getState() == DsOrderDetails.State.FINISHED) {
                    if (currentState == DsOrderDetails.State.FINISHED_ERROR) {
                        dsOrderDetails.setState(currentState);
                    }
                } else {
                    dsOrderDetails.setState(currentState);
                }
            }
        }
    }

    public boolean checkOriginatorInfo(PTKEntry ptk, PtkEntry vo, DsOrderDetails dsOrderDetails) {
        boolean modified = false;
        if (ptk.getResult() instanceof TransferResult) {
            TransferResult transfer = (TransferResult)ptk.getResult();
            if (transfer.getReference() == null) {
                UserInfo userInfo;
                if (dsOrderDetails.getSubmissionDate() == null || dsOrderDetails.getSubmissionDate().compareTo(vo.getPtkTime()) != 0) {
                    dsOrderDetails.setSubmissionDate(vo.getPtkTime());
                    modified = true;
                }
                if (transfer.getCustomerId() != null && !transfer.getCustomerId().equals(dsOrderDetails.getCustomerId())) {
                    dsOrderDetails.setCustomerId(transfer.getCustomerId());
                    modified = true;
                }
                if (transfer.getFilename() != null && !transfer.getFilename().equals(dsOrderDetails.getFilename())) {
                    dsOrderDetails.setFilename(transfer.getFilename());
                }
                if ((userInfo = transfer.getUserInfo()) != null) {
                    if (userInfo.getCustomerId() != null && !userInfo.getCustomerId().equals(dsOrderDetails.getCustomerId())) {
                        dsOrderDetails.setCustomerId(userInfo.getCustomerId());
                        modified = true;
                    }
                    if (userInfo.getUserId() != null && !userInfo.getUserId().equals(dsOrderDetails.getUserId())) {
                        dsOrderDetails.setUserId(userInfo.getUserId());
                        modified = true;
                    }
                    if (userInfo.getLongName() != null && !userInfo.getLongName().equals(dsOrderDetails.getUserName())) {
                        dsOrderDetails.setUserName(userInfo.getLongName());
                        modified = true;
                    }
                }
            }
            modified |= this.handlePtkTicket(transfer.getTicket(), dsOrderDetails);
        }
        return modified;
    }

    public boolean checkOriginatorInfo(HAC30Entry hac, HacEntry vo, DsOrderDetails dsOrderDetails) {
        boolean modified = false;
        if (vo.getAction() != null && vo.getAction().intValue() == HAC30Entry.Action.FILE_UPLOAD.ordinal()) {
            if (dsOrderDetails.getSubmissionDate() == null || dsOrderDetails.getSubmissionDate().compareTo(vo.getHacTime()) != 0) {
                dsOrderDetails.setSubmissionDate(vo.getHacTime());
                modified = true;
            }
            if (dsOrderDetails.getCustomerId() == null || !dsOrderDetails.getCustomerId().equals(vo.getCustomerId())) {
                dsOrderDetails.setCustomerId(vo.getCustomerId());
                modified = true;
            }
            if (!(vo.getUserId() == null || dsOrderDetails.getUserId() != null && dsOrderDetails.getUserId().equals(vo.getUserId()))) {
                dsOrderDetails.setUserId(vo.getUserId());
                modified = true;
            }
        }
        return modified;
    }

    public boolean checkSignerInfo(PTKEntry ptk, PtkEntry vo, DsOrderDetails dsOrderDetails) {
        boolean modified = false;
        UserInfo[] users = null;
        DisplayMessage displayMessage = null;
        if (ptk.getResult() instanceof DSFinishResult) {
            DSFinishResult finish = (DSFinishResult)ptk.getResult();
            users = finish.getUserInfos();
            displayMessage = finish.getTicket();
        } else if (ptk.getResult() instanceof DSSignatureResult) {
            UserInfo info = ((DSSignatureResult)ptk.getResult()).getUserInfo();
            if (info != null) {
                users = new UserInfo[]{info};
            }
        } else if (ptk.getResult() instanceof SignatureResult) {
            SignatureResult signature = (SignatureResult)ptk.getResult();
            users = signature.getUserInfos();
            displayMessage = signature.getTicket();
        }
        if (users != null && users.length > 0) {
            int newSigDoneNumber;
            int oldSigDoneNumber = dsOrderDetails.getNumSigDone() == null ? 0 : dsOrderDetails.getNumSigDone();
            for (UserInfo i : users) {
                boolean found = false;
                if (dsOrderDetails.getSigningInfos() != null) {
                    for (DsSigningInfo signerInfo : dsOrderDetails.getSigningInfos()) {
                        if (signerInfo.getUserId() == null || !signerInfo.getUserId().equals(i.getUserId())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                this.createDsSigningInfo(dsOrderDetails, i.getCustomerId(), i.getUserId(), i.getLongName(), vo.getPtkTime());
                modified = true;
            }
            if (dsOrderDetails.getUserId() == null && dsOrderDetails.getUserName() == null) {
                if (users[0].getCustomerId() != null) {
                    dsOrderDetails.setCustomerId(users[0].getCustomerId());
                    modified = true;
                }
                if (users[0].getUserId() != null) {
                    dsOrderDetails.setUserId(users[0].getUserId());
                    modified = true;
                }
                if (users[0].getLongName() != null) {
                    dsOrderDetails.setUserName(users[0].getLongName());
                    modified = true;
                }
            }
            if ((newSigDoneNumber = dsOrderDetails.getSigningInfos().size()) > oldSigDoneNumber) {
                dsOrderDetails.setNumSigDone(newSigDoneNumber);
                if (dsOrderDetails.getState() == DsOrderDetails.State.FINISHED || dsOrderDetails.getState() == DsOrderDetails.State.FINISHED_FINAL || dsOrderDetails.getState() == DsOrderDetails.State.FINISHED_ERROR || dsOrderDetails.getState() == DsOrderDetails.State.CANCELLED) {
                    dsOrderDetails.setNumSigRequired(newSigDoneNumber);
                } else {
                    dsOrderDetails.setNumSigRequired(newSigDoneNumber + 1);
                }
                modified = true;
            }
        }
        if (ptk.getResult() instanceof DSCancelResult && ptk.getResult().isSuccess()) {
            UserInfo userInfo = ((DSCancelResult)ptk.getResult()).getUserInfo();
            this.createDsSigningInfo(dsOrderDetails, userInfo.getCustomerId(), userInfo.getUserId(), userInfo.getLongName(), vo.getPtkTime());
            modified = true;
        }
        if (ptk.getResult() instanceof DSFinishResult && dsOrderDetails.getNumSigDone() != null && !dsOrderDetails.getNumSigDone().equals(dsOrderDetails.getNumSigRequired())) {
            dsOrderDetails.setNumSigRequired(dsOrderDetails.getNumSigDone());
            modified = true;
        }
        if (displayMessage != null) {
            modified |= this.handlePtkTicket(displayMessage, dsOrderDetails);
        }
        return modified;
    }

    public boolean checkSignerInfo(HAC30Entry hac, HacEntry vo, DsOrderDetails dsOrderDetails) {
        boolean modified = false;
        if (vo.getUserId() != null && (vo.getAction().intValue() == HAC30Entry.Action.ES_VERIFICATION.ordinal() || vo.getAction().intValue() == HAC30Entry.Action.VEU_VERIFICATION.ordinal() || vo.getAction().intValue() == HAC30Entry.Action.VEU_CANCEL_ORDER.ordinal() && HAC30Entry.ReasonCode.ORDER_CANCELLED.getIsoCode().equals(vo.getReason()))) {
            boolean foundUserSignature = false;
            boolean checkTimeStamp = vo.getAction().intValue() == HAC30Entry.Action.ES_VERIFICATION.ordinal() || vo.getAction().intValue() == HAC30Entry.Action.VEU_VERIFICATION.ordinal();
            for (DsSigningInfo signerInfo : dsOrderDetails.getSigningInfos()) {
                if (signerInfo.getUserId() == null || !vo.getUserId().equals(signerInfo.getUserId()) || !checkTimeStamp && Math.abs(signerInfo.getSignDate().getTime() - vo.getHacTime().getTime()) >= 10000L) continue;
                foundUserSignature = true;
                break;
            }
            String customerId = vo.getCustomerId();
            if (hac != null) {
                customerId = hac.getPartnerID();
            }
            if (!foundUserSignature) {
                this.createDsSigningInfo(dsOrderDetails, customerId, vo.getUserId(), null, vo.getHacTime());
                modified = true;
            }
        }
        if (dsOrderDetails.getNumSigDone() == null) {
            return modified;
        }
        if (!dsOrderDetails.getNumSigDone().equals(dsOrderDetails.getSigningInfos().size())) {
            dsOrderDetails.setNumSigDone(dsOrderDetails.getSigningInfos().size());
            if (dsOrderDetails.getState() == DsOrderDetails.State.CONFIRMED || dsOrderDetails.getState() == DsOrderDetails.State.WAITING) {
                dsOrderDetails.setNumSigRequired(dsOrderDetails.getNumSigDone() + 1);
            } else {
                dsOrderDetails.setNumSigRequired(dsOrderDetails.getNumSigDone());
            }
            modified = true;
        }
        if (!(dsOrderDetails.getNumSigDone().equals(dsOrderDetails.getNumSigRequired()) || dsOrderDetails.getState() != DsOrderDetails.State.FINISHED && dsOrderDetails.getState() != DsOrderDetails.State.FINISHED_FINAL && dsOrderDetails.getState() != DsOrderDetails.State.FINISHED_ERROR && dsOrderDetails.getState() != DsOrderDetails.State.CANCELLED)) {
            dsOrderDetails.setNumSigRequired(dsOrderDetails.getNumSigDone());
            modified = true;
        }
        return modified;
    }

    private boolean handlePtkTicket(DisplayMessage displayMessage, DsOrderDetails dsOrderDetails) {
        if (displayMessage != null && dsOrderDetails.getTicket() == null) {
            StringBuilder buffer = new StringBuilder();
            displayMessage.appendText(Locale.getDefault(), buffer);
            return this.handleTicket(buffer.toString(), dsOrderDetails);
        }
        return false;
    }

    private boolean handleTicket(String ticket, DsOrderDetails dsOrderDetails) {
        if (ticket != null && dsOrderDetails.getTicket() == null) {
            dsOrderDetails.setTicket(ticket.getBytes(StandardCharsets.ISO_8859_1));
            if (dsOrderDetails.getTicket() != null) {
                DatabasePreferenceStore preferenceStore;
                if (dsOrderDetails.getFilename() == null && (preferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null)).getBoolean(PreferenceConstants.DS_SHOW_FILENAME)) {
                    dsOrderDetails.setFilename(LocalDSUtil.readFilenameFromTicket(dsOrderDetails.getTicket()));
                }
                return true;
            }
        }
        return false;
    }

    private boolean checkDsType(PTKEntry ptk, PtkEntry vo, DsOrderDetails dsOrderDetails) {
        if (dsOrderDetails.getType() == DsOrderDetails.Type.SIGNED && ptk.getAction() == Action.DS_CANCEL && ptk.getResult().isSuccess()) {
            dsOrderDetails.setType(DsOrderDetails.Type.REJECTED);
            return true;
        }
        return false;
    }

    private boolean checkDsType(HacEntry vo, DsOrderDetails dsOrderDetails) {
        if (dsOrderDetails.getType() == DsOrderDetails.Type.SIGNED && vo.getAction() != null && vo.getAction().intValue() == HAC30Entry.Action.VEU_CANCEL_ORDER.ordinal() && HAC30Entry.ReasonCode.ORDER_CANCELLED.getIsoCode().equals(vo.getReason())) {
            dsOrderDetails.setType(DsOrderDetails.Type.REJECTED);
            return true;
        }
        return false;
    }

    private void createDsSigningInfo(DsOrderDetails orderDetails, String customerId, String userId, String userName, Timestamp signDate) {
        DsSigningInfo signingInfo = new DsSigningInfo();
        if (customerId == null) {
            signingInfo.setCustomerId(orderDetails.getCustomerId());
        } else {
            signingInfo.setCustomerId(customerId);
        }
        if (userId == null) {
            signingInfo.setUserId(orderDetails.getUserId());
        } else {
            signingInfo.setUserId(userId);
        }
        if (userName != null) {
            signingInfo.setUserName(userName);
        }
        signingInfo.setSignDate(signDate);
        signingInfo.setPermission(Character.valueOf(' '));
        orderDetails.getSigningInfos().add(signingInfo);
    }
}

