/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.Messages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.format.iso20022.pain00200103.Hac2Pdf;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLParagraph;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import io.ebean.Query;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;

public class PrintUtil {
    public static boolean isFileTooLargeForDetails(long fileSize, BLDocument doc, User user, Locale locale) throws PDFException {
        long maxFileSize = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getLong(PreferenceConstants.SEND_REPORT_MAX_FILE_SIZE_FOR_DETAILS);
        if (fileSize > maxFileSize) {
            BLParagraph<?> p = PDFCreator.getInstance().createParagraph(MessageFormat.format(Messages.getString(locale, "PrintUtil.noDetailsTableForLargeFiles", new Object[0]), maxFileSize));
            p.setSpacingBefore(20.0f);
            p.setSpacingAfter(20.0f);
            doc.add(p);
            return true;
        }
        return false;
    }

    public static class HacTable
    extends Hac2Pdf {
        private final NameTranslator myTranslator = new NameTranslator();

        public HacTable(boolean showOrderNumber, Locale locale) throws PDFException {
            super(showOrderNumber, locale);
            this.setTranslator(this.myTranslator);
        }

        public void setBank(BankSettings bank) {
            this.myTranslator.bank = bank;
        }

        public BLTable<?> addHacEntry(HacEntry hac) {
            this.myTranslator.bank = hac.getBank();
            this.addEntry(ProtocolUtil.toHAC(hac));
            return this.getHacTable();
        }

        public BLTable<?> addHacEntries(Query<HacEntry> hac) {
            hac.findEach(h -> {
                this.myTranslator.bank = h.getBank();
                this.addEntry(ProtocolUtil.toHAC(h));
            });
            return this.getHacTable();
        }
    }

    public static class NameTranslator
    extends Hac2Pdf.NameTranslator {
        private BankSettings bank;
        private final HashMap<String, String> userMapping = new HashMap();

        public void setBank(BankSettings bank) {
            this.bank = bank;
        }

        @Override
        public String getUserName(String partnerId, String userId) {
            User u;
            String rep = super.getUserName(partnerId, userId);
            String toReturn = this.userMapping.get(rep);
            if (toReturn != null) {
                return toReturn;
            }
            if (userId != null && this.bank != null && (u = BankUser.findLoginUserByUserIdAndCustomerId(this.bank, userId, partnerId)) != null) {
                this.userMapping.put(rep, u.getName());
                return u.getName();
            }
            return rep;
        }
    }
}

