/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;

public class PreferenceUtil {
    public static boolean doRenameAccounts(User user) {
        return !new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null).getBoolean(PreferenceConstants.ACCOUNT_RENAME_BY_ADMIN_ONLY) || user.isAdmin();
    }

    public static boolean doAllowRecipientConfirmation(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.CONFIRM_RECIPIENT_PERMISSION);
    }

    public static boolean doAllowViewAccountStatements(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_VIEW_ACCOUNT_STATEMENTS);
    }

    public static boolean doAllowViewFetchedFiles(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_FETCH_FILES);
    }

    public static boolean doAllowViewSentFiles(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_SEND_FILES);
    }

    public static boolean doAllowVEU(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_VEU);
    }

    public static boolean doAllowNotifications(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_NOTIFICATIONS);
    }

    public static boolean doAllowPaymentRecording(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_PAYMENT_RECORDING);
    }

    public static boolean doAllowAWVRecording(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_AWV_RECORDING);
    }

    public static boolean doAllowFolderFiles(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_FOLDER_FILES);
    }

    public static boolean doAllowBanksAndAccounts(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_BANKS_AND_ACCOUNTS);
    }

    public static boolean doAllowSettings(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.ALLOW_SETTINGS);
    }

    public static boolean logPerformance() {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null).getBoolean(PreferenceConstants.LOG_PERFORMANCE);
    }

    public static boolean allowH005() {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null).getBoolean(PreferenceConstants.ALLOW_H005);
    }

    public static boolean displayBanksInOtherPerspectives(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.DISPLAY_BANKS_IN_OTHER_PERSPECTIVES);
    }
}

