/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class PermissionsLoader {
    private final User user;

    public PermissionsLoader(User user) {
        this.user = user;
    }

    public Set<Account> loadAccounts(String[] orderTypes, AccountType accountType) {
        return this.loadAccounts(orderTypes, (BankUser)null, accountType);
    }

    public Set<Account> loadAccounts(String[] orderTypes, BankUser bankUser, AccountType accountType) {
        return this.loadAccounts(orderTypes, Collections.singletonList(bankUser), accountType);
    }

    public Set<Account> loadAccounts(String[] orderTypes, List<BankUser> bankUsers, AccountType accountType) {
        if (bankUsers == null || bankUsers.size() == 0 || bankUsers.stream().allMatch(x -> x == null)) {
            bankUsers = BankUser.findActiveBanksForUser(this.user);
        }
        HashSet<Account> result = new HashSet<Account>();
        if (orderTypes == null || orderTypes.length == 0) {
            List banks = bankUsers.stream().map(BankUser::getBank).collect(Collectors.toList());
            ExpressionList accountExpression = DB.find(Account.class).where().in("bank", banks).or(Expr.eq((String)"type", (Object)((Object)Account.Type.HTD)), Expr.eq((String)"type", (Object)((Object)Account.Type.MANUAL)));
            Expression accountFilterExpression = PermissionsLoader.getAccountFilter(accountType, "");
            if (accountFilterExpression != null) {
                accountExpression = accountExpression.add(accountFilterExpression);
            }
            result.addAll(accountExpression.findList());
        } else {
            for (UserPermission userPermission : this.getAccountUserPermission("accountPermission.account", accountType, orderTypes, bankUsers)) {
                result.add(userPermission.getAccountPermission().getAccount());
            }
            List permissionsAll = DB.find(UserPermission.class).fetch("bankUser").where().in("bankUser", bankUsers).or(Expr.in((String)"orderType.orderType", (Object[])orderTypes), Expr.in((String)"orderType.fileFormat", (Object[])orderTypes)).isNull("accountPermission").findList();
            HashSet<BankUser> permissionBankUsers = new HashSet<BankUser>();
            for (UserPermission permission : permissionsAll) {
                permissionBankUsers.add(permission.getBankUser());
            }
            Expression expr = Expr.or((Expression)Expr.in((String)"bankUser", permissionBankUsers), (Expression)Expr.and((Expression)Expr.eq((String)"account.type", (Object)((Object)Account.Type.MANUAL)), (Expression)Expr.in((String)"bankUser", bankUsers)));
            Expression accountFilterExpression = PermissionsLoader.getAccountFilter(accountType, "account.");
            if (accountFilterExpression != null) {
                expr = Expr.and((Expression)expr, (Expression)accountFilterExpression);
            }
            List accountPermissions = DB.find(AccountPermission.class).fetch("account").where(expr).findList();
            for (AccountPermission accountPermission : accountPermissions) {
                result.add(accountPermission.getAccount());
            }
        }
        return result;
    }

    public Set<Account> loadAccounts(PaymentTransferType.PmtType pmtType, User user, AccountType accountType) {
        List<BankUser> bankUsers = BankUser.findActiveBanksForUser(user);
        HashMap banksForOrderTypes = new HashMap();
        for (BankUser bankUser : bankUsers) {
            String orderTypeOrBtf = SendParameters.getTransferTypeByBank(bankUser.getBank(), pmtType);
            if (orderTypeOrBtf == null) continue;
            if (banksForOrderTypes.containsKey(orderTypeOrBtf)) {
                ((List)banksForOrderTypes.get(orderTypeOrBtf)).add(bankUser);
                continue;
            }
            ArrayList<BankUser> banks = new ArrayList<BankUser>();
            banks.add(bankUser);
            banksForOrderTypes.put(orderTypeOrBtf, banks);
        }
        HashSet<Account> result = new HashSet<Account>();
        for (Map.Entry entry : banksForOrderTypes.entrySet()) {
            result.addAll(this.loadAccounts(new String[]{(String)entry.getKey()}, (List)entry.getValue(), accountType));
        }
        return result;
    }

    public Set<String> getAccountOrderTypes(Account account, String[] orderTypes) {
        List<BankUser> bankUsers = BankUser.findActiveBanksForUser(this.user);
        HashSet<String> result = new HashSet<String>();
        if (DB.find(AccountPermission.class).where().eq("account", (Object)account).in("bankUser", bankUsers).findCount() > 0) {
            for (UserPermission userPermission : DB.find(UserPermission.class).where().in("bankUser", bankUsers).or(Expr.in((String)"orderType.orderType", (Object[])orderTypes), Expr.in((String)"orderType.fileFormat", (Object[])orderTypes)).findList()) {
                OrderType orderType = userPermission.getOrderType();
                result.add(orderType.getGeneralizedOrderType());
            }
        }
        return result;
    }

    private List<UserPermission> getAccountUserPermission(String loadItem, AccountType accountType, String[] orderTypes, List<BankUser> bankUsers) {
        ExpressionList expression = loadItem == null ? DB.find(UserPermission.class).where() : DB.find(UserPermission.class).fetch(loadItem).where();
        expression = expression.in("bankUser", bankUsers).or(Expr.in((String)"orderType.orderType", (Object[])orderTypes), Expr.in((String)"orderType.fileFormat", (Object[])orderTypes)).isNotNull("accountPermission");
        Expression accountFilterExpression = PermissionsLoader.getAccountFilter(accountType, "accountPermission.account.");
        if (accountFilterExpression != null) {
            expression = expression.add(accountFilterExpression);
        }
        return expression.findList();
    }

    public static Expression getAccountFilter(AccountType accountType, String prefix) {
        if (accountType == null) {
            return null;
        }
        Expression basis = Expr.not((Expression)Expr.eq((String)(prefix + "type"), (Object)((Object)Account.Type.CASH_MANAGEMENT)));
        switch (accountType.ordinal()) {
            case 3: {
                return Expr.and((Expression)basis, (Expression)Expr.and((Expression)Expr.isNotNull((String)(prefix + "frenchBankCode")), (Expression)Expr.and((Expression)Expr.isNotNull((String)(prefix + "frenchBranchCode")), (Expression)Expr.isNotNull((String)(prefix + "frenchAccountNumber")))));
            }
            case 2: {
                return Expr.and((Expression)basis, (Expression)Expr.and((Expression)Expr.isNotNull((String)(prefix + "germanAccountNumber")), (Expression)Expr.isNotNull((String)(prefix + "germanBankCode"))));
            }
            case 4: {
                return Expr.and((Expression)basis, (Expression)Expr.and((Expression)Expr.eq((String)(prefix + "currency"), (Object)"EUR"), (Expression)Expr.and((Expression)Expr.isNotNull((String)(prefix + "germanAccountNumber")), (Expression)Expr.isNotNull((String)(prefix + "germanBankCode")))));
            }
            case 0: {
                return Expr.and((Expression)basis, (Expression)Expr.isNotNull((String)(prefix + "iban")));
            }
            case 1: {
                return Expr.and((Expression)basis, (Expression)Expr.and((Expression)Expr.isNotNull((String)(prefix + "iban")), (Expression)Expr.isNotNull((String)(prefix + "bic"))));
            }
            case 5: {
                Expression accNumber = Expr.or((Expression)Expr.isNotNull((String)(prefix + "iban")), (Expression)Expr.isNotNull((String)(prefix + "nationalAccountNumber")));
                return Expr.and((Expression)basis, (Expression)Expr.and((Expression)accNumber, (Expression)Expr.isNotNull((String)(prefix + "bic"))));
            }
        }
        return null;
    }

    public boolean hasPermissionForAccount(Account account, String orderType, String fileTypeOrBTF) {
        if (account == null || orderType == null && fileTypeOrBTF == null) {
            return false;
        }
        BankUser bankUser = BankUser.findBankUser(account.getBank(), this.user);
        AccountPermission accountPermission = AccountPermission.findAccountPermissionForBank(bankUser, account);
        if (accountPermission == null) {
            return false;
        }
        Set userPermissions = DB.find(UserPermission.class).where().eq("bankUser", (Object)bankUser).or(Expr.eq((String)"accountPermission", null), Expr.eq((String)"accountPermission", (Object)accountPermission)).or(Expr.eq((String)"orderType.orderType", (Object)orderType), Expr.and((Expression)Expr.ne((String)"orderType.fileFormat", null), (Expression)Expr.eq((String)"orderType.fileFormat", (Object)fileTypeOrBTF))).findSet();
        return !userPermissions.isEmpty();
    }

    public static enum AccountType {
        IBAN,
        IBAN_AND_BIC,
        GERMAN,
        FRANCE,
        GERMAN_EUR,
        IBAN_OR_NAT_ACC_NUMBER_AND_BIC;

    }
}

