/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.SignedPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import java.util.Locale;

public class PaymentTypeUtil {
    private final Locale locale;
    private final boolean displayOrdersAsText;
    private final boolean displayInternalInfo;

    public PaymentTypeUtil(Locale locale) {
        this.locale = locale;
        this.displayOrdersAsText = true;
        this.displayInternalInfo = false;
    }

    public PaymentTypeUtil(User user, Locale locale) {
        this.locale = locale;
        DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        this.displayOrdersAsText = store.getBoolean(PreferenceConstants.DISPLAY_ORDERS_AS_TEXT);
        this.displayInternalInfo = store.getBoolean(PreferenceConstants.DISPLAY_INTERNAL_INFO);
    }

    public String getNameForDSOverview(BankSettings bank, String transferType, String orderNumber) {
        return this.getNameForDSOverview(SendParameters.getPmtType(bank, transferType), transferType, orderNumber);
    }

    public String getNameForDSOverview(DsOrderDetails dsOrderDetails) {
        return this.getNameForDSOverview(dsOrderDetails.getPmtType(), dsOrderDetails.getFileType(), dsOrderDetails.getOrderId());
    }

    public String getNameForDSOverview(DsOpenOrder dsOpenOrder) {
        return this.getNameForDSOverview(dsOpenOrder.getPmtType(), dsOpenOrder.getFileType(), dsOpenOrder.getOrderId());
    }

    private String getNameForDSOverview(PaymentTransferType.PmtType pmtType, String transferType, String orderNumber) {
        if (this.displayOrdersAsText) {
            String sendOrderName = pmtType != null ? PaymentTypeUtil.getSendOrderName(this.locale, pmtType, transferType, orderNumber) : PaymentTypeUtil.geOrderIdentification(transferType, orderNumber);
            if (this.displayInternalInfo) {
                return PaymentTypeUtil.appendInternalInfo(sendOrderName, transferType, pmtType);
            }
            return sendOrderName;
        }
        return PaymentTypeUtil.geOrderIdentification(transferType, orderNumber);
    }

    public String getNameForSendOverview(Send send) {
        Send calledBackOrder = Send.findCalledBackOrder(send);
        if (calledBackOrder != null) {
            PaymentTransferType.PmtType pmtType = calledBackOrder.getPmtType();
            if (pmtType != null) {
                return BankingApiMessages.getString(this.locale, "PaymentTypeUtil.cancellationOf", PaymentTypeUtil.getSendOrderName(this.locale, pmtType, calledBackOrder.getOriginalSendType(), calledBackOrder.getOrderNumber()));
            }
            return BankingApiMessages.getString(this.locale, "PaymentTypeUtil.cancellationOf", PaymentTypeUtil.geOrderIdentification(calledBackOrder));
        }
        if (this.displayOrdersAsText) {
            PaymentTransferType.PmtType pmtType = send.getPmtType();
            String sendOrderName = pmtType != null ? PaymentTypeUtil.getSendOrderName(this.locale, pmtType, send.getOriginalSendType(), send.getOrderNumber()) : PaymentTypeUtil.geOrderIdentification(send);
            if (this.displayInternalInfo) {
                return PaymentTypeUtil.appendInternalInfo(sendOrderName, send.getOrderType(), send.getFileTypeOrBTF(), pmtType);
            }
            return sendOrderName;
        }
        return PaymentTypeUtil.geOrderIdentification(send);
    }

    public static String getSendOrderName(Locale locale, PaymentTransferType.PmtType pmtType, String sendType, String orderNumber) {
        String s = PaymentTypeUtil.getUniqueSendOrderName(locale, pmtType);
        if (sendType != null || orderNumber != null) {
            Object info = null;
            if (sendType != null && !sendType.isEmpty()) {
                info = s.isEmpty() ? sendType : " (" + sendType;
            }
            if (orderNumber != null && !orderNumber.isEmpty()) {
                info = info != null ? (String)info + " " + orderNumber : (s.isEmpty() ? orderNumber : " (" + orderNumber);
            }
            if (!s.isEmpty()) {
                info = info + ")";
            }
            return s + (String)info;
        }
        return s;
    }

    public String getNameForSignedPaymentOverview(SignedPayment sp) {
        PaymentTransferType.PmtType pmtType = sp.getPmtType();
        Send send = sp.getSend();
        String signedPaymentName = pmtType != null ? PaymentTypeUtil.getSignedPaymentName(this.locale, pmtType, PaymentTypeUtil.geOrderIdentification(send)) : PaymentTypeUtil.geOrderIdentification(send);
        if (this.displayInternalInfo) {
            return PaymentTypeUtil.appendInternalInfo(signedPaymentName, send.getOrderType(), send.getFileTypeOrBTF(), pmtType);
        }
        return signedPaymentName;
    }

    public static String geOrderIdentification(Send send) {
        return PaymentTypeUtil.geOrderIdentification(send.getOriginalSendType(), send.getOrderNumber());
    }

    public static String geOrderIdentification(HacEntry hacEntry) {
        return PaymentTypeUtil.geOrderIdentification(hacEntry.getGeneralizedOrderType(), hacEntry.getOrderNumber());
    }

    public static String geOrderIdentification(String transferType, String orderNumber) {
        StringBuilder sb = new StringBuilder();
        if (transferType != null) {
            sb.append(transferType);
        }
        if (orderNumber != null) {
            if (!sb.isEmpty()) {
                sb.append(' ');
            }
            sb.append(orderNumber);
        }
        return sb.toString();
    }

    private static String getSignedPaymentName(Locale locale, PaymentTransferType.PmtType pmtType, String orderIdentification) {
        return PaymentTypeUtil.getUniquePaymentName(locale, pmtType) + " (" + orderIdentification + ")";
    }

    public String getNameForOpenPaymentOverview(OpenPayment op) {
        return this.getNameForPaymentOverview(op.getPmtType(), op.getOrderType(), op.getFileTypeOrBTF());
    }

    public String getNameForPeriodicPaymentOverview(PeriodicPayment pp) {
        return this.getNameForPaymentOverview(pp.getPmtType(), pp.getOrderType(), pp.getFileTypeOrBTF());
    }

    public String getNameForPaymentTemplateOverview(PaymentTemplate pt) {
        return this.getNameForPaymentOverview(pt.getPmtType(), pt.getOrderType(), pt.getFileTypeOrBTF());
    }

    private String getNameForPaymentOverview(PaymentTransferType.PmtType pmtType, String orderType, String btf) {
        String paymentTypeName = pmtType != null ? PaymentTypeUtil.getUniquePaymentName(this.locale, pmtType) : orderType;
        if (this.displayInternalInfo) {
            return PaymentTypeUtil.appendInternalInfo(paymentTypeName, orderType, btf, pmtType);
        }
        return paymentTypeName;
    }

    public static String getUniquePaymentName(Locale locale, PaymentTransferType.PmtType pmtType) {
        if (pmtType == null) {
            return "";
        }
        return switch (pmtType) {
            case PaymentTransferType.PmtType.SEPA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transfer", "SEPA");
            case PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.salaryTransfer", "SEPA");
            case PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.expressTransfer", "SEPA");
            case PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.expressSalaryTransfer", "SEPA");
            case PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.instantTransfer", "SEPA");
            case PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transferInForeignCurrency", "SEPA");
            case PaymentTransferType.PmtType.SEPA_NON_SEPA_COUNTRY_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transferInNonSepaCountry", "SEPA");
            case PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.internationalTransfer", "XML");
            case PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.chequePaymentXML", new Object[0]);
            case PaymentTransferType.PmtType.SEPA_URGENT_FOREIGN_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.internationalExpressTransfer", "XML");
            case PaymentTransferType.PmtType.SEPA_VIRTUAL_ACCOUNT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transferVirtualAccount", "SEPA");
            case PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.coreDirectDebit", "SEPA");
            case PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.cor1DirectDebit", "SEPA");
            case PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.b2bDirectDebit", "SEPA");
            case PaymentTransferType.PmtType.DTAZV_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.foreignTransfer", "DTAZV");
            case PaymentTransferType.PmtType.MT101_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.internationalTransfer", "MT101");
            case PaymentTransferType.PmtType.SWISS_ES1_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissES1Transfer", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_ES2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissES2Transfer", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_ESR_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissESRTransfer", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_DOMESTIC_TRANSFER_3, PaymentTransferType.PmtType.SWISS_SEPA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissDomesticTransfer", new Object[0]);
            case PaymentTransferType.PmtType.AUSTRIAN_FOREIGN -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianForeignPayment", "XML");
            case PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianForeignChkPayment", "XML");
            case PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianTaxOfficePayment", "SEPA");
            case PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianUrgentTaxOfficePayment", "SEPA");
            case PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianPostbarPayment", "SEPA");
            case PaymentTransferType.PmtType.C55_CALLBACK -> BankingApiMessages.getString(locale, "PaymentTypeUtil.cancellationCT", "SEPA");
            case PaymentTransferType.PmtType.C55_SDD_CALLBACK -> BankingApiMessages.getString(locale, "PaymentTypeUtil.cancellationDD", "SEPA");
            case PaymentTransferType.PmtType.CFONB160_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.domesticTransfer", "CFONB160");
            case PaymentTransferType.PmtType.CFONB160_URGENT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.domesticExpressTransfer", "CFONB160");
            case PaymentTransferType.PmtType.CFONB160_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.directDomesticDebit", "CFONB160");
            case PaymentTransferType.PmtType.CFONB160_URGENT_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.directDomesticUrgentDebit", "CFONB160");
            case PaymentTransferType.PmtType.CFONB160_BILL_OF_EXCHANGE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.billOfExchange", "CFONB160");
            case PaymentTransferType.PmtType.CFONB320_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.internationalTransfer", "CFONB320");
            case PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_EUR -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVForeignEURTransfer", new Object[0]);
            case PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_NON_EUR -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVForeignNonEURTransfer", new Object[0]);
            case PaymentTransferType.PmtType.BBK_HBV_TARGET2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkTarget2Transfer", new Object[0]);
            case PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_SWIFT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVDomesticSwiftTransfer", new Object[0]);
            case PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_DTA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVDomesticDtaTransfer", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_DTA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZDtaTransfer", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_DTA_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZDtaDirectDebit", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_STEP2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZStep2Transfer", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZPackedDtaTransfer", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZPackedDtaDirectDebit", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_PACKED_STEP2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZPackedStep2Transfer", new Object[0]);
            default -> pmtType.toString();
        };
    }

    public static String getUniqueSendOrderName(Locale locale, PaymentTransferType.PmtType pmtType) {
        if (pmtType == null) {
            return "";
        }
        return switch (pmtType) {
            case PaymentTransferType.PmtType.SEPA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transfers", "SEPA");
            case PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.salaryTransfers", "SEPA");
            case PaymentTransferType.PmtType.SEPA_URGENT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.expressTransfers", "SEPA");
            case PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.expressSalaryTransfers", "SEPA");
            case PaymentTransferType.PmtType.SEPA_INSTANT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.instantTransfers", "SEPA");
            case PaymentTransferType.PmtType.SEPA_FOREIGN_CURRENCY_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transfersInForeignCurrency", "SEPA");
            case PaymentTransferType.PmtType.SEPA_NON_SEPA_COUNTRY_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transfersInNonSepaCountry", "SEPA");
            case PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.internationalTransfers", "XML");
            case PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.chequePaymentsXML", new Object[0]);
            case PaymentTransferType.PmtType.SEPA_URGENT_FOREIGN_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.internationalExpressTransfers", "XML");
            case PaymentTransferType.PmtType.SEPA_VIRTUAL_ACCOUNT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transfersVirtualAccount", "SEPA");
            case PaymentTransferType.PmtType.SEPA_CORE_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.coreDirectDebits", "SEPA");
            case PaymentTransferType.PmtType.SEPA_COR1_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.cor1DirectDebits", "SEPA");
            case PaymentTransferType.PmtType.SEPA_B2B_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.b2bDirectDebits", "SEPA");
            case PaymentTransferType.PmtType.DTAZV_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.foreignTransfers", "DTAZV");
            case PaymentTransferType.PmtType.MT101_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.internationalTransfers", "MT101");
            case PaymentTransferType.PmtType.SWISS_ES1_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissES1Transfers", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_ES2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissES2Transfers", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_ESR_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissESRTransfers", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_DOMESTIC_TRANSFER_3 -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissDomesticTransfers", new Object[0]);
            case PaymentTransferType.PmtType.AUSTRIAN_FOREIGN -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianForeignPayments", "XML");
            case PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianForeignChkPayments", "XML");
            case PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianTaxOfficePayments", "SEPA");
            case PaymentTransferType.PmtType.AUSTRIAN_URGENT_TAX_PAYMENT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianUrgentTaxOfficePayments", "SEPA");
            case PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.austrianPostbarPayments", "SEPA");
            case PaymentTransferType.PmtType.C55_CALLBACK -> BankingApiMessages.getString(locale, "PaymentTypeUtil.cancellationCT", "SEPA");
            case PaymentTransferType.PmtType.C55_SDD_CALLBACK -> BankingApiMessages.getString(locale, "PaymentTypeUtil.cancellationDD", "SEPA");
            case PaymentTransferType.PmtType.CFONB160_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.domesticTransfers", "CFONB160");
            case PaymentTransferType.PmtType.CFONB160_URGENT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.domesticExpressTransfers", "CFONB160");
            case PaymentTransferType.PmtType.CFONB160_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.directDomesticDebit", "CFONB160");
            case PaymentTransferType.PmtType.CFONB160_URGENT_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.directDomesticUrgentDebit", "CFONB160");
            case PaymentTransferType.PmtType.CFONB160_BILL_OF_EXCHANGE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.billsOfExchange", "CFONB160");
            case PaymentTransferType.PmtType.CFONB320_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.internationalTransfers", "CFONB320");
            case PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_EUR -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVForeignEURTransfers", new Object[0]);
            case PaymentTransferType.PmtType.BBK_HBV_FOREIGN_TRANSFER_NON_EUR -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVForeignNonEURTransfers", new Object[0]);
            case PaymentTransferType.PmtType.BBK_HBV_TARGET2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkTarget2Transfers", new Object[0]);
            case PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_SWIFT_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVDomesticSwiftTransfers", new Object[0]);
            case PaymentTransferType.PmtType.BBK_HBV_DOMESTIC_DTA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVDomesticDtaTransfers", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_DTA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZDtaTransfers", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_DTA_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZDtaDirectDebits", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_STEP2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZStep2Transfers", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZPackedDtaTransfers", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_PACKED_DTA_DIRECT_DEBIT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZPackedDtaDirectDebits", new Object[0]);
            case PaymentTransferType.PmtType.BBK_EMZ_PACKED_STEP2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkEMZPackedStep2Transfers", new Object[0]);
            default -> pmtType.toString();
        };
    }

    public static String getNameForSendReport(Locale locale, Send send) {
        PaymentTransferType.PmtType pmtType = send.getPmtType();
        if (pmtType != null) {
            return PaymentTypeUtil.getNameForSendReport(locale, pmtType);
        }
        return null;
    }

    public static String getNameForSendReport(Locale locale, PaymentTransferType.PmtType pmtType) {
        return switch (pmtType) {
            case PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER, PaymentTransferType.PmtType.SEPA_URGENT_FOREIGN_TRANSFER, PaymentTransferType.PmtType.AUSTRIAN_FOREIGN -> BankingApiMessages.getString(locale, "PaymentTypeUtil.reportName.foreignTransfer", new Object[0]);
            case PaymentTransferType.PmtType.SEPA_FOREIGN_CHEQUE, PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.reportName.chequePayment", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_ES1_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.reportName.swissES1Transfer", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_ES2_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.reportName.swissES2Transfer", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_ESR_TRANSFER -> BankingApiMessages.getString(locale, "PaymentTypeUtil.reportName.swissESRTransfer", new Object[0]);
            case PaymentTransferType.PmtType.SWISS_DOMESTIC_TRANSFER_3 -> BankingApiMessages.getString(locale, "PaymentTypeUtil.reportName.domesticTransfer", new Object[0]);
            default -> null;
        };
    }

    public static String getOrderName(PaymentTransferType.PmtType pmtType, String orderID, Locale locale) {
        String name = PaymentTypeUtil.getNameForSendReport(locale, pmtType);
        if (name != null) {
            return name + " " + orderID;
        }
        return null;
    }

    private static String appendInternalInfo(String s, String orderType, String btf, PaymentTransferType.PmtType pmtType) {
        StringBuilder sb = new StringBuilder(s);
        sb.append(" (");
        sb.append(orderType);
        sb.append(",");
        sb.append(btf);
        sb.append(",");
        if (pmtType != null) {
            sb.append(pmtType.name());
        }
        sb.append(")");
        return sb.toString();
    }

    private static String appendInternalInfo(String s, String transferType, PaymentTransferType.PmtType pmtType) {
        StringBuilder sb = new StringBuilder(s);
        sb.append(" (");
        sb.append(transferType);
        sb.append(",");
        if (pmtType != null) {
            sb.append(pmtType.name());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getUniquePaymentTypeName(Locale locale, PaymentType paymentType) {
        return switch (paymentType) {
            case PaymentType.DTAZV -> PaymentTypeUtil.getUniquePaymentName(locale, PaymentTransferType.PmtType.DTAZV_TRANSFER);
            case PaymentType.SWIFT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.bbkHBVForeignTransfer", new Object[0]);
            case PaymentType.MANDATE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.directDebit", "SEPA");
            case PaymentType.MT101 -> PaymentTypeUtil.getUniquePaymentName(locale, PaymentTransferType.PmtType.MT101_TRANSFER);
            case PaymentType.SEPA_FOREIGN -> PaymentTypeUtil.getUniquePaymentName(locale, PaymentTransferType.PmtType.SEPA_FOREIGN_TRANSFER);
            case PaymentType.AUSTRIAN_TAX_OFFICE -> PaymentTypeUtil.getUniquePaymentName(locale, PaymentTransferType.PmtType.AUSTRIAN_TAX_PAYMENT);
            case PaymentType.AUSTRIAN_POSTBAR -> PaymentTypeUtil.getUniquePaymentName(locale, PaymentTransferType.PmtType.AUSTRIAN_POSTBAR_PAYMENT);
            case PaymentType.SWISS_ESR -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissESRTransfer", new Object[0]);
            case PaymentType.SWISS_POST_ACCOUNT -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissES1Transfer", new Object[0]);
            case PaymentType.SWISS_IID -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissES2Transfer", new Object[0]);
            case PaymentType.SWISS_DOMESTIC -> BankingApiMessages.getString(locale, "PaymentTypeUtil.swissDomesticTransfer", new Object[0]);
            case PaymentType.CHEQUE -> BankingApiMessages.getString(locale, "PaymentTypeUtil.chequePayment", new Object[0]);
            default -> BankingApiMessages.getString(locale, "PaymentTypeUtil.transfer", paymentType.name());
        };
    }
}

