/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.PasswordHistory;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.HexTool;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public final class PasswordRequirement {
    private static PasswordRequirement INSTANCE;
    private final int minLength;
    private final boolean lowerCase;
    private final boolean upperCase;
    private final boolean number;
    private final boolean special;
    private final boolean letter;
    private final int changeInDays;
    private final int historyCheck;
    private final int userLockedCount;

    public static void reloadRequirements() {
        INSTANCE = null;
    }

    public static boolean isLessSecureThanDefault(int minLength, boolean letter, boolean lowerCase, boolean upperCase, boolean number, boolean special, int changeInDays, int historyCheck, int userLockedCount) {
        return minLength < Integer.valueOf(PreferenceConstants.PASSWORD_MIN_LENGTH.getDefaultValue()) || Boolean.valueOf(PreferenceConstants.PASSWORD_NEED_LETTER.getDefaultValue()) != false && !letter || Boolean.valueOf(PreferenceConstants.PASSWORD_NEED_LOWER.getDefaultValue()) != false && !lowerCase || Boolean.valueOf(PreferenceConstants.PASSWORD_NEED_UPPER.getDefaultValue()) != false && !upperCase || Boolean.valueOf(PreferenceConstants.PASSWORD_NEED_NUMBER.getDefaultValue()) != false && !number || Boolean.valueOf(PreferenceConstants.PASSWORD_NEED_SPECIAL.getDefaultValue()) != false && !special || changeInDays < Integer.valueOf(PreferenceConstants.PASSWORD_CHANGE_IN_DAYS.getDefaultValue()) || userLockedCount < Integer.valueOf(PreferenceConstants.PASSWORD_USER_LOCKED.getDefaultValue()) || historyCheck < Integer.valueOf(PreferenceConstants.PASSWORD_CHECK_HISTORY.getDefaultValue());
    }

    public static void setDefaultValues(int minLength, boolean letter, boolean lowerCase, boolean upperCase, boolean number, boolean special, int changeInDays, int historyCheck, int userLockedCount) {
        PreferenceConstants.PASSWORD_CHANGE_IN_DAYS.setDefaultValue(String.valueOf(changeInDays));
        PreferenceConstants.PASSWORD_CHECK_HISTORY.setDefaultValue(String.valueOf(historyCheck));
        PreferenceConstants.PASSWORD_MIN_LENGTH.setDefaultValue(String.valueOf(minLength));
        PreferenceConstants.PASSWORD_NEED_LETTER.setDefaultValue(String.valueOf(letter));
        PreferenceConstants.PASSWORD_NEED_LOWER.setDefaultValue(String.valueOf(lowerCase));
        PreferenceConstants.PASSWORD_NEED_NUMBER.setDefaultValue(String.valueOf(number));
        PreferenceConstants.PASSWORD_NEED_SPECIAL.setDefaultValue(String.valueOf(special));
        PreferenceConstants.PASSWORD_NEED_UPPER.setDefaultValue(String.valueOf(upperCase));
        PreferenceConstants.PASSWORD_USER_LOCKED.setDefaultValue(String.valueOf(userLockedCount));
    }

    public static PasswordRequirement getRequirement() {
        if (INSTANCE == null) {
            DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null);
            INSTANCE = new PasswordRequirement(store.getInt(PreferenceConstants.PASSWORD_MIN_LENGTH), store.getBoolean(PreferenceConstants.PASSWORD_NEED_LETTER), store.getBoolean(PreferenceConstants.PASSWORD_NEED_LOWER), store.getBoolean(PreferenceConstants.PASSWORD_NEED_UPPER), store.getBoolean(PreferenceConstants.PASSWORD_NEED_NUMBER), store.getBoolean(PreferenceConstants.PASSWORD_NEED_SPECIAL), store.getInt(PreferenceConstants.PASSWORD_CHANGE_IN_DAYS), store.getInt(PreferenceConstants.PASSWORD_CHECK_HISTORY), store.getInt(PreferenceConstants.PASSWORD_USER_LOCKED));
        }
        return INSTANCE;
    }

    private PasswordRequirement(int minLength, boolean letter, boolean lowerCase, boolean upperCase, boolean number, boolean special, int changeInDays, int historyCheck, int userLockedCount) {
        this.minLength = minLength;
        this.letter = letter;
        this.lowerCase = lowerCase;
        this.upperCase = upperCase;
        this.number = number;
        this.special = special;
        this.changeInDays = changeInDays;
        this.historyCheck = historyCheck;
        this.userLockedCount = userLockedCount;
    }

    public String check(char[] pwd, User user, Locale locale) {
        block21: {
            boolean error;
            if (this.minLength > 0 && pwd.length < this.minLength) {
                return BankingApiMessages.getString(locale, "PasswordRequirement.minLength", this.minLength);
            }
            if (this.letter) {
                error = true;
                for (char c : pwd) {
                    if (!Character.isLetter(c)) continue;
                    error = false;
                    break;
                }
                if (error) {
                    return BankingApiMessages.getString(locale, "PasswordRequirement.letter", new Object[0]);
                }
            }
            if (this.lowerCase) {
                error = true;
                for (char c : pwd) {
                    if (!Character.isLowerCase(c)) continue;
                    error = false;
                    break;
                }
                if (error) {
                    return BankingApiMessages.getString(locale, "PasswordRequirement.lowerCase", new Object[0]);
                }
            }
            if (this.upperCase) {
                error = true;
                for (char c : pwd) {
                    if (!Character.isUpperCase(c)) continue;
                    error = false;
                    break;
                }
                if (error) {
                    return BankingApiMessages.getString(locale, "PasswordRequirement.upperCase", new Object[0]);
                }
            }
            if (this.number) {
                error = true;
                for (char c : pwd) {
                    if (!Character.isDigit(c)) continue;
                    error = false;
                    break;
                }
                if (error) {
                    return BankingApiMessages.getString(locale, "PasswordRequirement.number", new Object[0]);
                }
            }
            if (this.special) {
                error = true;
                for (char c : pwd) {
                    if (Character.isLetterOrDigit(c)) continue;
                    error = false;
                    break;
                }
                if (error) {
                    return BankingApiMessages.getString(locale, "PasswordRequirement.special", new Object[0]);
                }
            }
            if (user != null && this.historyCheck > 0) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA1");
                    String hash = HexTool.toHex(md.digest(new String(pwd).getBytes()));
                    if (this.historyCheck <= 0) break block21;
                    int toCheck = this.historyCheck;
                    for (PasswordHistory h : PasswordHistory.getHistory(user)) {
                        if (h.getHashValue().equals(hash)) {
                            return BankingApiMessages.getString(locale, "PasswordRequirement.historyCheck", new Object[0]);
                        }
                        if (--toCheck != 0) continue;
                        break;
                    }
                }
                catch (NoSuchAlgorithmException no) {
                    throw new RuntimeException(no);
                }
            }
        }
        return null;
    }

    public void saveUsage(User user, char[] pwd, BLLogger logger) {
        long savePoint = System.currentTimeMillis();
        if (this.historyCheck > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA1");
                String hash = HexTool.toHex(md.digest(new String(pwd).getBytes()));
                List<PasswordHistory> history = PasswordHistory.getHistory(user);
                for (int i = this.historyCheck; i <= history.size(); ++i) {
                    DB.delete(history.get(i - 1));
                }
                PasswordHistory h = new PasswordHistory();
                h.setChangeDate(new Timestamp(savePoint));
                h.setHashValue(hash);
                h.setUser(user);
                h.save();
            }
            catch (NoSuchAlgorithmException no) {
                throw new RuntimeException(no);
            }
        }
        if (logger != null) {
            user.setLastPasswordChange(new Date(savePoint));
            user.save();
            logger.logInfo("The password of the user " + user.getName() + " was changed.");
        }
    }

    public boolean hasToChange(User user) {
        if (user == null || User.SecurityMedium.SMARTCARD.equals((Object)user.getSecurityMedium())) {
            return false;
        }
        if (this.changeInDays > 0) {
            if (user.getLastPasswordChange() == null) {
                return true;
            }
            Calendar changeDate = Calendar.getInstance();
            changeDate.setTime(user.getLastPasswordChange());
            changeDate.add(5, this.changeInDays);
            return System.currentTimeMillis() - changeDate.getTimeInMillis() > 0L;
        }
        return false;
    }

    public String getLoginInfo(User user, Locale locale) {
        if (user == null || User.SecurityMedium.SMARTCARD.equals((Object)user.getSecurityMedium()) || user.getLastLogin() == null) {
            return null;
        }
        if (this.changeInDays > 0) {
            Calendar changeDate = Calendar.getInstance();
            if (user.getLastPasswordChange() == null) {
                return BankingApiMessages.getString(locale, "PasswordRequirement.loginMessage", changeDate.getTime(), 0);
            }
            changeDate.setTime(user.getLastPasswordChange());
            changeDate.add(5, this.changeInDays);
            Calendar nowPlus5 = Calendar.getInstance();
            nowPlus5.add(5, 5);
            if (changeDate.before(nowPlus5)) {
                Calendar day = Calendar.getInstance();
                long diff = 0L;
                while (day.getTimeInMillis() < changeDate.getTimeInMillis()) {
                    day.add(5, 1);
                    ++diff;
                }
                return BankingApiMessages.getString(locale, "PasswordRequirement.loginMessage", changeDate.getTime(), diff);
            }
        }
        return null;
    }

    public List<String> getDescription(Locale locale) {
        ArrayList<String> description = new ArrayList<String>();
        if (this.minLength > 1) {
            description.add(PreferenceConstants.PASSWORD_MIN_LENGTH.getLabel(locale) + " " + this.minLength);
        }
        if (this.letter && !this.lowerCase && !this.upperCase) {
            description.add(PreferenceConstants.PASSWORD_NEED_LETTER.getLabel(locale));
        }
        if (this.lowerCase) {
            description.add(PreferenceConstants.PASSWORD_NEED_LOWER.getLabel(locale));
        }
        if (this.upperCase) {
            description.add(PreferenceConstants.PASSWORD_NEED_UPPER.getLabel(locale));
        }
        if (this.number) {
            description.add(PreferenceConstants.PASSWORD_NEED_NUMBER.getLabel(locale));
        }
        if (this.special) {
            description.add(PreferenceConstants.PASSWORD_NEED_SPECIAL.getLabel(locale));
        }
        return description;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public boolean isLowerCase() {
        return this.lowerCase;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public boolean isNumber() {
        return this.number;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean isLetter() {
        return this.letter;
    }
}

