/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.ebics.client.BTFTranslator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OrderTypeUtil {
    public static final String BTD = "BTD";
    public static final String BTU = "BTU";
    private static final Map<String, OrderTypes> map = new HashMap<String, OrderTypes>();

    public static OrderType.TransferType getTransferType(String orderType) {
        OrderTypes ot;
        if (map.size() == 0) {
            OrderTypeUtil.initializeMap();
        }
        if ((ot = map.get(orderType)) != null) {
            return ot.getTransferType();
        }
        return null;
    }

    public static List<OrderType> findOrderTypesForSendDialog(BankUser bankUser) {
        if (map.size() == 0) {
            OrderTypeUtil.initializeMap();
        }
        boolean isProtocolH005OrNewer = BankUtils.isProtocolH005OrNewer(bankUser.getBank().getProtocolVersion());
        ArrayList<OrderType> orderTypes = new ArrayList<OrderType>();
        List permissions = UserPermission.findSendPermissionsForBankUser(bankUser).findList();
        for (UserPermission permission : permissions) {
            OrderType orderType = permission.getOrderType();
            if (!OrderTypeUtil.displayInTransferDialog(isProtocolH005OrNewer, orderType)) continue;
            orderTypes.add(orderType);
        }
        return orderTypes;
    }

    public static List<OrderType> findOrderTypesForFetchDialog(BankSettings bank) {
        return OrderTypeUtil.getOrderTypesForDialog(bank, OrderType.findFetchOrderTypesForBank(bank));
    }

    private static List<OrderType> getOrderTypesForDialog(BankSettings bank, List<OrderType> allOrderTypes) {
        if (map.size() == 0) {
            OrderTypeUtil.initializeMap();
        }
        boolean isProtocolH005OrNewer = BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion());
        ArrayList<OrderType> orderTypes = new ArrayList<OrderType>();
        for (OrderType vo : allOrderTypes) {
            if (!OrderTypeUtil.displayInTransferDialog(isProtocolH005OrNewer, vo)) continue;
            orderTypes.add(vo);
        }
        return orderTypes;
    }

    private static boolean displayInTransferDialog(boolean isProtocolH005OrNewer, OrderType vo) {
        if (vo != null) {
            String orderType = vo.getOrderType();
            OrderTypes ot = map.get(orderType);
            if (isProtocolH005OrNewer) {
                return ot != null && (ot.displayInTransferDialog() || BTU.equals(orderType) || BTD.equals(orderType));
            }
            return ot == null || ot.displayInTransferDialog();
        }
        return false;
    }

    private static void initializeMap() {
        for (OrderTypes ot : OrderTypes.values()) {
            map.put(ot.getOrderType(), ot);
        }
    }

    public static String getSendOrderTypeDescription(OrderType vo, boolean isProtocolH005OrNewer) {
        if (isProtocolH005OrNewer) {
            String transferType = vo.getGeneralizedOrderType();
            String pmtTypeName = null;
            PaymentTransferType.PmtType pmtType = SendParameters.getPmtType(vo.getBank(), transferType);
            if (pmtType != null) {
                pmtTypeName = PaymentTypeUtil.getUniquePaymentName(Locale.getDefault(), pmtType);
            }
            if (pmtTypeName != null) {
                return pmtTypeName + " (" + transferType + ")";
            }
            if (vo.getDescription() != null) {
                return vo.getDescription() + " (" + transferType + ")";
            }
            return transferType;
        }
        if (vo.getDescription() != null) {
            return vo.getOrderType() + " - " + vo.getDescription();
        }
        return vo.getOrderType();
    }

    public static String getFetchOrderTypeDescription(OrderType vo, boolean isProtocolH005OrNewer) {
        if (isProtocolH005OrNewer) {
            if (vo.getDescription() != null) {
                return vo.getDescription() + " (" + vo.getGeneralizedOrderType() + ")";
            }
            return vo.getGeneralizedOrderType();
        }
        if (vo.getDescription() != null) {
            return vo.getOrderType() + " - " + vo.getDescription();
        }
        return vo.getOrderType();
    }

    public static String getTransferTypeFromDescription(String description, boolean isProtocolH005OrNewer) {
        if (isProtocolH005OrNewer) {
            String s;
            int pos1 = description.lastIndexOf("(") + 1;
            int pos2 = description.lastIndexOf(")");
            if (pos2 > pos1 && pos1 >= 1 && (Util.isOrderType(s = description.substring(pos1, pos2)) || BTFTranslator.isBTFString(s))) {
                return s;
            }
            return description;
        }
        if (description.length() > 3) {
            return description.substring(0, 3);
        }
        return description;
    }

    public static boolean isAdminOrderType(String orderType) {
        if (orderType != null) {
            if (map.size() == 0) {
                OrderTypeUtil.initializeMap();
            }
            return map.containsKey(orderType);
        }
        return false;
    }

    private static enum OrderTypes {
        BTD("BTD", OrderType.TransferType.FETCH),
        BTU("BTU", OrderType.TransferType.SEND),
        HAA("HAA", OrderType.TransferType.FETCH, true),
        HAC("HAC", OrderType.TransferType.FETCH, true),
        HCA("HCA", OrderType.TransferType.SEND),
        HCS("HCS", OrderType.TransferType.SEND),
        HEV("HEV", OrderType.TransferType.FETCH),
        HIA("HIA", OrderType.TransferType.SEND),
        HKD("HKD", OrderType.TransferType.FETCH, true),
        HPB("HPB", OrderType.TransferType.FETCH),
        HPD("HPD", OrderType.TransferType.FETCH, true),
        HTD("HTD", OrderType.TransferType.FETCH, true),
        HVD("HVD", OrderType.TransferType.FETCH),
        HVE("HVE", OrderType.TransferType.SEND),
        HVS("HVS", OrderType.TransferType.SEND),
        HVT("HVT", OrderType.TransferType.FETCH),
        HVU("HVU", OrderType.TransferType.FETCH),
        HVZ("HVZ", OrderType.TransferType.FETCH),
        H3K("H3K", OrderType.TransferType.SEND),
        INI("INI", OrderType.TransferType.SEND),
        PTK("PTK", OrderType.TransferType.FETCH, true),
        PUB("PUB", OrderType.TransferType.SEND),
        SPR("SPR", OrderType.TransferType.SEND),
        FDL("FDL", OrderType.TransferType.FETCH),
        FUL("FUL", OrderType.TransferType.SEND),
        HSA("HSA", OrderType.TransferType.SEND);

        private final String orderType;
        private final OrderType.TransferType transferType;
        private final boolean displayInTransferDialog;

        private OrderTypes(String orderType, OrderType.TransferType transferType) {
            this(orderType, transferType, false);
        }

        private OrderTypes(String orderType, OrderType.TransferType transferType, boolean displayInTransferDialog) {
            this.orderType = orderType;
            this.transferType = transferType;
            this.displayInTransferDialog = displayInTransferDialog;
        }

        private String getOrderType() {
            return this.orderType;
        }

        private OrderType.TransferType getTransferType() {
            return this.transferType;
        }

        private boolean displayInTransferDialog() {
            return this.displayInTransferDialog;
        }
    }
}

