/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.Log;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;

public class Logger {
    public static final int MESSAGE_COLUMN_SIZE = 500;
    private static final Set<String> ERROR_MESSAGE_TYPES;
    private static final Set<PaymentTransferType.PmtType> SALARY_PMT_TYPES;
    private static final Set<String> LOG_TYPES_OPEN_PAYMENT;
    private static final int PREF_TYPE_USER = 0;
    private static final int PREF_TYPE_TENANT = 1;
    private static final int PREF_TYPE_ADMIN = 2;

    public static boolean isErrorLog(Log log) {
        return ERROR_MESSAGE_TYPES.contains(log.getMessageName());
    }

    public static void logOriginatorCreated(User user, PaymentOriginator originator) {
        Logger.log(Message.ORIGINATOR_CREATED, originator.getTenant(), user, new Serializable[]{originator.getId(), originator.getName()});
    }

    public static void logOriginatorDeleted(User user, PaymentOriginator originator) {
        Logger.log(Message.ORIGINATOR_DELETED, originator.getTenant(), user, new Serializable[]{originator.getId(), originator.getName()});
    }

    public static void logOriginatorModified(User user, PaymentOriginator originator, OriginatorField field, String oldValue, String newValue) {
        Logger.log(Message.ORIGINATOR_MODIFIED, originator.getTenant(), user, new Serializable[]{originator.getId(), originator.getName(), field, Logger.checkNull(oldValue), Logger.checkNull(newValue)});
    }

    public static void logRecipientCreated(User user, PaymentRecipient recipient) {
        Logger.log(Message.RECIPIENT_CREATED, recipient.getTenant(), user, new Serializable[]{recipient.getId(), recipient.getName()});
    }

    public static void logRecipientDeleted(User user, PaymentRecipient recipient) {
        Logger.log(Message.RECIPIENT_DELETED, recipient.getTenant(), user, new Serializable[]{recipient.getId(), recipient.getName()});
    }

    public static void logRecipientModified(User user, PaymentRecipient recipient, RecipientField field, String oldValue, String newValue) {
        Logger.log(Message.RECIPIENT_MODIFIED, recipient.getTenant(), user, new Serializable[]{recipient.getId(), recipient.getName(), field, Logger.checkNull(oldValue), Logger.checkNull(newValue)});
    }

    public static void logRecipientRenamedFromVOP(User user, PaymentRecipient recipient, String oldName, String newName) {
        Logger.log(Message.RECIPIENT_RENAMED_FROM_VOP, recipient.getTenant(), user, new Serializable[]{recipient.getId(), recipient.getName(), Logger.checkNull(oldName)});
    }

    public static void logSepaMandateCreated(User user, PaymentRecipient mandateRecipient) {
        Logger.log(Message.SEPA_MANDATE_CREATED, mandateRecipient.getTenant(), user, new Serializable[]{mandateRecipient.getId(), mandateRecipient.getDisplayName()});
    }

    public static void logSepaMandateDeleted(User user, PaymentRecipient mandateRecipient) {
        Logger.log(Message.SEPA_MANDATE_DELETED, mandateRecipient.getTenant(), user, new Serializable[]{mandateRecipient.getId(), mandateRecipient.getDisplayName()});
    }

    public static void logSepaMandateModified(User user, PaymentRecipient mandateRecipient, RecipientField field, String oldValue, String newValue) {
        Logger.log(Message.SEPA_MANDATE_MODIFIED, mandateRecipient.getTenant(), user, new Serializable[]{mandateRecipient.getId(), mandateRecipient.getDisplayName(), field, Logger.checkNull(oldValue), Logger.checkNull(newValue)});
    }

    public static void logAdminLoginSuccessful(User actor, String ipAddress) {
        Logger.log(Message.ADMIN_LOGIN_SUCCESSSFUL, Logger.checkSingleTenant(actor), actor, new Serializable[]{ipAddress});
    }

    public static void logAdminLoginFailed(User actor, String reason, String ipAddress) {
        Logger.log(Message.ADMIN_LOGIN_FAILED, Logger.checkSingleTenant(actor), actor, new Serializable[]{reason, ipAddress});
    }

    public static void logAdminLocked(User actor, String ipAddress) {
        Logger.log(Message.ADMIN_LOCKED, Logger.checkSingleTenant(actor), actor, new Serializable[]{actor.getName(), ipAddress});
    }

    public static void logBankCreated(User actor, BankSettings bank) {
        Logger.log(Message.BANK_CREATED, bank.getTenant(), actor, new Serializable[]{bank.getBankId(), bank.getDisplayName()});
    }

    public static void logBankModified(User actor, BankSettings bank) {
        Logger.log(Message.BANK_MODIFIED, bank.getTenant(), actor, new Serializable[]{bank.getBankId(), bank.getDisplayName()});
    }

    public static void logBankDeleted(User actor, BankSettings bank) {
        Logger.log(Message.BANK_DELETED, bank.getTenant(), actor, new Serializable[]{bank.getBankId(), bank.getDisplayName()});
    }

    public static void logBankAddedUser(User actor, User user, BankSettings bank) {
        Logger.log(Message.BANK_USER_ADDED, bank.getTenant(), actor, new Serializable[]{bank.getBankId(), bank.getDisplayName(), user.getId(), user.getName()});
    }

    public static void logBankRemovedUser(User actor, User user, BankSettings bank) {
        Logger.log(Message.BANK_USER_REMOVED, bank.getTenant(), actor, new Serializable[]{bank.getBankId(), bank.getDisplayName(), user.getId(), user.getName()});
    }

    public static void logBankModified(User actor, BankSettings bank, BankField field, String oldName) {
        Logger.log(Message.BANK_FIELD_CHANGED, bank.getTenant(), actor, new Serializable[]{bank.getBankId(), field, Logger.checkNull(oldName), bank.getDisplayName()});
    }

    public static void logBankMovedToTenant(User actor, BankSettings bank, Tenant oldTenant) {
        Logger.log(Message.BANK_MOVE_TENANT, bank.getTenant(), actor, new Serializable[]{bank.getBankId(), bank.getDisplayName(), oldTenant.getName(), oldTenant.getId(), bank.getTenant().getName(), bank.getTenant().getId()});
    }

    public static void logUserCreated(User actor, User user) {
        Logger.log(Message.USER_CREATED, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
    }

    public static void logUserModified(User actor, User user) {
        Logger.log(Message.USER_MODIFIED, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
    }

    public static void logUserDeleted(User actor, User user) {
        Logger.log(Message.USER_DELETED, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
    }

    public static void logUserReset(User actor, User user) {
        Logger.log(Message.USER_RESET, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
    }

    public static void logUserLocked(User actor, User user) {
        Logger.log(Message.USER_LOCKED, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
    }

    public static void logUserResetErrorCounter(User actor, User user) {
        Logger.log(Message.USER_RESET_ERROR_COUNTER, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
    }

    public static void logUserRenamed(User actor, User user, String oldName) {
        Logger.log(Message.USER_RENAMED, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName(), oldName});
    }

    public static void logUserChangedAdminPrivileges(User actor, User user) {
        if (user.isAdmin()) {
            Logger.log(Message.USER_GRANTED_ADMIN_PRIVILEGES, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
        } else {
            Logger.log(Message.USER_REMOVED_ADMIN_PRIVILEGES, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
        }
    }

    public static void logUserChangedPermission(User actor, User user, String permissionShortDescription, boolean newValue) {
        if (newValue) {
            Logger.log(Message.USER_GRANTED_PERMISSION, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName(), permissionShortDescription});
        } else {
            Logger.log(Message.USER_REMOVED_PERMISSION, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName(), permissionShortDescription});
        }
    }

    public static void logUserChangedSalaryPermission(User actor, User user, String newPermissionKey) {
        if ("0".equals(newPermissionKey)) {
            Logger.log(Message.USER_CHANGED_SALARY_PERMISSION_ALL, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
        } else if ("1".equals(newPermissionKey)) {
            Logger.log(Message.USER_CHANGED_SALARY_PERMISSION_NO_AMOUNTS, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
        } else if ("3".equals(newPermissionKey)) {
            Logger.log(Message.USER_CHANGED_SALARY_PERMISSION_NO_DETAILS, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
        } else {
            Logger.log(Message.USER_CHANGED_SALARY_PERMISSION_NONE, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
        }
    }

    public static void logTenantCreated(User actor, Tenant tenant) {
        Logger.log(Message.TENANT_CREATED, tenant, actor, new Serializable[]{tenant.getId(), tenant.getName()});
    }

    public static void logTenantDeleted(User actor, Tenant tenant) {
        Logger.log(Message.TENANT_DELETED, tenant, actor, new Serializable[]{tenant.getId(), tenant.getName()});
    }

    public static void logTenantRenamed(User actor, Tenant tenant, String oldName) {
        Logger.log(Message.TENANT_RENAMED, tenant, actor, new Serializable[]{tenant.getId(), tenant.getName(), oldName});
    }

    public static void logTenantChangedUserLimit(User actor, Tenant tenant, Integer oldLimit) {
        Integer newLimit = tenant.getUserCount();
        String limitOld = oldLimit != null && oldLimit > 0 ? String.valueOf(oldLimit) : "UNLIMITED";
        String limitNew = newLimit != null && newLimit > 0 ? String.valueOf(newLimit) : "UNLIMITED";
        Logger.log(Message.TENANT_CHANGED_USER_LIMIT, tenant, actor, new Serializable[]{tenant.getId(), tenant.getName(), limitOld, limitNew});
    }

    public static void logTenantAddedUser(User actor, User user, Tenant tenant) {
        Logger.log(Message.TENANT_USER_ADDED, tenant, actor, new Serializable[]{tenant.getId(), tenant.getName(), user.getId(), user.getName()});
    }

    public static void logTenantDroppedUser(User actor, User user, Tenant tenant) {
        Logger.log(Message.TENANT_USER_REMOVED, tenant, actor, new Serializable[]{tenant.getId(), tenant.getName(), user.getId(), user.getName()});
    }

    public static void logTenantGrantManagingUserPrivileges(User actor, User user, Tenant tenant) {
        Logger.log(Message.TENANT_GRANT_MANAGING_PRIVILEGES, tenant, actor, new Serializable[]{tenant.getId(), tenant.getName(), user.getId(), user.getName()});
    }

    public static void logTenantRemoveManagingUserPrivileges(User actor, User user, Tenant tenant) {
        Logger.log(Message.TENANT_REMOVED_MANAGING_PRIVILEGES, tenant, actor, new Serializable[]{tenant.getId(), tenant.getName(), user.getId(), user.getName()});
    }

    public static void logDeletedAllYubikeysForUser(User actor, User user) {
        Logger.log(Message.USER_REMOVED_ALL_YUBIKEYS, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName()});
    }

    public static void logYubikeyAdded(User actor, User user, Yubikey yubikey) {
        Logger.log(Message.USER_ADDED_YUBIKEYS, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName(), yubikey.getId()});
    }

    public static void logYubikeyDeleted(User actor, User user, Yubikey yubikey) {
        Logger.log(Message.USER_DELETED_YUBIKEYS, Logger.checkSingleTenant(user), actor, new Serializable[]{user.getId(), user.getName(), Logger.checkNull(yubikey.getDescription()), yubikey.getId()});
    }

    public static void logDirectoryScannerCreated(User actor, DirectoryScanner directoryScanner) {
        Logger.log(Message.DIRECTORY_SCANNER_CREATED, directoryScanner.getBank().getTenant(), actor, new Serializable[]{directoryScanner.getId(), directoryScanner.getDirectory()});
    }

    public static void logDirectoryScannerDeleted(User actor, DirectoryScanner directoryScanner) {
        Logger.log(Message.DIRECTORY_SCANNER_DELETED, directoryScanner.getBank().getTenant(), actor, new Serializable[]{directoryScanner.getId(), directoryScanner.getDirectory()});
    }

    public static void logDirectoryScannerChanged(User actor, DirectoryScanner directoryScanner, DirectoryScannerField field, String oldValue, String newValue) {
        Logger.log(Message.DIRECTORY_SCANNER_CHANGED, directoryScanner.getBank().getTenant(), actor, new Serializable[]{directoryScanner.getId(), directoryScanner.getDirectory(), field, Logger.checkNull(oldValue), Logger.checkNull(newValue)});
    }

    private static int getPrefType(DatabasePreferenceConstant preference) {
        if (preference.isUserSpecific() && !preference.isOnlyConfigurableByAdmin() && !preference.isOnlyConfigurableByAdminOrTenantAdmin()) {
            return 0;
        }
        if (preference.isOnlyConfigurableByAdminOrTenantAdmin()) {
            return 1;
        }
        return 2;
    }

    public static void logPreferenceModifiedDetail(User actor, DatabasePreferenceConstant prefKey, String oldValue, String newValue) {
        Logger.logPreferenceModifiedDetail(actor, prefKey, oldValue, newValue, Logger.getPrefType(prefKey), "");
    }

    public static void logPreferenceModifiedDetail(User actor, Tenant tenant, DatabasePreferenceConstant prefKey, String oldValue, String newValue) {
        Logger.logPreferenceModifiedDetail(actor, prefKey, oldValue, newValue, Logger.getPrefType(prefKey), tenant.getName());
    }

    private static void logPreferenceModifiedDetail(User actor, DatabasePreferenceConstant prefKey, String oldValue, String newValue, int prefType, String tenantName) {
        Logger.log(Message.PREFERENCE_CHANGED, Logger.checkSingleTenant(actor), actor, new Serializable[]{Integer.valueOf(prefType), tenantName, prefKey.getId(), Logger.checkNull(oldValue), Logger.checkNull(newValue)});
    }

    public static void logPreferencesCleanedUpTransfers(User actor) {
        Logger.log(Message.CLEANUP_TRANSFERS, Logger.checkSingleTenant(actor), actor, new Serializable[0]);
    }

    public static void logPreferencesCleanedUpDes(User actor) {
        Logger.log(Message.CLEANUP_DES, Logger.checkSingleTenant(actor), actor, new Serializable[0]);
    }

    public static void logPreferencesCleanedUpCm(User actor) {
        Logger.log(Message.CLEANUP_CM, Logger.checkSingleTenant(actor), actor, new Serializable[0]);
    }

    public static void logDatabaseMigrationStarted(User actor, String dbTypeName, String url, String dbUserName) {
        Logger.log(Message.DATABASE_MIGRATION_START, Logger.checkSingleTenant(actor), actor, new Serializable[]{dbTypeName, url, dbUserName});
    }

    public static void logDatabaseMigrationFinishedError(User actor, String dbTypeName, String url, String dbUserName) {
        Logger.log(Message.DATABASE_MIGRATION_FINISHED_ERROR, Logger.checkSingleTenant(actor), actor, new Serializable[]{dbTypeName, url, dbUserName});
    }

    public static void logDatabaseMigrationFinishedSuccess(User actor, String dbTypeName, String url, String dbUserName) {
        Logger.log(Message.DATABASE_MIGRATION_FINISHED_SUCCESS, Logger.checkSingleTenant(actor), actor, new Serializable[]{dbTypeName, url, dbUserName});
    }

    public static void logExecutedCustomSqlQuery(User actor, String query) {
        Logger.log(Message.DATABASE_CUSTOM_SQL_QUERY, Logger.checkSingleTenant(actor), actor, new Serializable[]{query});
    }

    public static void logExecutedCustomSqlUpdate(User actor, String query, int nRowsModified) {
        Logger.log(Message.DATABASE_CUSTOM_SQL_UPDATE, Logger.checkSingleTenant(actor), actor, new Serializable[]{query, Integer.valueOf(nRowsModified)});
    }

    public static void logSchedulerChangedBankUser(User actor, Scheduler scheduler, User oldUser, User newUser) {
        String oldUserName = oldUser == null ? null : oldUser.getName();
        Integer oldUserId = oldUser == null ? null : oldUser.getId();
        String newUserName = newUser == null ? null : newUser.getName();
        Integer newUserId = newUser == null ? null : newUser.getId();
        Logger.log(Message.SCHEDULER_CHANGED_BANKUSER, scheduler.getBank().getTenant(), actor, new Serializable[]{scheduler.getId(), scheduler.getBank().getDisplayName(), oldUserName, oldUserId, newUserName, newUserId});
    }

    public static void logSchedulerCreated(User actor, Scheduler scheduler) {
        Logger.log(Message.SCHEDULER_CREATED, scheduler.getBank().getTenant(), actor, new Serializable[]{scheduler.getId(), scheduler.getBank().getDisplayName()});
    }

    public static void logSchedulerDeleted(User actor, Scheduler scheduler) {
        Logger.log(Message.SCHEDULER_DELETED, scheduler.getBank().getTenant(), actor, new Serializable[]{scheduler.getId(), scheduler.getBank().getDisplayName()});
    }

    public static void logDatabaseAccountsMerged(User actor) {
        Logger.log(Message.ACCOUNTS_MERGED, null, actor, new Serializable[0]);
    }

    public static void logOpenPaymentCreated(User actor, OpenPayment openPayment) {
        Account account = openPayment.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(openPayment.getAmount(), Currency.getInstance(openPayment.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = openPayment.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.OPEN_PAYMENT_CREATED, bank.getTenant(), account, pmtType, actor, new Serializable[]{openPayment.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(openPayment.getRecipient()), amount});
    }

    public static void logOpenPaymentDeleted(User actor, OpenPayment openPayment) {
        Account account = openPayment.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(openPayment.getAmount(), Currency.getInstance(openPayment.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = openPayment.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.OPEN_PAYMENT_DELETED, bank.getTenant(), account, pmtType, actor, new Serializable[]{openPayment.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(openPayment.getRecipient()), amount});
    }

    public static void logOpenPaymentModified(User actor, OpenPayment openPayment, PaymentField field, String oldValue, String newValue) {
        Account account = openPayment.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(openPayment.getAmount(), Currency.getInstance(openPayment.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = openPayment.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.OPEN_PAYMENT_MODIFIED, bank.getTenant(), account, pmtType, actor, new Serializable[]{openPayment.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(openPayment.getRecipient()), amount, field, Logger.checkNull(oldValue), Logger.checkNull(newValue)});
    }

    public static void logOpenPaymentSigned(User actor, OpenPayment openPayment, String orderId, Send sentItem) {
        Account account = openPayment.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(openPayment.getAmount(), Currency.getInstance(openPayment.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = openPayment.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.OPEN_PAYMENT_SIGNED, bank.getTenant(), account, pmtType, actor, new Serializable[]{openPayment.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(openPayment.getRecipient()), amount, orderId, sentItem.getId()});
    }

    public static void logPeriodicPaymentCreated(User actor, PeriodicPayment periodicPayment) {
        Account account = periodicPayment.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(periodicPayment.getAmount(), Currency.getInstance(periodicPayment.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = periodicPayment.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.PERIODIC_PAYMENT_CREATED, bank.getTenant(), account, pmtType, actor, new Serializable[]{periodicPayment.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(periodicPayment.getRecipient()), amount});
    }

    public static void logPeriodicPaymentDeleted(User actor, PeriodicPayment periodicPayment) {
        Account account = periodicPayment.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(periodicPayment.getAmount(), Currency.getInstance(periodicPayment.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = periodicPayment.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.PERIODIC_PAYMENT_DELETED, bank.getTenant(), account, pmtType, actor, new Serializable[]{periodicPayment.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(periodicPayment.getRecipient()), amount});
    }

    public static void logPeriodicPaymentModified(User actor, PeriodicPayment periodicPayment, PaymentField field, String oldValue, String newValue) {
        Account account = periodicPayment.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(periodicPayment.getAmount(), Currency.getInstance(periodicPayment.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = periodicPayment.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.PERIODIC_PAYMENT_MODIFIED, bank.getTenant(), account, pmtType, actor, new Serializable[]{periodicPayment.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(periodicPayment.getRecipient()), amount, field, Logger.checkNull(oldValue), Logger.checkNull(newValue)});
    }

    public static void logPaymentTemplateCreated(User actor, PaymentTemplate paymentTemplate) {
        Account account = paymentTemplate.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(paymentTemplate.getAmount(), Currency.getInstance(paymentTemplate.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = paymentTemplate.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.PAYMENT_TEMPLATE_CREATED, bank.getTenant(), account, pmtType, actor, new Serializable[]{paymentTemplate.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(paymentTemplate.getRecipient()), amount, paymentTemplate.getName()});
    }

    public static void logPaymentTemplateDeleted(User actor, PaymentTemplate paymentTemplate) {
        Account account = paymentTemplate.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(paymentTemplate.getAmount(), Currency.getInstance(paymentTemplate.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = paymentTemplate.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.PAYMENT_TEMPLATE_DELETED, bank.getTenant(), account, pmtType, actor, new Serializable[]{paymentTemplate.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(paymentTemplate.getRecipient()), amount, paymentTemplate.getName()});
    }

    public static void logPaymentTemplateModified(User actor, PaymentTemplate paymentTemplate, PaymentField field, String oldValue, String newValue) {
        Account account = paymentTemplate.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(paymentTemplate.getAmount(), Currency.getInstance(paymentTemplate.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = paymentTemplate.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.PAYMENT_TEMPLATE_MODIFIED, bank.getTenant(), account, pmtType, actor, new Serializable[]{paymentTemplate.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(paymentTemplate.getRecipient()), amount, field, Logger.checkNull(oldValue), Logger.checkNull(newValue), paymentTemplate.getName()});
    }

    public static void logAccountCreated(User actor, Account account) {
        Logger.log(Message.ACCOUNT_CREATED, account.getBank().getTenant(), account, actor, new Serializable[]{account.getId(), Account.getDefaultDisplayName(account)});
    }

    public static void logAccountDeleted(User actor, Account account) {
        Logger.log(Message.ACCOUNT_DELETED, account.getBank().getTenant(), account, actor, new Serializable[]{account.getId(), Account.getDefaultDisplayName(account)});
    }

    public static void logAccountModified(User actor, Account account, AccountField field, String oldValue, String newValue) {
        Logger.log(Message.ACCOUNT_MODIFIED, account.getBank().getTenant(), account, actor, new Serializable[]{account.getId(), Account.getDefaultDisplayName(account), field, Logger.checkNull(oldValue), Logger.checkNull(newValue)});
    }

    public static void logFileSent(User actor, Send sentFile, boolean vopUsed) {
        String amount = PaymentUtils.formatAmount(sentFile.getAmount(), Currency.getInstance(sentFile.getCurrency()));
        String orderId = sentFile.getOrderNumber();
        BankSettings bank = sentFile.getBank();
        if (vopUsed) {
            Logger.log(Message.VOP_ORDER_SENT, bank.getTenant(), actor, new Serializable[]{sentFile.getId(), Logger.checkNull(bank.getDisplayName()), amount, orderId, sentFile.getNbOfTxs()});
        } else {
            Logger.log(Message.ORDER_SENT, bank.getTenant(), actor, new Serializable[]{sentFile.getId(), Logger.checkNull(bank.getDisplayName()), amount, orderId, sentFile.getNbOfTxs()});
        }
    }

    public static void logOrderRecalled(User actor, Send callbackOrder, Send recalledOrder) {
        BankSettings bank = callbackOrder.getBank();
        Logger.log(Message.ORDER_RECALLED, bank.getTenant(), actor, new Serializable[]{recalledOrder.getOrderNumber(), recalledOrder.getId(), callbackOrder.getOrderNumber(), callbackOrder.getId()});
    }

    public static void logEdsOrderSigned(User actor, DsOpenOrder dsOrder) {
        String amount = PaymentUtils.formatAmount(dsOrder.getAmount(), Currency.getInstance(dsOrder.getAmountCurrency()));
        Logger.log(Message.EDS_ORDER_SIGNED, dsOrder.getBankUser().getBank().getTenant(), actor, new Serializable[]{dsOrder.getId(), dsOrder.getOrderId(), amount, Logger.checkNull(dsOrder.getBankUser().getBank().getDisplayName())});
    }

    public static void logEdsOrderCancelled(User actor, DsOpenOrder dsOrder) {
        String amount = PaymentUtils.formatAmount(dsOrder.getAmount(), Currency.getInstance(dsOrder.getAmountCurrency()));
        Logger.log(Message.EDS_ORDER_CANCELLED, dsOrder.getBankUser().getBank().getTenant(), actor, new Serializable[]{dsOrder.getId(), dsOrder.getOrderId(), amount, Logger.checkNull(dsOrder.getBankUser().getBank().getDisplayName())});
    }

    public static void logErrorCreatingOpenFromPeriodicPayment(User actor, PeriodicPayment periodicPayment, String exceptionMessage) {
        Account account = periodicPayment.getAccount();
        BankSettings bank = account.getBank();
        String amount = PaymentUtils.formatAmount(periodicPayment.getAmount(), Currency.getInstance(periodicPayment.getAmountCurrency()));
        String accountName = Account.getMT101DisplayName(account, true);
        PaymentTransferType.PmtType pmtType = periodicPayment.getPmtType();
        String pmtTypeName = pmtType == null ? null : pmtType.name();
        Logger.log(Message.ERROR_EXECUTING_PERIODIC_PAYMENT, bank.getTenant(), account, pmtType, actor, new Serializable[]{periodicPayment.getId(), Logger.checkNull(pmtTypeName), Logger.checkNull(accountName), Logger.checkNull(periodicPayment.getRecipient()), amount, exceptionMessage});
    }

    private static Tenant checkSingleTenant(User user) {
        return user.getTenants().size() == 1 ? user.getTenants().get(0) : null;
    }

    private static String checkNull(String value) {
        return value == null ? "(null)" : value;
    }

    public static String getMessage(User user, Log log, Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle(Logger.class.getName(), locale);
        try {
            if (!user.isAdmin()) {
                Message message = Message.valueOf(log.getMessageName());
                if (message.needsAccountPermissionCheck() && log.getAccount() == null) {
                    return log.getMessageName() + " " + rb.getString("DETAILS_HIDDEN_NO_ACCOUNT");
                }
                if (SALARY_PMT_TYPES.contains((Object)log.getPmtType()) && LOG_TYPES_OPEN_PAYMENT.contains(log.getMessageName()) && !Util.displaySalaries(user)) {
                    return log.getMessageName() + " " + rb.getString("DETAILS_HIDDEN_NO_SALARY_PERMISSION");
                }
            }
            if ("de".equals(locale.getLanguage())) {
                return log.getMessageDe() == null ? log.getMessageName() : log.getMessageDe();
            }
            return log.getMessageEn() == null ? log.getMessageName() : log.getMessageEn();
        }
        catch (Exception e) {
            return log.getMessageName();
        }
    }

    private static String buildMessage(Log log, Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle(Logger.class.getName(), locale);
        try {
            String s;
            String result = s = rb.getString(log.getMessageName());
            Serializable[] parameter = log.getParameter();
            if (parameter != null && parameter.length > 0) {
                result = new MessageFormat(s, locale).format(parameter);
            }
            if (result.length() > 500) {
                result = result.substring(0, 500);
            }
            return result;
        }
        catch (Exception e) {
            return log.getMessageName();
        }
    }

    private static void log(Message message, Tenant tenant, User actor, Serializable ... parameters) {
        Logger.log(message, tenant, null, null, actor, parameters);
    }

    private static void log(Message message, Tenant tenant, Account account, User actor, Serializable ... parameters) {
        Logger.log(message, tenant, account, null, actor, parameters);
    }

    private static void log(Message message, Tenant tenant, PaymentTransferType.PmtType pmtType, User actor, Serializable ... parameters) {
        Logger.log(message, tenant, null, pmtType, actor, parameters);
    }

    private static void log(Message message, Tenant tenant, Account account, PaymentTransferType.PmtType pmtType, User actor, Serializable ... parameters) {
        try {
            Log log = new Log();
            log.setLogTime(new Timestamp(System.currentTimeMillis()));
            log.setTenant(tenant);
            log.setAccount(account);
            log.setPmtType(pmtType);
            log.setActor(actor);
            log.setMessageName(message.name());
            log.setParameter(parameters);
            log.setMessageEn(Logger.buildMessage(log, Locale.UK));
            log.setMessageDe(Logger.buildMessage(log, Locale.GERMANY));
            DB.save(log);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SALARY_PMT_TYPES = new HashSet<PaymentTransferType.PmtType>(Arrays.asList(PaymentTransferType.PmtType.SEPA_CONFIDENTAL_TRANSFER, PaymentTransferType.PmtType.SEPA_URGENT_CONFIDENTAL_TRANSFER));
        LOG_TYPES_OPEN_PAYMENT = new HashSet<String>(Arrays.asList("OPEN_PAYMENT_CREATED", "OPEN_PAYMENT_MODIFIED", "OPEN_PAYMENT_DELETED", "OPEN_PAYMENT_SIGNED"));
        ERROR_MESSAGE_TYPES = Arrays.stream(Message.values()).filter(m -> m.isError()).map(Enum::name).collect(Collectors.toSet());
    }

    public static enum Message {
        ADMIN_LOGIN_SUCCESSSFUL(VisibleFor.ADMINS),
        ADMIN_LOGIN_FAILED(VisibleFor.ADMINS),
        ADMIN_LOCKED(VisibleFor.ADMINS),
        BANK_CREATED(VisibleFor.TENANT_ADMINS),
        BANK_MODIFIED(VisibleFor.TENANT_ADMINS),
        BANK_DELETED(VisibleFor.TENANT_ADMINS),
        BANK_USER_ADDED(VisibleFor.TENANT_ADMINS),
        BANK_USER_REMOVED(VisibleFor.TENANT_ADMINS),
        BANK_FIELD_CHANGED(VisibleFor.TENANT_ADMINS),
        BANK_MOVE_TENANT(VisibleFor.TENANT_ADMINS),
        TENANT_CREATED(VisibleFor.ADMINS),
        TENANT_DELETED(VisibleFor.ADMINS),
        TENANT_RENAMED(VisibleFor.TENANT_ADMINS),
        TENANT_CHANGED_USER_LIMIT(VisibleFor.TENANT_ADMINS),
        TENANT_USER_ADDED(VisibleFor.TENANT_ADMINS),
        TENANT_USER_REMOVED(VisibleFor.TENANT_ADMINS),
        TENANT_GRANT_MANAGING_PRIVILEGES(VisibleFor.TENANT_ADMINS),
        TENANT_REMOVED_MANAGING_PRIVILEGES(VisibleFor.TENANT_ADMINS),
        USER_CREATED(VisibleFor.TENANT_ADMINS),
        USER_MODIFIED(VisibleFor.TENANT_ADMINS),
        USER_DELETED(VisibleFor.TENANT_ADMINS),
        USER_RESET(VisibleFor.TENANT_ADMINS),
        USER_LOCKED(VisibleFor.TENANT_ADMINS),
        USER_RESET_ERROR_COUNTER(VisibleFor.TENANT_ADMINS),
        USER_RENAMED(VisibleFor.TENANT_ADMINS),
        USER_GRANTED_ADMIN_PRIVILEGES(VisibleFor.ADMINS),
        USER_REMOVED_ADMIN_PRIVILEGES(VisibleFor.ADMINS),
        USER_GRANTED_PERMISSION(VisibleFor.TENANT_ADMINS),
        USER_REMOVED_PERMISSION(VisibleFor.TENANT_ADMINS),
        USER_CHANGED_SALARY_PERMISSION_ALL(VisibleFor.TENANT_ADMINS),
        USER_CHANGED_SALARY_PERMISSION_NO_AMOUNTS(VisibleFor.TENANT_ADMINS),
        USER_CHANGED_SALARY_PERMISSION_NO_DETAILS(VisibleFor.TENANT_ADMINS),
        USER_CHANGED_SALARY_PERMISSION_NONE(VisibleFor.TENANT_ADMINS),
        USER_REMOVED_ALL_YUBIKEYS(VisibleFor.TENANT_ADMINS),
        USER_ADDED_YUBIKEYS(VisibleFor.TENANT_ADMINS),
        USER_DELETED_YUBIKEYS(VisibleFor.TENANT_ADMINS),
        DIRECTORY_SCANNER_CREATED(VisibleFor.TENANT_ADMINS),
        DIRECTORY_SCANNER_DELETED(VisibleFor.TENANT_ADMINS),
        DIRECTORY_SCANNER_CHANGED(VisibleFor.TENANT_ADMINS),
        ACCOUNTS_MERGED(VisibleFor.ADMINS),
        PREFERENCE_CHANGED(VisibleFor.TENANT_ADMINS),
        CLEANUP_TRANSFERS(VisibleFor.SUPER_ADMINS),
        CLEANUP_DES(VisibleFor.SUPER_ADMINS),
        CLEANUP_CM(VisibleFor.SUPER_ADMINS),
        DATABASE_MIGRATION_START(VisibleFor.SUPER_ADMINS),
        DATABASE_MIGRATION_FINISHED_ERROR(VisibleFor.SUPER_ADMINS),
        DATABASE_MIGRATION_FINISHED_SUCCESS(VisibleFor.SUPER_ADMINS),
        DATABASE_CUSTOM_SQL_QUERY(VisibleFor.SUPER_ADMINS),
        DATABASE_CUSTOM_SQL_UPDATE(VisibleFor.SUPER_ADMINS),
        SCHEDULER_CREATED(VisibleFor.ALL),
        SCHEDULER_DELETED(VisibleFor.ALL),
        SCHEDULER_CHANGED_BANKUSER(VisibleFor.ALL),
        ORIGINATOR_CREATED(VisibleFor.ALL),
        ORIGINATOR_MODIFIED(VisibleFor.ALL),
        ORIGINATOR_DELETED(VisibleFor.ALL),
        ACCOUNT_CREATED(VisibleFor.ALL, true),
        ACCOUNT_MODIFIED(VisibleFor.ALL, true),
        ACCOUNT_DELETED(VisibleFor.ALL, true),
        RECIPIENT_CREATED(VisibleFor.ALL),
        RECIPIENT_MODIFIED(VisibleFor.ALL),
        RECIPIENT_DELETED(VisibleFor.ALL),
        SEPA_MANDATE_CREATED(VisibleFor.ALL),
        SEPA_MANDATE_MODIFIED(VisibleFor.ALL),
        SEPA_MANDATE_DELETED(VisibleFor.ALL),
        OPEN_PAYMENT_CREATED(VisibleFor.ALL, true),
        OPEN_PAYMENT_MODIFIED(VisibleFor.ALL, true),
        OPEN_PAYMENT_DELETED(VisibleFor.ALL, true),
        OPEN_PAYMENT_SIGNED(VisibleFor.ALL, true),
        PERIODIC_PAYMENT_CREATED(VisibleFor.ALL, true),
        PERIODIC_PAYMENT_MODIFIED(VisibleFor.ALL, true),
        PERIODIC_PAYMENT_DELETED(VisibleFor.ALL, true),
        PAYMENT_TEMPLATE_CREATED(VisibleFor.ALL, true),
        PAYMENT_TEMPLATE_MODIFIED(VisibleFor.ALL, true),
        PAYMENT_TEMPLATE_DELETED(VisibleFor.ALL, true),
        ORDER_SENT(VisibleFor.ALL),
        EDS_ORDER_SIGNED(VisibleFor.ALL),
        EDS_ORDER_CANCELLED(VisibleFor.ALL),
        ORDER_RECALLED(VisibleFor.ALL),
        RECIPIENT_RENAMED_FROM_VOP(VisibleFor.ALL),
        ERROR_EXECUTING_PERIODIC_PAYMENT(ErrorStatus.ERROR, VisibleFor.ALL, true),
        VOP_ORDER_SENT(VisibleFor.ALL);

        private ErrorStatus errorStatus;
        private VisibleFor userGroup;
        private boolean needsAccountPermissionCheck;

        private Message(VisibleFor userGroup) {
            this.errorStatus = ErrorStatus.NO_ERROR;
            this.userGroup = userGroup;
            this.needsAccountPermissionCheck = false;
        }

        private Message(VisibleFor userGroup, boolean needsAccountPermissionCheck) {
            this.errorStatus = ErrorStatus.NO_ERROR;
            this.userGroup = userGroup;
            this.needsAccountPermissionCheck = needsAccountPermissionCheck;
        }

        private Message(ErrorStatus errorStatus, VisibleFor userGroup) {
            this.errorStatus = errorStatus;
            this.userGroup = userGroup;
            this.needsAccountPermissionCheck = false;
        }

        private Message(ErrorStatus errorStatus, VisibleFor userGroup, boolean needsAccountPermissionCheck) {
            this.errorStatus = errorStatus;
            this.userGroup = userGroup;
            this.needsAccountPermissionCheck = needsAccountPermissionCheck;
        }

        public boolean isVisibleForUserGroup(VisibleFor userGroup) {
            return this.userGroup.value <= userGroup.value;
        }

        public boolean isVisibleForNonAdmins() {
            return this.userGroup.value <= VisibleFor.ALL.value;
        }

        public boolean isVisibleForTenantAdmins() {
            return this.userGroup.value <= VisibleFor.TENANT_ADMINS.value;
        }

        public boolean isVisibleForAdmins() {
            return this.userGroup.value <= VisibleFor.ADMINS.value;
        }

        public boolean needsAccountPermissionCheck() {
            return this.needsAccountPermissionCheck;
        }

        public boolean isError() {
            return this.errorStatus.value == ErrorStatus.ERROR.value;
        }

        public boolean canBeSeenByUser(User user, boolean superAdminsExist) {
            if (user == null) {
                return false;
            }
            if (user.isAdmin() && (!superAdminsExist || this.isVisibleForAdmins())) {
                return true;
            }
            if (user.isAdminOrTenantAdmin() && this.isVisibleForTenantAdmins()) {
                return true;
            }
            return this.isVisibleForNonAdmins();
        }
    }

    public static enum ErrorStatus {
        NO_ERROR(0),
        ERROR(10);

        final int value;

        private ErrorStatus(int value) {
            this.value = value;
        }
    }

    public static enum VisibleFor {
        ALL(0),
        TENANT_ADMINS(10),
        ADMINS(20),
        SUPER_ADMINS(30);

        final int value;

        private VisibleFor(int value) {
            this.value = value;
        }
    }

    public static enum PaymentField {
        ORIGINATOR_ACCOUNT,
        ORIGINATOR,
        PAYEE,
        ULTIMATE_ORIGINATOR,
        ULTIMATE_PAYEE,
        SENDER_BIC,
        RECIPIENT,
        PAYER,
        ULTIMATE_RECIPIENT,
        ULTIMATE_PAYER,
        RECEIVER_BIC,
        RECIPIENT_IBAN,
        RECIPIENT_BIC,
        RECIPIENT_ACCOUNT_NUMBER,
        RECIPIENT_BANK_CODE,
        INTERMEDIARY_BANK_CODE,
        AMOUNT,
        CURRENCY,
        COUNTER_VALUE_CURRENCY,
        PURPOSE,
        PAYMENT_CATEGORY,
        PURPOSE_CODE,
        INSTRUCTION_PRIORITY,
        EXECUTION_DATE,
        END_TO_END_REFERENCE,
        FEE_TYPE,
        INSTRUCTION_CODES,
        SEQUENCE_TYPE,
        PAYMENT_TYPE,
        TEMPLATE_NAME,
        PERIODIC_FIRST_EXECUTION,
        PERIODIC_EXECUTION_INTERVAL,
        PERIODIC_NUMBER_OF_EXECUTIONS;

    }

    public static enum AccountField {
        NAME,
        ACCOUNT_HOLDER,
        ACCOUNT_NUMBER,
        BANK_CODE,
        IBAN,
        BIC,
        CURRENCY,
        CREDIT_LIMIT,
        INVESTMENT_AMOUNT;

    }

    public static enum RecipientField {
        NAME,
        LEI_NUMBER,
        ACCOUNT_NUMBER,
        BANK_CODE,
        INTERMEDIARY_BANK_CODE,
        CREDITOR_NAME,
        CREDITOR_ID,
        MANDATE_ID,
        MANDATE_SIGN_DATE,
        DEBIT_TYPE,
        SEQUENCE_TYPE;

    }

    public static enum OriginatorField {
        NAME,
        CREDITOR_ID,
        TAX_NUMBER,
        TENANT_ID,
        DEFAULT_ACCOUNT;

    }

    public static enum DirectoryScannerField {
        BANK,
        DIRECTORY,
        REG_EX,
        ARCHIVE_DIR,
        ORDER_OR_FILE_TYPE;

    }

    public static enum BankField {
        NAME,
        URL,
        HOST_ID,
        CUSTOMER_ID,
        COUNTRY,
        TRANSPORT_ONLY,
        EBICS_VERSION,
        E001_DIGEST,
        E002_DIGEST,
        X001_DIGEST,
        X002_DIGEST,
        VOP_ACTIVATED,
        VOP_MANDATORY;

    }
}

