/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import java.util.Arrays;
import java.util.List;

public class KeyUtil {
    public static final int MIN_LENGTH_EBICS30 = 2048;
    private static final int MIN_LENGTH_A005_A006_EBICS25 = 2048;
    private static final int MIN_LENGTH_E002_X002_EBICS25 = 2048;
    public static final int MAX_LENGTH_A005_A006 = 4096;
    public static final int MAX_LENGTH_E002_X002 = 16384;
    public static final int LENGTH_A004 = 1024;
    private final boolean isH005OrNewer;

    public KeyUtil(ProtocolVersion protocolVersion) {
        this.isH005OrNewer = BankUtils.isProtocolH005OrNewer(protocolVersion);
    }

    public int getMinKeyLength(KeyType keyType) {
        switch (keyType.ordinal()) {
            case 1: 
            case 2: {
                return this.isH005OrNewer ? 2048 : 2048;
            }
            case 3: 
            case 4: {
                return this.isH005OrNewer ? 2048 : 2048;
            }
        }
        return 1024;
    }

    public int getMaxKeyLength(KeyType keyType) {
        switch (keyType.ordinal()) {
            case 1: 
            case 2: {
                return 4096;
            }
            case 3: 
            case 4: {
                return 16384;
            }
        }
        return 1024;
    }

    public int getDefaultKeyLength(KeyType keyType) {
        switch (keyType.ordinal()) {
            case 0: {
                return 1024;
            }
        }
        return 2048;
    }

    public int getProposedKeyLength(KeyType keyType, int existingLength) {
        if (existingLength >= this.getDefaultKeyLength(keyType) && existingLength <= this.getMaxKeyLength(keyType)) {
            return existingLength;
        }
        return this.getDefaultKeyLength(keyType);
    }

    public int getAllowedKeyLength(KeyType keyType, int chosenLength) {
        if (chosenLength >= this.getMinKeyLength(keyType) && chosenLength <= this.getMaxKeyLength(keyType)) {
            return chosenLength;
        }
        return this.getDefaultKeyLength(keyType);
    }

    public List<SignatureVersion> getAvailableSignatureVersions() {
        return Arrays.asList(SignatureVersion.A005, SignatureVersion.A006);
    }

    public static boolean newKeysRequired(BankUser bankUser, ProtocolVersion protocolVersion) {
        return KeyUtil.newKeysRequired(bankUser, protocolVersion.toString());
    }

    public static boolean newKeysRequired(BankUser bankUser, String protocolVersion) {
        if (bankUser != null && BankUtils.isProtocolH005OrNewer(protocolVersion)) {
            if (bankUser.getSigKeyLength() < 2048) {
                return true;
            }
            if (bankUser.getAuthKeyLength() < 2048) {
                return true;
            }
            if (bankUser.getEncrKeyLength() < 2048) {
                return true;
            }
        }
        return false;
    }

    public static enum KeyType {
        A004,
        A005,
        A006,
        E002,
        X002;

    }
}

