/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.bank.Keybag;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.RSAPublicKey;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.ebics.security.AuthenticationHandler;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.E001PrivateKey;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.X001PrivateKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ImportMasterData
extends DefaultHandler {
    private final User user;
    private final File workspaceDirectory;
    private final PasswordCallback sigPasswordCallback;
    private final PasswordCallback loginPasswordCallback;
    private final List<Tenant> allTenants;
    private final boolean importAccountNames;
    private final boolean importRecipients;
    private final BLLogger logger;
    private String xmlPath;
    private BankDetails currentBank;
    private AccountDetails currentAccount;
    private RecipientDetails currentRecipient;
    private PermissionDetails currentPermissions;
    private File keyDir;

    public ImportMasterData(User user, File workspaceDirectory, PasswordCallback sigPasswordCallback, PasswordCallback loginPasswordCallback, List<Tenant> allTenants, boolean importAccountNames, boolean importRecipients, BLLogger logger) {
        this.user = user;
        this.workspaceDirectory = workspaceDirectory;
        this.sigPasswordCallback = sigPasswordCallback;
        this.loginPasswordCallback = loginPasswordCallback;
        this.allTenants = allTenants;
        this.importAccountNames = importAccountNames;
        this.importRecipients = importRecipients;
        this.logger = logger;
    }

    public void importMasterdata(InputStream inputStream) throws IOException, SAXException, GeneralSecurityException {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser parser = saxFactory.newSAXParser();
            parser.parse(inputStream, (DefaultHandler)this);
        }
        catch (SAXException e) {
            if (e.getCause() instanceof InvalidPasswordException) {
                throw (InvalidPasswordException)e.getCause();
            }
            if (e.getCause() instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    public void readFromLicenseServer(String syncNumber, String encryptKey) throws IOException, GeneralSecurityException, SAXException {
        this.readFromLicenseServer(syncNumber, encryptKey, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFromLicenseServer(String syncNumber, String encryptKey, boolean saveCopy) throws IOException, GeneralSecurityException, SAXException {
        File lastSyncFile;
        InputStream inputStream;
        block9: {
            inputStream = null;
            lastSyncFile = null;
            try {
                boolean encrypted;
                URL url = new URL(System.getProperty("de.businesslogics.banking.licenseServer", "https://www.blbanking.de/license/keyexchange/") + syncNumber);
                HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
                EbicsHttpEngineImpl.setSSLSocketFactory(con);
                con.setDoOutput(true);
                inputStream = con.getInputStream();
                boolean bl = encrypted = encryptKey != null && !encryptKey.isEmpty();
                if (encrypted) {
                    byte[] marker = new byte[EncryptData.ENCRYPTION_MARKER.length];
                    inputStream.read(marker);
                    if (!Arrays.equals(EncryptData.ENCRYPTION_MARKER, marker)) {
                        throw new IOException("Did not find expected encryption marker: " + String.valueOf(EncryptData.ENCRYPTION_MARKER) + " Found " + String.valueOf(marker) + " instead.");
                    }
                }
                if (saveCopy) {
                    File tmp = new File(this.workspaceDirectory, "tmp");
                    Object name = syncNumber;
                    if (encrypted) {
                        name = (String)name + "_" + encryptKey;
                    }
                    lastSyncFile = new File(tmp, (String)name);
                    lastSyncFile.mkdirs();
                    Files.copy(inputStream, lastSyncFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    inputStream = new FileInputStream(lastSyncFile);
                }
                if (encrypted) {
                    inputStream = this.decryptImportedStream(inputStream, encryptKey);
                }
                this.importMasterdata(inputStream);
                inputStream.close();
                if (lastSyncFile == null || lastSyncFile.delete()) break block9;
                lastSyncFile.deleteOnExit();
            }
            catch (Throwable throwable) {
                Util.closeStream(inputStream);
                if (lastSyncFile != null && lastSyncFile.exists()) {
                    new Timer().schedule((TimerTask)new DeleteFile(lastSyncFile), 300000L);
                }
                throw throwable;
            }
        }
        Util.closeStream(inputStream);
        if (lastSyncFile != null && lastSyncFile.exists()) {
            new Timer().schedule((TimerTask)new DeleteFile(lastSyncFile), 300000L);
        }
    }

    private File checkSyncFile(String syncNumber, String encryptKey) {
        File sync;
        File tmp = new File(this.workspaceDirectory, "tmp");
        Object name = syncNumber;
        if (encryptKey != null && !encryptKey.isEmpty()) {
            name = (String)name + "_" + encryptKey;
        }
        if ((sync = new File(tmp, (String)name)).isFile()) {
            return sync;
        }
        return null;
    }

    private InputStream decryptImportedStream(InputStream inputStream, String encryptKey) throws IOException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchPaddingException, NoSuchAlgorithmException {
        int ivLength = inputStream.read();
        byte[] iv = new byte[ivLength];
        inputStream.read(iv);
        byte[] syncEncryptionKey = HexTool.fromHex(encryptKey);
        SecretKeySpec ourKey = new SecretKeySpec(syncEncryptionKey, "AES");
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        c.init(2, (Key)ourKey, new IvParameterSpec(iv));
        return new CipherInputStream(inputStream, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFromLicenseServerWithRetry(String syncNumber, String encryptKey) throws GeneralSecurityException, IOException, SAXException {
        File f = this.checkSyncFile(syncNumber, encryptKey);
        if (f == null) {
            this.readFromLicenseServer(syncNumber, encryptKey, true);
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
            if (encryptKey != null && !encryptKey.isEmpty()) {
                inputStream = this.decryptImportedStream(inputStream, encryptKey);
            }
            this.importMasterdata(inputStream);
        }
        catch (Throwable throwable) {
            Util.closeStream(inputStream);
            throw throwable;
        }
        Util.closeStream(inputStream);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.xmlPath = this.xmlPath == null ? localName : this.xmlPath + "/" + localName;
        if ("BLBanking/BankConnection".equals(this.xmlPath)) {
            this.currentBank = new BankDetails();
        } else if (this.importAccountNames && "BLBanking/BankConnection/Account".equals(this.xmlPath)) {
            this.currentAccount = new AccountDetails();
        } else if (this.importRecipients && "BLBanking/Recipient".equals(this.xmlPath)) {
            this.currentRecipient = new RecipientDetails();
        } else if ("BLBanking/Permissions".equals(this.xmlPath)) {
            this.currentPermissions = new PermissionDetails();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (ch == null || length == 0 || this.xmlPath == null) {
            return;
        }
        if (this.xmlPath.startsWith("BLBanking/BankConnection/Account") && this.currentAccount != null) {
            this.currentAccount.handleData(new String(ch, start, length));
        } else if (this.xmlPath.startsWith("BLBanking/BankConnection") && this.currentBank != null) {
            this.currentBank.handleData(new String(ch, start, length));
        } else if (this.xmlPath.startsWith("BLBanking/Recipient") && this.currentRecipient != null) {
            this.currentRecipient.handleData(new String(ch, start, length));
        } else if (this.xmlPath.startsWith("BLBanking/Permissions") && this.currentPermissions != null) {
            this.currentPermissions.handleData(new String(ch, start, length));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.xmlPath == null) {
            return;
        }
        if ("BLBanking/BankConnection".equals(this.xmlPath) && this.currentBank != null) {
            this.currentBank.store();
            this.currentBank = null;
        } else if ("BLBanking/BankConnection/Account".equals(this.xmlPath) && this.currentAccount != null) {
            this.currentAccount.store();
            this.currentAccount = null;
        } else if ("BLBanking/Recipient".equals(this.xmlPath) && this.currentRecipient != null) {
            this.currentRecipient.store();
            this.currentRecipient = null;
        } else if ("BLBanking/Permissions".equals(this.xmlPath) && this.currentPermissions != null) {
            this.currentPermissions.store();
            this.currentPermissions = null;
        }
        int slashPos = this.xmlPath.lastIndexOf(47);
        this.xmlPath = slashPos >= 0 ? this.xmlPath.substring(0, slashPos) : null;
    }

    private String mergeStrings(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return str1 + str2;
    }

    private File getKeyDir() {
        if (!DatabaseToken.userKeysInKeybag) {
            return null;
        }
        if (this.keyDir == null) {
            this.keyDir = new File(this.workspaceDirectory, this.user.getKeyDirectory());
            this.keyDir.mkdirs();
        }
        return this.keyDir;
    }

    private static class DeleteFile
    extends TimerTask {
        private final File fileToDelete;

        public DeleteFile(File file) {
            this.fileToDelete = file;
        }

        @Override
        public void run() {
            if (this.fileToDelete.exists() && !this.fileToDelete.delete()) {
                this.fileToDelete.deleteOnExit();
            }
        }
    }

    private final class BankDetails {
        private String name;
        private String icon;
        private String url;
        private String country;
        private String hostId;
        private String customerId;
        private String userId;
        private String protocolVersion;
        private String encKeyMod;
        private String encKeyExp;
        private String authKeyMod;
        private String authKeyExp;
        private String orderNumber;
        private String signatureVersion;
        private String userSigKey;
        private String userEncKey;
        private String userAuthKey;
        private List<AccountDetails> accounts;

        private BankDetails() {
        }

        public void handleData(String data) {
            if ("BLBanking/BankConnection/Name".equals(ImportMasterData.this.xmlPath)) {
                this.name = ImportMasterData.this.mergeStrings(this.name, data);
            } else if ("BLBanking/BankConnection/Icon".equals(ImportMasterData.this.xmlPath)) {
                this.icon = ImportMasterData.this.mergeStrings(this.icon, data);
            } else if ("BLBanking/BankConnection/URL".equals(ImportMasterData.this.xmlPath)) {
                this.url = ImportMasterData.this.mergeStrings(this.url, data);
            } else if ("BLBanking/BankConnection/Country".equals(ImportMasterData.this.xmlPath)) {
                this.country = ImportMasterData.this.mergeStrings(this.country, data);
            } else if ("BLBanking/BankConnection/HostID".equals(ImportMasterData.this.xmlPath)) {
                this.hostId = ImportMasterData.this.mergeStrings(this.hostId, data);
            } else if ("BLBanking/BankConnection/CustomerID".equals(ImportMasterData.this.xmlPath)) {
                this.customerId = ImportMasterData.this.mergeStrings(this.customerId, data);
            } else if ("BLBanking/BankConnection/UserID".equals(ImportMasterData.this.xmlPath)) {
                this.userId = ImportMasterData.this.mergeStrings(this.userId, data);
            } else if ("BLBanking/BankConnection/EbicsProtocolVersion".equals(ImportMasterData.this.xmlPath)) {
                this.protocolVersion = ImportMasterData.this.mergeStrings(this.protocolVersion, data);
            } else if ("BLBanking/BankConnection/BankEncryptionKeyMod".equals(ImportMasterData.this.xmlPath)) {
                this.encKeyMod = ImportMasterData.this.mergeStrings(this.encKeyMod, data);
            } else if ("BLBanking/BankConnection/BankEncryptionKeyExp".equals(ImportMasterData.this.xmlPath)) {
                this.encKeyExp = ImportMasterData.this.mergeStrings(this.encKeyExp, data);
            } else if ("BLBanking/BankConnection/BankAuthenticationKeyMod".equals(ImportMasterData.this.xmlPath)) {
                this.authKeyMod = ImportMasterData.this.mergeStrings(this.authKeyMod, data);
            } else if ("BLBanking/BankConnection/BankAuthenticationKeyExp".equals(ImportMasterData.this.xmlPath)) {
                this.authKeyExp = ImportMasterData.this.mergeStrings(this.authKeyExp, data);
            } else if ("BLBanking/BankConnection/OrderNumber".equals(ImportMasterData.this.xmlPath)) {
                this.orderNumber = ImportMasterData.this.mergeStrings(this.orderNumber, data);
            } else if ("BLBanking/BankConnection/SignatureVersion".equals(ImportMasterData.this.xmlPath)) {
                this.signatureVersion = ImportMasterData.this.mergeStrings(this.signatureVersion, data);
            } else if ("BLBanking/BankConnection/UserSignatureKey".equals(ImportMasterData.this.xmlPath)) {
                this.userSigKey = ImportMasterData.this.mergeStrings(this.userSigKey, data);
            } else if ("BLBanking/BankConnection/UserEncryptionKey".equals(ImportMasterData.this.xmlPath)) {
                this.userEncKey = ImportMasterData.this.mergeStrings(this.userEncKey, data);
            } else if ("BLBanking/BankConnection/UserAuthenticationKey".equals(ImportMasterData.this.xmlPath)) {
                this.userAuthKey = ImportMasterData.this.mergeStrings(this.userAuthKey, data);
            }
        }

        public void addAccount(AccountDetails account) {
            if (this.accounts == null) {
                this.accounts = new ArrayList<AccountDetails>();
            }
            this.accounts.add(account);
        }

        /*
         * Unable to fully structure code
         */
        public void store() throws SAXException {
            for (Tenant tenant : ImportMasterData.this.allTenants) {
                banks = BankSettings.findByCustomer(this.url, this.hostId, this.customerId, tenant);
                newBank = false;
                bank = null;
                if (banks == null || banks.isEmpty()) {
                    bank = new BankSettings();
                    newBank = true;
                    bank.setTenant(tenant);
                    bank.setUrl(this.url);
                    bank.setCountryCode(this.country);
                    bank.setHostId(this.hostId);
                    bank.setCustomerId(this.customerId);
                    bank.setDisplayName(this.name);
                    bank.setIcon(this.icon);
                    bank.setCountryCode("DE");
                    bank.setProtocolVersion(this.protocolVersion);
                    try {
                        if (this.encKeyMod != null && this.encKeyExp != null) {
                            e00x = new RSAPublicKey();
                            e00x.setModulo(HexTool.fromHex(this.encKeyMod));
                            e00x.setExponent(HexTool.fromHex(this.encKeyExp));
                            e00x.save();
                            pubKey = Provider.buildKey(e00x.getModulo(), e00x.getExponent());
                            if ("H002".equals(this.protocolVersion)) {
                                bank.setExpectedDigestE001(HexTool.toHex(EncryptionHandler.E001.getHash(pubKey)));
                                bank.setE001Key(e00x);
                            } else {
                                bank.setExpectedDigestE002(HexTool.toHex(EncryptionHandler.E002.getHash(pubKey)));
                                bank.setE002Key(e00x);
                            }
                        }
                        if (this.authKeyMod == null || this.authKeyExp == null) ** GOTO lbl52
                        x00x = new RSAPublicKey();
                        x00x.setModulo(HexTool.fromHex(this.authKeyMod));
                        x00x.setExponent(HexTool.fromHex(this.authKeyExp));
                        x00x.save();
                        pubKey = Provider.buildKey(x00x.getModulo(), x00x.getExponent());
                        if ("H002".equals(this.protocolVersion)) {
                            bank.setExpectedDigestX001(HexTool.toHex(AuthenticationHandler.X001.getHash(pubKey)));
                            bank.setX001Key(x00x);
                        }
                        bank.setExpectedDigestX002(HexTool.toHex(AuthenticationHandler.X002.getHash(pubKey)));
                        bank.setX002Key(x00x);
                    }
                    catch (GeneralSecurityException e) {
                        ImportMasterData.this.logger.logWarning("Failed to set bank key information!", e);
                        throw new SAXException(e);
                    }
                } else {
                    for (BankSettings b : banks) {
                        if (this.name == null || !this.name.equals(b.getDisplayName())) continue;
                        bank = b;
                        break;
                    }
                    if (bank == null) {
                        bank = banks.get(0);
                    }
                }
lbl52:
                // 6 sources

                if (newBank) {
                    bankUser = new BankUser();
                } else {
                    bankUser = BankUser.findBankUser(bank, ImportMasterData.this.user);
                    if (bankUser == null) continue;
                }
                bank.save();
                bankUser.setBank(bank);
                bankUser.setUser(ImportMasterData.this.user);
                bankUser.setDefaultUser(this.userId);
                if (this.orderNumber != null) {
                    bankUser.setOrderNumber(this.orderNumber);
                }
                bankUser.setState(BankUser.UserState.READY);
                bankUser.setSignatureVersion(this.signatureVersion);
                try {
                    if (DatabaseToken.userKeysInKeybag) {
                        keybag = new Keybag(new File(ImportMasterData.this.getKeyDir(), bank.getUniqueKey() + ".keybag"));
                        keybag.getProperties().setProperty(this.userId + "_" + this.signatureVersion, this.userSigKey);
                    } else {
                        keybag = null;
                        bankUser.setSigKey(HexTool.fromHex(this.userSigKey));
                    }
                    if (this.userEncKey != null) {
                        privKey = E001PrivateKey.fromPKCS(HexTool.fromHex(this.userEncKey), this.userId, ImportMasterData.this.sigPasswordCallback);
                        if (DatabaseToken.userKeysInKeybag) {
                            keybag.getProperties().setProperty(this.userId + "_E001", HexTool.toHex(privKey.toPKCS(ImportMasterData.this.loginPasswordCallback)));
                        } else {
                            bankUser.setEncrKey(privKey.toPKCS(DatabaseToken.PASSWORD_CALLBACK));
                        }
                        bankUser.setEncrKeyLength(privKey.getPrivateKey().getModulus().bitLength());
                    }
                    if (this.userAuthKey != null) {
                        privKey = X001PrivateKey.fromPKCS(HexTool.fromHex(this.userAuthKey), this.userId, ImportMasterData.this.sigPasswordCallback);
                        if (DatabaseToken.userKeysInKeybag) {
                            keybag.getProperties().setProperty(this.userId + "_X001", HexTool.toHex(privKey.toPKCS(ImportMasterData.this.loginPasswordCallback)));
                        } else {
                            bankUser.setAuthKey(privKey.toPKCS(DatabaseToken.PASSWORD_CALLBACK));
                        }
                        bankUser.setAuthKeyLength(privKey.getPrivateKey().getModulus().bitLength());
                    }
                    if (keybag != null) {
                        keybag.save();
                    }
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new SAXException(e);
                }
                bankUser.save();
            }
        }
    }

    private final class AccountDetails {
        private String iban;
        private String bic;
        private String accountNumber;
        private String bankCode;
        private String nationalAccountNumber;
        private String nationalBankCode;
        private String currency;
        private String holder;
        private String name;

        private AccountDetails() {
        }

        public void handleData(String data) {
            if ("BLBanking/BankConnection/Account/IBAN".equals(ImportMasterData.this.xmlPath)) {
                this.iban = ImportMasterData.this.mergeStrings(this.iban, data);
            } else if ("BLBanking/BankConnection/Account/BIC".equals(ImportMasterData.this.xmlPath)) {
                this.bic = ImportMasterData.this.mergeStrings(this.bic, data);
            } else if ("BLBanking/BankConnection/Account/AccountNumber".equals(ImportMasterData.this.xmlPath)) {
                this.accountNumber = ImportMasterData.this.mergeStrings(this.accountNumber, data);
            } else if ("BLBanking/BankConnection/Account/BankCode".equals(ImportMasterData.this.xmlPath)) {
                this.bankCode = ImportMasterData.this.mergeStrings(this.bankCode, data);
            } else if ("BLBanking/BankConnection/Account/NationalAccountNumber".equals(ImportMasterData.this.xmlPath)) {
                this.nationalAccountNumber = ImportMasterData.this.mergeStrings(this.nationalAccountNumber, data);
            } else if ("BLBanking/BankConnection/Account/NationalBankCode".equals(ImportMasterData.this.xmlPath)) {
                this.nationalBankCode = ImportMasterData.this.mergeStrings(this.nationalBankCode, data);
            } else if ("BLBanking/BankConnection/Account/Currency".equals(ImportMasterData.this.xmlPath)) {
                this.currency = ImportMasterData.this.mergeStrings(this.currency, data);
            } else if ("BLBanking/BankConnection/Account/Holder".equals(ImportMasterData.this.xmlPath)) {
                this.holder = ImportMasterData.this.mergeStrings(this.holder, data);
            } else if ("BLBanking/BankConnection/Account/Name".equals(ImportMasterData.this.xmlPath)) {
                this.name = ImportMasterData.this.mergeStrings(this.name, data);
            }
        }

        public void store() {
            if (ImportMasterData.this.importAccountNames && ImportMasterData.this.currentBank != null) {
                ImportMasterData.this.currentBank.addAccount(this);
            }
        }
    }

    private final class RecipientDetails {
        private String displayname;
        private String name;
        private String accountNumber;
        private String bankCode;
        private String purpose;

        private RecipientDetails() {
        }

        public void handleData(String data) {
            if ("BLBanking/Recipient/DisplayName".equals(ImportMasterData.this.xmlPath)) {
                this.displayname = ImportMasterData.this.mergeStrings(this.displayname, data);
            } else if ("BLBanking/Recipient/Name".equals(ImportMasterData.this.xmlPath)) {
                this.name = ImportMasterData.this.mergeStrings(this.name, data);
            } else if ("BLBanking/Recipient/AccountNumber".equals(ImportMasterData.this.xmlPath)) {
                this.accountNumber = ImportMasterData.this.mergeStrings(this.accountNumber, data);
            } else if ("BLBanking/Recipient/BankCode".equals(ImportMasterData.this.xmlPath)) {
                this.bankCode = ImportMasterData.this.mergeStrings(this.bankCode, data);
            } else if ("BLBanking/Recipient/Purpose".equals(ImportMasterData.this.xmlPath)) {
                this.purpose = ImportMasterData.this.mergeStrings(this.purpose, data);
            }
        }

        public void store() {
            for (Tenant tenant : ImportMasterData.this.allTenants) {
                PaymentRecipient recipient;
                if (!ImportMasterData.this.importRecipients || (recipient = PaymentRecipient.findRecipientByAccountInfo(PaymentType.SEPA, this.name, this.accountNumber, this.bankCode, tenant)) != null) continue;
                recipient = new PaymentRecipient();
                recipient.setAccountNumber(this.accountNumber);
                recipient.setDisplayName(this.displayname);
                recipient.setName(this.name);
                recipient.setTenant(tenant);
                recipient.setBankCode(this.bankCode);
                recipient.setPaymentType(PaymentType.SEPA);
                recipient.setPurpose(this.purpose);
                recipient.save(ImportMasterData.this.user, false);
            }
        }
    }

    private final class PermissionDetails {
        private String salaryPermission;

        private PermissionDetails() {
        }

        public void handleData(String data) {
            if ("BLBanking/Permissions/Salary".equals(ImportMasterData.this.xmlPath)) {
                this.salaryPermission = ImportMasterData.this.mergeStrings(this.salaryPermission, data);
            }
        }

        public void store() {
            if (this.salaryPermission != null) {
                new DatabasePreferenceStore(Preference.ApplicationId.BANKING, ImportMasterData.this.user).setValue((DatabasePreferenceConstant)PreferenceConstants.SALARY_PERMISSIONS, this.salaryPermission);
            }
        }
    }
}

