/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.util.Locale;

public class HTDUtil {
    public static String getAccountNumber(Account account) {
        if (account.getIban() != null) {
            return account.getIban();
        }
        if (account.getGermanAccountNumber() != null) {
            return account.getGermanAccountNumber();
        }
        if (account.getFrenchAccountNumber() != null) {
            return account.getFrenchAccountNumber();
        }
        if (account.getNationalAccountNumber() != null) {
            return account.getNationalAccountNumber();
        }
        return "";
    }

    public static String getBankCode(Account account) {
        if (account.getBic() != null) {
            return account.getBic();
        }
        if (account.getGermanBankCode() != null) {
            return account.getGermanBankCode();
        }
        if (account.getFrenchBankCode() != null) {
            StringBuilder result = new StringBuilder(account.getFrenchBankCode());
            if (account.getFrenchBranchCode() != null) {
                result.append('/').append(account.getFrenchBranchCode());
            }
            return result.toString();
        }
        if (account.getNationalBankCode() != null) {
            return account.getNationalBankCode();
        }
        return "";
    }

    public static String getOrderTypeText(OrderType ot) {
        if (ot == null) {
            return "";
        }
        String orderType = ot.getOrderType();
        String fileFormat = ot.getFileFormat();
        if (fileFormat != null) {
            if ("BTU".equals(orderType) || "BTD".equals(orderType)) {
                return fileFormat;
            }
            return orderType != null ? orderType + "." + fileFormat : fileFormat;
        }
        return orderType != null ? orderType : "";
    }

    public static String getSignatureClass(UserPermission.AuthorizationLevel authLevel) {
        if (authLevel == UserPermission.AuthorizationLevel.SINGLE) {
            return "E";
        }
        if (authLevel == UserPermission.AuthorizationLevel.FIRST) {
            return "A";
        }
        if (authLevel == UserPermission.AuthorizationLevel.SECOND) {
            return "B";
        }
        if (authLevel == UserPermission.AuthorizationLevel.TRANSPORT) {
            return "T";
        }
        return "";
    }

    public static String getMaxAmount(Locale locale, BigDecimal maxAmount, String maxAmountCurrency) {
        if (maxAmount != null && maxAmountCurrency != null) {
            return PaymentUtils.formatAmount(maxAmount, Currency.getInstance(maxAmountCurrency), locale);
        }
        return "";
    }

    public static String getAccount(AccountPermission accountPermission) {
        if (accountPermission != null) {
            Account account = accountPermission.getAccount();
            StringBuilder result = new StringBuilder(HTDUtil.getBankCode(account));
            if (result.length() > 0) {
                result.append('/');
            }
            return result.append(HTDUtil.getAccountNumber(account)).toString();
        }
        return "";
    }
}

