/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.OrderTypeUtil;
import de.businesslogics.banking.api.UserEffectivePermissions;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.ListElement;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.h005.ServiceOptionStringType;
import de.businesslogics.ebics.schema.h005.UsageOrderType;
import de.businesslogics.ebics.schema.orders.AccountInfo;
import de.businesslogics.ebics.schema.orders.HKDResponseOrderData;
import de.businesslogics.ebics.schema.orders.HTDResponseOrderData;
import de.businesslogics.ebics.schema.orders.OrderInfo;
import de.businesslogics.ebics.schema.orders.PartnerInfo;
import de.businesslogics.ebics.schema.orders.UserInfo;
import de.businesslogics.ebics.schema.orders.UserPermission;
import de.businesslogics.ebics.schema.types.Parameter;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.TransferType;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class HTDProcessing {
    public static boolean USE_ACCOUNT_HOLDER_AS_NAME = false;
    protected BLLogger logger;

    private static boolean areObjectsEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }

    private static String normalizeGermanAccountNumber(String accountNumber) {
        StringBuilder result = new StringBuilder(accountNumber);
        while (result.length() < 10) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    private static BankCodeType getBankCodeType(SimpleStringElement bankCodeElement) {
        if (bankCodeElement != null && bankCodeElement.getValue() != null) {
            if (RegularExpressions.GERMAN_BANK_CODE.matches(bankCodeElement.getValue())) {
                return BankCodeType.GERMAN;
            }
            if (bankCodeElement.getValue().matches("[A-Z]{6}[A-Z0-9]{2}([A-Z0-9]{3})?")) {
                return BankCodeType.BIC;
            }
            return BankCodeType.NATIONAL;
        }
        return null;
    }

    private static AccountNumberType getAccountNumberType(SimpleStringElement accountNumberElement) {
        if (accountNumberElement != null && accountNumberElement.getValue() != null) {
            if (accountNumberElement.getValue().matches("\\d{1,10}")) {
                return AccountNumberType.GERMAN;
            }
            if (accountNumberElement.getValue().matches("[A-Z]{2}[0-9]{2}[A-Z0-9]{1,30}")) {
                return AccountNumberType.IBAN;
            }
            return AccountNumberType.NATIONAL;
        }
        return null;
    }

    public void handleHtdFromInputStream(BankUser bankUser, InputStream inputStream) throws SAXException, IOException {
        HTDResponseOrderData htd = new HTDResponseOrderData(ProtocolVersion.getInstance(bankUser.getBank().getProtocolVersion()));
        EbicsRootParser parser = new EbicsRootParser(null, htd);
        EbicsHandler.parse(inputStream, parser);
        this.handleHtd(bankUser, htd.getPartnerInfo(), htd.getUserInfo());
        UserEffectivePermissions.updatePermissions(bankUser);
    }

    public void handleHkdFromInputStream(BankSettings bank, InputStream inputStream) throws SAXException, IOException {
        HKDResponseOrderData hkd = new HKDResponseOrderData(ProtocolVersion.getInstance(bank.getProtocolVersion()));
        EbicsRootParser parser = new EbicsRootParser(null, hkd);
        EbicsHandler.parse(inputStream, parser);
        for (UserInfo userInfo : hkd.getUserInfos()) {
            BankUser user = BankUser.findBankUser(bank, userInfo.getUserID().getValue());
            this.handleHtd(user, hkd.getPartnerInfo(), userInfo);
        }
        UserEffectivePermissions.updatePermissions(bank);
    }

    protected void handleHtd(BankUser bankUser, PartnerInfo partnerInfo, UserInfo userInfo) {
        if (bankUser == null) {
            return;
        }
        BankSettings bank = bankUser.getBank();
        this.checkForTransferSystem(bank, partnerInfo);
        this.checkGeneralInformation(bankUser, partnerInfo, userInfo);
        boolean checkSendPermissions = new DatabasePreferenceStore(Preference.ApplicationId.CM, bankUser.getUser(), null).getBoolean(CmPreferenceConstants.DISPLAY_ONLY_ACCOUNTS_WITH_PAYMENT_PERMISSIONS);
        boolean isH005OrNewer = BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion());
        HashMap<String, OrderType> knownOrderTypes = new HashMap<String, OrderType>();
        for (OrderInfo orderInfo : partnerInfo.getOrders()) {
            Object vooInfo;
            Object orderFileType = orderInfo.getOrderType() != null ? orderInfo.getOrderType().getValue() : "";
            String generalizedFileType = this.getGeneralizedFileType(isH005OrNewer, orderInfo);
            if (generalizedFileType != null) {
                orderFileType = (String)orderFileType + "/" + generalizedFileType;
            }
            knownOrderTypes.put((String)orderFileType, this.checkHtdOrderType(bank, orderInfo, generalizedFileType));
            if (!isH005OrNewer || (vooInfo = this.getVOOOderInfo(orderInfo)) == null) continue;
            String general = this.getGeneralizedFileType(true, (OrderInfo)vooInfo);
            knownOrderTypes.put("BTU/" + general, this.checkHtdOrderType(bank, (OrderInfo)vooInfo, general));
        }
        List<Account> allAccountsList = Account.findAccountsForBank(bank);
        HashMap<String, Account> knownAccountIds = new HashMap<String, Account>();
        for (AccountInfo accountInfo : partnerInfo.getAccounts()) {
            if (accountInfo.getUsageOrderTypes() instanceof ListElement && ((ListElement)accountInfo.getUsageOrderTypes()).isEmpty() || accountInfo.getUsageOrderTypes() instanceof UsageOrderType && ((UsageOrderType)accountInfo.getUsageOrderTypes()).getServices().isEmpty()) continue;
            if (checkSendPermissions) {
                boolean isProtocolH005OrNewer = BankUtils.isProtocolH005OrNewer(bankUser.getBank().getProtocolVersion());
                boolean foundAtLeastOnePermission = false;
                block2: for (UserPermission userPermission : userInfo.getPermissions()) {
                    if (userPermission.getAuthorisationLevel() == null || userPermission.getAuthorisationLevel().isEmpty() || userPermission.getAccount() != null && !userPermission.getAccount().getValue().equals(accountInfo.getID())) continue;
                    if (isProtocolH005OrNewer) {
                        if (userPermission.getService() == null) continue;
                        foundAtLeastOnePermission = true;
                        break;
                    }
                    for (SimpleStringElement simpleStringElement : userPermission.getOrderTypes()) {
                        if (OrderTypeUtil.isAdminOrderType(simpleStringElement.getValue())) continue;
                        foundAtLeastOnePermission = true;
                        continue block2;
                    }
                }
                if (!foundAtLeastOnePermission) continue;
            }
            Account account = this.checkHtdAccount(bank, allAccountsList, accountInfo);
            knownAccountIds.put(accountInfo.getID(), account);
            this.checkAccountPermission(bankUser, account);
        }
        this.deactivateDeprecatedAccounts(bankUser, allAccountsList, knownAccountIds);
        ArrayList<de.businesslogics.banking.database.vo.UserPermission> knownUserPermissions = new ArrayList<de.businesslogics.banking.database.vo.UserPermission>();
        for (UserPermission permission : userInfo.getPermissions()) {
            UserPermission vooPermission;
            knownUserPermissions.addAll(this.checkUserPermission(bankUser, permission, knownOrderTypes, knownAccountIds, isH005OrNewer));
            if (!isH005OrNewer || (vooPermission = this.getVOOPermission(permission)) == null) continue;
            knownUserPermissions.addAll(this.checkUserPermission(bankUser, vooPermission, knownOrderTypes, knownAccountIds, true));
        }
        de.businesslogics.banking.database.vo.UserPermission.deleteUnknownUserPermissions(bankUser, knownUserPermissions);
    }

    private boolean isVOO(RestrictedServiceType btf) {
        if (btf == null) {
            return false;
        }
        return !(!"SCT".equals(btf.getServiceName().getValue()) && !"SCI".equals(btf.getServiceName().getValue()) || btf.getServiceOption() != null && !"VOO".equals(btf.getServiceOption().getValue()) || !"pain.001".equals(btf.getMsgName().getValue()));
    }

    private RestrictedServiceType reverseVOO(RestrictedServiceType existing) {
        RestrictedServiceType service = new RestrictedServiceType(existing.getServiceName(), existing.getMsgName());
        service.setContainer(existing.getContainer());
        service.setScope(existing.getScope());
        if (existing.getServiceOption() == null) {
            service.setServiceOption(new ServiceOptionStringType("VOO"));
        }
        return service;
    }

    private OrderInfo getVOOOderInfo(OrderInfo orderInfo) {
        if (this.isVOO(orderInfo.getService())) {
            OrderInfo voo = new OrderInfo(orderInfo.getOrderType(), orderInfo.getDescription(), orderInfo.getNumSigRequired());
            voo.setService(this.reverseVOO(orderInfo.getService()));
            return voo;
        }
        return null;
    }

    private UserPermission getVOOPermission(UserPermission permission) {
        if (this.isVOO(permission.getService())) {
            UserPermission voo = new UserPermission(permission.getAdminOrderType(), permission.getAccount(), permission.getMaxAmount(), permission.getAuthorisationLevel());
            voo.setService(this.reverseVOO(permission.getService()));
            return voo;
        }
        return null;
    }

    private String getGeneralizedFileType(boolean isH005OrNewer, OrderInfo orderInfo) {
        if (isH005OrNewer) {
            if (orderInfo.getService() != null) {
                return BTFTranslator.convertToString(orderInfo.getService());
            }
        } else if (orderInfo.getFileFormat() != null) {
            return orderInfo.getFileFormat().getValue();
        }
        return null;
    }

    private void checkForTransferSystem(BankSettings bank, PartnerInfo partnerInfo) {
        List<Parameter> parameters = partnerInfo.getBankInfo().getParameters();
        if (parameters == null || parameters.isEmpty()) {
            this.setTransferSystemFlag(bank, false);
            return;
        }
        for (Parameter parameter : parameters) {
            if (parameter.getName() == null || parameter.getName().getValue() == null || !parameter.getName().getValue().equals("BL-Transfersystem")) continue;
            this.setTransferSystemFlag(bank, true);
            return;
        }
        this.setTransferSystemFlag(bank, false);
    }

    private void setTransferSystemFlag(BankSettings bank, boolean flag) {
        if (bank.isTransferSystem() != flag) {
            bank.setTransferSystem(flag);
            bank.save();
        }
    }

    private void checkGeneralInformation(BankUser bankUser, PartnerInfo partnerInfo, UserInfo userInfo) {
        BankUserHtdInfo bankUserHtdInfo = BankUserHtdInfo.findForBankUser(bankUser);
        if (bankUserHtdInfo == null) {
            bankUserHtdInfo = new BankUserHtdInfo();
            bankUserHtdInfo.setBankUser(bankUser);
        }
        bankUserHtdInfo.setEbicsHostId(partnerInfo.getBankInfo().getHostID().getValue());
        if (partnerInfo.getAddressInfo().getName() != null) {
            bankUserHtdInfo.setName(partnerInfo.getAddressInfo().getName().getValue());
        } else {
            bankUserHtdInfo.setName(null);
        }
        if (partnerInfo.getAddressInfo().getStreet() != null) {
            bankUserHtdInfo.setStreet(partnerInfo.getAddressInfo().getStreet().getValue());
        } else {
            bankUserHtdInfo.setStreet(null);
        }
        if (partnerInfo.getAddressInfo().getPostCode() != null) {
            bankUserHtdInfo.setPostCode(partnerInfo.getAddressInfo().getPostCode().getValue());
        } else {
            bankUserHtdInfo.setPostCode(null);
        }
        if (partnerInfo.getAddressInfo().getCity() != null) {
            bankUserHtdInfo.setCity(partnerInfo.getAddressInfo().getCity().getValue());
        } else {
            bankUserHtdInfo.setCity(null);
        }
        if (partnerInfo.getAddressInfo().getRegion() != null) {
            bankUserHtdInfo.setRegion(partnerInfo.getAddressInfo().getRegion().getValue());
        } else {
            bankUserHtdInfo.setRegion(null);
        }
        if (partnerInfo.getAddressInfo().getCountry() != null) {
            bankUserHtdInfo.setCountry(partnerInfo.getAddressInfo().getCountry().getValue());
        } else {
            bankUserHtdInfo.setCountry(null);
        }
        if (userInfo.getUserID() != null) {
            bankUserHtdInfo.setUserId(userInfo.getUserID().getValue());
        } else {
            bankUserHtdInfo.setUserId(null);
        }
        if (userInfo.getName() != null) {
            bankUserHtdInfo.setUserName(userInfo.getName().getValue());
        } else {
            bankUserHtdInfo.setUserName(null);
        }
        bankUserHtdInfo.setHtdTime(new Timestamp(System.currentTimeMillis()));
        bankUserHtdInfo.save();
    }

    private OrderType checkHtdOrderType(BankSettings bank, OrderInfo orderInfo, String generalizedFileType) {
        OrderType.TransferType transferType;
        String orderTypeString = orderInfo.getOrderType().getValue();
        if (TransferType.DOWNLOAD.equals(orderInfo.getTransferType())) {
            transferType = OrderType.TransferType.FETCH;
        } else if (TransferType.UPLOAD.equals(orderInfo.getTransferType())) {
            transferType = OrderType.TransferType.SEND;
        } else {
            transferType = OrderTypeUtil.getTransferType(orderTypeString);
            if (transferType == null) {
                transferType = OrderType.TransferType.SEND;
                if (this.logger != null) {
                    this.logger.logWarning("Unexpected order type " + orderTypeString + ". Setting transfer type to " + String.valueOf((Object)transferType));
                }
            }
        }
        OrderType orderType = OrderType.findOrderType(bank, transferType, orderTypeString, generalizedFileType);
        if (orderType == null) {
            orderType = new OrderType();
            orderType.setBank(bank);
            orderType.setOrderType(orderInfo.getOrderType().getValue());
            orderType.setTransferType(transferType);
            orderType.setFileFormat(generalizedFileType);
        }
        if (orderInfo.getOrderFormat() != null) {
            orderType.setOrderFormat(orderInfo.getOrderFormat().getValue());
        } else {
            orderType.setOrderFormat(null);
        }
        if (orderInfo.getNumSigRequired() != null) {
            orderType.setNumSigRequired(orderInfo.getNumSigRequired().intValue());
        } else {
            orderType.setNumSigRequired(null);
        }
        if (orderInfo.getDescription() != null && orderInfo.getDescription().getValue() != null) {
            if (orderInfo.getDescription().getValue().length() > 255) {
                orderType.setDescription(orderInfo.getDescription().getValue().substring(0, 255));
            } else {
                orderType.setDescription(orderInfo.getDescription().getValue());
            }
        } else {
            orderType.setDescription(null);
        }
        orderType.save();
        BankUser.setPermissionsForLocalUser(orderType);
        BankUser.setPermissionsForNotInitializedUser(orderType);
        return orderType;
    }

    private Account checkHtdAccount(BankSettings bank, List<Account> allAccountsList, AccountInfo accountInfo) {
        Matcher frIbanMatcher;
        SEPABankConnection sepaBankConnection;
        String germanBankCode = null;
        String bic = null;
        String nationalBankCode = null;
        BankCodeType bankCodeType = HTDProcessing.getBankCodeType(accountInfo.getBankCode());
        if (bankCodeType == BankCodeType.GERMAN) {
            germanBankCode = accountInfo.getBankCode().getValue();
        } else if (bankCodeType == BankCodeType.BIC) {
            bic = accountInfo.getBankCode().getValue();
        } else if (bankCodeType == BankCodeType.NATIONAL) {
            nationalBankCode = accountInfo.getBankCode().getValue();
        }
        bankCodeType = HTDProcessing.getBankCodeType(accountInfo.getBankCode2());
        if (bankCodeType == BankCodeType.GERMAN) {
            germanBankCode = accountInfo.getBankCode2().getValue();
        } else if (bankCodeType == BankCodeType.BIC) {
            bic = accountInfo.getBankCode2().getValue();
        } else if (bankCodeType == BankCodeType.NATIONAL) {
            nationalBankCode = accountInfo.getBankCode2().getValue();
        }
        String germanAccountNumber = null;
        String iban = null;
        String nationalAccountNumber = null;
        AccountNumberType accountNumberType = HTDProcessing.getAccountNumberType(accountInfo.getAccountNumber());
        if (accountNumberType == AccountNumberType.GERMAN) {
            if (germanBankCode != null) {
                germanAccountNumber = StringUtils.removeLeadingChars(accountInfo.getAccountNumber().getValue(), '0');
            } else {
                nationalAccountNumber = accountInfo.getAccountNumber().getValue();
            }
        } else if (accountNumberType == AccountNumberType.IBAN) {
            iban = accountInfo.getAccountNumber().getValue();
        } else if (accountNumberType == AccountNumberType.NATIONAL) {
            nationalAccountNumber = accountInfo.getAccountNumber().getValue();
        }
        accountNumberType = HTDProcessing.getAccountNumberType(accountInfo.getAccountNumber2());
        if (accountNumberType == AccountNumberType.GERMAN) {
            if (germanBankCode != null) {
                germanAccountNumber = StringUtils.removeLeadingChars(accountInfo.getAccountNumber2().getValue(), '0');
            } else {
                nationalAccountNumber = accountInfo.getAccountNumber2().getValue();
            }
        } else if (accountNumberType == AccountNumberType.IBAN) {
            iban = accountInfo.getAccountNumber2().getValue();
        } else if (accountNumberType == AccountNumberType.NATIONAL) {
            nationalAccountNumber = accountInfo.getAccountNumber2().getValue();
        }
        if (germanBankCode != null && germanAccountNumber == null) {
            nationalBankCode = germanBankCode;
            germanBankCode = null;
        }
        if (iban != null && !"DE".equals(iban.substring(0, 2)) || iban == null && bic != null && !"DE".equals(bic.substring(4, 6))) {
            if (germanBankCode != null) {
                nationalBankCode = germanBankCode;
                germanBankCode = null;
            }
            if (germanAccountNumber != null) {
                nationalAccountNumber = germanAccountNumber;
                germanAccountNumber = null;
            }
        }
        if (germanBankCode != null && germanAccountNumber != null && (iban == null || bic == null) && (sepaBankConnection = BLZCache.getSEPABankConnection(germanBankCode, germanAccountNumber)) != null) {
            if (iban == null) {
                iban = sepaBankConnection.getIban();
            }
            if (bic == null) {
                bic = sepaBankConnection.getBic();
            }
        }
        String frenchBankCode = null;
        String frenchBranchCode = null;
        String frenchAccountNumber = null;
        String frenchCheckCode = null;
        if (iban != null && (frIbanMatcher = Pattern.compile("FR[0-9]{2}([0-9]{5})([0-9]{5})([A-Z0-9]{11})([0-9]{2})").matcher(iban)).matches()) {
            frenchBankCode = frIbanMatcher.group(1);
            frenchBranchCode = frIbanMatcher.group(2);
            frenchAccountNumber = frIbanMatcher.group(3);
            frenchCheckCode = frIbanMatcher.group(4);
        }
        String currency = accountInfo.getCurrency();
        String invalidCurrency = null;
        Account accountWithInvalidCurrency = null;
        try {
            Currency.getInstance(currency);
        }
        catch (Exception e) {
            invalidCurrency = currency;
            currency = "EUR";
            accountWithInvalidCurrency = this.findAccount(allAccountsList, iban, bic, germanAccountNumber, germanBankCode, nationalAccountNumber, nationalBankCode, invalidCurrency);
        }
        Account account = this.findAccount(allAccountsList, iban, bic, germanAccountNumber, germanBankCode, nationalAccountNumber, nationalBankCode, currency);
        if (account == null && accountWithInvalidCurrency != null) {
            if (this.logger != null && invalidCurrency != null) {
                this.logger.logWarning("Account " + this.getAccountNumber(iban, nationalAccountNumber, germanAccountNumber, frenchAccountNumber) + " has invalid currency " + invalidCurrency + ". Change the account currency to " + currency);
            }
            account = accountWithInvalidCurrency;
        }
        if (account == null) {
            account = new Account();
            account.setBank(bank);
            allAccountsList.add(account);
            if (this.logger != null && invalidCurrency != null) {
                this.logger.logWarning("Account " + this.getAccountNumber(iban, nationalAccountNumber, germanAccountNumber, frenchAccountNumber) + " has invalid currency " + invalidCurrency + ". Create account with currency " + currency);
            }
        }
        account.setDescription(accountInfo.getDescription());
        if (accountInfo.getAccountHolder() != null && accountInfo.getAccountHolder().getValue() != null && !accountInfo.getAccountHolder().getValue().isEmpty()) {
            String old = account.getAccountHolderHTD();
            account.setAccountHolderHTD(accountInfo.getAccountHolder().getValue());
            if (old == null && account.getAccountHolder() == null) {
                account.setAccountHolder(accountInfo.getAccountHolder().getValue());
            } else if (old != null && old.equals(account.getAccountHolder())) {
                account.setAccountHolder(accountInfo.getAccountHolder().getValue());
            }
            if (USE_ACCOUNT_HOLDER_AS_NAME && (account.getName() == null || old == null || account.getName().equals(old))) {
                account.setName(account.getAccountHolderHTD());
            }
        }
        account.setGermanBankCode(germanBankCode);
        account.setGermanAccountNumber(germanAccountNumber);
        account.setFrenchBankCode(frenchBankCode);
        account.setFrenchBranchCode(frenchBranchCode);
        account.setFrenchAccountNumber(frenchAccountNumber);
        account.setFrenchCheckCode(frenchCheckCode);
        account.setIban(iban);
        account.setBic(bic);
        account.setNationalBankCode(nationalBankCode);
        account.setNationalAccountNumber(nationalAccountNumber);
        account.setCurrency(currency);
        account.setType(Account.Type.HTD);
        account.save();
        return account;
    }

    private String getAccountNumber(String iban, String nationalAccountNumber, String germanAccountNumber, String frenchAccountNumber) {
        if (iban != null) {
            return iban;
        }
        if (nationalAccountNumber != null) {
            return nationalAccountNumber;
        }
        if (germanAccountNumber != null) {
            return germanAccountNumber;
        }
        if (frenchAccountNumber != null) {
            return frenchAccountNumber;
        }
        return "";
    }

    private Account findAccount(List<Account> allAccountsList, String iban, String bic, String germanAccountNumber, String germanBankCode, String nationalAccountNumber, String nationalBankCode, String currency) {
        for (Account account : allAccountsList) {
            if (!HTDProcessing.areObjectsEqual(iban, account.getIban()) || !HTDProcessing.areObjectsEqual(bic, account.getBic()) || !HTDProcessing.areObjectsEqual(germanAccountNumber, account.getGermanAccountNumber()) || !HTDProcessing.areObjectsEqual(germanBankCode, account.getGermanBankCode()) || !HTDProcessing.areObjectsEqual(nationalAccountNumber, account.getNationalAccountNumber()) || !HTDProcessing.areObjectsEqual(nationalBankCode, account.getNationalBankCode()) || !HTDProcessing.areObjectsEqual(currency, account.getCurrency())) continue;
            return account;
        }
        if (iban != null) {
            ArrayList<Account> ibanAccountsList = new ArrayList<Account>();
            for (Account account : allAccountsList) {
                if (!iban.equals(account.getIban()) || !HTDProcessing.areObjectsEqual(currency, account.getCurrency())) continue;
                ibanAccountsList.add(account);
            }
            if (ibanAccountsList.size() == 1) {
                return (Account)ibanAccountsList.get(0);
            }
            if (bic != null && ibanAccountsList.size() > 1) {
                ArrayList<Account> arrayList = new ArrayList<Account>();
                for (Account account : ibanAccountsList) {
                    if (!bic.equals(account.getBic())) continue;
                    arrayList.add(account);
                }
                if (arrayList.size() == 0) {
                    for (Account account : ibanAccountsList) {
                        if (account.getBic() != null) continue;
                        return account;
                    }
                } else {
                    return (Account)arrayList.get(0);
                }
            }
        }
        if (germanBankCode != null && germanAccountNumber != null) {
            String normalizedAccountNumber = HTDProcessing.normalizeGermanAccountNumber(germanAccountNumber);
            for (Account account : allAccountsList) {
                if (account.getGermanAccountNumber() == null || !normalizedAccountNumber.equals(HTDProcessing.normalizeGermanAccountNumber(account.getGermanAccountNumber())) || !germanBankCode.equals(account.getGermanBankCode()) || account.getCurrency() == null || !currency.equals(account.getCurrency())) continue;
                return account;
            }
        }
        if (nationalAccountNumber != null) {
            ArrayList<Account> nationalAccountsList = new ArrayList<Account>();
            for (Account account : allAccountsList) {
                if (!nationalAccountNumber.equals(account.getNationalAccountNumber()) || !currency.equals(account.getCurrency()) || !HTDProcessing.areObjectsEqual(nationalBankCode, account.getNationalBankCode())) continue;
                nationalAccountsList.add(account);
            }
            if (nationalAccountsList.size() == 1) {
                return (Account)nationalAccountsList.get(0);
            }
            if (nationalAccountsList.size() > 1) {
                for (Account account : nationalAccountsList) {
                    if (!HTDProcessing.areObjectsEqual(bic, account.getBic())) continue;
                    return account;
                }
            }
        }
        return null;
    }

    private AccountPermission checkAccountPermission(BankUser bankUser, Account account) {
        ApOverwrite overwrite;
        AccountPermission accountPermission = AccountPermission.findAccountPermissionForBank(bankUser, account);
        if (accountPermission == null && (overwrite = ApOverwrite.findByBankAndAccount(bankUser, account)) == null) {
            accountPermission = new AccountPermission();
            accountPermission.setBankUser(bankUser);
            accountPermission.setAccount(account);
            accountPermission.save();
        }
        return accountPermission;
    }

    private void deactivateDeprecatedAccounts(BankUser bankUser, List<Account> allAccounts, Map<String, Account> activeAccounts) {
        HashSet<Account> toDelete = new HashSet<Account>(allAccounts);
        toDelete.removeAll(activeAccounts.values());
        if (!toDelete.isEmpty()) {
            toDelete.removeIf(a -> a.isManualAccount() || a.isCMAccount());
            AccountPermission.deleteForUser(bankUser, new ArrayList<Account>(toDelete));
        }
    }

    private List<de.businesslogics.banking.database.vo.UserPermission> checkUserPermission(BankUser bankUser, UserPermission permission, Map<String, OrderType> knownOrderTypes, Map<String, Account> knownAccountIds, boolean isProtocolH005OrNewer) {
        ArrayList<de.businesslogics.banking.database.vo.UserPermission> userPermissions = new ArrayList<de.businesslogics.banking.database.vo.UserPermission>();
        int countOrderTypes = isProtocolH005OrNewer ? 1 : permission.getOrderTypes().size();
        for (int i = 0; i < countOrderTypes; ++i) {
            String maxAmountCurrency;
            BigDecimal maxAmount;
            OrderType orderType;
            Object orderFileType;
            if (isProtocolH005OrNewer) {
                orderFileType = permission.getAdminOrderType().getValue();
                if (permission.getService() != null) {
                    orderFileType = (String)orderFileType + "/" + BTFTranslator.convertToString(permission.getService());
                }
            } else {
                orderFileType = ((SimpleStringElement)permission.getOrderTypes().get(i)).getValue();
                if (permission.getFileFormat() != null) {
                    orderFileType = (String)orderFileType + "/" + permission.getFileFormat().getValue();
                }
            }
            if ((orderType = knownOrderTypes.get(orderFileType)) == null) continue;
            Account account = permission.getAccount() != null ? knownAccountIds.get(permission.getAccount().getValue()) : null;
            UserPermission.AuthorizationLevel authLevel = "A".equals(permission.getAuthorisationLevel()) ? UserPermission.AuthorizationLevel.FIRST : ("B".equals(permission.getAuthorisationLevel()) ? UserPermission.AuthorizationLevel.SECOND : ("E".equals(permission.getAuthorisationLevel()) ? UserPermission.AuthorizationLevel.SINGLE : ("T".equals(permission.getAuthorisationLevel()) ? UserPermission.AuthorizationLevel.TRANSPORT : null)));
            if (permission.getMaxAmount() != null) {
                maxAmount = permission.getMaxAmount().getValue();
                maxAmountCurrency = permission.getMaxAmount().getCurrency() != null ? permission.getMaxAmount().getCurrency().getCurrencyCode() : "EUR";
            } else {
                maxAmount = null;
                maxAmountCurrency = null;
            }
            int userPermissionsSize = userPermissions.size();
            userPermissions.addAll(de.businesslogics.banking.database.vo.UserPermission.findUserPermission(bankUser, orderType, account, authLevel, maxAmount));
            if (userPermissions.size() != userPermissionsSize) continue;
            AccountPermission ap = null;
            if (account != null && (ap = AccountPermission.findAccountPermissionForBank(bankUser, account)) == null) continue;
            de.businesslogics.banking.database.vo.UserPermission newUserPermission = new de.businesslogics.banking.database.vo.UserPermission();
            newUserPermission.setBankUser(bankUser);
            newUserPermission.setOrderType(orderType);
            newUserPermission.setAuthLevel(authLevel);
            newUserPermission.setMaxAmount(maxAmount);
            newUserPermission.setMaxAmountCurrency(maxAmountCurrency);
            newUserPermission.setAccountPermission(ap);
            newUserPermission.save();
            userPermissions.add(newUserPermission);
        }
        return userPermissions;
    }

    private static enum BankCodeType {
        GERMAN,
        BIC,
        NATIONAL;

    }

    private static enum AccountNumberType {
        GERMAN,
        IBAN,
        NATIONAL;

    }
}

