/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.HTDUtil;
import de.businesslogics.banking.api.OrderTypeUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;

public class HTDPrinter {
    private static final float SPACING = 20.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File printHTD(Locale locale, String userName, BankUser bankUser, BankUserHtdInfo bankUserHtdInfo) throws IOException, PDFException {
        File dest = Util.createTempFile(StringUtils.convertToValidFileName(bankUser.getBank().getCustomerId() + "_" + bankUser.getDefaultUser() + "_"), ".pdf", true);
        OutputStream fos = null;
        try {
            List<UserPermission> userPermissions;
            fos = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
            GeneralMessages messages = GeneralMessages.getInstance(locale);
            BLDocument document = Util.createBLDocument(fos, BLDocument.PageLayout.A4, messages.USER_PROFILE, Util.printLogo(bankUser.getUser()), locale);
            BankSettings bank = bankUser.getBank();
            String bankName = bank.getDisplayName();
            String title = MessageFormat.format(messages.USER_PROFILE_AT_BANK, userName, bankName);
            BLFont font = BLFont.FONT_BIG_BOLD;
            document.addHeadline(title, font, Alignment.ALIGN_CENTER, 10.0f);
            BLTable<?> t = PDFCreator.getInstance().createTable(2);
            t.setWidth(100.0f);
            t.setWidths(new int[]{1, 3});
            t.setBorder(BLBorder.NO_BORDER);
            t.addCell(messages.USER);
            t.addCell(userName);
            t.addCell(messages.BANK);
            t.addCell(bankName);
            t.addCell(messages.URL);
            t.addCell(bank.getUrl());
            t.addCell(messages.HOST_ID);
            t.addCell(bank.getHostId());
            t.addCell(messages.CUSTOMER_ID);
            t.addCell(bank.getCustomerId());
            t.addCell(messages.USER_ID);
            t.addCell(bankUser.getDefaultUser());
            t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
            document.addTable(t);
            List<AccountPermission> accountPermissions = HTDPrinter.getAccountPermissions(bankUser);
            if (accountPermissions != null && accountPermissions.size() > 0) {
                String accountTableTitle = messages.ACCOUNTS;
                BLFont accountTableFont = BLFont.FONT_BIG_BOLD;
                document.addHeadline(accountTableTitle, accountTableFont, Alignment.ALIGN_CENTER, 10.0f);
                BLTable<?> accountTable = HTDPrinter.createAccountTable(messages);
                for (AccountPermission accountPermission : accountPermissions) {
                    HTDPrinter.addAccount(accountTable, accountPermission.getAccount());
                }
                document.addTable(accountTable);
            }
            if ((userPermissions = HTDPrinter.getUserPermissions(bankUser)) != null && userPermissions.size() > 0) {
                String permissionTableTitle = messages.PERMISSIONS;
                BLFont permissionTableFont = BLFont.FONT_BIG_BOLD;
                document.addHeadline(permissionTableTitle, permissionTableFont, Alignment.ALIGN_CENTER, 10.0f);
                boolean isEbics30OrNewer = BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion());
                BLTable<?> permissionTable = HTDPrinter.createPermissionTable(messages, isEbics30OrNewer);
                for (UserPermission userPermission : userPermissions) {
                    OrderType ot = userPermission.getOrderType();
                    if (ot == null) {
                        HTDPrinter.addPermission(locale, permissionTable, userPermission);
                        continue;
                    }
                    String orderType = ot.getOrderType();
                    if (!"BTU".equals(orderType) && !"BTD".equals(orderType) && OrderTypeUtil.isAdminOrderType(orderType)) continue;
                    HTDPrinter.addPermission(locale, permissionTable, userPermission);
                }
                document.addTable(permissionTable);
            }
            document.close();
        }
        catch (Throwable throwable) {
            SystemUtils.close(fos);
            throw throwable;
        }
        SystemUtils.close(fos);
        return dest;
    }

    private static List<AccountPermission> getAccountPermissions(BankUser bankUser) {
        return AccountPermission.findByBankUser(bankUser).where().eq("account.type", (Object)Account.Type.HTD).orderBy("account.iban,account.germanAccountNumber,account.frenchAccountNumber,account.nationalAccountNumber").query().findList();
    }

    private static List<UserPermission> getUserPermissions(BankUser bankUser) {
        return UserPermission.findByBankUser(bankUser).findList();
    }

    private static BLTable<?> createAccountTable(GeneralMessages messages) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(6);
        t.setWidth(96.0f);
        t.setPadding(3.0f);
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(messages.NAME);
        t.addCell(messages.ACCOUNT_NUMBER);
        t.addCell(messages.BANK_CODE);
        t.addCell(messages.CURRENCY);
        t.addCell(messages.DESCRIPTION);
        t.addCell(messages.ACCOUNT_OWNER);
        t.setWidths(new int[]{20, 20, 15, 10, 20, 15});
        t.setHeaderRows(1);
        return t;
    }

    private static void addAccount(BLTable<?> t, Account account) throws PDFException {
        t.addCell(StringUtils.checkNullAndTrim(account.getName()));
        t.addCell(HTDUtil.getAccountNumber(account));
        t.addCell(HTDUtil.getBankCode(account));
        t.addCell(StringUtils.checkNullAndTrim(account.getCurrency()));
        t.addCell(StringUtils.checkNullAndTrim(account.getDescription()));
        t.addCell(StringUtils.checkNullAndTrim(account.getAccountHolderHTD()));
    }

    private static BLTable<?> createPermissionTable(GeneralMessages messages, boolean isEbics30OrNewer) throws PDFException {
        BLTable<?> t = PDFCreator.getInstance().createTable(4);
        t.setWidth(96.0f);
        t.setPadding(3.0f);
        t.setSpacingBefore(20.0f);
        t.setSpacingAfter(20.0f);
        t.setHorizontalAlignment(Alignment.ALIGN_CENTER);
        t.addCell(isEbics30OrNewer ? messages.BTF : messages.ORDER_TYPE);
        t.addCell(messages.SIGNATURE_CLASS);
        t.addCell(messages.AMOUNT);
        t.addCell(messages.ACCOUNT);
        t.setWidths(new int[]{30, 20, 20, 30});
        t.setHeaderRows(1);
        return t;
    }

    private static void addPermission(Locale locale, BLTable<?> t, UserPermission permission) throws PDFException {
        t.addCell(HTDUtil.getOrderTypeText(permission.getOrderType()));
        t.addCell(HTDUtil.getSignatureClass(permission.getAuthLevel()));
        t.addCell(HTDUtil.getMaxAmount(locale, permission.getMaxAmount(), permission.getMaxAmountCurrency()));
        t.addCell(HTDUtil.getAccount(permission.getAccountPermission()));
    }
}

