/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class GeneralMessages {
    private static final Map<String, GeneralMessages> INSTANCES = new HashMap<String, GeneralMessages>();
    public final String IN_ENGLISH;
    public final String Yes;
    public final String No;
    public final String and;
    public final String or;
    public final String from;
    public final String to;
    public final String equal;
    public final String unequal;
    public final String NEW;
    public final String CANCEL;
    public final String CANCELLED_ON;
    public final String CHECK;
    public final String CONFIRM;
    public final String CONFIRM_CREATION;
    public final String CONFIRM_MODIFICATION;
    public final String DELETE;
    public final String ENTER;
    public final String DISCARD_CREATION;
    public final String DISCARD_MODIFICATION;
    public final String MODIFY;
    public final String ACTIVATE;
    public final String DEACTIVATE;
    public final String RESET;
    public final String LOCK;
    public final String UNLOCK;
    public final String CALCULATE;
    public final String DETERMINE;
    public final String DISPLAY;
    public final String UPDATE;
    public final String PRINT;
    public final String PRINT_OVERVIEW;
    public final String EXPORT;
    public final String EXPORT_OVERVIEW;
    public final String BROWSE;
    public final String REMEMBER_DECISION;
    public final String DO_NOT_SHOW_AGAIN;
    public final String SEQUENTIAL_NUMBER;
    public final String REFERENCE_NUMBER;
    public final String ACCOUNT_NUMBER;
    public final String IBAN;
    public final String IBAN_RIB;
    public final String IBAN_ACCOUNT_NUMBER;
    public final String ACCOUNT_NUMBER_IBAN;
    public final String BANK_CODE;
    public final String BIC;
    public final String BANK_CODE_BIC;
    public final String BIC_BLZ;
    public final String BLZ;
    public final String BANKLEITZAHL;
    public final String BRANCH_CODE;
    public final String LEI;
    public final String CONTROL_KEY;
    public final String CURRENCY;
    public final String COUNTER_VALUE_CURRENCY;
    public final String CUSTOMER_ID;
    public final String CUSTOMER_PROTOCOL;
    public final String HOST_ID;
    public final String URL;
    public final String ADDRESS;
    public final String BANK_ADDRESS;
    public final String BANK_NAME;
    public final String STREET;
    public final String PLACE;
    public final String COUNTRY;
    public final String COUNTRY_CODE;
    public final String ACCOUNT;
    public final String ACCOUNTS;
    public final String ACCOUNT_CURRENCY;
    public final String ACCOUNT_FILTER;
    public final String ACCOUNT_OWNER;
    public final String DEFAULT_ACCOUNT;
    public final String AMOUNT;
    public final String AMOUNT_IN_ACCOUNT_CURRENCY;
    public final String ORIGINAL_AMOUNT;
    public final String EXCHANGE_RATE;
    public final String BALANCE;
    public final String DATE;
    public final String EXECUTION_DATE;
    public final String EXECUTION_TIME;
    public final String PAYMENT_DATE;
    public final String TIME;
    public final String TIME_OF_DAY;
    public final String EXPIRATION_DATE;
    public final String DATE_FORMAT;
    public final String NUMBER_FORMAT;
    public final String EXAMPLE;
    public final String CHARGE;
    public final String CHARGES;
    public final String TOTAL_CHARGES;
    public final String CREATION_DATE;
    public final String CREATION_TIME;
    public final String LAST_FETCH;
    public final String LAST_UPDATE;
    public final String PAYMENT_CATEGORY;
    public final String PAYMENT_TYPE;
    public final String REGULATORY_INFORMATION;
    public final String PRIORITY;
    public final String FEE_TYPE;
    public final String CHEQUE_TYPE;
    public final String DELIVERY_METHOD;
    public final String ADDITIONAL_INFORMATION;
    public final String ADDITIONAL_INFORMATION_SINGULAR;
    public final String PURPOSE;
    public final String CREDITOR_REFERENCE;
    public final String ESR_PARTICIPANT_NUMBER;
    public final String ESR_REFERENCE;
    public final String QR_REFERENCE;
    public final String ORIGINATOR;
    public final String RECIPIENT;
    public final String PAYEE;
    public final String PAYER;
    public final String ORIGINAL_ORIGINATOR;
    public final String ORIGINAL_RECIPIENT;
    public final String ORIGINAL_PAYEE;
    public final String ORIGINAL_PAYER;
    public final String ULTIMATE_ORIGINATOR;
    public final String ULTIMATE_RECIPIENT;
    public final String ULTIMATE_PAYEE;
    public final String ULTIMATE_PAYER;
    public final String ORIGINATOR_ACC_NO;
    public final String ORIGINATOR_ACCOUNT_NUMBER;
    public final String ORIGINATOR_IBAN;
    public final String ORIGINATOR_BANK_CODE;
    public final String ORIGINATOR_BIC;
    public final String ORIGINATOR_BLZ;
    public final String ORIGINATOR_COUNTRY;
    public final String ORIGINATOR_COUNTRY_CODE;
    public final String RECIPIENT_ACC_NO;
    public final String RECIPIENT_ACCOUNT_NUMBER;
    public final String RECIPIENT_IBAN;
    public final String RECIPIENT_BANK;
    public final String RECIPIENT_BANK_CODE;
    public final String RECIPIENT_BANK_COUNTRY;
    public final String RECIPIENT_BIC;
    public final String RECIPIENT_COUNTRY;
    public final String RECIPIENT_COUNTRY_CODE;
    public final String PAYER_ACC_NO;
    public final String PAYER_ACCOUNT_NUMBER;
    public final String PAYER_IBAN;
    public final String PAYER_BANK_CODE;
    public final String PAYER_BIC;
    public final String PAYER_STREET;
    public final String PAYER_PLACE;
    public final String PAYER_COUNTRY;
    public final String PAYER_COUNTRY_CODE;
    public final String PAYEE_ACC_NO;
    public final String PAYEE_ACCOUNT_NUMBER;
    public final String PAYEE_IBAN;
    public final String PAYEE_BANK_CODE;
    public final String PAYEE_BIC;
    public final String CODE;
    public final String CLEARING_SYSTEM;
    public final String LOCAL_INSTRUMENT;
    public final String SERVICE_LEVEL;
    public final String CORRESPONDENT;
    public final String INTERMEDIARY_INSTITUTION;
    public final String REFERENCE;
    public final String SINGLE_BOOKING;
    public final String TEXT;
    public final String TYPE;
    public final String INSTRUCTION_CODE;
    public final String INSTRUCTION_CODES;
    public final String RECIPIENT_ACCOUNT;
    public final String ORIGINATOR_ACCOUNT;
    public final String PAYER_ACCOUNT;
    public final String PAYER_ACCOUNT_LONG;
    public final String PAYEE_ACCOUNT;
    public final String NAME;
    public final String DISPLAY_NAME;
    public final String DESCRIPTION;
    public final String ERROR;
    public final String UNKNOWN_ERROR;
    public final String ERROR_CODE;
    public final String ERROR_CODES;
    public final String DESCRIPTION_ERROR_CODES;
    public final String COMPANY_NAME;
    public final String USER;
    public final String USER_ID;
    public final String USER_PROFILE;
    public final String USER_PROFILE_AT_BANK;
    public final String ADMINISTRATOR;
    public final String BANK;
    public final String BANK_ACCESS;
    public final String BANK_CONNECTION;
    public final String SCHEME;
    public final String RECEIVING_INSTITUTE;
    public final String SENDING_INSTITUTE;
    public final String FILE_TYPE;
    public final String FILE;
    public final String FILE_NAME;
    public final String FILE_SIZE;
    public final String FILE_DOES_NOT_EXIST;
    public final String FILE_ALREADY_EXISTS;
    public final String FILE_ALREADY_EXISTS_TITLE;
    public final String FILE_OVERWRITE_QUESTION;
    public final String FILE_NOT_WRITTEN_MESSAGE;
    public final String FILE_IS_A_DIRECTORY;
    public final String HASH_VALUE;
    public final String NEW_VALUE;
    public final String OLD_VALUE;
    public final String FORMAT;
    public final String BTF;
    public final String BTF_VOP;
    public final String ORDER_TYPE;
    public final String ORDER_TYPE_VOP;
    public final String FETCH_ORDER_TYPE;
    public final String FETCH_FILE_TYPE;
    public final String ORDER_NUMBER;
    public final String ACCOUNT_STATEMENT;
    public final String ACCOUNT_STATEMENTS;
    public final String ADVICE;
    public final String ADVICES;
    public final String BATCHED_TRANSACTION_FILE;
    public final String BATCHED_TRANSACTION_FILES;
    public final String BOOKING_DATE;
    public final String VALUE_DATE;
    public final String COUNTER_VALUE_PAYMENT;
    public final String COUNTER_VALUE_PAYMENT_IN;
    public final String NOTIFICATION;
    public final String NOTIFICATION_TYPE;
    public final String NOTIFICATIONS;
    public final String CREDITOR;
    public final String DRAWEE;
    public final String CREDITOR_ID;
    public final String MANDATE_REFERENCE;
    public final String MANDATE_SIGN_DATE;
    public final String SIGN_DATE;
    public final String DEBIT_TYPE;
    public final String SEQUENCE_TYPE;
    public final String MESSAGE_ID;
    public final String UNAMBIGUOUS_REFERENCE;
    public final String COLLECTOR_REFERENCE;
    public final String END_TO_END_REFERENCE;
    public final String TRANSACTION_REFERENCE;
    public final String STATE;
    public final String STATUS;
    public final String STATUS_CODE;
    public final String BOOKED;
    public final String PENDING;
    public final String REASON;
    public final String REASONS;
    public final String DISPLAY_PAYMENT_DETAILS;
    public final String DISPLAY_REJECTED_PAYMENTS;
    public final String WRONG_CONTROL_SUM;
    public final String WRONG_NUMBER_OF_PAYMENTS;
    public final String RECIPIENT_NATIONAL_ID;
    public final String ORDER;
    public final String ORDERS;
    public final String ORDER_REQUEST_FAILED;
    public final String ORDER_REQUEST_FAILED_EXPLANATION;
    public final String PAYMENT;
    public final String PAYMENTS;
    public final String FOREIGN_PAYMENT;
    public final String INTERNATIONAL_TRANSFER;
    public final String PASSWORD;
    public final String DS_PASSWORD;
    public final String LOGIN_PASSWORD;
    public final String ONE_TIME_PASSWORD;
    public final String PDF_STATEMENTS;
    public final String SIGN;
    public final String SIGNATURE_CLASS;
    public final String SIGNATURE_WITH_TYPE_ON;
    public final String SIGNED_ON;
    public final String SIGNER;
    public final String ACCEPTING_TIME;
    public final String SENDING_TIME;
    public final String SEND;
    public final String SUBMISSION_TIME;
    public final String SUBMIT;
    public final String SUBMITTER;
    public final String SUBMITTED_ON;
    public final String SIZE;
    public final String PERMISSION;
    public final String PERMISSIONS;
    public final String NO_PERMISSION;
    public final String YOU_HAVE_NO_PERM_FOR_THIS_PAGE;
    public final String YOU_HAVE_NO_PERM_FOR_THIS_VIEW;
    public final String YOU_HAVE_NO_PERM_FOR_THIS_ACTION;
    public final String ORDER_DATA;
    public final String DATA_OF_ORDER;
    public final String DETAILS_FOR;
    public final String ORDER_DATA_AND_TICKET;
    public final String TICKET;
    public final String ORDER_DATA_CHECK;
    public final String ORDER_DATA_ADDITIONAL_INFO;
    public final String ORDER_DATA_ADDITIONAL_INFO_FROM_SUBMITTER;
    public final String ORDER_DATA_ADDITIONAL_INFO_DESCRIPTION;
    public final String ORDER_DATA_ADDITIONAL_INFO_DESCRIPTION_DEBIT;
    public final String ORDER_NAME_ORDER;
    public final String ORDER_NAME_TRANSFER_ORDER;
    public final String ORDER_NAME_DEBIT_ORDER;
    public final String ORDER_NAME_CANCELLATION_ORDER;
    public final String ORDER_NAME_CONTAINER_TRANSFER_ORDER;
    public final String ORDER_NAME_CONTAINER_DEBIT_ORDER;
    public final String ORDER_NAME_INSTANT_PAYMENT_ORDER;
    public final String ORDER_NAME_EXPRESS_PAYMENT_ORDER;
    public final String ORDER_NAME_FOREIGN_TRANSFER_ORDER;
    public final String ORDER_NAME_FOREIGN_TRANSFER_ORDER_WITHOUT_FORMAT;
    public final String ORDER_NAME_DOMESTIC_TRANSFER_ORDER;
    public final String ORDER_NAME_BASE_DEBIT_ORDER;
    public final String ORDER_NAME_BUSINESS_DEBIT_ORDER;
    public final String LICENSE_NUMBER;
    public final String TABLE;
    public final String TENANT;
    public final String FIELD_CONTAINS_INVALID_CHARACTERS;

    public static GeneralMessages getInstance(Locale locale) {
        GeneralMessages result = INSTANCES.get(locale.getLanguage());
        if (result == null) {
            result = new GeneralMessages(locale);
            INSTANCES.put(locale.getLanguage(), result);
        }
        return result;
    }

    private GeneralMessages(Locale locale) {
        this.IN_ENGLISH = BankingApiMessages.getString(locale, "GeneralMessages.inEnglish", new Object[0]);
        this.Yes = BankingApiMessages.getString(locale, "GeneralMessages.yes", new Object[0]);
        this.No = BankingApiMessages.getString(locale, "GeneralMessages.no", new Object[0]);
        this.and = BankingApiMessages.getString(locale, "GeneralMessages.and", new Object[0]);
        this.or = BankingApiMessages.getString(locale, "GeneralMessages.or", new Object[0]);
        this.from = BankingApiMessages.getString(locale, "GeneralMessages.from", new Object[0]);
        this.to = BankingApiMessages.getString(locale, "GeneralMessages.to", new Object[0]);
        this.equal = BankingApiMessages.getString(locale, "GeneralMessages.equal", new Object[0]);
        this.unequal = BankingApiMessages.getString(locale, "GeneralMessages.unequal", new Object[0]);
        this.NEW = BankingApiMessages.getString(locale, "GeneralMessages.new", new Object[0]);
        this.CANCEL = BankingApiMessages.getString(locale, "GeneralMessages.cancel", new Object[0]);
        this.CANCELLED_ON = BankingApiMessages.getString(locale, "GeneralMessages.cancelledOn", new Object[0]);
        this.CHECK = BankingApiMessages.getString(locale, "GeneralMessages.check", new Object[0]);
        this.CONFIRM = BankingApiMessages.getString(locale, "GeneralMessages.confirm", new Object[0]);
        this.CONFIRM_CREATION = BankingApiMessages.getString(locale, "GeneralMessages.confirmCreation", new Object[0]);
        this.CONFIRM_MODIFICATION = BankingApiMessages.getString(locale, "GeneralMessages.confirmModification", new Object[0]);
        this.DELETE = BankingApiMessages.getString(locale, "GeneralMessages.delete", new Object[0]);
        this.ENTER = BankingApiMessages.getString(locale, "GeneralMessages.enter", new Object[0]);
        this.DISCARD_CREATION = BankingApiMessages.getString(locale, "GeneralMessages.discardCreation", new Object[0]);
        this.DISCARD_MODIFICATION = BankingApiMessages.getString(locale, "GeneralMessages.discardModification", new Object[0]);
        this.MODIFY = BankingApiMessages.getString(locale, "GeneralMessages.modify", new Object[0]);
        this.ACTIVATE = BankingApiMessages.getString(locale, "GeneralMessages.activate", new Object[0]);
        this.DEACTIVATE = BankingApiMessages.getString(locale, "GeneralMessages.deactivate", new Object[0]);
        this.RESET = BankingApiMessages.getString(locale, "GeneralMessages.reset", new Object[0]);
        this.LOCK = BankingApiMessages.getString(locale, "GeneralMessages.lock", new Object[0]);
        this.UNLOCK = BankingApiMessages.getString(locale, "GeneralMessages.unlock", new Object[0]);
        this.CALCULATE = BankingApiMessages.getString(locale, "GeneralMessages.calculate", new Object[0]);
        this.DETERMINE = BankingApiMessages.getString(locale, "GeneralMessages.determine", new Object[0]);
        this.DISPLAY = BankingApiMessages.getString(locale, "GeneralMessages.display", new Object[0]);
        this.UPDATE = BankingApiMessages.getString(locale, "GeneralMessages.update", new Object[0]);
        this.PRINT = BankingApiMessages.getString(locale, "GeneralMessages.print", new Object[0]);
        this.PRINT_OVERVIEW = BankingApiMessages.getString(locale, "GeneralMessages.printOverview", new Object[0]);
        this.EXPORT = BankingApiMessages.getString(locale, "GeneralMessages.export", new Object[0]);
        this.EXPORT_OVERVIEW = BankingApiMessages.getString(locale, "GeneralMessages.exportOverview", new Object[0]);
        this.BROWSE = BankingApiMessages.getString(locale, "GeneralMessages.browse", new Object[0]);
        this.REMEMBER_DECISION = BankingApiMessages.getString(locale, "GeneralMessages.rememberDecision", new Object[0]);
        this.DO_NOT_SHOW_AGAIN = BankingApiMessages.getString(locale, "GeneralMessages.doNotShowAgain", new Object[0]);
        this.SEQUENTIAL_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.sequentialNumber", new Object[0]);
        this.REFERENCE_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.referenceNumber", new Object[0]);
        this.ACCOUNT_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.accountNumber", new Object[0]);
        this.IBAN = BankingApiMessages.getString(locale, "GeneralMessages.iban", new Object[0]);
        this.IBAN_RIB = BankingApiMessages.getString(locale, "GeneralMessages.ibanRib", new Object[0]);
        this.IBAN_ACCOUNT_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.ibanAccountNumber", new Object[0]);
        this.ACCOUNT_NUMBER_IBAN = BankingApiMessages.getString(locale, "GeneralMessages.accountNumberIban", new Object[0]);
        this.BANK_CODE = BankingApiMessages.getString(locale, "GeneralMessages.bankCode", new Object[0]);
        this.BIC = BankingApiMessages.getString(locale, "GeneralMessages.bic", new Object[0]);
        this.BANK_CODE_BIC = BankingApiMessages.getString(locale, "GeneralMessages.bankCodeBic", new Object[0]);
        this.BIC_BLZ = BankingApiMessages.getString(locale, "GeneralMessages.bicBlz", new Object[0]);
        this.BLZ = BankingApiMessages.getString(locale, "GeneralMessages.blz", new Object[0]);
        this.BANKLEITZAHL = BankingApiMessages.getString(locale, "GeneralMessages.bankleitzahl", new Object[0]);
        this.BRANCH_CODE = BankingApiMessages.getString(locale, "GeneralMessages.branchCode", new Object[0]);
        this.LEI = BankingApiMessages.getString(locale, "GeneralMessages.lei", new Object[0]);
        this.CONTROL_KEY = BankingApiMessages.getString(locale, "GeneralMessages.controlKey", new Object[0]);
        this.CURRENCY = BankingApiMessages.getString(locale, "GeneralMessages.currency", new Object[0]);
        this.COUNTER_VALUE_CURRENCY = BankingApiMessages.getString(locale, "GeneralMessages.counterValueCurrency", new Object[0]);
        this.CUSTOMER_ID = BankingApiMessages.getString(locale, "GeneralMessages.customerID", new Object[0]);
        this.HOST_ID = BankingApiMessages.getString(locale, "GeneralMessages.hostID", new Object[0]);
        this.URL = BankingApiMessages.getString(locale, "GeneralMessages.url", new Object[0]);
        this.CUSTOMER_PROTOCOL = BankingApiMessages.getString(locale, "GeneralMessages.customerProtocol", new Object[0]);
        this.ADDRESS = BankingApiMessages.getString(locale, "GeneralMessages.address", new Object[0]);
        this.BANK_ADDRESS = BankingApiMessages.getString(locale, "GeneralMessages.bankAddress", new Object[0]);
        this.BANK_NAME = BankingApiMessages.getString(locale, "GeneralMessages.bankName", new Object[0]);
        this.STREET = BankingApiMessages.getString(locale, "GeneralMessages.street", new Object[0]);
        this.PLACE = BankingApiMessages.getString(locale, "GeneralMessages.city", new Object[0]);
        this.COUNTRY = BankingApiMessages.getString(locale, "GeneralMessages.country", new Object[0]);
        this.COUNTRY_CODE = BankingApiMessages.getString(locale, "GeneralMessages.countryCode", new Object[0]);
        this.ACCOUNT = BankingApiMessages.getString(locale, "GeneralMessages.account", new Object[0]);
        this.ACCOUNTS = BankingApiMessages.getString(locale, "GeneralMessages.accounts", new Object[0]);
        this.ACCOUNT_CURRENCY = BankingApiMessages.getString(locale, "GeneralMessages.accountCurrency", new Object[0]);
        this.ACCOUNT_FILTER = BankingApiMessages.getString(locale, "Filter.accounts.title", new Object[0]);
        this.ACCOUNT_OWNER = BankingApiMessages.getString(locale, "GeneralMessages.accountOwner", new Object[0]);
        this.DEFAULT_ACCOUNT = BankingApiMessages.getString(locale, "GeneralMessages.defaultAccount", new Object[0]);
        this.AMOUNT = BankingApiMessages.getString(locale, "GeneralMessages.amount", new Object[0]);
        this.AMOUNT_IN_ACCOUNT_CURRENCY = BankingApiMessages.getString(locale, "GeneralMessages.amountInAccountCurrency", new Object[0]);
        this.ORIGINAL_AMOUNT = BankingApiMessages.getString(locale, "GeneralMessages.originalAmount", new Object[0]);
        this.EXCHANGE_RATE = BankingApiMessages.getString(locale, "GeneralMessages.exchangeRate", new Object[0]);
        this.BALANCE = BankingApiMessages.getString(locale, "GeneralMessages.balance", new Object[0]);
        this.DATE = BankingApiMessages.getString(locale, "GeneralMessages.date", new Object[0]);
        this.EXECUTION_DATE = BankingApiMessages.getString(locale, "GeneralMessages.executionDate", new Object[0]);
        this.EXECUTION_TIME = BankingApiMessages.getString(locale, "GeneralMessages.executionTime", new Object[0]);
        this.PAYMENT_DATE = BankingApiMessages.getString(locale, "GeneralMessages.paymentDate", new Object[0]);
        this.EXPIRATION_DATE = BankingApiMessages.getString(locale, "GeneralMessages.expirationDate", new Object[0]);
        this.TIME = BankingApiMessages.getString(locale, "GeneralMessages.time", new Object[0]);
        this.TIME_OF_DAY = BankingApiMessages.getString(locale, "GeneralMessages.timeOfDay", new Object[0]);
        this.DATE_FORMAT = BankingApiMessages.getString(locale, "GeneralMessages.dateFormat", new Object[0]);
        this.NUMBER_FORMAT = BankingApiMessages.getString(locale, "GeneralMessages.numberFormat", new Object[0]);
        this.EXAMPLE = BankingApiMessages.getString(locale, "GeneralMessages.example", new Object[0]);
        this.CREATION_DATE = BankingApiMessages.getString(locale, "GeneralMessages.creationDate", new Object[0]);
        this.CREATION_TIME = BankingApiMessages.getString(locale, "GeneralMessages.creationTime", new Object[0]);
        this.LAST_FETCH = BankingApiMessages.getString(locale, "GeneralMessages.lastFetch", new Object[0]);
        this.LAST_UPDATE = BankingApiMessages.getString(locale, "GeneralMessages.lastUpdate", new Object[0]);
        this.PAYMENT_CATEGORY = BankingApiMessages.getString(locale, "GeneralMessages.paymentCategory", new Object[0]);
        this.PAYMENT_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.paymentMethod", new Object[0]);
        this.REGULATORY_INFORMATION = BankingApiMessages.getString(locale, "GeneralMessages.regulatoryInformation", new Object[0]);
        this.PRIORITY = BankingApiMessages.getString(locale, "GeneralMessages.priority", new Object[0]);
        this.CHARGE = BankingApiMessages.getString(locale, "GeneralMessages.charge", new Object[0]);
        this.CHARGES = BankingApiMessages.getString(locale, "GeneralMessages.charges", new Object[0]);
        this.TOTAL_CHARGES = BankingApiMessages.getString(locale, "GeneralMessages.totalCharges", new Object[0]);
        this.FEE_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.feeType", new Object[0]);
        this.CHEQUE_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.chequeType", new Object[0]);
        this.DELIVERY_METHOD = BankingApiMessages.getString(locale, "GeneralMessages.deliveryMethod", new Object[0]);
        this.ADDITIONAL_INFORMATION = BankingApiMessages.getString(locale, "GeneralMessages.additionalInformation", new Object[0]);
        this.ADDITIONAL_INFORMATION_SINGULAR = BankingApiMessages.getString(locale, "GeneralMessages.additionalInformationSingular", new Object[0]);
        this.PURPOSE = BankingApiMessages.getString(locale, "GeneralMessages.purpose", new Object[0]);
        this.CREDITOR_REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.creditorReference", new Object[0]);
        this.ESR_PARTICIPANT_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.esrParticipantNumber", new Object[0]);
        this.ESR_REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.esrReference", new Object[0]);
        this.QR_REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.qrReference", new Object[0]);
        this.ORIGINATOR = BankingApiMessages.getString(locale, "GeneralMessages.originator", new Object[0]);
        this.RECIPIENT = BankingApiMessages.getString(locale, "GeneralMessages.recipient", new Object[0]);
        this.PAYEE = BankingApiMessages.getString(locale, "GeneralMessages.payee", new Object[0]);
        this.PAYER = BankingApiMessages.getString(locale, "GeneralMessages.payer", new Object[0]);
        this.ORIGINAL_ORIGINATOR = BankingApiMessages.getString(locale, "GeneralMessages.originalOriginator", new Object[0]);
        this.ORIGINAL_RECIPIENT = BankingApiMessages.getString(locale, "GeneralMessages.originalRecipient", new Object[0]);
        this.ORIGINAL_PAYEE = BankingApiMessages.getString(locale, "GeneralMessages.originalPayee", new Object[0]);
        this.ORIGINAL_PAYER = BankingApiMessages.getString(locale, "GeneralMessages.originalPayer", new Object[0]);
        this.ULTIMATE_ORIGINATOR = BankingApiMessages.getString(locale, "GeneralMessages.ultimateOriginator", new Object[0]);
        this.ULTIMATE_RECIPIENT = BankingApiMessages.getString(locale, "GeneralMessages.ultimateRecipient", new Object[0]);
        this.ULTIMATE_PAYEE = BankingApiMessages.getString(locale, "GeneralMessages.ultimatePayee", new Object[0]);
        this.ULTIMATE_PAYER = BankingApiMessages.getString(locale, "GeneralMessages.ultimatePayer", new Object[0]);
        this.ORIGINATOR_ACC_NO = BankingApiMessages.getString(locale, "GeneralMessages.originatorAccNo", new Object[0]);
        this.ORIGINATOR_ACCOUNT_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.originatorAccountNumber", new Object[0]);
        this.ORIGINATOR_IBAN = BankingApiMessages.getString(locale, "GeneralMessages.originatorIban", new Object[0]);
        this.ORIGINATOR_BANK_CODE = BankingApiMessages.getString(locale, "GeneralMessages.originatorBankCode", new Object[0]);
        this.ORIGINATOR_BIC = BankingApiMessages.getString(locale, "GeneralMessages.originatorBic", new Object[0]);
        this.ORIGINATOR_BLZ = BankingApiMessages.getString(locale, "GeneralMessages.originatorBlz", new Object[0]);
        this.ORIGINATOR_COUNTRY = BankingApiMessages.getString(locale, "GeneralMessages.originatorCountry", new Object[0]);
        this.ORIGINATOR_COUNTRY_CODE = BankingApiMessages.getString(locale, "GeneralMessages.originatorCountryCode", new Object[0]);
        this.RECIPIENT_ACC_NO = BankingApiMessages.getString(locale, "GeneralMessages.recipientAccNo", new Object[0]);
        this.RECIPIENT_ACCOUNT_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.recipientAccountNumber", new Object[0]);
        this.RECIPIENT_IBAN = BankingApiMessages.getString(locale, "GeneralMessages.recipientIban", new Object[0]);
        this.RECIPIENT_BANK = BankingApiMessages.getString(locale, "GeneralMessages.recipientBank", new Object[0]);
        this.RECIPIENT_BANK_CODE = BankingApiMessages.getString(locale, "GeneralMessages.recipientBankCode", new Object[0]);
        this.RECIPIENT_BANK_COUNTRY = BankingApiMessages.getString(locale, "GeneralMessages.recipientBankCountry", new Object[0]);
        this.RECIPIENT_BIC = BankingApiMessages.getString(locale, "GeneralMessages.recipientBic", new Object[0]);
        this.RECIPIENT_COUNTRY = BankingApiMessages.getString(locale, "GeneralMessages.recipientCountry", new Object[0]);
        this.RECIPIENT_COUNTRY_CODE = BankingApiMessages.getString(locale, "GeneralMessages.recipientCountryCode", new Object[0]);
        this.PAYER_ACC_NO = BankingApiMessages.getString(locale, "GeneralMessages.payerAccNo", new Object[0]);
        this.PAYER_ACCOUNT_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.payerAccountNumber", new Object[0]);
        this.PAYER_IBAN = BankingApiMessages.getString(locale, "GeneralMessages.payerIban", new Object[0]);
        this.PAYER_BANK_CODE = BankingApiMessages.getString(locale, "GeneralMessages.payerBankCode", new Object[0]);
        this.PAYER_BIC = BankingApiMessages.getString(locale, "GeneralMessages.payerBic", new Object[0]);
        this.PAYER_STREET = BankingApiMessages.getString(locale, "GeneralMessages.payerStreet", new Object[0]);
        this.PAYER_PLACE = BankingApiMessages.getString(locale, "GeneralMessages.payerPlace", new Object[0]);
        this.PAYER_COUNTRY = BankingApiMessages.getString(locale, "GeneralMessages.payerCountry", new Object[0]);
        this.PAYER_COUNTRY_CODE = BankingApiMessages.getString(locale, "GeneralMessages.payerCountryCode", new Object[0]);
        this.PAYEE_ACC_NO = BankingApiMessages.getString(locale, "GeneralMessages.payeeAccNo", new Object[0]);
        this.PAYEE_ACCOUNT_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.payeeAccountNumber", new Object[0]);
        this.PAYEE_IBAN = BankingApiMessages.getString(locale, "GeneralMessages.payeeIban", new Object[0]);
        this.PAYEE_BANK_CODE = BankingApiMessages.getString(locale, "GeneralMessages.payeeBankCode", new Object[0]);
        this.PAYEE_BIC = BankingApiMessages.getString(locale, "GeneralMessages.payeeBic", new Object[0]);
        this.PAYMENT = BankingApiMessages.getString(locale, "GeneralMessages.payment", new Object[0]);
        this.PAYMENTS = BankingApiMessages.getString(locale, "GeneralMessages.payments", new Object[0]);
        this.FOREIGN_PAYMENT = BankingApiMessages.getString(locale, "GeneralMessages.foreignPayment", new Object[0]);
        this.INTERNATIONAL_TRANSFER = BankingApiMessages.getString(locale, "GeneralMessages.internationalTransfer", new Object[0]);
        this.CLEARING_SYSTEM = BankingApiMessages.getString(locale, "GeneralMessages.clearingSystem", new Object[0]);
        this.LOCAL_INSTRUMENT = BankingApiMessages.getString(locale, "GeneralMessages.localInstrument", new Object[0]);
        this.SERVICE_LEVEL = BankingApiMessages.getString(locale, "GeneralMessages.serviceLevel", new Object[0]);
        this.CODE = BankingApiMessages.getString(locale, "GeneralMessages.code", new Object[0]);
        this.CORRESPONDENT = BankingApiMessages.getString(locale, "GeneralMessages.correspondent", new Object[0]);
        this.INTERMEDIARY_INSTITUTION = BankingApiMessages.getString(locale, "GeneralMessages.intermediaryInstitution", new Object[0]);
        this.REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.reference", new Object[0]);
        this.SINGLE_BOOKING = BankingApiMessages.getString(locale, "GeneralMessages.singleBooking", new Object[0]);
        this.TEXT = BankingApiMessages.getString(locale, "GeneralMessages.text", new Object[0]);
        this.TYPE = BankingApiMessages.getString(locale, "GeneralMessages.type", new Object[0]);
        this.INSTRUCTION_CODE = BankingApiMessages.getString(locale, "GeneralMessages.instructionCode", new Object[0]);
        this.INSTRUCTION_CODES = BankingApiMessages.getString(locale, "GeneralMessages.instructionCodes", new Object[0]);
        this.RECIPIENT_ACCOUNT = BankingApiMessages.getString(locale, "GeneralMessages.recipientAccount", new Object[0]);
        this.ORIGINATOR_ACCOUNT = BankingApiMessages.getString(locale, "GeneralMessages.originatorAccount", new Object[0]);
        this.PAYER_ACCOUNT = BankingApiMessages.getString(locale, "GeneralMessages.payerAccount", new Object[0]);
        this.PAYER_ACCOUNT_LONG = BankingApiMessages.getString(locale, "GeneralMessages.payerAccountLong", new Object[0]);
        this.PAYEE_ACCOUNT = BankingApiMessages.getString(locale, "GeneralMessages.payeeAccount", new Object[0]);
        this.NAME = BankingApiMessages.getString(locale, "GeneralMessages.name", new Object[0]);
        this.DISPLAY_NAME = BankingApiMessages.getString(locale, "GeneralMessages.displayName", new Object[0]);
        this.DESCRIPTION = BankingApiMessages.getString(locale, "GeneralMessages.description", new Object[0]);
        this.ERROR = BankingApiMessages.getString(locale, "GeneralMessages.error", new Object[0]);
        this.UNKNOWN_ERROR = BankingApiMessages.getString(locale, "GeneralMessages.unknownError", new Object[0]);
        this.ERROR_CODE = BankingApiMessages.getString(locale, "GeneralMessages.errorCode", new Object[0]);
        this.ERROR_CODES = BankingApiMessages.getString(locale, "GeneralMessages.errorCodes", new Object[0]);
        this.DESCRIPTION_ERROR_CODES = BankingApiMessages.getString(locale, "GeneralMessages.descriptionErrorCodes", new Object[0]);
        this.COMPANY_NAME = BankingApiMessages.getString(locale, "GeneralMessages.companyName", new Object[0]);
        this.USER = BankingApiMessages.getString(locale, "GeneralMessages.user", new Object[0]);
        this.USER_ID = BankingApiMessages.getString(locale, "GeneralMessages.userID", new Object[0]);
        this.USER_PROFILE = BankingApiMessages.getString(locale, "GeneralMessages.userProfile", new Object[0]);
        this.USER_PROFILE_AT_BANK = BankingApiMessages.getString(locale, "GeneralMessages.userProfileAtBank", new Object[0]);
        this.ADMINISTRATOR = BankingApiMessages.getString(locale, "GeneralMessages.administrator", new Object[0]);
        this.BANK = BankingApiMessages.getString(locale, "GeneralMessages.bank", new Object[0]);
        this.BANK_ACCESS = BankingApiMessages.getString(locale, "GeneralMessages.bankAccess", new Object[0]);
        this.BANK_CONNECTION = BankingApiMessages.getString(locale, "GeneralMessages.bankConnection", new Object[0]);
        this.RECEIVING_INSTITUTE = BankingApiMessages.getString(locale, "GeneralMessages.receivingInstitute", new Object[0]);
        this.SENDING_INSTITUTE = BankingApiMessages.getString(locale, "GeneralMessages.sendingInstitute", new Object[0]);
        this.FILE_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.fileType", new Object[0]);
        this.FILE = BankingApiMessages.getString(locale, "GeneralMessages.file", new Object[0]);
        this.FILE_NAME = BankingApiMessages.getString(locale, "GeneralMessages.fileName", new Object[0]);
        this.FILE_SIZE = BankingApiMessages.getString(locale, "GeneralMessages.fileSize", new Object[0]);
        this.FILE_DOES_NOT_EXIST = BankingApiMessages.getString(locale, "GeneralMessages.fileDoesNotExist", new Object[0]);
        this.FILE_ALREADY_EXISTS = BankingApiMessages.getString(locale, "GeneralMessages.fileAlreadyExists", new Object[0]);
        this.FILE_ALREADY_EXISTS_TITLE = BankingApiMessages.getString(locale, "GeneralMessages.fileAlreadyExistsTitle", new Object[0]);
        this.FILE_OVERWRITE_QUESTION = BankingApiMessages.getString(locale, "GeneralMessages.fileOverwriteQuestion", new Object[0]);
        this.FILE_NOT_WRITTEN_MESSAGE = BankingApiMessages.getString(locale, "GeneralMessages.fileNotWrittenMessage", new Object[0]);
        this.FILE_IS_A_DIRECTORY = BankingApiMessages.getString(locale, "GeneralMessages.fileIsADirectory", new Object[0]);
        this.HASH_VALUE = BankingApiMessages.getString(locale, "GeneralMessages.hashValue", new Object[0]);
        this.NEW_VALUE = BankingApiMessages.getString(locale, "GeneralMessages.newValue", new Object[0]);
        this.OLD_VALUE = BankingApiMessages.getString(locale, "GeneralMessages.oldValue", new Object[0]);
        this.FORMAT = BankingApiMessages.getString(locale, "GeneralMessages.format", new Object[0]);
        this.BTF = BankingApiMessages.getString(locale, "GeneralMessages.btf", new Object[0]);
        this.BTF_VOP = BankingApiMessages.getString(locale, "GeneralMessages.btfVop", new Object[0]);
        this.ORDER_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.orderType", new Object[0]);
        this.ORDER_TYPE_VOP = BankingApiMessages.getString(locale, "GeneralMessages.orderTypeVop", new Object[0]);
        this.FETCH_ORDER_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.fetchOrderType", new Object[0]);
        this.FETCH_FILE_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.fetchFileType", new Object[0]);
        this.ORDER_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.orderNumber", new Object[0]);
        this.ACCOUNT_STATEMENT = BankingApiMessages.getString(locale, "GeneralMessages.accountStatement", new Object[0]);
        this.ACCOUNT_STATEMENTS = BankingApiMessages.getString(locale, "GeneralMessages.accountStatements", new Object[0]);
        this.ADVICE = BankingApiMessages.getString(locale, "GeneralMessages.advice", new Object[0]);
        this.ADVICES = BankingApiMessages.getString(locale, "GeneralMessages.advices", new Object[0]);
        this.BATCHED_TRANSACTION_FILE = BankingApiMessages.getString(locale, "GeneralMessages.batchedTransactionFile", new Object[0]);
        this.BATCHED_TRANSACTION_FILES = BankingApiMessages.getString(locale, "GeneralMessages.batchedTransactionFiles", new Object[0]);
        this.BOOKING_DATE = BankingApiMessages.getString(locale, "GeneralMessages.bookingDate", new Object[0]);
        this.VALUE_DATE = BankingApiMessages.getString(locale, "GeneralMessages.valueDate", new Object[0]);
        this.COUNTER_VALUE_PAYMENT = BankingApiMessages.getString(locale, "GeneralMessages.counterValuePayment", new Object[0]);
        this.COUNTER_VALUE_PAYMENT_IN = BankingApiMessages.getString(locale, "GeneralMessages.counterValuePaymentIn", new Object[0]);
        this.NOTIFICATION = BankingApiMessages.getString(locale, "GeneralMessages.notification", new Object[0]);
        this.NOTIFICATION_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.notificationType", new Object[0]);
        this.NOTIFICATIONS = BankingApiMessages.getString(locale, "GeneralMessages.notifications", new Object[0]);
        this.CREDITOR = BankingApiMessages.getString(locale, "GeneralMessages.creditor", new Object[0]);
        this.DRAWEE = BankingApiMessages.getString(locale, "GeneralMessages.drawee", new Object[0]);
        this.CREDITOR_ID = BankingApiMessages.getString(locale, "GeneralMessages.creditorId", new Object[0]);
        this.MANDATE_REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.mandateReference", new Object[0]);
        this.MANDATE_SIGN_DATE = BankingApiMessages.getString(locale, "GeneralMessages.mandateSignDate", new Object[0]);
        this.SIGN_DATE = BankingApiMessages.getString(locale, "GeneralMessages.signDate", new Object[0]);
        this.DEBIT_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.debitType", new Object[0]);
        this.SEQUENCE_TYPE = BankingApiMessages.getString(locale, "GeneralMessages.sequenceType", new Object[0]);
        this.MESSAGE_ID = BankingApiMessages.getString(locale, "GeneralMessages.messageId", new Object[0]);
        this.UNAMBIGUOUS_REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.unambiguousReference", new Object[0]);
        this.COLLECTOR_REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.collectorReference", new Object[0]);
        this.END_TO_END_REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.endToEndReference", new Object[0]);
        this.TRANSACTION_REFERENCE = BankingApiMessages.getString(locale, "GeneralMessages.transactionReference", new Object[0]);
        this.STATE = BankingApiMessages.getString(locale, "GeneralMessages.state", new Object[0]);
        this.STATUS = BankingApiMessages.getString(locale, "GeneralMessages.status", new Object[0]);
        this.STATUS_CODE = BankingApiMessages.getString(locale, "GeneralMessages.statusCode", new Object[0]);
        this.BOOKED = BankingApiMessages.getString(locale, "GeneralMessages.booked", new Object[0]);
        this.PENDING = BankingApiMessages.getString(locale, "GeneralMessages.pending", new Object[0]);
        this.REASON = BankingApiMessages.getString(locale, "GeneralMessages.reason", new Object[0]);
        this.REASONS = BankingApiMessages.getString(locale, "GeneralMessages.reasons", new Object[0]);
        this.DISPLAY_PAYMENT_DETAILS = BankingApiMessages.getString(locale, "GeneralMessages.displayPaymentDetails", new Object[0]);
        this.DISPLAY_REJECTED_PAYMENTS = BankingApiMessages.getString(locale, "GeneralMessages.displayRejectedPayments", new Object[0]);
        this.WRONG_CONTROL_SUM = BankingApiMessages.getString(locale, "GeneralMessages.wrongControlSum", new Object[0]);
        this.WRONG_NUMBER_OF_PAYMENTS = BankingApiMessages.getString(locale, "GeneralMessages.wrongNumberOfPayments", new Object[0]);
        this.RECIPIENT_NATIONAL_ID = BankingApiMessages.getString(locale, "GeneralMessages.recipientNationalId", new Object[0]);
        this.ORDER = BankingApiMessages.getString(locale, "GeneralMessages.order", new Object[0]);
        this.ORDERS = BankingApiMessages.getString(locale, "GeneralMessages.orders", new Object[0]);
        this.ORDER_REQUEST_FAILED = BankingApiMessages.getString(locale, "GeneralMessages.orderRequestFailed", new Object[0]);
        this.ORDER_REQUEST_FAILED_EXPLANATION = BankingApiMessages.getString(locale, "GeneralMessages.orderRequestFailedExplanation", new Object[0]);
        this.SCHEME = BankingApiMessages.getString(locale, "GeneralMessages.scheme", new Object[0]);
        this.PASSWORD = BankingApiMessages.getString(locale, "GeneralMessages.password", new Object[0]);
        this.DS_PASSWORD = BankingApiMessages.getString(locale, "GeneralMessages.dsPassword", new Object[0]);
        this.LOGIN_PASSWORD = BankingApiMessages.getString(locale, "GeneralMessages.loginPassword", new Object[0]);
        this.ONE_TIME_PASSWORD = BankingApiMessages.getString(locale, "GeneralMessages.oneTimePassword", new Object[0]);
        this.PDF_STATEMENTS = BankingApiMessages.getString(locale, "GeneralMessages.pdfStatements", new Object[0]);
        this.SIZE = BankingApiMessages.getString(locale, "GeneralMessages.size", new Object[0]);
        this.SIGNATURE_CLASS = BankingApiMessages.getString(locale, "GeneralMessages.signatureClass", new Object[0]);
        this.SIGNATURE_WITH_TYPE_ON = BankingApiMessages.getString(locale, "GeneralMessages.signatureWithTypeOn", new Object[0]);
        this.SIGN = BankingApiMessages.getString(locale, "GeneralMessages.sign", new Object[0]);
        this.SIGNED_ON = BankingApiMessages.getString(locale, "GeneralMessages.signedOn", new Object[0]);
        this.SIGNER = BankingApiMessages.getString(locale, "GeneralMessages.signer", new Object[0]);
        this.ACCEPTING_TIME = BankingApiMessages.getString(locale, "GeneralMessages.acceptingTime", new Object[0]);
        this.SENDING_TIME = BankingApiMessages.getString(locale, "GeneralMessages.sendingTime", new Object[0]);
        this.SEND = BankingApiMessages.getString(locale, "GeneralMessages.send", new Object[0]);
        this.SUBMISSION_TIME = BankingApiMessages.getString(locale, "GeneralMessages.submissionTime", new Object[0]);
        this.SUBMIT = BankingApiMessages.getString(locale, "GeneralMessages.submit", new Object[0]);
        this.SUBMITTED_ON = BankingApiMessages.getString(locale, "GeneralMessages.submittedOn", new Object[0]);
        this.SUBMITTER = BankingApiMessages.getString(locale, "GeneralMessages.submitter", new Object[0]);
        this.PERMISSION = BankingApiMessages.getString(locale, "GeneralMessages.permission", new Object[0]);
        this.PERMISSIONS = BankingApiMessages.getString(locale, "GeneralMessages.permissions", new Object[0]);
        this.NO_PERMISSION = BankingApiMessages.getString(locale, "GeneralMessages.noPermission", new Object[0]);
        this.YOU_HAVE_NO_PERM_FOR_THIS_PAGE = BankingApiMessages.getString(locale, "GeneralMessages.youHaveNoPermissionForThisPage", new Object[0]);
        this.YOU_HAVE_NO_PERM_FOR_THIS_VIEW = BankingApiMessages.getString(locale, "GeneralMessages.youHaveNoPermissionForThisView", new Object[0]);
        this.YOU_HAVE_NO_PERM_FOR_THIS_ACTION = BankingApiMessages.getString(locale, "GeneralMessages.youHaveNoPermissionForThisAction", new Object[0]);
        this.ORDER_DATA = BankingApiMessages.getString(locale, "GeneralMessages.orderData", new Object[0]);
        this.DATA_OF_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.dataOfOrder", new Object[0]);
        this.DETAILS_FOR = BankingApiMessages.getString(locale, "GeneralMessages.detailsFor", new Object[0]);
        this.ORDER_DATA_AND_TICKET = BankingApiMessages.getString(locale, "GeneralMessages.orderDataAndTicket", new Object[0]);
        this.TICKET = BankingApiMessages.getString(locale, "GeneralMessages.ticket", new Object[0]);
        this.ORDER_DATA_CHECK = BankingApiMessages.getString(locale, "GeneralMessages.orderDataCheck", new Object[0]);
        this.ORDER_DATA_ADDITIONAL_INFO = BankingApiMessages.getString(locale, "GeneralMessages.orderDataAdditionalInfo", new Object[0]);
        this.ORDER_DATA_ADDITIONAL_INFO_FROM_SUBMITTER = BankingApiMessages.getString(locale, "GeneralMessages.orderDataAdditionalInfoFromSubmitter", new Object[0]);
        this.ORDER_DATA_ADDITIONAL_INFO_DESCRIPTION = BankingApiMessages.getString(locale, "GeneralMessages.orderDataAdditionalInfoDescription", new Object[0]);
        this.ORDER_DATA_ADDITIONAL_INFO_DESCRIPTION_DEBIT = BankingApiMessages.getString(locale, "GeneralMessages.orderDataAdditionalInfoDescriptionDebit", new Object[0]);
        this.ORDER_NAME_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.order", new Object[0]);
        this.ORDER_NAME_TRANSFER_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.transferOrder", new Object[0]);
        this.ORDER_NAME_DEBIT_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.debitOrder", new Object[0]);
        this.ORDER_NAME_CANCELLATION_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.cancellationOrder", new Object[0]);
        this.ORDER_NAME_CONTAINER_TRANSFER_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.containerTransferOrder", new Object[0]);
        this.ORDER_NAME_CONTAINER_DEBIT_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.containerDebitOrder", new Object[0]);
        this.ORDER_NAME_INSTANT_PAYMENT_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.instantPaymentOrder", new Object[0]);
        this.ORDER_NAME_EXPRESS_PAYMENT_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.expressPaymentOrder", new Object[0]);
        this.ORDER_NAME_DOMESTIC_TRANSFER_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.domesticTransferOrder", new Object[0]);
        this.ORDER_NAME_FOREIGN_TRANSFER_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.foreignTransferOrder", new Object[0]);
        this.ORDER_NAME_FOREIGN_TRANSFER_ORDER_WITHOUT_FORMAT = BankingApiMessages.getString(locale, "GeneralMessages.orderName.foreignTransferOrderWithoutFormat", new Object[0]);
        this.ORDER_NAME_BASE_DEBIT_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.baseDebitOrder", new Object[0]);
        this.ORDER_NAME_BUSINESS_DEBIT_ORDER = BankingApiMessages.getString(locale, "GeneralMessages.orderName.businessDebitOrder", new Object[0]);
        this.LICENSE_NUMBER = BankingApiMessages.getString(locale, "GeneralMessages.licenseNumber", new Object[0]);
        this.TABLE = BankingApiMessages.getString(locale, "GeneralMessages.table", new Object[0]);
        this.TENANT = BankingApiMessages.getString(locale, "GeneralMessages.tenant", new Object[0]);
        this.FIELD_CONTAINS_INVALID_CHARACTERS = BankingApiMessages.getString(locale, "GeneralMessages.fieldContainsInvalidCharacters", new Object[0]);
    }
}

