/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.util.BLLogger;

public final class FormSettings {
    private final User user;
    private final Form form;
    private final BLLogger logger;

    public FormSettings(User user, Form form, BLLogger logger) {
        this.user = user;
        this.form = form;
        this.logger = logger;
    }

    public String getValue(String key) {
        return this.getValue(key, null);
    }

    public String getValue(String key, String defaultValue) {
        Preference preference = Preference.getPreference(this.user, Preference.ApplicationId.PAYMENTS, this.getPreferenceKey(key));
        if (preference == null || preference.getValue() == null) {
            return defaultValue;
        }
        return preference.getValue();
    }

    public int getValueInt(String key) {
        return this.getValueInt(key, 0);
    }

    public int getValueInt(String key, int defaultValue) {
        String resultString = this.getValue(key, String.valueOf(defaultValue));
        if (resultString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(resultString);
        }
        catch (NumberFormatException e) {
            this.logger.logWarning("Form setting " + key + " contained invalid value!", e);
            return defaultValue;
        }
    }

    public boolean getValueBoolean(String key) {
        return this.getValueBoolean(key, false);
    }

    public boolean getValueBoolean(String key, boolean defaultValue) {
        String resultString = this.getValue(key, String.valueOf(defaultValue));
        if (resultString == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(resultString);
        }
        catch (NumberFormatException e) {
            this.logger.logWarning("Form setting " + key + " contained invalid value!", e);
            return defaultValue;
        }
    }

    public FormSettings setValue(String key, String value) {
        Preference preference = Preference.getPreference(this.user, Preference.ApplicationId.PAYMENTS, this.getPreferenceKey(key));
        if (value == null) {
            if (preference != null) {
                preference.delete();
            }
            return this;
        }
        if (preference == null) {
            preference = new Preference();
            preference.setUser(this.user);
            preference.setApplicationId(Preference.ApplicationId.PAYMENTS);
            preference.setKey(this.getPreferenceKey(key));
        }
        preference.setValue(value);
        preference.save();
        return this;
    }

    public FormSettings setValue(String key, Integer value) {
        if (value == null) {
            return this.setValue(key, (String)null);
        }
        return this.setValue(key, String.valueOf(value));
    }

    public FormSettings setValue(String key, Boolean value) {
        if (value == null) {
            return this.setValue(key, (String)null);
        }
        return this.setValue(key, String.valueOf(value));
    }

    private String getPreferenceKey(String key) {
        return this.form.getId() + "_" + key;
    }

    public static enum Form {
        SEPA_CREDIT_PAYMENT("sepa_cpmt"),
        SEPA_DEBIT_PAYMENT("sepa_dpmt"),
        DTAZV_PAYMENT("dtazv_pmt"),
        MT101_PAYMENT("mt101_pmt");

        private final String id;

        private Form(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

