/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.database.vo.FilterComparator;
import java.util.Locale;

public final class Filter {
    private Filter() {
    }

    public static String getDateComparatorText(FilterComparator.Date comparator, Locale locale) {
        switch (comparator) {
            case BETWEEN: {
                return BankingApiMessages.getString(locale, "Filter.dateComparator.periodFrom", new Object[0]);
            }
            case EQUAL: {
                return GeneralMessages.getInstance((Locale)locale).equal;
            }
            case GREATER: {
                return BankingApiMessages.getString(locale, "Filter.dateComparator.newerThan", new Object[0]);
            }
            case LESS: {
                return BankingApiMessages.getString(locale, "Filter.dateComparator.olderThan", new Object[0]);
            }
        }
        return "";
    }

    public static String getAmountComparatorText(FilterComparator.Amount comparator, Locale locale) {
        switch (comparator) {
            case BETWEEN: {
                return BankingApiMessages.getString(locale, "Filter.amountComparator.between", new Object[0]);
            }
            case EQUAL: {
                return GeneralMessages.getInstance((Locale)locale).equal;
            }
            case GREATER: {
                return BankingApiMessages.getString(locale, "Filter.amountComparator.greaterThan", new Object[0]);
            }
            case LESS: {
                return BankingApiMessages.getString(locale, "Filter.amountComparator.lessThan", new Object[0]);
            }
        }
        return "";
    }

    public static String getPaymentTypeComparatorText(FilterComparator.PaymentType comparator, Locale locale) {
        switch (comparator) {
            case EQUAL: {
                return GeneralMessages.getInstance((Locale)locale).equal;
            }
            case UNEQUAL: {
                return GeneralMessages.getInstance((Locale)locale).unequal;
            }
        }
        return "";
    }

    public static String getTextComparatorText(FilterComparator.Text comparator, Locale locale) {
        switch (comparator) {
            case CONTAINS: {
                return BankingApiMessages.getString(locale, "Filter.textComparator.contains", new Object[0]);
            }
            case CONTAINS_NOT: {
                return BankingApiMessages.getString(locale, "Filter.textComparator.containsnot", new Object[0]);
            }
            case STARTS_WITH: {
                return BankingApiMessages.getString(locale, "Filter.textComparator.startswith", new Object[0]);
            }
            case ENDS_WITH: {
                return BankingApiMessages.getString(locale, "Filter.textComparator.endswith", new Object[0]);
            }
        }
        return "";
    }

    public static boolean hasDateTwoElements(int comparatorIndex) {
        if (comparatorIndex >= 0 && comparatorIndex < FilterComparator.Date.values().length) {
            return FilterComparator.Date.BETWEEN == FilterComparator.Date.values()[comparatorIndex];
        }
        return false;
    }

    public static boolean hasAmountTwoElements(int comparatorIndex) {
        if (comparatorIndex >= 0 && comparatorIndex < FilterComparator.Amount.values().length) {
            return FilterComparator.Amount.BETWEEN == FilterComparator.Amount.values()[comparatorIndex];
        }
        return false;
    }
}

