/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.ebics.client.AustrianBTFTranslator;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.client.SwissBTFTranslator;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;

public class FetchParameterUtil {
    private static final String AT = "AT";
    private static final String CH = "CH";
    private static final String FR = "FR";

    public static StatementType getTypeForFetchParameter(String defaultFetchParameter, String countryCode) {
        StatementType[] allTypes = new StatementType[]{StatementType.mt940Statement, StatementType.mt942Advice, StatementType.camt053Statement, StatementType.camt052Advice, StatementType.camt054, StatementType.camt054CreditAdvice, StatementType.pdfStatement, StatementType.otherPdfDocument, StatementType.pain002ReportSCT, StatementType.pain002ReportSDD, StatementType.pain002ReportSCI, StatementType.camt029Report, StatementType.camt086Report, StatementType.dki, StatementType.cfonb120Statement, StatementType.pain002ReportAXS, StatementType.pain002ReportVOP};
        boolean isEbics30OrNewer = BTFTranslator.isBTFString(defaultFetchParameter);
        for (StatementType st : allTypes) {
            String defaultType = FetchParameterUtil.getDefaultFetchParameter(st, isEbics30OrNewer, countryCode);
            if (!defaultType.equals(defaultFetchParameter)) continue;
            return st;
        }
        return null;
    }

    public static String getDefaultOrderType(StatementType statementType, String countryCode) {
        return FetchParameterUtil.getDefault(statementType, countryCode, true);
    }

    public static String getDefaultBTF(StatementType statementType, String countryCode) {
        return FetchParameterUtil.getDefault(statementType, countryCode, false);
    }

    public static String getDefaultFetchParameter(StatementType statementType, boolean isEbics30OrNewer, String countryCode) {
        return FetchParameterUtil.getDefault(statementType, countryCode, !isEbics30OrNewer);
    }

    private static String getDefault(StatementType statementType, String countryCode, boolean isOrderType) {
        switch (statementType.ordinal()) {
            case 0: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "STA");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "ZK3");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "camt.fin.mt940.stm" : "EOP:GLB_mt940";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 1: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "VMK");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "VMK");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "camt.fin.mt942.rep" : "STM:GLB_mt942";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 2: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "C53");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "Z53");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "camt.053.001.02.stm" : "EOP:GLB_camt.053_ZIP";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 3: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "C52");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "Z52");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "camt.052.001.02.rep" : "STM:GLB_camt.052_ZIP";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 4: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "C54");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "Z54");
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 6: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "BKA");
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 8: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "CRZ");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "Z01");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.002.001.03.psr" : "PSR:FR_pain.002_ZIP ";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 9: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "CDZ");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "CDZ");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.002.001.03.psr" : "PSR:FR_pain.002_ZIP ";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 10: {
                if (AT.equals(countryCode)) {
                    return isOrderType ? "CIZ" : "REP:AT:SCI_pain.002_ZIP";
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.002.001.03.psr" : "PSR:FR_pain.002_ZIP ";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 15: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "AXS");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "AXS");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.002.001.03.psr" : "PSR:FR_pain.002_ZIP ";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 16: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "VPZ");
                }
                if (CH.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultSwissFetchParameter(isOrderType, "VPZ");
                }
                if (FR.equals(countryCode)) {
                    return isOrderType ? "pain.002.001.03.psr" : "PSR:FR_pain.002_ZIP ";
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 12: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "C86");
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 13: {
                if (AT.equals(countryCode)) {
                    return FetchParameterUtil.getDefaultAustrianFetchParameter(isOrderType, "DKI");
                }
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
            case 14: {
                return isOrderType ? statementType.getDefaultOrderType() : "EOP:FR_cfonb120";
            }
            case 5: 
            case 7: 
            case 11: {
                return FetchParameterUtil.getDefaultFetchParameter(isOrderType, statementType);
            }
        }
        return null;
    }

    private static String getDefaultFetchParameter(boolean isOrderType, StatementType statementType) {
        return isOrderType ? statementType.getDefaultOrderType() : BTFTranslator.getBTFFromFetchOrderType(statementType.getDefaultOrderType());
    }

    private static String getDefaultAustrianFetchParameter(boolean isOrderType, String transferType) {
        return isOrderType ? transferType : AustrianBTFTranslator.getBTFFromFetchOrderType(transferType);
    }

    private static String getDefaultSwissFetchParameter(boolean isOrderType, String transferType) {
        return isOrderType ? transferType : SwissBTFTranslator.getBTFFromFetchOrderType(transferType);
    }

    public static String getDefaultWssFetchType(BankSettings bank) {
        if (BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion())) {
            String countryCode = bank.getCountryCode();
            if (RegularExpressions.COUNTRY_CODE.matches(countryCode)) {
                return "OTH:" + countryCode + "_wssparam";
            }
            return "OTH_wssparam";
        }
        return "WSS";
    }

    public static String getWssFetchType(BankSettings bank) {
        String wssFetchType = StringUtils.checkNullAndTrim(bank.getWssFetchType());
        if (wssFetchType.length() == 0 || !BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion()) && !Util.isOrderType(wssFetchType)) {
            return FetchParameterUtil.getDefaultWssFetchType(bank);
        }
        return wssFetchType;
    }

    public static enum StatementType {
        mt940Statement("MT940", "STA"),
        mt942Advice("MT942", "VMK"),
        camt053Statement("camt.053", "C53"),
        camt052Advice("camt.052", "C52"),
        camt054("camt.054", "C54"),
        camt054CreditAdvice("camt.054", "C5N"),
        pdfStatement("PDF", "BKA"),
        otherPdfDocument("PDF", "BKI"),
        pain002ReportSCT("pain.002", "CRZ"),
        pain002ReportSDD("pain.002", "CDZ"),
        pain002ReportSCI("pain.002", "CIZ"),
        camt029Report("camt.029", "C29"),
        camt086Report("camt.086", "C86"),
        dki("dki", "DKI"),
        cfonb120Statement("cfonb120", "camt.xxx.cfonb120.stm"),
        pain002ReportAXS("pain.002", "AXS"),
        pain002ReportVOP("pain.002", "VPZ");

        private final String displayName;
        private final String defaultOrderType;

        private StatementType(String displayName, String defaultOrderType) {
            this.displayName = displayName;
            this.defaultOrderType = defaultOrderType;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDefaultOrderType() {
            return this.defaultOrderType;
        }
    }
}

