/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.bcs.core.OrderNumber;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.io.Streams;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.IProgressMonitorWrapper;
import de.businesslogics.zkasecurity.E001PrivateKey;
import de.businesslogics.zkasecurity.KeyStore;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.X001PrivateKey;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;

public final class ExportMasterData {
    private static final String ENCODING = "UTF-8";
    private static final String INDENT = "  ";
    private final List<BankUser> bankUsers;
    private final PasswordCallback signaturePasswordCallback;
    private final PasswordCallback loginPasswordCallback;
    private final File workspaceDirectory;
    private final List<Tenant> tenants;
    private int indent;
    private byte[] syncEncryptionKey;

    public ExportMasterData(List<BankUser> bankUsers, File workspaceDirectory, PasswordCallback signaturePasswordCallback, PasswordCallback loginPasswordCallback, List<Tenant> tenants) {
        this.bankUsers = bankUsers;
        this.workspaceDirectory = workspaceDirectory;
        this.signaturePasswordCallback = signaturePasswordCallback;
        this.loginPasswordCallback = loginPasswordCallback;
        this.tenants = tenants;
    }

    public void exportMasterData(OutputStream out, String licenseCode) throws IOException, GeneralSecurityException {
        Map<String, String> passwordRequirements;
        this.indent = 0;
        if (this.bankUsers == null || this.bankUsers.isEmpty()) {
            return;
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, ENCODING));
        w.write(String.format("<?xml version=\"1.0\" encoding=\"%s\"?>\n\n", ENCODING));
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("version", "1.0");
        attributes.put("xmlns", "bl:blbanking");
        if (licenseCode != null) {
            attributes.put("licenseCode", licenseCode);
        }
        this.openXmlTag(w, "BLBanking", attributes, true);
        attributes.clear();
        User user = null;
        for (BankUser bankUser : this.bankUsers) {
            byte[] cert;
            this.openXmlTag(w, "BankConnection", null, true);
            this.writeSimpleTag(w, "Name", bankUser.getBank().getDisplayName());
            this.writeSimpleTag(w, "Icon", this.extractIconNameFromFilename(bankUser.getBank().getIcon()));
            this.writeSimpleTag(w, "URL", bankUser.getBank().getUrl());
            this.writeSimpleTag(w, "Country", bankUser.getBank().getCountryCode());
            this.writeSimpleTag(w, "HostID", bankUser.getBank().getHostId());
            this.writeSimpleTag(w, "CustomerID", bankUser.getBank().getCustomerId());
            this.writeSimpleTag(w, "UserID", bankUser.getDefaultUser());
            this.writeSimpleTag(w, "EbicsProtocolVersion", bankUser.getBank().getProtocolVersion());
            if (bankUser.getBank().getE002Key() != null) {
                this.writeSimpleTag(w, "BankEncryptionKeyMod", HexTool.toHex(bankUser.getBank().getE002Key().getModulo()));
                this.writeSimpleTag(w, "BankEncryptionKeyExp", HexTool.toHex(bankUser.getBank().getE002Key().getExponent()));
                cert = bankUser.getBank().getE002Key().getCertificate();
                if (cert != null) {
                    this.writeSimpleTag(w, "BankEncryptionCert", HexTool.toHex(cert));
                }
            } else if (bankUser.getBank().getE001Key() != null) {
                this.writeSimpleTag(w, "BankEncryptionKeyMod", HexTool.toHex(bankUser.getBank().getE001Key().getModulo()));
                this.writeSimpleTag(w, "BankEncryptionKeyExp", HexTool.toHex(bankUser.getBank().getE001Key().getExponent()));
                cert = bankUser.getBank().getE001Key().getCertificate();
                if (cert != null) {
                    this.writeSimpleTag(w, "BankEncryptionCert", HexTool.toHex(cert));
                }
            }
            if (bankUser.getBank().getE001Key() == null && bankUser.getBank().getE002Key() == null) {
                this.writeSimpleTag(w, "E001_DIGEST", bankUser.getBank().getExpectedDigestE001());
                this.writeSimpleTag(w, "E002_DIGEST", bankUser.getBank().getExpectedDigestE002());
            }
            if (bankUser.getBank().getX002Key() != null) {
                this.writeSimpleTag(w, "BankAuthenticationKeyMod", HexTool.toHex(bankUser.getBank().getX002Key().getModulo()));
                this.writeSimpleTag(w, "BankAuthenticationKeyExp", HexTool.toHex(bankUser.getBank().getX002Key().getExponent()));
                cert = bankUser.getBank().getX002Key().getCertificate();
                if (cert != null) {
                    this.writeSimpleTag(w, "BankAuthenticationCert", HexTool.toHex(cert));
                }
            } else if (bankUser.getBank().getX001Key() != null) {
                this.writeSimpleTag(w, "BankAuthenticationKeyMod", HexTool.toHex(bankUser.getBank().getX001Key().getModulo()));
                this.writeSimpleTag(w, "BankAuthenticationKeyExp", HexTool.toHex(bankUser.getBank().getX001Key().getExponent()));
                cert = bankUser.getBank().getX001Key().getCertificate();
                if (cert != null) {
                    this.writeSimpleTag(w, "BankAuthenticationCert", HexTool.toHex(cert));
                }
            }
            if (bankUser.getBank().getX001Key() == null && bankUser.getBank().getX002Key() == null) {
                this.writeSimpleTag(w, "X001_DIGEST", bankUser.getBank().getExpectedDigestX001());
                this.writeSimpleTag(w, "X002_DIGEST", bankUser.getBank().getExpectedDigestX002());
            }
            this.writeSimpleTag(w, "OrderNumber", bankUser.getOrderNumber());
            this.writeSimpleTag(w, "SignatureVersion", bankUser.getSignatureVersion());
            Properties properties = new Properties();
            String keyDir = bankUser.getUser().getKeyDirectory();
            if ("DATABASE".equals(keyDir)) {
                this.writeSimpleTag(w, "UserSignatureKey", HexTool.toHex(bankUser.getSigKey()));
                if (bankUser.getSigCert() != null) {
                    this.writeSimpleTag(w, "UserSignatureCert", HexTool.toHex(bankUser.getSigCert()));
                }
            } else if (keyDir != null) {
                byte[] enc;
                Object keyDirectory = new File(keyDir);
                if (!((File)keyDirectory).isAbsolute()) {
                    keyDirectory = new File(this.workspaceDirectory, bankUser.getUser().getKeyDirectory());
                }
                File keybag = new File((File)keyDirectory, bankUser.getBank().getUniqueKey() + ".keybag");
                try (InputStream keybagInputStream = Files.newInputStream(keybag.toPath(), new OpenOption[0]);){
                    enc = Streams.readAll(keybagInputStream);
                }
                properties = new Properties();
                properties.load(new ByteArrayInputStream(KeyStore.decryptData(enc, "CHANGEIT".toCharArray())));
                this.writeSimpleTag(w, "UserSignatureKey", properties.getProperty(bankUser.getDefaultUser() + "_" + bankUser.getSignatureVersion()));
                if (properties.contains("A00X_CERT")) {
                    this.writeSimpleTag(w, "UserSignatureCert", properties.getProperty("A00X_CERT"));
                }
            }
            E001PrivateKey e001 = DatabaseToken.userKeysInKeybag ? E001PrivateKey.fromPKCS(HexTool.fromHex(properties.getProperty(bankUser.getDefaultUser() + "_E001")), bankUser.getDefaultUser(), this.loginPasswordCallback) : ("DATABASE_MIGRATION_NEEDED".equals(keyDir) ? E001PrivateKey.fromPKCS(bankUser.getEncrKey(), bankUser.getDefaultUser(), this.signaturePasswordCallback) : E001PrivateKey.fromPKCS(bankUser.getEncrKey(), bankUser.getDefaultUser(), DatabaseToken.PASSWORD_CALLBACK));
            this.writeSimpleTag(w, "UserEncryptionKey", HexTool.toHex(e001.toPKCS(this.signaturePasswordCallback)));
            if (DatabaseToken.userKeysInKeybag && properties.containsKey("E001_CERT")) {
                this.writeSimpleTag(w, "UserEncryptionCert", properties.getProperty("E001_CERT"));
            } else if (bankUser.getEncrCert() != null) {
                this.writeSimpleTag(w, "UserEncryptionCert", HexTool.toHex(bankUser.getEncrCert()));
            }
            X001PrivateKey x001 = DatabaseToken.userKeysInKeybag ? X001PrivateKey.fromPKCS(HexTool.fromHex(properties.getProperty(bankUser.getDefaultUser() + "_X001")), bankUser.getDefaultUser(), this.loginPasswordCallback) : ("DATABASE_MIGRATION_NEEDED".equals(keyDir) ? X001PrivateKey.fromPKCS(bankUser.getAuthKey(), bankUser.getDefaultUser(), this.signaturePasswordCallback) : X001PrivateKey.fromPKCS(bankUser.getAuthKey(), bankUser.getDefaultUser(), DatabaseToken.PASSWORD_CALLBACK));
            this.writeSimpleTag(w, "UserAuthenticationKey", HexTool.toHex(x001.toPKCS(this.signaturePasswordCallback)));
            if (DatabaseToken.userKeysInKeybag && properties.containsKey("X001_CERT")) {
                this.writeSimpleTag(w, "UserAuthenticationCert", properties.getProperty("X001_CERT"));
            } else if (bankUser.getEncrCert() != null) {
                this.writeSimpleTag(w, "UserAuthenticationCert", HexTool.toHex(bankUser.getEncrCert()));
            }
            for (Account account : Account.findAccountsForBank(bankUser.getBank())) {
                this.openXmlTag(w, "Account", null, true);
                if (account.getIban() != null && account.getIban().length() > 0) {
                    this.writeSimpleTag(w, "IBAN", account.getIban());
                }
                if (account.getBic() != null && account.getBic().length() > 0) {
                    this.writeSimpleTag(w, "BIC", account.getBic());
                }
                if (account.getGermanAccountNumber() != null && account.getGermanAccountNumber().length() > 0) {
                    this.writeSimpleTag(w, "AccountNumber", account.getGermanAccountNumber());
                }
                if (account.getGermanBankCode() != null && account.getGermanBankCode().length() > 0) {
                    this.writeSimpleTag(w, "BankCode", account.getGermanBankCode());
                }
                if (account.getNationalAccountNumber() != null && account.getNationalAccountNumber().length() > 0) {
                    this.writeSimpleTag(w, "NationalAccountNumber", account.getNationalAccountNumber());
                }
                if (account.getNationalBankCode() != null && account.getNationalBankCode().length() > 0) {
                    this.writeSimpleTag(w, "NationalBankCode", account.getNationalBankCode());
                }
                if (account.getCurrency() != null && account.getCurrency().length() > 0) {
                    this.writeSimpleTag(w, "Currency", account.getCurrency());
                }
                if (account.getAccountHolder() != null && account.getAccountHolder().length() > 0) {
                    this.writeSimpleTag(w, "Holder", account.getAccountHolder());
                }
                if (account.getName() != null && account.getName().length() > 0) {
                    this.writeSimpleTag(w, "Name", account.getName());
                }
                this.closeTag(w, "Account", true);
            }
            this.closeTag(w, "BankConnection", true);
            if (user == null) {
                user = bankUser.getUser();
                continue;
            }
            if (user.getId().equals(bankUser.getUser().getId())) continue;
            user = new User();
        }
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>(2);
        Collections.addAll(paymentTypes, PaymentType.SEPA, PaymentType.MANDATE);
        for (PaymentRecipient recipient : PaymentRecipient.findRecipientsForPaymentTypes(paymentTypes, this.tenants)) {
            this.openXmlTag(w, "Recipient", null, true);
            this.writeSimpleTag(w, "DisplayName", recipient.getDisplayName());
            this.writeSimpleTag(w, "Name", recipient.getName());
            this.writeSimpleTag(w, "AccountNumber", recipient.getAccountNumber());
            this.writeSimpleTag(w, "BankCode", recipient.getBankCode());
            this.writeSimpleTag(w, "Purpose", recipient.getPurpose());
            this.closeTag(w, "Recipient", true);
        }
        DatabasePreferenceStore databasePreferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user);
        if (user != null && user.getId() != null) {
            this.openXmlTag(w, "Permissions", null, true);
            this.writeSimpleTag(w, "Salary", databasePreferenceStore.getString(PreferenceConstants.SALARY_PERMISSIONS));
            this.closeTag(w, "Permissions", true);
        }
        if (!(passwordRequirements = this.loadPasswordRequirements()).isEmpty()) {
            this.openXmlTag(w, "PasswordRequirements", null, true);
            for (Map.Entry<String, String> e : passwordRequirements.entrySet()) {
                this.writeSimpleTag(w, e.getKey(), e.getValue());
            }
            this.closeTag(w, "PasswordRequirements", true);
        }
        this.closeTag(w, "BLBanking", true);
        w.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendToLicenseServer(String license, boolean qrCode, IProgressMonitorWrapper monitor) throws IOException, GeneralSecurityException {
        byte[] responseData;
        URLConnection conn = new URL("https://www.blbanking.de/license/keyexchange/long/" + license).openConnection();
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        conn.setDoInput(true);
        conn.setDoOutput(true);
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsUrl = (HttpsURLConnection)conn;
            httpsUrl.setSSLSocketFactory(EbicsHttpEngineImpl.getDefaultSocketFactory());
        }
        OutputStream exportDataOutputStream = conn.getOutputStream();
        try {
            if (qrCode) {
                KeyGenerator kgen = KeyGenerator.getInstance("AES");
                kgen.init(128);
                SecretKey ourKey = kgen.generateKey();
                this.syncEncryptionKey = ourKey.getEncoded();
                Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
                c.init(1, ourKey);
                exportDataOutputStream.write(EncryptData.ENCRYPTION_MARKER);
                byte[] iv = c.getIV();
                exportDataOutputStream.write(iv.length);
                exportDataOutputStream.write(iv);
                exportDataOutputStream = new CipherOutputStream(exportDataOutputStream, c);
            }
            monitor.worked(10);
            this.exportMasterData(exportDataOutputStream, license);
        }
        finally {
            Util.closeStream(exportDataOutputStream);
        }
        monitor.worked(10);
        InputStream responseInputStream = null;
        try {
            responseInputStream = conn.getInputStream();
            monitor.worked(10);
            responseData = Streams.readAll(responseInputStream);
        }
        finally {
            Util.closeStream(responseInputStream);
        }
        monitor.worked(10);
        this.setNewOrderNumbers();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < responseData.length; ++i) {
            b.append((char)responseData[i]);
            if (this.syncEncryptionKey != null || i % 3 != 2 || i >= 11) continue;
            b.append('-');
        }
        monitor.worked(10);
        return b.toString();
    }

    public byte[] getSynchronizationEncryptionKey() {
        return this.syncEncryptionKey;
    }

    private void openXmlTag(Writer w, String tagName, Map<String, String> attributes, boolean endOfLine) throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            w.write(INDENT);
        }
        w.write(60);
        w.write(tagName);
        if (attributes != null && !attributes.isEmpty()) {
            for (String key : attributes.keySet()) {
                w.write(32);
                w.write(key);
                w.write("=\"");
                w.write(attributes.get(key));
                w.write(34);
            }
        }
        w.write(62);
        if (endOfLine) {
            w.write(10);
            ++this.indent;
        }
    }

    private void closeTag(Writer writer, String tagName, boolean newLine) throws IOException {
        if (newLine) {
            --this.indent;
            for (int i = 0; i < this.indent; ++i) {
                writer.write(INDENT);
            }
        }
        writer.write("</");
        writer.write(tagName);
        writer.write(">\n");
    }

    private void writeSimpleTag(Writer writer, String tagName, String content) throws IOException {
        if (content == null) {
            return;
        }
        this.openXmlTag(writer, tagName, null, false);
        writer.write(this.replaceXmlSpecialCharacters(content));
        this.closeTag(writer, tagName, false);
    }

    private String extractIconNameFromFilename(String filename) {
        if (filename != null) {
            int lastSlashPos = filename.lastIndexOf(47);
            int startPos = lastSlashPos >= 0 && lastSlashPos < filename.length() - 1 ? filename.lastIndexOf(47) + 1 : 0;
            int lastDotPos = filename.lastIndexOf(46);
            int endPos = lastDotPos >= 0 && lastDotPos > startPos ? lastDotPos : filename.length();
            return filename.substring(startPos, endPos);
        }
        return "";
    }

    private String replaceXmlSpecialCharacters(String data) {
        data = data.replaceAll("&", "&amp;");
        data = data.replaceAll("<", "&lt;");
        data = data.replaceAll(">", "&gt;");
        data = data.replaceAll("\"", "&quot;");
        data = data.replaceAll("'", "&apos;");
        return data;
    }

    private void setNewOrderNumbers() {
        int orderNumberLeap = 1296;
        for (BankUser bankUser : this.bankUsers) {
            String orderNumber = bankUser.getOrderNumber();
            if (orderNumber == null || orderNumber.length() != 4) continue;
            for (int i = 0; i < 1296; ++i) {
                orderNumber = OrderNumber.next(orderNumber);
            }
            bankUser.setOrderNumber(orderNumber);
            bankUser.save();
        }
    }

    private Map<String, String> loadPasswordRequirements() {
        HashMap<String, String> result = new HashMap<String, String>();
        DatabasePreferenceStore prefs = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null);
        Consumer<PreferenceConstants> addIfDifferent = t -> Optional.ofNullable(prefs.getString((DatabasePreferenceConstant)t)).filter(p -> !p.equals(t.getDefaultValue())).ifPresent(p -> result.put(t.getId(), (String)p));
        addIfDifferent.accept(PreferenceConstants.PASSWORD_MIN_LENGTH);
        addIfDifferent.accept(PreferenceConstants.PASSWORD_NEED_LETTER);
        addIfDifferent.accept(PreferenceConstants.PASSWORD_NEED_LOWER);
        addIfDifferent.accept(PreferenceConstants.PASSWORD_NEED_UPPER);
        addIfDifferent.accept(PreferenceConstants.PASSWORD_NEED_NUMBER);
        addIfDifferent.accept(PreferenceConstants.PASSWORD_NEED_SPECIAL);
        addIfDifferent.accept(PreferenceConstants.PASSWORD_CHANGE_IN_DAYS);
        addIfDifferent.accept(PreferenceConstants.PASSWORD_CHECK_HISTORY);
        return result;
    }

    private static byte[] read(File file, byte[] syncEncryptionKey) throws IOException, GeneralSecurityException {
        InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);
        byte[] marker = new byte["BL2.0".getBytes().length];
        in.read(marker);
        int ivLength = in.read();
        byte[] iv = new byte[ivLength];
        in.read(iv);
        SecretKeySpec ourKey = new SecretKeySpec(syncEncryptionKey, "AES");
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        c.init(2, (Key)ourKey, new IvParameterSpec(iv));
        in = new CipherInputStream(in, c);
        return Streams.readAll(in);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new String(ExportMasterData.read(new File("/home/ralfr/workspace/trunk/BL/blbanking/license2/qr_codes/492103339931"), HexTool.fromHex("5CA6FDF033CEDD36B517350907836736"))));
        System.out.println(new String(ExportMasterData.read(new File("/home/ralfr/workspace/trunk/BL/blbanking/license2/qr_codes/089217125650"), HexTool.fromHex("A220C7F1BAD44342288394C80AE63222"))));
        System.out.println(new String(ExportMasterData.read(new File("/home/ralfr/workspace/trunk/BL/blbanking/license2/qr_codes/053121285441"), HexTool.fromHex("4513F65E561B5D3900471C3E0CF6CBC0"))));
        System.out.println(new String(ExportMasterData.read(new File("/home/ralfr/workspace/trunk/BL/blbanking/license2/qr_codes/494143999500"), HexTool.fromHex("B580883B6FF3D8818F30A6C75B9458D5"))));
    }
}

