/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.crypto.BCBlockCipher;
import de.businesslogics.crypto.CipherOutputStream;
import de.businesslogics.io.Streams;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import de.businesslogics.zkasecurity.KeyStore;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptData {
    public static final byte[] ENCRYPTION_MARKER = "BL2.0".getBytes();
    private static final char[] PASSWORD = new char[]{'j', 'q', 'i', 'F', 'w', 'F', 'e', 'P', '2', 'G', 'g', '5', 'n', 'x', 'S', 'H', '7', 'v', '7', 'X'};
    private static EncryptData theInstance;
    protected boolean encryption;
    protected SecretKey ourKey;
    protected boolean longEncryptionKey;

    public static void checkForEncryptionKeyMigration(User user, KeyEncryptionHandler encryptionHandler) throws GeneralSecurityException, IOException {
        byte[] key;
        if (ApplicationInfo.findByKey(ApplicationInfo.PropKey.DATA_ENC_KEY) == null && (key = EncryptData.getEncryptedKey(user.getEncryptionKey())) != null && key.length > 0) {
            byte[] decryptedKey = encryptionHandler.decryptKey(key);
            byte[] encryptedKey = KeyStore.encryptData(decryptedKey, PASSWORD);
            if (EncryptData.isLongEncryptionKey(user.getEncryptionKey())) {
                ApplicationInfo.createInstance(ApplicationInfo.PropKey.DATA_ENC_KEY, HexTool.toHex(EncryptData.addEncryptionMarker(encryptedKey))).save();
            } else {
                ApplicationInfo.createInstance(ApplicationInfo.PropKey.DATA_ENC_KEY, HexTool.toHex(encryptedKey)).save();
            }
        }
    }

    public static EncryptData createEncryptionKey() throws IOException, InvalidPasswordException {
        ApplicationInfo info = ApplicationInfo.findByKey(ApplicationInfo.PropKey.DATA_ENC_KEY);
        if (info == null) {
            byte[] encryptedKey = KeyStore.encryptData(EncryptData.createKey().getEncoded(), PASSWORD);
            ApplicationInfo.createInstance(ApplicationInfo.PropKey.DATA_ENC_KEY, HexTool.toHex(EncryptData.addEncryptionMarker(encryptedKey))).save();
        }
        return EncryptData.getInstance();
    }

    public static EncryptData getInstance() throws InvalidPasswordException, IOException {
        if (theInstance == null) {
            boolean useEncryption = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null).getBoolean(PreferenceConstants.ENCRYPT_DATA);
            return EncryptData.getInstance(useEncryption);
        }
        return theInstance;
    }

    public static EncryptData getInstance(boolean useEncryption) throws InvalidPasswordException, IOException {
        if (theInstance == null) {
            theInstance = new EncryptData(useEncryption);
        } else if (EncryptData.theInstance.encryption != useEncryption) {
            EncryptData.theInstance.encryption = useEncryption;
        }
        return theInstance;
    }

    public static boolean isLongEncryptionKey(byte[] encryptedKey) {
        return encryptedKey[0] == ENCRYPTION_MARKER[0] && encryptedKey[1] == ENCRYPTION_MARKER[1] && encryptedKey[2] == ENCRYPTION_MARKER[2] && encryptedKey[3] == ENCRYPTION_MARKER[3] && encryptedKey[4] == ENCRYPTION_MARKER[4];
    }

    public static byte[] getEncryptedKey(byte[] encryptedKey) {
        if (encryptedKey != null && encryptedKey.length > 0 && EncryptData.isLongEncryptionKey(encryptedKey)) {
            return Arrays.copyOfRange(encryptedKey, ENCRYPTION_MARKER.length, encryptedKey.length);
        }
        return encryptedKey;
    }

    public static byte[] addEncryptionMarker(byte[] key) {
        byte[] tmp = new byte[key.length + ENCRYPTION_MARKER.length];
        System.arraycopy(ENCRYPTION_MARKER, 0, tmp, 0, ENCRYPTION_MARKER.length);
        System.arraycopy(key, 0, tmp, ENCRYPTION_MARKER.length, key.length);
        return tmp;
    }

    public EncryptData(boolean useEncryption) throws InvalidPasswordException, IOException {
        this.encryption = useEncryption;
        ApplicationInfo applicationInfo = ApplicationInfo.findByKey(ApplicationInfo.PropKey.DATA_ENC_KEY);
        if (applicationInfo == null) {
            throw new RuntimeException("Key has not been migrated!");
        }
        byte[] key = HexTool.fromHex(applicationInfo.getPropValue());
        if (EncryptData.isLongEncryptionKey(key)) {
            key = EncryptData.getEncryptedKey(key);
            this.longEncryptionKey = true;
        } else {
            this.longEncryptionKey = false;
        }
        byte[] tmp = KeyStore.decryptData(key, PASSWORD);
        if (tmp.length > 16 && !this.longEncryptionKey) {
            byte[] tmp2 = new byte[16];
            System.arraycopy(tmp, 0, tmp2, 0, 16);
            tmp = tmp2;
        }
        this.ourKey = new SecretKeySpec(tmp, "AES");
    }

    public static boolean checkLoginKey(byte[] decryptedKey) {
        if (theInstance != null) {
            return Arrays.equals(EncryptData.theInstance.ourKey.getEncoded(), decryptedKey);
        }
        ApplicationInfo info = ApplicationInfo.findByKey(ApplicationInfo.PropKey.DATA_ENC_KEY);
        if (info == null) {
            return true;
        }
        try {
            return Arrays.equals(EncryptData.getDecryptedKey(info.getPropValue()), decryptedKey);
        }
        catch (InvalidPasswordException invalid) {
            return false;
        }
    }

    public static byte[] getDecryptedKey(String dataEncKey) throws InvalidPasswordException {
        byte[] encKey = EncryptData.getEncryptedKey(HexTool.fromHex(dataEncKey));
        return KeyStore.decryptData(encKey, PASSWORD);
    }

    public InputStream openInputStream(File file) throws IOException {
        return this.openInputStream(file, this.encryption);
    }

    private InputStream openInputStream(File file, boolean encrypted) throws IOException {
        Path path = file.toPath();
        if (encrypted) {
            try {
                PushbackInputStream in = new PushbackInputStream(Files.newInputStream(path, new OpenOption[0]), ENCRYPTION_MARKER.length);
                byte[] marker = new byte[ENCRYPTION_MARKER.length];
                int read = in.read(marker);
                if (Arrays.equals(ENCRYPTION_MARKER, marker)) {
                    byte[] iv = new byte[in.read()];
                    Streams.readFully(in, iv);
                    if (!this.longEncryptionKey) {
                        long size = file.length() - (long)ENCRYPTION_MARKER.length - 1L - (long)iv.length;
                        if (size % 16L == 0L) {
                            BCBlockCipher c = BCBlockCipher.createAESCTRNoPadding();
                            c.init(2, this.ourKey, new IvParameterSpec(iv));
                            return new EncryptionPaddingFilter(size, new de.businesslogics.crypto.CipherInputStream(c, in));
                        }
                        BCBlockCipher c = BCBlockCipher.createAESCTRNoPadding();
                        c.init(2, this.ourKey, new IvParameterSpec(iv));
                        return new de.businesslogics.crypto.CipherInputStream(c, in);
                    }
                    BCBlockCipher c = BCBlockCipher.createAESCTRPKCS7Padding();
                    c.init(2, this.ourKey, new IvParameterSpec(iv));
                    return new de.businesslogics.crypto.CipherInputStream(c, in);
                }
                if (read > 0) {
                    in.unread(marker, 0, read);
                    Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
                    c.init(2, this.ourKey);
                    return new CipherInputStream(in, c);
                }
                return in;
            }
            catch (GeneralSecurityException g) {
                throw new IOException("Security setup", g);
            }
        }
        return Files.newInputStream(path, new OpenOption[0]);
    }

    public OutputStream openOutputStream(File file) throws IOException {
        try {
            return this.openOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]), this.encryption);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public OutputStream openOutputStream(OutputStream out) throws IOException, GeneralSecurityException {
        return this.openOutputStream(out, this.encryption);
    }

    public boolean isEncryption() {
        return this.encryption;
    }

    private OutputStream openOutputStream(OutputStream out, boolean encrypted) throws IOException, GeneralSecurityException {
        if (encrypted) {
            BCBlockCipher c = BCBlockCipher.createAESCTRPKCS7Padding();
            byte[] iv = new byte[16];
            new SecureRandom().nextBytes(iv);
            c.init(1, this.ourKey, new IvParameterSpec(iv));
            out.write(ENCRYPTION_MARKER);
            out.write(iv.length);
            out.write(iv);
            return new VerifyOutputStream(new CipherOutputStream(c, out));
        }
        return out;
    }

    public byte[] copyKey(KeyEncryptionHandler encHandler) throws GeneralSecurityException, IOException {
        byte[] encKey = encHandler.encryptKey(this.ourKey.getEncoded());
        if (this.longEncryptionKey) {
            return EncryptData.addEncryptionMarker(encKey);
        }
        return encKey;
    }

    public void updateFile(File file, File workspaceDirectory) throws IOException, GeneralSecurityException {
        File tmpFile = File.createTempFile("encryption", null, workspaceDirectory);
        try {
            Streams.copy(this.openInputStream(file, !this.encryption), this.openOutputStream(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]), this.encryption));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Error updating file " + file.getAbsolutePath() + " to " + this.encryption, e);
        }
        file.delete();
        Util.copyFiles(tmpFile, file);
    }

    public static SecretKey createKey() {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(256);
            return kgen.generateKey();
        }
        catch (NoSuchAlgorithmException invalid) {
            throw new RuntimeException(invalid);
        }
    }

    public static interface KeyEncryptionHandler {
        public byte[] encryptKey(byte[] var1) throws GeneralSecurityException, IOException;

        public byte[] decryptKey(byte[] var1) throws GeneralSecurityException, IOException;
    }

    private static class EncryptionPaddingFilter
    extends InputStream {
        private final long size;
        private long pos = 0L;
        private final InputStream in;
        private final byte[] one_byte = new byte[1];
        private byte[] lastBytes = null;
        private int lastPos = 0;
        private int paddingBytes;

        protected EncryptionPaddingFilter(long size, InputStream in) {
            this.size = size;
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int toReturn = this.read(this.one_byte, 0, 1);
            if (toReturn != 1) {
                return toReturn;
            }
            return this.one_byte[0] & 0xFF;
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int toCopy;
            if (this.lastBytes == null && this.pos + (long)length < this.size - 16L) {
                int i = this.in.read(buffer, offset, length);
                if (i >= 0) {
                    this.pos += (long)i;
                }
                return i;
            }
            if (this.lastBytes == null) {
                this.lastBytes = new byte[(int)(this.size - this.pos)];
                Streams.readFully(this.in, this.lastBytes);
                this.paddingBytes = this.lastBytes[this.lastBytes.length - 1];
                if (this.paddingBytes >= 0 && this.paddingBytes <= 16) {
                    boolean allArePaddingBytes = true;
                    for (int i = this.lastBytes.length - this.paddingBytes; i < this.lastBytes.length; ++i) {
                        if (this.lastBytes[i] == this.paddingBytes) continue;
                        allArePaddingBytes = false;
                        break;
                    }
                    if (!allArePaddingBytes) {
                        this.paddingBytes = 0;
                    }
                } else {
                    this.paddingBytes = 0;
                }
            }
            if ((toCopy = Math.min(length, this.lastBytes.length - this.paddingBytes - this.lastPos)) == 0) {
                return -1;
            }
            System.arraycopy(this.lastBytes, this.lastPos, buffer, offset, toCopy);
            this.lastPos += toCopy;
            return toCopy;
        }

        @Override
        public int available() {
            long result = this.size - this.pos;
            if (result > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)result;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private static class VerifyOutputStream
    extends FilterOutputStream {
        private int position = 0;
        private byte[] header = new byte[ENCRYPTION_MARKER.length];

        public VerifyOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.position < ENCRYPTION_MARKER.length) {
                int copy = Math.min(len, this.header.length - this.position);
                System.arraycopy(b, off, this.header, this.position, copy);
                this.position += copy;
                if (this.position >= this.header.length) {
                    boolean equal = true;
                    for (int i = 0; i < ENCRYPTION_MARKER.length; ++i) {
                        if (this.header[i] == ENCRYPTION_MARKER[i]) continue;
                        equal = false;
                        break;
                    }
                    if (equal) {
                        throw new RuntimeException("Error: Encrypting an encrypted file again.");
                    }
                }
            }
            super.write(b, off, len);
        }
    }
}

