/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.ProtocolSetting;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.ebics.client.AustrianBTFTranslator;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.client.BTFTranslatorBase;
import de.businesslogics.ebics.client.SwissBTFTranslator;
import de.businesslogics.util.BLLogger;

public class Ebics30Migrator {
    private final BankSettings bank;
    private final BLLogger logger;
    private final BTFTranslatorBase translator;

    public Ebics30Migrator(BankSettings bank, BLLogger logger) {
        this.bank = bank;
        this.logger = logger;
        this.translator = bank.isAustrianBank() ? new AustrianBTFTranslator() : (bank.isSwissBank() ? new SwissBTFTranslator() : new BTFTranslator());
    }

    public void migrate() {
        this.migrateProtocolFormat();
        this.migrateSendOrders();
    }

    private void migrateProtocolFormat() {
        ProtocolSetting protocolSetting = ProtocolSetting.get(this.bank);
        if (protocolSetting != null && protocolSetting.getProtocolType().equals((Object)ProtocolSetting.ProtocolType.PTK)) {
            protocolSetting.setProtocolType(ProtocolSetting.ProtocolType.HAC);
            protocolSetting.save();
            this.logger.logInfo("Ebics30Migrator: Updated customer protocol for bank " + this.bank.getDisplayName() + " from PTK to HAC.");
        }
    }

    private void migrateSendOrders() {
        String cctBtf = this.translator.getBTFFromSendOrderType2("CCT");
        this.migrateSendOrders("CCT", cctBtf);
        this.migrateSendOrders("XCT");
        this.migrateSendOrders("XE2");
        this.migrateSendOrders("CCU");
        this.migrateSendOrders("CIP");
        this.migrateSendOrders("CDD");
        this.migrateSendOrders("CD1");
        this.migrateSendOrders("CDB");
        String azvBtf = this.translator.getBTFFromSendOrderType2("AZV");
        this.migrateSendOrders("AZV", azvBtf);
        this.migrateSendOrders("EUE", azvBtf);
        this.migrateSendOrders("RFT");
        this.migrateSendOrders("AXZ");
        this.migrateSendOrders("XET");
        this.migrateSendOrders("SDD");
        this.migrateSendOrders("CTV");
        this.migrateSendOrders("CIV");
        this.migrateSendOrders("XDT", this.translator.getBTFFromSendOrderType2("QDT"));
        this.migrateSendOrders("XWT", this.translator.getBTFFromSendOrderType2("QWT"));
        this.migrateSendOrders("XG2", this.translator.getBTFFromSendOrderType2("QG2"));
        if (this.bank.isSwissBank()) {
            this.migrateSendOrders("XG1");
        } else {
            this.migrateSendOrders("XG1", this.translator.getBTFFromSendOrderType2("QG1"));
        }
        this.migrateSendOrders("XTG", "XCT:BBK:URG_tgbbksw");
        this.migrateSendOrders("XGK", "DCT:BBK_gkdta");
        this.migrateSendOrders("XLK", "DDD:BBK_lkdta");
        this.migrateSendOrders("XGS", "DCT:BBK_gsbbksw");
        this.migrateSendOrders("XCG", "DCT:BBK_cgdta");
        this.migrateSendOrders("XCL", "DDD:BBK_cldta");
        this.migrateSendOrders("XCS", "DCT:BBK_csbbksw");
    }

    private void migrateSendOrders(String orderType) {
        this.migrateSendOrders(orderType, this.translator.getBTFFromSendOrderType2(orderType));
    }

    private void migrateSendOrders(String orderType, String btf) {
        int count = Send.updateSendOrdersForEbics30(this.bank, orderType, btf);
        if (count > 0) {
            this.logger.logInfo("Ebics30Migrator: Updated " + count + " " + orderType + "-send orders for bank " + this.bank.getDisplayName() + ". file_type has been set to " + btf + ".");
        }
    }

    public void migrateSendOrdersFrom30To25() {
        for (PaymentTransferType.PmtType pmtType : Send.findPmtTypesOfEbics30Orders(this.bank)) {
            String orderType = SendParameters.getOrderType(this.bank, pmtType);
            int count = 0;
            String orderTypeVop = null;
            if (pmtType.supportsVop()) {
                String btf = SendParameters.getBTF(this.bank, pmtType);
                orderTypeVop = SendParameters.getOrderTypeVop(this.bank, pmtType);
                String btfVop = SendParameters.getBTFVop(this.bank, pmtType);
                count = Send.updateOrderTypeOfEbics30Orders(this.bank, pmtType, btf, orderType);
                count += Send.updateOrderTypeOfEbics30Orders(this.bank, pmtType, btfVop, orderTypeVop);
            }
            if ((count += Send.updateOrderTypeOfEbics30Orders(this.bank, pmtType, orderType)) <= 0) continue;
            this.logger.logInfo("Ebics30Migrator: Updated " + count + " " + String.valueOf((Object)pmtType) + "-send orders for bank " + this.bank.getDisplayName() + ". order_type has been set from BTU to " + orderType + (String)(orderTypeVop == null ? "." : " or " + orderTypeVop + "."));
        }
    }
}

