/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DownloadableNotification;
import de.businesslogics.banking.database.vo.BankSettings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DownloadableNotificationHandler {
    private static final DownloadableNotificationHandler myInstance = new DownloadableNotificationHandler();
    private final Queue<DownloadableNotification> downloadableNotifications = new ConcurrentLinkedQueue<DownloadableNotification>();
    private final Map<BankSettings, Set<String>> bankTransferTypesMap = new HashMap<BankSettings, Set<String>>();

    private DownloadableNotificationHandler() {
    }

    public static DownloadableNotificationHandler getInstance() {
        return myInstance;
    }

    public void add(DownloadableNotification notification) {
        BankSettings bank = notification.getBank();
        String transferType = notification.getTransferType();
        Set<String> transferTypes = this.bankTransferTypesMap.get(bank);
        if (transferTypes == null) {
            transferTypes = new HashSet<String>();
            this.bankTransferTypesMap.put(bank, transferTypes);
        }
        if (!transferTypes.contains(transferType)) {
            transferTypes.add(transferType);
            this.downloadableNotifications.add(notification);
        }
    }

    public void displayNotifications() {
        DownloadableNotification notification = this.downloadableNotifications.poll();
        while (notification != null) {
            notification.display();
            BankSettings bank = notification.getBank();
            String transferType = notification.getTransferType();
            Set<String> transferTypes = this.bankTransferTypesMap.get(bank);
            if (transferTypes != null) {
                transferTypes.remove(transferType);
            }
            notification = this.downloadableNotifications.poll();
        }
    }

    public int getCountNotifications() {
        return this.downloadableNotifications.size();
    }
}

