/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;

public class DatabasePreferenceStore {
    protected final Preference.ApplicationId applicationId;
    protected final User user;
    protected final Tenant tenant;

    public DatabasePreferenceStore(Preference.ApplicationId applicationId, User user) {
        this.applicationId = applicationId;
        this.user = user;
        this.tenant = null;
    }

    public DatabasePreferenceStore(Preference.ApplicationId applicationId, User user, Tenant tenant) {
        this.applicationId = applicationId;
        this.user = user;
        this.tenant = tenant;
    }

    public final String getString(DatabasePreferenceConstant key) {
        if (key == null) {
            return null;
        }
        if (key.isUserSpecific()) {
            if (this.user == null) {
                throw new IllegalArgumentException("No user specified when reading preference for application ID " + this.applicationId.name() + ", key " + key.getId());
            }
            Preference preference = Preference.getPreference(this.user, this.applicationId, key.getId());
            if (preference == null) {
                return key.getDefaultValue();
            }
            return preference.getValue();
        }
        if (key.isOnlyConfigurableByAdminOrTenantAdmin() && this.tenant != null) {
            Preference preference = Preference.getPreference(this.tenant, this.applicationId, key.getId());
            if (preference == null) {
                preference = Preference.getPreference(this.applicationId, key.getId());
            }
            if (preference == null) {
                return key.getDefaultValue();
            }
            return preference.getValue();
        }
        Preference preference = Preference.getPreference(this.applicationId, key.getId());
        if (preference == null) {
            return key.getDefaultValue();
        }
        return preference.getValue();
    }

    public final boolean getBoolean(DatabasePreferenceConstant key) {
        return Boolean.parseBoolean(this.getString(key));
    }

    public final double getDouble(DatabasePreferenceConstant key) {
        return Double.parseDouble(this.getString(key));
    }

    public final float getFloat(DatabasePreferenceConstant key) {
        return Float.parseFloat(this.getString(key));
    }

    public final int getInt(DatabasePreferenceConstant key) {
        return Integer.parseInt(this.getString(key));
    }

    public final long getLong(DatabasePreferenceConstant key) {
        return Long.parseLong(this.getString(key));
    }

    public final void setValue(DatabasePreferenceConstant key, String value) {
        Preference preference;
        if (key == null) {
            throw new IllegalArgumentException("Cannot set a preference value without a key");
        }
        if (this.user == null && key.isUserSpecific()) {
            throw new IllegalArgumentException("No user specified when setting preference for application ID " + this.applicationId.name() + ", key " + key.getId());
        }
        boolean isDefaultValue = value == null && key.getDefaultValue() == null || value != null && value.equals(key.getDefaultValue());
        boolean isTenantPref = false;
        if (key.isUserSpecific()) {
            preference = Preference.getPreference(this.user, this.applicationId, key.getId());
        } else if (key.isOnlyConfigurableByAdminOrTenantAdmin() && this.tenant != null) {
            preference = Preference.getPreference(this.tenant, this.applicationId, key.getId());
            isTenantPref = true;
        } else {
            preference = Preference.getPreference(this.applicationId, key.getId());
        }
        if (preference == null && (!isDefaultValue || isTenantPref)) {
            preference = new Preference();
            preference.setApplicationId(this.applicationId);
            preference.setKey(key.getId());
            preference.setValue(value);
            if (key.isUserSpecific()) {
                preference.setUser(this.user);
            } else if (key.isOnlyConfigurableByAdminOrTenantAdmin() && this.tenant != null) {
                preference.setTenant(this.tenant);
            }
            preference.save();
            this.preferenceChanged(key, key.getDefaultValue(), value);
        } else if (preference != null && isDefaultValue && !isTenantPref) {
            String oldValue = preference.getValue();
            preference.delete();
            this.preferenceChanged(key, oldValue, key.getDefaultValue());
        } else if (preference != null && (value == null && preference.getValue() != null || value != null && !value.equals(preference.getValue()))) {
            String oldValue = preference.getValue();
            preference.setValue(value);
            preference.save();
            this.preferenceChanged(key, oldValue, value);
        }
    }

    public final void setValue(DatabasePreferenceConstant key, boolean value) {
        this.setValue(key, String.valueOf(value));
    }

    public final void setValue(DatabasePreferenceConstant key, double value) {
        this.setValue(key, String.valueOf(value));
    }

    public final void setValue(DatabasePreferenceConstant key, float value) {
        this.setValue(key, String.valueOf(value));
    }

    public final void setValue(DatabasePreferenceConstant key, int value) {
        this.setValue(key, String.valueOf(value));
    }

    public final void setValue(DatabasePreferenceConstant key, long value) {
        this.setValue(key, String.valueOf(value));
    }

    public final boolean resetPreference(DatabasePreferenceConstant key) {
        Preference preference = key.isUserSpecific() ? Preference.getPreference(this.user, this.applicationId, key.getId()) : (key.isOnlyConfigurableByAdminOrTenantAdmin() && this.tenant != null ? Preference.getPreference(this.tenant, this.applicationId, key.getId()) : Preference.getPreference(this.applicationId, key.getId()));
        if (preference == null) {
            return false;
        }
        String oldValue = preference.getValue();
        preference.delete();
        this.preferenceChanged(key, oldValue, key.getDefaultValue());
        return true;
    }

    protected void preferenceChanged(DatabasePreferenceConstant key, String oldValue, String newValue) {
    }

    public User getUser() {
        return this.user;
    }
}

