/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.vo.BankSettings;
import java.io.File;
import java.util.Arrays;
import java.util.Date;

public final class DataToSign
implements Comparable<DataToSign> {
    private final BankSettings bank;
    private final byte[] digest;
    private final String orderType;
    private final String fileName;
    private final Date fileDate;
    private byte[] signature;
    private int pos;
    private int total;
    private String ticket;

    public DataToSign(BankSettings bank, byte[] digest, String orderType) {
        this(bank, digest, orderType, "filename", new Date());
    }

    public DataToSign(BankSettings bank, byte[] digest, String orderType, String id) {
        this(bank, digest, orderType, id, new Date());
    }

    public DataToSign(BankSettings bank, byte[] digest, String orderType, File file) {
        this(bank, digest, orderType, file.getName(), new Date(file.lastModified()));
    }

    private DataToSign(BankSettings bank, byte[] digest, String orderType, String filename, Date fileDate) {
        this.bank = bank;
        this.digest = digest;
        this.orderType = orderType;
        this.fileDate = fileDate;
        this.fileName = filename;
    }

    public BankSettings getBank() {
        return this.bank;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getFileDate() {
        return this.fileDate;
    }

    @Override
    public int compareTo(DataToSign o) {
        if (Arrays.equals(this.digest, o.digest)) {
            return this.bank.getBankId().compareTo(o.bank.getBankId());
        }
        return Arrays.hashCode(this.digest) - Arrays.hashCode(o.digest);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataToSign other = (DataToSign)obj;
        if (this.bank == null ? other.bank != null : !((Object)this.bank).equals(other.bank)) {
            return false;
        }
        return Arrays.equals(this.digest, other.digest);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bank == null ? 0 : ((Object)this.bank).hashCode());
        result = 31 * result + Arrays.hashCode(this.digest);
        result = 31 * result + (this.orderType == null ? 0 : this.orderType.hashCode());
        return result;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }
}

