/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.orders.OrderDetails;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

public class DSUtil {
    public static final Pattern SENDER_PATTERN = Pattern.compile(".+\\(.+/.+\\)");
    private static final String UNKNOWN_USER = "unknown";

    public static String getUserInfoText(Locale locale, String customerId, String userId, String userNameAtBank, Date time) {
        String userName = null;
        if (userId != null) {
            userName = BankUser.findUniqueLoginUserNameByUserIdAndCustomerId(userId, customerId);
        } else {
            userId = UNKNOWN_USER;
        }
        if (userName == null) {
            userName = userNameAtBank;
        }
        if (userName != null && userName.length() > 0) {
            if (customerId == null || SENDER_PATTERN.matcher(userName).matches()) {
                return MessageFormat.format(BankingApiMessages.getString(locale, "DSUtil.userName", new Object[0]), time, userName);
            }
            return MessageFormat.format(BankingApiMessages.getString(locale, "DSUtil.userInfoNameAndId", new Object[0]), time, customerId, userId, userName);
        }
        return MessageFormat.format(BankingApiMessages.getString(locale, "DSUtil.userInfoId", new Object[0]), time, customerId, userId);
    }

    public static String getUserInfoText(Locale locale, String senderInfo, Date time) {
        return MessageFormat.format(BankingApiMessages.getString(locale, "DSUtil.userName", new Object[0]), time, senderInfo);
    }

    public static String getGeneralizedOrderType(OrderDetails details) {
        if (details.isH004AndBelow()) {
            FileFormat ff = details.getFileFormat();
            if (ff != null) {
                return ff.getFullOrderType(details.getOrderType().getValue());
            }
            return details.getOrderType().getValue();
        }
        return BTFTranslator.convertToString(details.getService());
    }
}

