/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DSUtil;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.PrintUtil;
import de.businesslogics.banking.api.ProtocolUtil;
import de.businesslogics.banking.api.SendOrderNameHandler;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.SendStateUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOpenOrderSigner;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.DsSigningInfo;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.ebics.schema.orders.OrderDetails;
import de.businesslogics.ebics.schema.orders.SignerInfo;
import de.businesslogics.format.iso20022.pain00200103.HAC30Entry;
import de.businesslogics.format.iso20022.pain00200103.Hac2Pdf;
import de.businesslogics.format.ptk2.Result;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFCreator;
import de.businesslogics.pdf.PDFElement;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.SystemUtils;
import io.ebean.Query;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class DSPrinter {
    @Deprecated
    public static File print(String orderType, String orderId, UserInfo originator, List<UserInfo> signers, String displayFile, BankSettings bank, File dataFile, DataFilePrintHandler printHandler, Locale locale, boolean printLogo, User user) throws IOException, PDFException {
        return DSPrinter.print(orderType, orderId, originator, signers, displayFile, bank, dataFile, printHandler, user, locale, printLogo, new SendOrderNameHandler(user), null, null, false);
    }

    public static File print(String orderType, String orderId, UserInfo originator, List<UserInfo> signers, String displayFile, BankSettings bank, File dataFile, DataFilePrintHandler printHandler, User user, Locale locale, boolean printLogo, SendOrderNameHandler orderNameHandler, String hashValue, String additionalOrderInfo, boolean lastRejected) throws IOException, PDFException {
        return DSPrinter.print(orderType, orderId, originator, signers, displayFile, bank, dataFile, printHandler, user, locale, printLogo, orderNameHandler, hashValue, additionalOrderInfo, lastRejected, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File print(String orderType, String orderId, UserInfo originator, List<UserInfo> signers, String displayFile, BankSettings bank, File dataFile, DataFilePrintHandler printHandler, User user, Locale locale, boolean printLogo, SendOrderNameHandler orderNameHandler, String hashValue, String additionalOrderInfo, boolean lastRejected, DsOrderDetails dsOrderDetails) throws IOException, PDFException {
        FileOutputStream out = null;
        File dest = null;
        try {
            String orderName;
            GeneralMessages messages = GeneralMessages.getInstance(locale);
            dest = Util.createTempFile("VEUOrder", ".pdf", true);
            out = new FileOutputStream(dest);
            BLDocument document = Util.createBLDocument(out, BLDocument.PageLayout.A4, BankingApiMessages.getString(locale, "DsPrinter.title", orderType, orderId), printLogo, locale);
            PaymentTransferType.PmtType pmtType = SendParameters.getPmtType(bank, orderType);
            if (pmtType != null) {
                orderName = PaymentTypeUtil.getOrderName(pmtType, orderId, Locale.getDefault());
                if (orderName == null) {
                    String transferType = pmtType.getHandlerKey();
                    orderName = orderNameHandler.getName(transferType, orderId, Locale.getDefault(), false);
                }
            } else {
                orderName = orderNameHandler.getName(orderType, orderId, Locale.getDefault(), false);
            }
            String headline = MessageFormat.format(messages.DETAILS_FOR, orderName);
            document.addHeadline(headline, BLFont.H1_BOLD, Alignment.ALIGN_CENTER, 0.0f);
            document.addNewLine();
            BLTable<?> t = PDFCreator.getInstance().createTable(2);
            t.setWidth(100.0f);
            t.setWidths(new int[]{1, 3});
            t.setBorder(BLBorder.NO_BORDER);
            t.addCell(messages.BANK);
            t.addCell(Util.getNameWithIdInBrackets(bank.getDisplayName(), bank.getCustomerId()));
            t.addCell(messages.ORDER);
            t.addCell(orderType + " / " + orderId);
            originator.addToTable(t, locale);
            int countSigners = signers.size();
            for (int i = 0; i < countSigners; ++i) {
                UserInfo signer = signers.get(i);
                if (i < countSigners - 1) {
                    signer.addToTable(t, locale);
                    continue;
                }
                signer.addToTable(t, locale, lastRejected);
            }
            if (dsOrderDetails != null) {
                List decline;
                List accept = ProtocolUtil.getHacEntries(dsOrderDetails, HAC30Entry.Action.ORDER_HAC_FINAL_POS.ordinal()).findList();
                if (!accept.isEmpty()) {
                    t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.acceptedOn", new Object[0]));
                    t.addCell(MessageFormat.format("{0,date} {0,time}", ((HacEntry)accept.getLast()).getHacTime()));
                }
                if (!(decline = ProtocolUtil.getHacEntries(dsOrderDetails, HAC30Entry.Action.ORDER_HAC_FINAL_NEG.ordinal()).findList()).isEmpty()) {
                    t.addCell(BankingApiMessages.getString(locale, "GeneralMessages.declinedOn", new Object[0]));
                    t.addCell(MessageFormat.format("{0,date} {0,time}", ((HacEntry)decline.getLast()).getHacTime()));
                }
            }
            if (dsOrderDetails != null && dsOrderDetails.getState() != null) {
                String state = DSPrinter.getStateString(dsOrderDetails);
                t.addCell(messages.STATE);
                t.addCell(state);
            }
            if (hashValue != null) {
                t.addCell(messages.HASH_VALUE);
                t.addCell(hashValue);
            }
            if (additionalOrderInfo != null && additionalOrderInfo.length() > 0) {
                t.addCell(messages.ORDER_DATA_ADDITIONAL_INFO);
                t.addCell(additionalOrderInfo);
            }
            t.setHorizontalAlignment(Alignment.ALIGN_LEFT);
            document.addTable(t);
            document.addNewLine();
            document.addTextln(displayFile, BLFont.COURIER_SMALL);
            if (dsOrderDetails != null) {
                Query<HacEntry> query = ProtocolUtil.getHacEntries(dsOrderDetails);
                DSPrinter.printProtocol(document, locale, orderName, bank.getDisplayName(), query);
            }
            if (dataFile != null && dataFile.isFile() && printHandler != null && !PrintUtil.isFileTooLargeForDetails(dataFile.length(), document, user, locale)) {
                boolean newPage = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean(PreferenceConstants.DS_PRINT_DETAILS_WITH_PAGE_BREAK);
                printHandler.printDataFileInfo(document, dataFile, bank, orderType, newPage, locale);
            }
            document.close();
        }
        catch (Throwable throwable) {
            SystemUtils.close(out);
            throw throwable;
        }
        SystemUtils.close(out);
        return dest;
    }

    private static String getStateString(DsOrderDetails details) {
        if (details == null || details.getState() == null) {
            return "";
        }
        return DSPrinter.getStateString(details.getState(), details.getErrorCode());
    }

    private static String getStateString(DsOrderDetails.State state, String error) {
        String errorMsg = null;
        if (error != null) {
            errorMsg = Character.isDigit(error.charAt(0)) ? Result.getInstance(Integer.valueOf(error)).toString() : HAC30Entry.getReasonMessage(Locale.getDefault(), error, HAC30Entry.Action.FILE_UPLOAD);
        }
        return SendStateUtil.getStateFilterText(state, errorMsg, Locale.getDefault());
    }

    private static void printProtocol(BLDocument document, Locale locale, String orderName, String bankName, Query<HacEntry> query) throws PDFException {
        PDFElement<?> protocolElement = DSPrinter.printHac(locale, query);
        if (protocolElement != null) {
            document.newPage();
            document.addHeadline(DSPrinter.getBankProtocolHeadline(locale, orderName, bankName), BLFont.FONT_BIG_BOLD, Alignment.ALIGN_CENTER, 10.0f);
            document.add(protocolElement);
        }
    }

    private static PDFElement<?> printHac(Locale locale, Query<HacEntry> query) throws PDFException {
        if (query.findCount() > 0) {
            Hac2Pdf hac2pdf = new Hac2Pdf(false, locale);
            query.findEach(hac -> hac2pdf.addEntry(ProtocolUtil.toHAC(hac)));
            return hac2pdf.getHacTable();
        }
        return null;
    }

    private static String getBankProtocolHeadline(Locale locale, String orderName, String bankName) {
        return BankingApiMessages.getString(locale, "DistributedSignatureView.print.protocolWithOrderName", orderName, bankName);
    }

    public static final class UserInfo {
        private final Date date;
        private final String customerId;
        private final String userId;
        private final String userName;
        private final Character permission;
        private final boolean isSigner;

        public UserInfo(DsOrderDetails dsOrderDetails) {
            this.date = dsOrderDetails.getSubmissionDate();
            this.customerId = dsOrderDetails.getCustomerId();
            this.userId = dsOrderDetails.getUserId();
            this.userName = dsOrderDetails.getUserName();
            this.permission = null;
            this.isSigner = false;
        }

        public UserInfo(DsSigningInfo signingInfo) {
            this.date = signingInfo.getSignDate();
            this.customerId = signingInfo.getCustomerId();
            this.userId = signingInfo.getUserId();
            this.userName = signingInfo.getUserName();
            this.permission = signingInfo.getPermission();
            this.isSigner = true;
        }

        public UserInfo(DsOpenOrder dsOrderDetails) {
            this.date = dsOrderDetails.getSubmissionDate();
            this.customerId = dsOrderDetails.getCustomerId();
            this.userId = dsOrderDetails.getUserId();
            this.userName = dsOrderDetails.getUserName();
            this.permission = null;
            this.isSigner = false;
        }

        public UserInfo(DsOpenOrderSigner signingInfo) {
            this.date = signingInfo.getSignDate();
            this.customerId = signingInfo.getCustomerId();
            this.userId = signingInfo.getUserId();
            this.userName = signingInfo.getUserName();
            this.permission = signingInfo.getPermission();
            this.isSigner = true;
        }

        public UserInfo(OrderDetails orderDetails) {
            this.date = orderDetails.getOriginatorInfo().getTimestamp().getDate();
            this.customerId = orderDetails.getOriginatorInfo().getPartnerID().getValue();
            this.userId = orderDetails.getOriginatorInfo().getUserID().getValue();
            this.userName = orderDetails.getOriginatorInfo().getName() != null ? orderDetails.getOriginatorInfo().getName().getValue() : null;
            this.permission = null;
            this.isSigner = false;
        }

        public UserInfo(SignerInfo signingInfo) {
            this.date = signingInfo.getTimestamp().getDate();
            this.customerId = signingInfo.getPartnerID().getValue();
            this.userId = signingInfo.getUserID().getValue();
            this.userName = signingInfo.getName() != null ? signingInfo.getName().getValue() : null;
            this.permission = signingInfo.getPermission() != null && signingInfo.getPermission().getAuthorisationLevel() != null && signingInfo.getPermission().getAuthorisationLevel().length() > 0 ? Character.valueOf(signingInfo.getPermission().getAuthorisationLevel().charAt(0)) : null;
            this.isSigner = true;
        }

        private void addToTable(BLTable<?> table, Locale locale) throws PDFException {
            this.addToTable(table, locale, false);
        }

        private void addToTable(BLTable<?> table, Locale locale, boolean lastRejected) throws PDFException {
            table.addCell(this.getLabel(locale, lastRejected));
            table.addCell(DSUtil.getUserInfoText(locale, this.customerId, this.userId, this.userName, this.date));
        }

        private String getLabel(Locale locale, boolean lastRejected) {
            if (this.isSigner) {
                if (lastRejected) {
                    return GeneralMessages.getInstance((Locale)locale).CANCELLED_ON;
                }
                if (this.permission != null && this.permission.toString().trim().length() > 0) {
                    return MessageFormat.format(GeneralMessages.getInstance((Locale)locale).SIGNATURE_WITH_TYPE_ON, this.permission);
                }
                return GeneralMessages.getInstance((Locale)locale).SIGNED_ON;
            }
            return GeneralMessages.getInstance((Locale)locale).SUBMITTED_ON;
        }
    }

    public static interface DataFilePrintHandler {
        public void printDataFileInfo(BLDocument var1, File var2, BankSettings var3, String var4, boolean var5, Locale var6) throws PDFException, IOException;
    }
}

