/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.Collator;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public final class CountriesLoader {
    private static final Map<String, CountriesLoader> COUNTRIES_LOADERS = new HashMap<String, CountriesLoader>();
    private static final Map<String, String> USER_COUNTRIES = new HashMap<String, String>();
    private static long countriesPropertiesLastModified;
    private final Map<String, String> countries = new HashMap<String, String>();
    private final Locale locale;
    private String[] sortedCountryCodes;
    private String[] sortedCountryNames;

    public static CountriesLoader getInstance(Locale locale) {
        CountriesLoader.checkForCountriesProperties(Util.WORKSPACEDIR);
        CountriesLoader result = COUNTRIES_LOADERS.get(locale.getLanguage());
        if (result == null) {
            result = new CountriesLoader(locale);
            COUNTRIES_LOADERS.put(locale.getLanguage(), result);
        }
        return result;
    }

    private static void checkForCountriesProperties(File workspaceDir) {
        File countriesPropertiesFile = new File(new File(workspaceDir, "payments"), "countries.properties");
        if (countriesPropertiesFile.exists() && countriesPropertiesLastModified < countriesPropertiesFile.lastModified()) {
            InputStream propsInputStream = null;
            Properties countriesProperties = new Properties();
            try {
                propsInputStream = Files.newInputStream(countriesPropertiesFile.toPath(), new OpenOption[0]);
                countriesProperties.load(propsInputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (propsInputStream != null) {
                    try {
                        propsInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            USER_COUNTRIES.clear();
            for (Object object : countriesProperties.keySet()) {
                if (!(object instanceof String)) continue;
                String countryCode = (String)object;
                USER_COUNTRIES.put(countryCode, countriesProperties.getProperty(countryCode));
            }
            for (String string : COUNTRIES_LOADERS.keySet()) {
                COUNTRIES_LOADERS.get(string).reloadCountries();
            }
            countriesPropertiesLastModified = countriesPropertiesFile.lastModified();
        }
    }

    private CountriesLoader(Locale locale) {
        this.locale = locale;
        this.reloadCountries();
    }

    public String[] getCountryNames() {
        if (this.sortedCountryNames == null) {
            this.sortedCountryNames = new String[this.countries.size()];
            int index = 0;
            for (String countryCode : this.getCountryCodes()) {
                this.sortedCountryNames[index++] = this.countries.get(countryCode);
            }
        }
        return this.sortedCountryNames;
    }

    public String[] getCountryCodes() {
        if (this.sortedCountryCodes == null) {
            this.sortedCountryCodes = new String[this.countries.size()];
            int index = 0;
            for (String countryCode : this.countries.keySet()) {
                this.sortedCountryCodes[index++] = countryCode;
            }
            Collator collator = Collator.getInstance(this.locale);
            collator.setStrength(2);
            Arrays.sort(this.sortedCountryCodes, (o1, o2) -> collator.compare(this.countries.get(o1), this.countries.get(o2)));
        }
        return this.sortedCountryCodes;
    }

    public String getCountryName(String countryCode) {
        return this.countries.get(countryCode);
    }

    public int getIndexForCountry(String countryCode) {
        for (int i = 0; i < this.getCountryCodes().length; ++i) {
            if (!this.getCountryCodes()[i].equals(countryCode)) continue;
            return i;
        }
        return -1;
    }

    private void reloadCountries() {
        this.countries.clear();
        this.sortedCountryCodes = null;
        this.sortedCountryNames = null;
        for (String countryCode : Locale.getISOCountries()) {
            this.countries.put(countryCode, new Locale(countryCode, countryCode).getDisplayCountry(this.locale));
        }
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.banking.api.CountriesLoader", this.locale);
        Enumeration<String> keysEnum = bundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            String bundleKey = keysEnum.nextElement();
            int dotIndex = bundleKey.lastIndexOf(46);
            if (dotIndex < 0 || dotIndex >= bundleKey.length() - 1) continue;
            this.countries.put(bundleKey.substring(dotIndex + 1), bundle.getString(bundleKey));
        }
        this.countries.putAll(USER_COUNTRIES);
    }
}

