/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.SignedPaymentsUtil;
import de.businesslogics.banking.database.vo.CmPage;
import de.businesslogics.banking.database.vo.CmStatement;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class CMUtil {
    public static String getDisplayText(CmStatement stmt, Locale locale) {
        if (stmt.isDtiFile()) {
            StringBuffer sb = null;
            CmStatement.Type type = stmt.getType();
            if (CmStatement.Type.LOGICAL_PAYMENT_FILE.equals((Object)type)) {
                return SignedPaymentsUtil.getSendOrderName(locale, stmt.getOriginalFilename());
            }
            if (CmStatement.Type.CAMT054.equals((Object)type)) {
                sb = new StringBuffer("camt.054");
                sb.append('-');
                sb.append(BankingApiMessages.getString(locale, "AccountStatement.fileWithRefNumber", new Object[0]));
            } else {
                sb = new StringBuffer(type.name());
                sb.append('-');
                if (CmStatement.Type.DTI.equals((Object)type)) {
                    sb.append(BankingApiMessages.getString(locale, "AccountStatement.fileWithRefNumber", new Object[0]));
                } else {
                    sb.append(BankingApiMessages.getString(locale, "AccountStatement.fileWithSeqNumber", new Object[0]));
                }
            }
            sb.append(' ');
            sb.append(stmt.getReference1());
            if (!stmt.isHasPages() && stmt.getPageNumber() != null) {
                sb.append(" / ");
                sb.append(stmt.getPageNumber());
            }
            return sb.toString();
        }
        if (CmStatement.Type.CFONB120.equals((Object)stmt.getType())) {
            String s = MessageFormat.format(BankingApiMessages.getString(locale, "AccountOverviewLabelProvider.statementFromDate", new Object[0]), DateFormat.getDateInstance().format(stmt.getCreationDate()));
            return s;
        }
        StringBuffer sb = null;
        sb = stmt.isAdvice() ? (CmStatement.Type.CAMT054Advice.equals((Object)stmt.getType()) ? new StringBuffer(BankingApiMessages.getString(locale, "AccountOverviewLabelProvider.creditAdviceCamt054", new Object[0])) : new StringBuffer(BankingApiMessages.getString(locale, "GeneralMessages.advice", new Object[0]))) : new StringBuffer(BankingApiMessages.getString(locale, "GeneralMessages.accountStatement", new Object[0]));
        sb.append(": ");
        if (stmt.getStatementNumberToDisplay() != null) {
            sb.append(stmt.getStatementNumberToDisplay());
            if (!stmt.isHasPages() && stmt.getPageNumber() != null) {
                sb.append(" / ");
                sb.append(stmt.getPageNumber());
            }
        }
        if (!stmt.isHasPages() && stmt.isAdvice() && stmt.getCreationDate() != null) {
            sb.append("   ");
            sb.append(new SimpleDateFormat("HH:mm").format(stmt.getCreationDate()));
        }
        return sb.toString();
    }

    public static String getDisplayText(CmPage page, Locale locale) {
        StringBuffer sb = null;
        CmStatement stmt = page.getStatement();
        if (stmt.isDtiFile()) {
            CmStatement.Type type = stmt.getType();
            if (CmStatement.Type.LOGICAL_PAYMENT_FILE.equals((Object)type)) {
                return SignedPaymentsUtil.getSendOrderName(locale, stmt.getOriginalFilename());
            }
            if (CmStatement.Type.CAMT054.equals((Object)type)) {
                sb = new StringBuffer("camt.054");
                sb.append('-');
                sb.append(BankingApiMessages.getString(locale, "AccountStatement.fileWithRefNumber", new Object[0]));
            } else {
                sb = new StringBuffer(type.name());
                sb.append('-');
                if (CmStatement.Type.DTI.equals((Object)type)) {
                    sb.append(BankingApiMessages.getString(locale, "AccountStatement.fileWithRefNumber", new Object[0]));
                } else {
                    sb.append(BankingApiMessages.getString(locale, "AccountStatement.fileWithSeqNumber", new Object[0]));
                }
            }
            sb.append(' ');
            sb.append(stmt.getReference1());
            if (page.getPageNumber() != null) {
                sb.append(" / ");
                sb.append(page.getPageNumber());
            }
            return sb.toString();
        }
        sb = stmt.isAdvice() ? new StringBuffer(BankingApiMessages.getString(locale, "GeneralMessages.advice", new Object[0])) : new StringBuffer(BankingApiMessages.getString(locale, "GeneralMessages.accountStatement", new Object[0]));
        sb.append(": ");
        sb.append(stmt.getStatementNumberToDisplay());
        if (page.getPageNumber() != null) {
            sb.append(" / ");
            sb.append(page.getPageNumber());
        }
        if (stmt.isAdvice() && page.getCreationDate() != null) {
            sb.append("   ");
            sb.append(new SimpleDateFormat("HH:mm").format(page.getCreationDate()));
        }
        return sb.toString();
    }
}

