/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.ZipProcessing;
import de.businesslogics.banking.api.ZipProcessingResult;
import de.businesslogics.io.NoCloseInputStream;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class BaseZipHandler {
    protected final ZipProcessing processing;
    private final BLLogger logger;
    private int countEntries;
    private int countProcessedEntries;
    private final Map<String, Exception> entryErrorMap = new LinkedHashMap<String, Exception>();

    public BaseZipHandler(ZipProcessing processing, BLLogger logger) {
        this.processing = processing;
        this.logger = logger;
        this.countEntries = 0;
        this.countProcessedEntries = 0;
        this.entryErrorMap.clear();
    }

    public boolean isZipFile(File file) throws IOException {
        try (PushbackInputStream pushback = new PushbackInputStream(new FileInputStream(file), 2);){
            boolean bl = this.isZipFile(pushback);
            return bl;
        }
    }

    public void processZippedFile(File file) throws Exception {
        block10: {
            try {
                this.processZipped(new FileInputStream(file));
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            catch (Exception zipException) {
                try (ZipFile zip = new ZipFile(file);){
                    Enumeration<? extends ZipEntry> enumeration = zip.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        this.processZippedEntry(entry, zip.getInputStream(entry), 0);
                    }
                }
                if (file.delete()) break block10;
                file.deleteOnExit();
            }
        }
    }

    protected boolean isZipFile(PushbackInputStream pushback) throws IOException {
        int firstByte = pushback.read();
        int secondByte = pushback.read();
        pushback.unread(secondByte);
        pushback.unread(firstByte);
        return firstByte == 80 && secondByte == 75;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processZipped(InputStream in) throws Exception {
        try (ZipInputStream zip = new ZipInputStream(in);){
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                try {
                    this.processZippedEntry(entry, zip, 0);
                }
                finally {
                    zip.closeEntry();
                }
                entry = zip.getNextEntry();
            }
        }
    }

    private void processZippedEntry(ZipEntry entry, InputStream inputStream, int retries) throws Exception {
        if (!entry.isDirectory()) {
            PushbackInputStream pushback = new PushbackInputStream(inputStream, 2);
            if (retries < 10 && this.isZipFile(pushback)) {
                this.processZipped(new NoCloseInputStream(pushback));
            } else {
                try {
                    ++this.countEntries;
                    this.processing.processUnzipped(entry.getName(), new NoCloseInputStream(pushback));
                    ++this.countProcessedEntries;
                }
                catch (Exception e) {
                    if (entry.getName() != null) {
                        this.entryErrorMap.put(entry.getName(), e);
                        this.logger.logError(this.processing.getClass().getName() + ": Could not process entry '" + entry.getName() + "'" + e.getMessage(), e);
                    }
                    this.entryErrorMap.put("ENTRY_WITHOUT_NAME", e);
                    this.logger.logError(this.processing.getClass().getName() + ": Could not process entry without name " + e.getMessage(), e);
                }
            }
        }
    }

    public ZipProcessingResult getProcessingResult() {
        return new ZipProcessingResult(this.processing.getClass().getName(), this.countEntries, this.countProcessedEntries, this.entryErrorMap);
    }
}

