/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.ebics.schema.response.AccountAuthorizationFailedException;
import de.businesslogics.ebics.schema.response.AmountCheckFailedException;
import de.businesslogics.ebics.schema.response.AuthenticationFailedException;
import de.businesslogics.ebics.schema.response.AuthorisationFailedException;
import de.businesslogics.ebics.schema.response.BankPubKeyUpdateRequiredException;
import de.businesslogics.ebics.schema.response.DuplicateSignatureException;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.EbicsProcessingException;
import de.businesslogics.ebics.schema.response.EbicsUnknownUserException;
import de.businesslogics.ebics.schema.response.InternalErrorException;
import de.businesslogics.ebics.schema.response.InvalidOrderTypeException;
import de.businesslogics.ebics.schema.response.InvalidRequestContentException;
import de.businesslogics.ebics.schema.response.InvalidRequestException;
import de.businesslogics.ebics.schema.response.InvalidUserOrStateException;
import de.businesslogics.ebics.schema.response.InvalidUserStateException;
import de.businesslogics.ebics.schema.response.KeymgmtKeylengthErrorAuthenticationException;
import de.businesslogics.ebics.schema.response.KeymgmtKeylengthErrorEncryptionException;
import de.businesslogics.ebics.schema.response.KeymgmtKeylengthErrorSignatureException;
import de.businesslogics.ebics.schema.response.KeymgmtUnsupportedVersionAuthenticationException;
import de.businesslogics.ebics.schema.response.KeymgmtUnsupportedVersionEncryptionException;
import de.businesslogics.ebics.schema.response.OrderIdUnknownException;
import de.businesslogics.ebics.schema.response.SignatureVerificationFailedException;
import de.businesslogics.ebics.schema.response.UnknownHostIdException;
import de.businesslogics.ebics.schema.response.UnsupportedOrderTypeException;
import de.businesslogics.ebics.schema.types.AuthenticatedReturnCode;
import de.businesslogics.ebics.schema.types.ReturnCode;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class BankingApiMessages {
    private static Map<String, ResourceBundle> bundles;

    public static String getString(String key, Object ... args) {
        return BankingApiMessages.getString(Locale.getDefault(), key, args);
    }

    public static String getString(Locale locale, String key, Object ... args) {
        ResourceBundle bundle = BankingApiMessages.getBundle(locale);
        if (bundle != null) {
            try {
                if (args == null || args.length == 0) {
                    return bundle.getString(key);
                }
                return new MessageFormat(bundle.getString(key), locale).format(args);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "!" + key + "!";
    }

    public static String getStringWithBoldPos1(Locale locale, String key, Object ... args) {
        ResourceBundle bundle = BankingApiMessages.getBundle(locale);
        if (bundle != null) {
            try {
                if (args == null || args.length == 0) {
                    return bundle.getString(key);
                }
                String fatPosOne = bundle.getString(key).replace("\"{0}\"", "<b>{0}</b>");
                return new MessageFormat(fatPosOne, locale).format(args);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "!" + key + "!";
    }

    public static String getEbicsErrorStringForWeb(Locale locale, String key) {
        ResourceBundle bundle = BankingApiMessages.getBundle(locale);
        if (bundle != null) {
            try {
                String fatPosOne = bundle.getString(key).replaceFirst("\"", "<b>");
                fatPosOne = fatPosOne.replaceFirst("\"", "</b>");
                int enumPos = 1;
                int enumStart = fatPosOne.indexOf("1.");
                if (enumStart == -1) {
                    int boldEnd = fatPosOne.indexOf("</b>");
                    if (boldEnd == -1) {
                        return fatPosOne;
                    }
                    String beforePart = fatPosOne.substring(0, boldEnd);
                    Object instructionText = fatPosOne.substring(boldEnd);
                    instructionText = ((String)instructionText).replaceFirst("\n-", "<ul><li>");
                    instructionText = ((String)instructionText).replace("\n-", "</li><li>");
                    instructionText = (String)instructionText + "</li></ul>";
                    return beforePart + (String)instructionText;
                }
                String beforeEnumPart = fatPosOne.substring(0, enumStart);
                Object enumPart = fatPosOne.substring(enumStart);
                while (((String)enumPart).contains(enumPos + ".")) {
                    String next = enumPos + 1 + ".";
                    enumStart = ((String)enumPart).indexOf(enumPos + ".");
                    int enumEnd = ((String)enumPart).indexOf(next);
                    String firstPart = ((String)enumPart).substring(0, enumStart);
                    Object thisEnum = "";
                    String lastPart = "";
                    if (enumEnd == -1) {
                        thisEnum = ((String)enumPart).substring(enumStart);
                        lastPart = "";
                    } else {
                        thisEnum = ((String)enumPart).substring(enumStart, enumEnd);
                        lastPart = ((String)enumPart).substring(enumEnd);
                    }
                    thisEnum = enumPos == 1 ? ((String)thisEnum).replaceFirst(enumPos + ".", "<ol><li>") : ((String)thisEnum).replaceFirst(enumPos + ".", "<li>");
                    if (((String)thisEnum).contains("-")) {
                        thisEnum = ((String)thisEnum).replaceFirst("\n-", "<ul><li>");
                        thisEnum = ((String)thisEnum).replace("\n-", "</li><li>");
                        thisEnum = (String)thisEnum + "</li></ul>";
                    }
                    enumPart = firstPart + (String)thisEnum + lastPart;
                    ++enumPos;
                }
                if (((String)enumPart).contains("<ol>")) {
                    enumPart = (String)enumPart + "</ol>";
                }
                return beforeEnumPart + (String)enumPart;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "!" + key + "!";
    }

    private static ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle;
        if (bundles != null) {
            bundle = bundles.get(locale.getLanguage());
            if (bundle != null) {
                return bundle;
            }
        } else {
            bundle = null;
        }
        if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle("de.businesslogics.banking.api.BankingApiMessages", locale);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        if (bundle != null) {
            if (bundles == null) {
                bundles = new HashMap<String, ResourceBundle>();
            }
            bundles.put(locale.getLanguage(), bundle);
        }
        return bundle;
    }

    public static String getErrorMessage(Exception e) {
        return BankingApiMessages.getErrorMessage(e, Locale.getDefault(), false, false);
    }

    public static String getErrorMessage(Exception e, boolean withPattern) {
        return BankingApiMessages.getErrorMessage(e, Locale.getDefault(), false, withPattern);
    }

    public static String getErrorMessageWeb(Exception e, Locale l) {
        return BankingApiMessages.getErrorMessage(e, l, true, false);
    }

    private static String getErrorMessage(Exception e, Locale l, boolean webText, boolean withPattern) {
        String ebicsErrorKey = "";
        if (e instanceof EbicsException) {
            ReturnCode ebicsExReturnCode = ((EbicsException)e).getReturnCode();
            if (ReturnCode.EBICS_AUTHENTICATION_FAILED.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_AUTHENTICATION_FAILED";
            } else if (ReturnCode.EBICS_BANK_PUBKEY_UPDATE_REQUIRED.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_BANK_PUBKEY_UPDATE_REQUIRED";
            } else if (ReturnCode.EBICS_INVALID_HOSTID.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_HOSTID";
            } else if (ReturnCode.EBICS_INVALID_ORDER_TYPE.equals(ebicsExReturnCode)) {
                ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_INVALID_ORDER_TYPE" : "GeneralMessages.error.ebics.EBICS_INVALID_ORDER_TYPE";
            } else if (ReturnCode.EBICS_INVALID_ORDER_IDENTIFIER.equals(ebicsExReturnCode)) {
                ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_INVALID_ORDER_IDENTIFIER" : "GeneralMessages.error.ebics.EBICS_INVALID_ORDER_IDENTIFIER";
            } else if (ReturnCode.EBICS_INVALID_REQUEST.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_REQUEST";
            } else if (ReturnCode.EBICS_INVALID_REQUEST_CONTENT.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_REQUEST_CONTENT";
            } else if (ReturnCode.EBICS_INVALID_USER_OR_USER_STATE.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_USER_OR_USER_STATE";
            } else if (ReturnCode.EBICS_INVALID_XML.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_XML";
            } else if (ReturnCode.EBICS_INTERNAL_ERROR.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INTERNAL_ERROR";
            } else if (ReturnCode.EBICS_UNSUPPORTED_ORDER_IDENTIFIER.equals(ebicsExReturnCode)) {
                ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_UNSUPPORTED_ORDER_IDENTIFIER" : "GeneralMessages.error.ebics.EBICS_UNSUPPORTED_ORDER_IDENTIFIER";
            } else if (ReturnCode.EBICS_UNSUPPORTED_ORDER_TYPE.equals(ebicsExReturnCode)) {
                ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_UNSUPPORTED_ORDER_TYPE" : "GeneralMessages.error.ebics.EBICS_UNSUPPORTED_ORDER_TYPE";
            } else if (AuthenticatedReturnCode.EBICS_ACCOUNT_AUTHORISATION_FAILED.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_ACCOUNT_AUTHORISATION_FAILED";
            } else if (AuthenticatedReturnCode.EBICS_AMOUNT_CHECK_FAILED.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_AMOUNT_CHECK_FAILED";
            } else if (AuthenticatedReturnCode.EBICS_AUTHORISATION_ORDER_IDENTIFIER_FAILED.equals(ebicsExReturnCode)) {
                ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_AUTHORISATION_ORDER_IDENTIFIER_FAILED" : "GeneralMessages.error.ebics.EBICS_AUTHORISATION_ORDER_IDENTIFIER_FAILED";
            } else if (AuthenticatedReturnCode.EBICS_AUTHORISATION_ORDER_TYPE_FAILED.equals(ebicsExReturnCode)) {
                ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_AUTHORISATION_ORDER_TYPE_FAILED" : "GeneralMessages.error.ebics.EBICS_AUTHORISATION_ORDER_TYPE_FAILED";
            } else if (AuthenticatedReturnCode.EBICS_DISTRIBUTED_SIGNATURE_AUTHORISATION_FAILED.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_DISTRIBUTED_SIGNATURE_AUTHORISATION_FAILED";
            } else if (AuthenticatedReturnCode.EBICS_DUPLICATE_SIGNATURE.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_DUPLICATE_SIGNATURE";
            } else if (AuthenticatedReturnCode.EBICS_KEYMGMT_KEYLENGTH_ERROR_AUTHENTICATION.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_KEYLENGTH_ERROR_AUTHENTICATION";
            } else if (AuthenticatedReturnCode.EBICS_KEYMGMT_KEYLENGTH_ERROR_ENCRYPTION.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_KEYLENGTH_ERROR_ENCRYPTION";
            } else if (AuthenticatedReturnCode.EBICS_KEYMGMT_KEYLENGTH_ERROR_SIGNATURE.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_KEYLENGTH_ERROR_SIGNATURE";
            } else if (AuthenticatedReturnCode.EBICS_KEYMGMT_UNSUPPORTED_VERSION_AUTHENTICATION.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_UNSUPPORTED_VERSION_AUTHENTICATION";
            } else if (AuthenticatedReturnCode.EBICS_KEYMGMT_UNSUPPORTED_VERSION_ENCRYPTION.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_UNSUPPORTED_VERSION_ENCRYPTION";
            } else if (AuthenticatedReturnCode.EBICS_KEYMGMT_UNSUPPORTED_VERSION_SIGNATURE.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_UNSUPPORTED_VERSION_SIGNATURE";
            } else if (AuthenticatedReturnCode.EBICS_ORDERID_ALREADY_EXISTS.equals(ebicsExReturnCode)) {
                ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_ORDERID_ALREADY_EXISTS" : "GeneralMessages.error.ebics.EBICS_ORDERID_ALREADY_EXISTS";
            } else if (AuthenticatedReturnCode.EBICS_ORDERID_ALREADY_FINAL.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_ORDERID_ALREADY_FINAL";
            } else if (AuthenticatedReturnCode.EBICS_ORDERID_UNKNOWN.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_ORDERID_UNKNOWN";
            } else if (AuthenticatedReturnCode.EBICS_PROCESSING_ERROR.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_PROCESSING_ERROR";
            } else if (AuthenticatedReturnCode.EBICS_SIGNATURE_VERIFICATION_FAILED.equals(ebicsExReturnCode)) {
                ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_SIGNATURE_VERIFICATION_FAILED";
            } else if (AuthenticatedReturnCode.EBICS_USER_UNKNOWN.equals(ebicsExReturnCode)) {
                ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_USER_UNKNOWN" : "GeneralMessages.error.ebics.EBICS_USER_UNKNOWN";
            }
        } else if (e instanceof AccountAuthorizationFailedException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_ACCOUNT_AUTHORISATION_FAILED";
        } else if (e instanceof AmountCheckFailedException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_AMOUNT_CHECK_FAILED";
        } else if (e instanceof AuthenticationFailedException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_AUTHENTICATION_FAILED";
        } else if (e instanceof AuthorisationFailedException) {
            ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_AUTHORISATION_ORDER_IDENTIFIER_FAILED" : "GeneralMessages.error.ebics.EBICS_AUTHORISATION_ORDER_IDENTIFIER_FAILED";
        } else if (e instanceof BankPubKeyUpdateRequiredException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_BANK_PUBKEY_UPDATE_REQUIRED";
        } else if (e instanceof DuplicateSignatureException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_DUPLICATE_SIGNATURE";
        } else if (e instanceof InternalErrorException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INTERNAL_ERROR";
        } else if (e instanceof UnknownHostIdException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_HOSTID";
        } else if (e instanceof InvalidOrderTypeException) {
            ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_INVALID_ORDER_TYPE" : "GeneralMessages.error.ebics.EBICS_INVALID_ORDER_TYPE";
        } else if (e instanceof InvalidRequestException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_REQUEST";
        } else if (e instanceof InvalidRequestContentException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_REQUEST_CONTENT";
        } else if (e instanceof InvalidUserOrStateException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_USER_OR_USER_STATE";
        } else if (e instanceof InvalidUserStateException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_INVALID_USER_STATE";
        } else if (e instanceof KeymgmtKeylengthErrorAuthenticationException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_KEYLENGTH_ERROR_AUTHENTICATION";
        } else if (e instanceof KeymgmtKeylengthErrorEncryptionException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_KEYLENGTH_ERROR_ENCRYPTION";
        } else if (e instanceof KeymgmtKeylengthErrorSignatureException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_KEYLENGTH_ERROR_SIGNATURE";
        } else if (e instanceof KeymgmtUnsupportedVersionAuthenticationException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_UNSUPPORTED_VERSION_AUTHENTICATION";
        } else if (e instanceof KeymgmtUnsupportedVersionEncryptionException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_UNSUPPORTED_VERSION_ENCRYPTION";
        } else if (e instanceof KeymgmtKeylengthErrorSignatureException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_KEYMGMT_KEYLENGTH_ERROR_SIGNATURE";
        } else if (e instanceof OrderIdUnknownException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_ORDERID_UNKNOWN";
        } else if (e instanceof EbicsProcessingException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_PROCESSING_ERROR";
        } else if (e instanceof SignatureVerificationFailedException) {
            ebicsErrorKey = "GeneralMessages.error.ebics.EBICS_SIGNATURE_VERIFICATION_FAILED";
        } else if (e instanceof UnsupportedOrderTypeException) {
            ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_UNSUPPORTED_ORDER_TYPE" : "GeneralMessages.error.ebics.EBICS_UNSUPPORTED_ORDER_TYPE";
        } else if (e instanceof EbicsUnknownUserException) {
            ebicsErrorKey = withPattern ? "GeneralMessages.error.ebics.pattern.EBICS_USER_UNKNOWN" : "GeneralMessages.error.ebics.EBICS_USER_UNKNOWN";
        } else {
            return e.getMessage();
        }
        if (ebicsErrorKey.isEmpty()) {
            return e.getMessage();
        }
        if (webText) {
            return BankingApiMessages.getEbicsErrorStringForWeb(l, ebicsErrorKey);
        }
        return BankingApiMessages.getString(l, ebicsErrorKey, new Object[0]);
    }

    private BankingApiMessages() {
    }
}

