/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.FetchParameterUtil;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.bank.Keybag;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.BankUserHtdInfo;
import de.businesslogics.banking.database.vo.DsBank;
import de.businesslogics.banking.database.vo.FetchFilter;
import de.businesslogics.banking.database.vo.HacEntry;
import de.businesslogics.banking.database.vo.Log;
import de.businesslogics.banking.database.vo.NotificationFilter;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PdfStatementsFilter;
import de.businesslogics.banking.database.vo.PtkEntry;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.SendFilter;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserEffectivePermission;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.database.vo.ZipFilter;
import de.businesslogics.ebics.client.BTFTranslator;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class BankUtils {
    public static boolean isDeactivated(BankUser bankUser) {
        return bankUser != null && bankUser.isDeactivated();
    }

    public static boolean isCreated(BankUser bankUser) {
        return bankUser != null && !bankUser.isDeactivated() && BankUser.UserState.CREATED.equals((Object)bankUser.getState());
    }

    public static boolean isReady(BankUser bankUser) {
        return bankUser != null && !bankUser.isDeactivated() && BankUser.UserState.READY.equals((Object)bankUser.getState());
    }

    public static boolean isLocked(BankUser bankUser) {
        return bankUser != null && !bankUser.isDeactivated() && BankUser.UserState.LOCKED.equals((Object)bankUser.getState());
    }

    public static boolean isNotUsed(BankUser bankUser) {
        return bankUser == null || !bankUser.isDeactivated() && BankUser.UserState.NOT_USED.equals((Object)bankUser.getState());
    }

    public static boolean isUsedNoINI(BankUser bankUser) {
        return bankUser != null && !bankUser.isDeactivated() && BankUser.UserState.USED_NO_INI.equals((Object)bankUser.getState());
    }

    public static boolean isKeyChangeRequired(BankUser bankUser) {
        return bankUser != null && !bankUser.isDeactivated() && BankUser.UserState.KEY_CHANGE_REQUIRED.equals((Object)bankUser.getState());
    }

    public static String getState(Locale locale, BankUser user) {
        if (user != null) {
            if (user.isDeactivated()) {
                return BankingApiMessages.getString(locale, "GeneralMessages.bank.state.deactivated", new Object[0]);
            }
            return BankUtils.getState(locale, user.getState());
        }
        return "";
    }

    public static String getState(Locale locale, BankUser.UserState state) {
        if (state != null) {
            switch (state) {
                case CREATED: {
                    return BankingApiMessages.getString(locale, "GeneralMessages.bank.state.CREATED", new Object[0]);
                }
                case READY: {
                    return BankingApiMessages.getString(locale, "GeneralMessages.bank.state.READY", new Object[0]);
                }
                case LOCKED: {
                    return BankingApiMessages.getString(locale, "GeneralMessages.bank.state.LOCKED", new Object[0]);
                }
                case NOT_USED: {
                    return BankingApiMessages.getString(locale, "GeneralMessages.bank.state.NOT_USED", new Object[0]);
                }
                case USED_NO_INI: {
                    return BankingApiMessages.getString(locale, "GeneralMessages.bank.state.USED_NO_INI", new Object[0]);
                }
                case KEY_CHANGE_REQUIRED: {
                    return BankingApiMessages.getString(locale, "GeneralMessages.bank.state.KEY_CHANGE_REQUIRED", new Object[0]);
                }
            }
        }
        return "";
    }

    public static ProtocolVersion getProtocolVersion(BankSettings bankSettings) {
        if (bankSettings != null) {
            return ProtocolVersion.getInstance(bankSettings.getProtocolVersion());
        }
        return null;
    }

    public static boolean hasExpectedHashValues(BankSettings bankSettings) {
        return bankSettings.getE001Key() == null && bankSettings.getE002Key() == null;
    }

    public static boolean isProtocolH005OrNewer(ProtocolVersion protocolVersion) {
        return protocolVersion.compareTo(ProtocolVersion.H005) >= 0;
    }

    public static boolean isProtocolH005OrNewer(String protocolVersion) {
        return protocolVersion.compareTo(ProtocolVersion.H005.getValue()) >= 0;
    }

    public static SignatureVersion getSignatureVersion(BankUser bankUser) {
        if (bankUser != null) {
            return SignatureVersion.getInstance(bankUser.getSignatureVersion());
        }
        return null;
    }

    @Deprecated
    public static String getProperFetchType(boolean isEbics30OrNewer, String fetchType) {
        return BankUtils.getProperFetchType(isEbics30OrNewer, fetchType, "DE");
    }

    public static String getProperFetchType(boolean isEbics30OrNewer, String fetchType, String countryCode) {
        String orderType;
        String defaultFetchType;
        FetchParameterUtil.StatementType statementType = FetchParameterUtil.getTypeForFetchParameter(fetchType, countryCode);
        if (statementType != null && (defaultFetchType = FetchParameterUtil.getDefaultFetchParameter(statementType, isEbics30OrNewer, countryCode)) != null) {
            return defaultFetchType;
        }
        if (isEbics30OrNewer) {
            String btf;
            if (Util.isOrderType(fetchType) && (btf = BTFTranslator.getBTFFromFetchOrderType(fetchType)) != null) {
                return btf;
            }
        } else if (BTFTranslator.isBTFString(fetchType) && (orderType = BTFTranslator.getFetchOrderTypeFromBTF(fetchType)) != null) {
            return orderType;
        }
        return fetchType;
    }

    public static String getDefaultFetchTypeFromOrderType(boolean isEbics30OrNewer, String orderType) {
        String btf;
        if (isEbics30OrNewer && (btf = BTFTranslator.getBTFFromFetchOrderType(orderType)) != null) {
            return btf;
        }
        return orderType;
    }

    public static void updateBankUser(BankUser bankUser, String newUserId, BLLogger logger) {
        if (bankUser != null) {
            String oldUserId = StringUtils.checkNullAndTrim(bankUser.getDefaultUser());
            if (newUserId != null && newUserId.length() > 0 && !newUserId.equals(oldUserId)) {
                bankUser.setDefaultUser(newUserId);
                bankUser.save();
                if (oldUserId.length() > 0) {
                    try {
                        Keybag keybag = DatabaseToken.loadKeybag(bankUser);
                        if (keybag != null) {
                            Properties properties = keybag.getProperties();
                            HashMap<CallSite, Object> newEntries = new HashMap<CallSite, Object>();
                            HashSet<String> oldKeys = new HashSet<String>();
                            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                                String key = String.valueOf(entry.getKey());
                                if (!key.startsWith(oldUserId)) continue;
                                oldKeys.add(key);
                                String newKey = newUserId + key.substring(oldUserId.length());
                                newEntries.put((CallSite)((Object)newKey), entry.getValue());
                            }
                            properties.putAll((Map<?, ?>)newEntries);
                            for (String oldKey : oldKeys) {
                                properties.remove(oldKey);
                            }
                            keybag.save();
                            logger.logInfo("Changed userId in keybag from " + oldUserId + " to " + newUserId + " for bank access with customerId " + bankUser.getBank().getCustomerId());
                        }
                    }
                    catch (Exception e) {
                        logger.logError("Could not update userId in keybag from " + oldUserId + " to " + newUserId + " for bank access with customerId " + bankUser.getBank().getCustomerId(), e);
                    }
                }
            }
        }
    }

    public static void prepareDeleteBank(BankSettings bank) {
        if (bank == null) {
            return;
        }
        UserPermission.deleteAll(bank);
        BankUserHtdInfo.deleteAll(bank);
        AccountPermission.deleteAll(bank);
        UserEffectivePermission.deleteAll(bank);
        ApOverwrite.deleteAll(bank);
        Scheduler.deleteAll(bank);
        PaymentTransferType.deleteAll(bank);
        BankUser.deleteAll(bank);
        OrderType.deleteAll(bank);
        PtkEntry.deleteAll(bank);
        HacEntry.deleteAll(bank);
        Log.deleteByBank(bank, true);
        Account.deleteAll(bank);
        DsBank.deleteAll(bank);
        FetchFilter.deleteByBank(bank);
        NotificationFilter.deleteByBank(bank);
        SendFilter.deleteByBank(bank);
        ZipFilter.deleteByBank(bank);
        PdfStatementsFilter.deleteByBank(bank);
        String uniqueKey = bank.getUniqueKey();
        List<User> allUsers = User.getAll();
        String[] fileNames = new String[]{uniqueKey + ".keybag", uniqueKey + ".pdf"};
        for (User user : allUsers) {
            String keyDirPath = user.getKeyDirectory();
            File keyDir = keyDirPath == null ? null : new File(keyDirPath);
            if (keyDir == null) continue;
            for (String fileName : fileNames) {
                File fileToDelete = new File(keyDir, fileName);
                SystemUtils.deleteFile(fileToDelete);
            }
        }
    }
}

