/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.GeneralMessages;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class BankUserCsvExport
extends AbstractCsvExport<BankSettings> {
    private final Locale locale;
    private final ArrayList<User> users;
    private ArrayList<String> userNames;

    public BankUserCsvExport(Locale locale, ArrayList<User> users) {
        this.locale = locale;
        this.users = users;
        this.userNames = new ArrayList();
        for (int pos = 0; pos < users.size(); ++pos) {
            this.userNames.add(users.get(pos).getName());
        }
    }

    private String getBankUserTooltip(BankUser bu) {
        if (bu != null) {
            if (bu.isDeactivated()) {
                return BankingApiMessages.getString(this.locale, "GeneralMessages.bank.state.deactivated", new Object[0]);
            }
            return BankingApiMessages.getString(this.locale, "GeneralMessages.bank.state." + String.valueOf((Object)bu.getState()), new Object[0]);
        }
        return "";
    }

    @Override
    protected boolean writeHeader(Writer writer) throws IOException {
        GeneralMessages messages = GeneralMessages.getInstance(this.locale);
        this.addCell(writer, messages.BANK);
        for (int pos = 0; pos < this.users.size(); ++pos) {
            this.addCell(writer, this.users.get(pos).getName());
        }
        return true;
    }

    @Override
    protected boolean writeItem(Writer writer, BankSettings bank) throws IOException {
        this.addCell(writer, bank.getDisplayName());
        List foundUsers = DB.find(BankUser.class).where().eq("bank", (Object)bank).findList();
        String[] row = new String[this.users.size()];
        for (BankUser found : foundUsers) {
            int pos = this.userNames.indexOf(found.getUser().getName());
            if (pos == -1) continue;
            StringBuilder sb = new StringBuilder();
            if (found.getDefaultUser() != null) {
                sb.append(found.getDefaultUser());
                sb.append(" ");
            }
            sb.append("(");
            sb.append(this.getBankUserTooltip(found));
            sb.append(")");
            row[pos] = sb.toString();
        }
        for (int pos = 0; pos < this.users.size(); ++pos) {
            this.addCell(writer, row[pos]);
        }
        return true;
    }
}

