/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BankServerMigration {
    private static Date SANTANDER_MIG_DATE = null;

    public static void doIt(BLLogger logger) {
        boolean testMode = false;
        if (testMode) {
            BankServerMigration.updateSantanderServer(logger);
        } else {
            Date today = new Date();
            if (!today.before(SANTANDER_MIG_DATE)) {
                BankServerMigration.updateSantanderServer(logger);
            }
        }
    }

    private static void updateSantanderServer(BLLogger logger) {
        try {
            String oldUrl = "https://ebics.santanderbank.de/ebics";
            String oldHostId = "SANEBICS";
            String newUrl = "https://www.bv-corporatebanking.de/ebics/";
            String newHostId = "SANEBICS";
            String e002Hash = "15BEA30F593D8C0A9A3FDCAA4E8F6EADBAEA41418BE58CBDB9803DF888E24472";
            String x002Hash = "E27E94E905C877EA380B22F8A1357CE4EDBAF83FAF0AB3FBEA90ECC5FDD6C99E";
            RSAPublicKey e002 = Provider.buildKey(new BigInteger("00bfa50e081b05bd20079d562a1267f8e51b6a20476d6e51c01cfa61d43aac87222d597d7ad049733bb917788a7b0c5b7f7f690c68363cf6361fca82c3eef8851bfe3d704c22d39615b6f5584445cd86e1bb20e4eda76d469fab09e5a903a6a2b5614e528b14c076cfcce16f0fa4ff1bb179f6a0799a574454184524f093cc68c1", 16), new BigInteger("010001", 16));
            RSAPublicKey x002 = Provider.buildKey(new BigInteger("00cd96e33ff4eef84a106a6361866902e45bf6441bef6c7d3775ad06f5e74ba0ced51156eb6ff96e1b35ac3b16f2c1515f1fa26a65e028df9a5a9fb18303b9a2c2892a8e137644e7736447ace0f1ae1ec468249ab3eeea874b368318c1396eceaf9fe7fdb8e1359be256f0e4f3f9fbc631d59ba86f98f0e9f66bda3fddbf323cdd", 16), new BigInteger("010001", 16));
            BankServerMigration.updateBankServer(oldUrl, oldHostId, null, newUrl, newHostId, null, null, null, null, e002, e002Hash, x002, x002Hash, logger);
        }
        catch (Exception e) {
            logger.logError("Exception in updateWirecardServer()", e);
        }
    }

    private static final void updateBankServer(String oldUrl, String oldHostId, String[] customerPrefixes, String newUrl, String newHostId, RSAPublicKey e001, String e001Hash, RSAPublicKey x001, String x001Hash, RSAPublicKey e002, String e002Hash, RSAPublicKey x002, String x002Hash, BLLogger logger) {
        block12: {
            try {
                List<BankSettings> banks = BankSettings.findByCustomerPrefixes(oldUrl, oldHostId, customerPrefixes, null);
                if (banks.size() <= 0) break block12;
                try (Transaction t = DB.beginTransaction();){
                    logger.logInfo("Found " + banks.size() + " bank connections with old URL '" + oldUrl + "' and old hostID = '" + oldHostId + "'. Update them now !");
                    for (BankSettings bank : banks) {
                        List<de.businesslogics.banking.database.vo.RSAPublicKey> keysToDelete = BankServerMigration.removeBankKeyReferences(bank);
                        bank.setExpectedDigestE001(e001Hash);
                        bank.setExpectedDigestX001(x001Hash);
                        bank.setExpectedDigestE002(e002Hash);
                        bank.setExpectedDigestX002(x002Hash);
                        bank.setUrl(newUrl);
                        bank.setHostId(newHostId);
                        bank.save();
                        if (e001Hash != null || e002Hash != null || x001Hash != null || x002Hash != null) {
                            for (de.businesslogics.banking.database.vo.RSAPublicKey key : keysToDelete) {
                                key.delete();
                            }
                        }
                        if (e001 != null || x001 != null || e002 != null || x002 != null) {
                            BankServerMigration.saveBankKeys(bank, e001, x001, e002, x002);
                        }
                        logger.logInfo("Updated bank connection with customerId '" + bank.getCustomerId() + "'. Set new URL = '" + newUrl + " and new hostID '" + newHostId + "' and deleted " + keysToDelete.size() + " keys.");
                    }
                    t.commit();
                }
            }
            catch (Exception e) {
                logger.logError("Exception in updateBankServer()", e);
            }
        }
    }

    private static final void saveBankKeys(BankSettings bank, RSAPublicKey e001, RSAPublicKey x001, RSAPublicKey e002, RSAPublicKey x002) {
        de.businesslogics.banking.database.vo.RSAPublicKey p;
        if (e001 != null) {
            p = new de.businesslogics.banking.database.vo.RSAPublicKey();
            p.setExponent(e001.getPublicExponent().toByteArray());
            p.setModulo(e001.getModulus().toByteArray());
            p.save();
            bank.setE001Key(p);
        }
        if (x001 != null) {
            p = new de.businesslogics.banking.database.vo.RSAPublicKey();
            p.setExponent(x001.getPublicExponent().toByteArray());
            p.setModulo(x001.getModulus().toByteArray());
            p.save();
            bank.setX001Key(p);
        }
        if (e002 != null) {
            p = new de.businesslogics.banking.database.vo.RSAPublicKey();
            p.setExponent(e002.getPublicExponent().toByteArray());
            p.setModulo(e002.getModulus().toByteArray());
            p.save();
            bank.setE002Key(p);
        }
        if (x002 != null) {
            p = new de.businesslogics.banking.database.vo.RSAPublicKey();
            p.setExponent(x002.getPublicExponent().toByteArray());
            p.setModulo(x002.getModulus().toByteArray());
            p.save();
            bank.setX002Key(p);
        }
        bank.save();
    }

    private static final List<de.businesslogics.banking.database.vo.RSAPublicKey> removeBankKeyReferences(BankSettings bank) {
        ArrayList<de.businesslogics.banking.database.vo.RSAPublicKey> keysToDelete = new ArrayList<de.businesslogics.banking.database.vo.RSAPublicKey>();
        de.businesslogics.banking.database.vo.RSAPublicKey e001Key = bank.getE001Key();
        bank.setE001Key(null);
        if (e001Key != null) {
            keysToDelete.add(e001Key);
        }
        de.businesslogics.banking.database.vo.RSAPublicKey x001Key = bank.getX001Key();
        bank.setX001Key(null);
        if (x001Key != null) {
            keysToDelete.add(x001Key);
        }
        de.businesslogics.banking.database.vo.RSAPublicKey e002Key = bank.getE002Key();
        bank.setE002Key(null);
        if (e002Key != null) {
            keysToDelete.add(e002Key);
        }
        de.businesslogics.banking.database.vo.RSAPublicKey x002Key = bank.getX002Key();
        bank.setX002Key(null);
        if (x002Key != null) {
            keysToDelete.add(x002Key);
        }
        return keysToDelete;
    }

    static {
        String migDate = System.getProperty("santanderServerMigrationDate", "20190414");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            SANTANDER_MIG_DATE = sdf.parse(migDate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

