/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class BankIcons {
    private static final Set<String> HIDDEN_ICONS = new HashSet<String>();
    private static final Map<String, String> REPLACED_ICONS = new HashMap<String, String>();
    private static final String FILENAME_SUFFIX = ".ico";
    private final Map<String, String> icons = new HashMap<String, String>();
    private final Map<String, String> customIcons = new HashMap<String, String>();
    private String defaultIcon = "bl";

    public BankIcons(File workspaceDirectory, BLLogger logger) {
        this.loadFromProperties(workspaceDirectory, logger);
    }

    public boolean register(String icon) {
        if (icon != null && icon.length() > 0) {
            String key = this.getKey(icon);
            if (!(HIDDEN_ICONS.contains(key) || REPLACED_ICONS.containsKey(key) || this.icons.containsKey(key))) {
                this.icons.put(key, icon);
                return true;
            }
            return false;
        }
        return false;
    }

    public List<String> getIcons() {
        ArrayList<String> sortedIcons = new ArrayList<String>();
        for (String key : this.icons.keySet()) {
            if (key.equals(this.defaultIcon)) continue;
            sortedIcons.add(key);
        }
        for (String key : this.customIcons.keySet()) {
            if (key.equals(this.defaultIcon)) continue;
            sortedIcons.add(key);
        }
        Collections.sort(sortedIcons);
        if (this.defaultIcon != null) {
            sortedIcons.add(0, this.defaultIcon);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String key : sortedIcons) {
            result.add(this.getIcon(key));
        }
        return result;
    }

    public boolean hasIcons() {
        return !this.icons.isEmpty() || !this.customIcons.isEmpty();
    }

    public String getBankIcon(BankSettings bank) {
        if (bank.getIcon() == null || bank.getIcon().length() == 0) {
            return this.getIcon(this.defaultIcon);
        }
        String result = this.getIcon(this.getKey(bank.getIcon()));
        if (result == null) {
            return this.getIcon(this.defaultIcon);
        }
        return result;
    }

    public String getBankIcon(String icon) {
        if (icon == null || icon.isEmpty()) {
            return this.getIcon(this.defaultIcon);
        }
        return this.getIcon(this.getKey(icon));
    }

    public void setBankIcon(BankSettings bank, String icon) {
        String value;
        if (icon != null && icon.length() > 0 && (value = this.getBankIcon(icon)) != null && value.length() > 0) {
            bank.setIcon(value);
            return;
        }
        bank.setIcon(this.defaultIcon);
    }

    public void setDefaultIcon(String defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    public String getDefaultIcon() {
        return this.getIcon(this.defaultIcon);
    }

    private String getKey(String icon) {
        int separatorLocation = icon.lastIndexOf(47);
        if (separatorLocation < 0) {
            separatorLocation = icon.lastIndexOf(92);
        }
        String result = separatorLocation >= 0 && separatorLocation < icon.length() - 1 ? icon.substring(separatorLocation + 1) : icon;
        if (FILENAME_SUFFIX != null && result.endsWith(FILENAME_SUFFIX)) {
            return result.substring(0, result.length() - FILENAME_SUFFIX.length()).toLowerCase();
        }
        return result.toLowerCase();
    }

    private String getIcon(String key) {
        String result = this.customIcons.get(key);
        if (result == null) {
            if (REPLACED_ICONS.containsKey(key)) {
                return this.getIcon(REPLACED_ICONS.get(key));
            }
            result = this.icons.get(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromProperties(File workspaceDirectory, BLLogger logger) {
        File propertiesFile = new File(workspaceDirectory, "bankicons.properties");
        if (!propertiesFile.isFile()) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propertiesFile);
            properties.load(inputStream);
        }
        catch (IOException e) {
            if (logger != null) {
                logger.logError("Failed to load bankicons.properties", e);
            }
            return;
        }
        finally {
            block17: {
                if (inputStream != null) {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (IOException e) {
                        if (logger == null) break block17;
                        logger.logError("Failed to close input stream on bankicon.properties", e);
                    }
                }
            }
        }
        for (Object key : properties.keySet()) {
            if (!(key instanceof String)) continue;
            String keyString = (String)key;
            String value = properties.getProperty(keyString);
            File iconFile = new File(value);
            if (!iconFile.isFile()) {
                iconFile = new File(workspaceDirectory, value);
            }
            if (!iconFile.isFile()) continue;
            this.customIcons.put(keyString, iconFile.getAbsolutePath());
        }
    }

    static {
        HIDDEN_ICONS.add("bremer");
        HIDDEN_ICONS.add("bwbank");
        HIDDEN_ICONS.add("deutschebank");
        HIDDEN_ICONS.add("helaba");
        HIDDEN_ICONS.add("hsbc");
        HIDDEN_ICONS.add("lbbw");
        HIDDEN_ICONS.add("nlb");
        HIDDEN_ICONS.add("warburg");
        REPLACED_ICONS.put("haspa", "sparkasse");
        REPLACED_ICONS.put("lbb", "sparkasse");
        REPLACED_ICONS.put("mvb", "volksbank");
        REPLACED_ICONS.put("spkbremen", "sparkasse");
        REPLACED_ICONS.put("z_aqua", "z_black");
        REPLACED_ICONS.put("z_purple", "z_brown");
    }
}

