/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.BankInfo;
import de.businesslogics.account.BankInfoCache;
import de.businesslogics.account.Result;
import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class BLZCache {
    private static final String currentFile = "/BLZ2_20250609.txt";
    public static Date dateOfUsedBLZFile;
    public static Date dateOfNewestBLZFile;
    public static BankInfoCache CACHE;
    private static BLLogger LOGGER;

    private BLZCache() {
    }

    public static void initialize(File workspace, BLLogger logger) {
        LOGGER = logger;
        File newestFile = null;
        try {
            SimpleDateFormat blz2Sdf = new SimpleDateFormat("'/BLZ2_'yyyyMMdd'.txt'");
            Date today = new Date();
            try {
                dateOfNewestBLZFile = dateOfUsedBLZFile = blz2Sdf.parse(currentFile);
            }
            catch (ParseException parse) {
                LOGGER.logError("Error parsing BLZ filenames", parse);
            }
            InputStream in = null;
            File[] blzs = workspace.listFiles((dir, name) -> name.matches("blz[0-9]{8}\\.txt") || name.matches("BLZ_[0-9]{8}\\.txt") || name.matches("BLZ2_[0-9]{8}\\.txt") || name.matches("blz_[0-9]{4}_[0-9]{2}_[0-9]{2}_txt\\.txt"));
            if (blzs != null && blzs.length > 0) {
                SimpleDateFormat[] sdfs = new SimpleDateFormat[]{new SimpleDateFormat("'blz'yyyyMMdd'.txt'"), new SimpleDateFormat("'BLZ_'yyyyMMdd'.txt'"), new SimpleDateFormat("'BLZ2_'yyyyMMdd'.txt'"), new SimpleDateFormat("'blz_'yyyy_MM_dd'_txt.txt'")};
                for (File blz : blzs) {
                    String name2 = blz.getName();
                    try {
                        SimpleDateFormat sdf = name2.length() == 15 ? sdfs[0] : (name2.length() == 16 ? sdfs[1] : (name2.length() == 17 ? sdfs[2] : sdfs[3]));
                        Date d = sdf.parse(name2);
                        if (d.after(dateOfUsedBLZFile)) {
                            if (!d.after(today)) {
                                dateOfUsedBLZFile = d;
                                newestFile = blz;
                            }
                            if (!dateOfNewestBLZFile.before(d)) continue;
                            dateOfNewestBLZFile = d;
                            continue;
                        }
                        if (blz.delete()) continue;
                        blz.deleteOnExit();
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                if (newestFile != null) {
                    in = new FileInputStream(newestFile);
                }
            }
            if (in == null) {
                in = BLZCache.class.getResourceAsStream(currentFile);
            }
            CACHE = in != null ? new BankInfoCache(in) : new BankInfoCache(new ArrayList<BankInfo>());
        }
        catch (Exception e) {
            LOGGER.logError("Error reading BLZ file", e);
            BLZCache.useOriginalBLZFile();
            newestFile.renameTo(new File(newestFile.getAbsolutePath() + "_old"));
        }
    }

    public static Result checkAccountNumber(String blz, String accountNumber) {
        BankInfo info = CACHE.findByBankCode(blz);
        if (info == null) {
            return null;
        }
        AccountCheckAlgorithm a = AccountCheckAlgorithm.get(info.getCheckDigit());
        if (a == null) {
            return null;
        }
        try {
            return a.check(accountNumber, blz);
        }
        catch (Exception e) {
            LOGGER.logError(e.getMessage(), e);
            return Result.UNKNOWN;
        }
    }

    public static String getIban(String blz, String accNumber) {
        return CACHE.getIban(blz, accNumber);
    }

    public static SEPABankConnection getSEPABankConnection(String blz, String accNumber) {
        SEPABankConnection sbc = CACHE.getSEPABankConnection(blz, accNumber);
        if (sbc == null) {
            LOGGER.logInfo("Could not determine IBAN and BIC from BLZ = '" + blz + "' and AccNumber = '" + accNumber + "'");
        }
        return sbc;
    }

    public static String getBankName(String blz) {
        BankInfo bi;
        if (blz != null && (bi = CACHE.findByBankCode(blz)) != null) {
            return bi.getName();
        }
        return null;
    }

    public static String getBankNameFromIBAN(String iban) {
        if (IbanUtil.isGermanIban(iban)) {
            return BLZCache.getBankName(iban.substring(4, 12));
        }
        return null;
    }

    private static void useOriginalBLZFile() {
        InputStream in = BLZCache.class.getResourceAsStream(currentFile);
        if (in != null) {
            try {
                CACHE = new BankInfoCache(in);
            }
            catch (IOException e) {
                e.printStackTrace();
                CACHE = new BankInfoCache(new ArrayList<BankInfo>());
            }
        } else {
            CACHE = new BankInfoCache(new ArrayList<BankInfo>());
        }
    }
}

