/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.pdf.Alignment;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.util.Currency;
import de.businesslogics.util.PaymentUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;

public class AmountsSum {
    private final HashMap<Currency, BigDecimal> sums = new HashMap();
    private final HashMap<Currency, Integer> counts = new HashMap();

    public void addAmount(BigDecimal amount, Currency currency) {
        BigDecimal sum = this.sums.get(currency);
        if (sum == null) {
            sum = BigDecimal.ZERO;
        }
        this.sums.put(currency, sum.add(amount));
        Integer i = this.counts.get(currency);
        if (i == null) {
            i = 0;
        }
        this.counts.put(currency, i + 1);
    }

    public BLTable<?> addSumCells(BLTable<?> table, int colNumber, Locale locale) throws PDFException {
        return this.addSumCells(table, colNumber, BLFont.FONT_BOLD, locale);
    }

    public BLTable<?> addSumCells(BLTable<?> table, int colNumber, BLFont font, Locale locale) throws PDFException {
        if (!this.sums.isEmpty()) {
            for (Currency c : this.sums.keySet()) {
                if (colNumber > 2) {
                    table.setDefaultColspan(colNumber - 1);
                }
                table.setHorizontalAlignment(Alignment.ALIGN_RIGHT);
                Integer count = this.counts.get(c);
                if (this.sums.size() > 1) {
                    table.addCell(BankingApiMessages.getString(locale, "AmountSums.sum.currency", count, c), font);
                } else {
                    table.addCell(BankingApiMessages.getString(locale, "AmountSums.sum", count), font);
                }
                table.setDefaultColspan(1);
                table.addCell(PaymentUtils.formatAmount(this.sums.get(c), c, locale), font);
            }
        }
        return table;
    }
}

