/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.util.BLLogger;
import java.text.MessageFormat;

public class AdminLogger {
    private final BLLogger logger;

    public AdminLogger(BLLogger logger) {
        this.logger = logger;
    }

    public void logAdminLoginSuccessful(User admin, String ipAddress, Yubikey.SecurityType securityType) {
        if (securityType != null) {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has logged in successfully from IP {2}. Using a {3}.", new Object[]{admin.getName(), admin.getId(), ipAddress, securityType}));
        } else {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has logged in successfully from IP {2}.", admin.getName(), admin.getId(), ipAddress));
        }
        Logger.logAdminLoginSuccessful(admin, ipAddress);
    }

    public void logAdminLoginFailed(User admin, String reason, String ipAddress) {
        if (reason != null && !reason.isEmpty()) {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) failed to log in: {2} (IP: {3})", admin.getName(), admin.getId(), reason, ipAddress));
        } else {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) failed to log in.", admin.getName(), admin.getId()));
        }
        Logger.logAdminLoginFailed(admin, reason, ipAddress);
    }

    public void logAdminLocked(User admin, String ipAddress) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has been locked. (IP: {2})", admin.getName(), admin.getId(), ipAddress));
        Logger.logAdminLocked(admin, ipAddress);
    }

    public void logBankCreated(User admin, BankSettings bank) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has created bank \"{2}\" (ID={3}).", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId()));
        Logger.logBankCreated(admin, bank);
    }

    public void logBankModified(User admin, BankSettings bank) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has modified bank \"{2}\" (ID={3}).", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId()));
        Logger.logBankModified(admin, bank);
    }

    public void logBankDeleted(User admin, BankSettings bank) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has deleted bank \"{2}\" (ID={3}).", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId()));
        Logger.logBankDeleted(admin, bank);
    }

    public void logBankAddedUser(User admin, User user, BankSettings bank) {
        this.logger.logInfo(MessageFormat.format(this.getUserAddedToBankMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId(), bank.getDisplayName(), bank.getBankId()));
        Logger.logBankAddedUser(admin, user, bank);
    }

    private String getUserAddedToBankMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has added local user \"{2}\" (ID={3}) with admin permissions to bank \"{4}\" (ID={5}).";
            }
            return "\"{0}\" (ID={1}) has added local user \"{2}\" (ID={3}) to bank \"{4}\" (ID={5}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has added user \"{2}\" (ID={3}) with admin permissions to bank \"{4}\" (ID={5}).";
        }
        return "\"{0}\" (ID={1}) has added user \"{2}\" (ID={3}) to bank \"{4}\" (ID={5}).";
    }

    public void logBankRemovedUser(User admin, User user, BankSettings bank) {
        this.logger.logInfo(MessageFormat.format(this.getUserRemovedFromBankMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId(), bank.getDisplayName(), bank.getBankId()));
        Logger.logBankRemovedUser(admin, user, bank);
    }

    private String getUserRemovedFromBankMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has removed local user \"{2}\" (ID={3}) with admin permissions from bank \"{4}\" (ID={5}).";
            }
            return "\"{0}\" (ID={1}) has removed local user \"{2}\" (ID={3}) from bank \"{4}\" (ID={5}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has removed user \"{2}\" (ID={3}) with admin permissions from bank \"{4}\" (ID={5}).";
        }
        return "\"{0}\" (ID={1}) has removed user \"{2}\" (ID={3}) from bank \"{4}\" (ID={5}).";
    }

    public void logUserChangedDefaultUser(User admin, User user, BankSettings bank, String newDefaultUser) {
        if (newDefaultUser == null || newDefaultUser.isEmpty()) {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has removed the subscriber ID for user \"{2}\" (ID={3}) with the bank \"{4}\" (ID={5}).", admin.getName(), admin.getId(), user.getName(), user.getId(), bank.getDisplayName(), bank.getBankId()));
        } else {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has changed the subscriber ID for user \"{2}\" (ID={3}) with the bank \"{4}\" (ID={5}) to \"{6}\".", admin.getName(), admin.getId(), user.getName(), user.getId(), bank.getDisplayName(), bank.getBankId(), newDefaultUser));
        }
    }

    public void logBankRenamed(User admin, BankSettings bank, String oldName) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has renamed bank \"{2}\" (ID={3}) to \"{4}\".", admin.getName(), admin.getId(), oldName, bank.getBankId(), bank.getDisplayName()));
        Logger.logBankModified(admin, bank, Logger.BankField.NAME, oldName);
    }

    public void logBankUrlChanged(User admin, BankSettings bank, String oldUrl) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has changed URL of bank \"{2}\" (ID={3}) from \"{4}\" to \"{5}\".", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), oldUrl, bank.getUrl()));
        Logger.logBankModified(admin, bank, Logger.BankField.URL, oldUrl);
    }

    public void logBankHostIdChanged(User admin, BankSettings bank, String oldHostId) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has changed host ID of bank \"{2}\" (ID={3}) from \"{4}\" to \"{5}\".", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), oldHostId, bank.getHostId()));
        Logger.logBankModified(admin, bank, Logger.BankField.HOST_ID, oldHostId);
    }

    public void logBankCountryChanged(User admin, BankSettings bank, String oldCountry) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has changed country of bank \"{2}\" (ID={3}) from \"{4}\" to \"{5}\".", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), oldCountry, bank.getCountryCode()));
        Logger.logBankModified(admin, bank, Logger.BankField.COUNTRY, oldCountry);
    }

    public void logBankCustomerIdChanged(User admin, BankSettings bank, String oldCustomerId) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has changed customer ID of bank \"{2}\" (ID={3}) from \"{4}\" to \"{5}\".", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), oldCustomerId, bank.getCustomerId()));
        Logger.logBankModified(admin, bank, Logger.BankField.CUSTOMER_ID, oldCustomerId);
    }

    public void logBankTransportOnlyChanged(User admin, BankSettings bank) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has set the \"transport only\" flag for bank \"{2}\" (ID={3}) to \"{4}\".", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), bank.getTransportOnly()));
        Logger.logBankModified(admin, bank, Logger.BankField.TRANSPORT_ONLY, String.valueOf(bank.getTransportOnly() == false));
    }

    public void logBankVopActivatedChanged(User admin, BankSettings bank) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has set the \"VOP activated\" flag for bank \"{2}\" (ID={3}) to \"{4}\".", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), bank.isVopActivated()));
        Logger.logBankModified(admin, bank, Logger.BankField.VOP_ACTIVATED, String.valueOf(!bank.isVopActivated()));
    }

    public void logBankVopMandatoryChanged(User admin, BankSettings bank) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has set the \"VOP mandatory\" flag for bank \"{2}\" (ID={3}) to \"{4}\".", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), bank.isVopMandatory()));
        Logger.logBankModified(admin, bank, Logger.BankField.VOP_MANDATORY, String.valueOf(!bank.isVopMandatory()));
    }

    public void logEbicsVersionChanged(User admin, BankSettings bank, String oldVersion) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has changed EBICS version of bank \"{2}\" (ID={3}) from \"{4}\" to \"{5}\".", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), oldVersion, bank.getProtocolVersion()));
        Logger.logBankModified(admin, bank, Logger.BankField.EBICS_VERSION, oldVersion);
    }

    public void logBankDigestModified(User admin, String keyType, BankSettings bank, String newHash) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has changed expected {2} hash of bank \"{3}\" (ID={4}) to \"{5}\".", admin.getName(), admin.getId(), keyType, bank.getDisplayName(), bank.getBankId(), newHash));
        Logger.logBankModified(admin, bank, Logger.BankField.valueOf(keyType + "_DIGEST"), newHash);
    }

    public void logBankMovedToTenant(User admin, BankSettings bank, Tenant oldTenant) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has moved bank \"{2}\" (ID={3}) from tenant \"{4}\" (ID={5}) to \"{6}\" (ID={7}).", admin.getName(), admin.getId(), bank.getDisplayName(), bank.getBankId(), oldTenant.getName(), oldTenant.getId(), bank.getTenant().getName(), bank.getTenant().getId()));
        Logger.logBankMovedToTenant(admin, bank, oldTenant);
    }

    public void logUserCreated(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getUserCreatedMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserCreated(admin, user);
    }

    private String getUserCreatedMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has created local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has created local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has created user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has created user \"{2}\" (ID={3}).";
    }

    public void logUserModified(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getUserModifiedMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserModified(admin, user);
    }

    private String getUserModifiedMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has modified local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has modified local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has modified user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has modified user \"{2}\" (ID={3}).";
    }

    public void logUserDeleted(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getUserDeletedMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserDeleted(admin, user);
    }

    private String getUserDeletedMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has deleted local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has deleted local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has deleted user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has deleted user \"{2}\" (ID={3}).";
    }

    public void logUserReset(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getUserResetMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserReset(admin, user);
    }

    private String getUserResetMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has reset local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has reset local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has reset user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has reset user \"{2}\" (ID={3}).";
    }

    public void logUserLocked(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getUserLockedMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserLocked(admin, user);
    }

    private String getUserLockedMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has locked local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has locked local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has locked user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has locked user \"{2}\" (ID={3}).";
    }

    public void logUserResetErrorCounter(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getUserResetErrorCounterMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserResetErrorCounter(admin, user);
    }

    private String getUserResetErrorCounterMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has reset password error counter for local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has reset password error counter for local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has reset password error counter for user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has reset password error counter for user \"{2}\" (ID={3}).";
    }

    public void logUserRenamed(User admin, User user, String oldName) {
        this.logger.logInfo(MessageFormat.format(this.getUserRenamedMessage(user), admin.getName(), admin.getId(), oldName, user.getId(), user.getName()));
        Logger.logUserRenamed(admin, user, oldName);
    }

    private String getUserRenamedMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has renamed local user \"{2}\" (ID={3}) with admin permissions to \"{4}\".";
            }
            return "\"{0}\" (ID={1}) has renamed local user \"{2}\" (ID={3}) to \"{4}\".";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has renamed user \"{2}\" (ID={3}) with admin permissions to \"{4}\".";
        }
        return "\"{0}\" (ID={1}) has renamed user \"{2}\" (ID={3}) to \"{4}\".";
    }

    public void logUserChangedAdminPrivileges(User admin, User user) {
        if (user.isAdmin()) {
            this.logUserGrantedAdminPrivileges(admin, user);
        } else {
            this.logUserRemovedAdminPrivileges(admin, user);
        }
    }

    public void logUserGrantedAdminPrivileges(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getUserGrantedAdminPrivilegesMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserChangedAdminPrivileges(admin, user);
    }

    private String getUserGrantedAdminPrivilegesMessage(User user) {
        if (user.isLocalUser()) {
            return "\"{0}\" (ID={1}) has granted admin privileges to local user \"{2}\" (ID={3}).";
        }
        return "\"{0}\" (ID={1}) has granted admin privileges to user \"{2}\" (ID={3}).";
    }

    public void logUserRemovedAdminPrivileges(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getUserRemovedAdminPrivilegesMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserChangedAdminPrivileges(admin, user);
    }

    private String getUserRemovedAdminPrivilegesMessage(User user) {
        if (user.isLocalUser()) {
            return "\"{0}\" (ID={1}) has removed admin privileges from local user \"{2}\" (ID={3}).";
        }
        return "\"{0}\" (ID={1}) has removed admin privileges from user \"{2}\" (ID={3}).";
    }

    public void logUserChangedPermission(User admin, User user, String permissionShortDescription, boolean newValue) {
        if (newValue) {
            this.logUserGrantedPermission(admin, user, permissionShortDescription);
        } else {
            this.logUserRemovedPermission(admin, user, permissionShortDescription);
        }
    }

    public void logUserGrantedPermission(User admin, User user, String permissionShortDescription) {
        this.logger.logInfo(MessageFormat.format(this.getUserGrantedPermissionMessage(user), admin.getName(), admin.getId(), permissionShortDescription, user.getName(), user.getId()));
        Logger.logUserChangedPermission(admin, user, permissionShortDescription, true);
    }

    private String getUserGrantedPermissionMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has granted the permission to {2} to local user \"{3}\" (ID={4}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has granted the permission to {2} to local user \"{3}\" (ID={4}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has granted the permission to {2} to user \"{3}\" (ID={4}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has granted the permission to {2} to user \"{3}\" (ID={4}).";
    }

    public void logUserRemovedPermission(User admin, User user, String permissionShortDescription) {
        this.logger.logInfo(MessageFormat.format(this.getUserRemovedPermissionMessage(user), admin.getName(), admin.getId(), permissionShortDescription, user.getName(), user.getId()));
        Logger.logUserChangedPermission(admin, user, permissionShortDescription, false);
    }

    private String getUserRemovedPermissionMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has removed the permission to {2} for local user \"{3}\" (ID={4}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has removed the permission to {2} for local user \"{3}\" (ID={4}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has removed the permission to {2} for user \"{3}\" (ID={4}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has removed the permission to {2} for user \"{3}\" (ID={4}).";
    }

    public void logUserChangedSalaryPermission(User admin, User user, String newPermissionKey) {
        this.logger.logInfo(MessageFormat.format(this.getUserChangedSalaryPermissionMessage(user, newPermissionKey), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logUserChangedSalaryPermission(admin, user, newPermissionKey);
    }

    private String getUserChangedSalaryPermissionMessage(User user, String newPermissionKey) {
        switch (newPermissionKey) {
            case "0": {
                if (user.isLocalUser()) {
                    if (user.isAdmin()) {
                        return "\"{0}\" (ID={1}) has granted all salary payment permissions for local user \"{2}\" (ID={3}) with admin permissions.";
                    }
                    return "\"{0}\" (ID={1}) has granted all salary payment permissions for local user \"{2}\" (ID={3}).";
                }
                if (user.isAdmin()) {
                    return "\"{0}\" (ID={1}) has granted all salary payment permissions for user \"{2}\" (ID={3}) with admin permissions.";
                }
                return "\"{0}\" (ID={1}) has granted all salary payment permissions for user \"{2}\" (ID={3}).";
            }
            case "1": {
                if (user.isLocalUser()) {
                    if (user.isAdmin()) {
                        return "\"{0}\" (ID={1}) has set permissions to sign, but not see or create salary payments for local user \"{2}\" (ID={3}) with admin permissions.";
                    }
                    return "\"{0}\" (ID={1}) has set permissions to sign, but not see or create salary payments for local user \"{2}\" (ID={3}).";
                }
                if (user.isAdmin()) {
                    return "\"{0}\" (ID={1}) has set permissions to sign, but not see or create salary payments for user \"{2}\" (ID={3}) with admin permissions.";
                }
                return "\"{0}\" (ID={1}) has set permissions to sign, but not see or create salary payments for user \"{2}\" (ID={3}).";
            }
            case "2": {
                if (user.isLocalUser()) {
                    if (user.isAdmin()) {
                        return "\"{0}\" (ID={1}) has removed all salary payment permissions for local user \"{2}\" (ID={3}) with admin permissions.";
                    }
                    return "\"{0}\" (ID={1}) has removed all salary payment permissions for local user \"{2}\" (ID={3}).";
                }
                if (user.isAdmin()) {
                    return "\"{0}\" (ID={1}) has removed all salary payment permissions for user \"{2}\" (ID={3}) with admin permissions.";
                }
                return "\"{0}\" (ID={1}) has removed all salary payment permissions for user \"{2}\" (ID={3}).";
            }
        }
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has modified salary payment permissions for local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has modified salary payment permissions for local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has modified salary payment permissions for user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has modified salary payment permissions for user \"{2}\" (ID={3}).";
    }

    public void logTenantCreated(User admin, Tenant tenant) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has created tenant \"{2}\" (ID={3}).", admin.getName(), admin.getId(), tenant.getName(), tenant.getId()));
        Logger.logTenantCreated(admin, tenant);
    }

    public void logTenantDeleted(User admin, Tenant tenant) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has deleted tenant \"{2}\" (ID={3}).", admin.getName(), admin.getId(), tenant.getName(), tenant.getId()));
        Logger.logTenantDeleted(admin, tenant);
    }

    public void logTenantRenamed(User admin, Tenant tenant, String oldName) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has renamed tenant \"{2}\" (ID={3}) to \"{4}\".", admin.getName(), admin.getId(), oldName, tenant.getId(), tenant.getName()));
        Logger.logTenantRenamed(admin, tenant, oldName);
    }

    public void logTenantChangedUserLimit(User admin, Tenant tenant, Integer oldLimit) {
        this.logger.logInfo(MessageFormat.format(this.getTenantChangedUserLimitMessage(oldLimit, tenant.getUserCount()), admin.getName(), admin.getId(), tenant.getName(), tenant.getId(), oldLimit, tenant.getUserCount()));
        Logger.logTenantChangedUserLimit(admin, tenant, oldLimit);
    }

    private String getTenantChangedUserLimitMessage(Integer oldLimit, Integer newLimit) {
        if (oldLimit == null) {
            return "\"{0}\" (ID={1}) has set the user limit for tenant \"{2}\" (ID={3}) to {5}.";
        }
        if (newLimit == null) {
            return "\"{0}\" (ID={1}) has removed the user limit for tenant \"{2}\" (ID={3}).";
        }
        return "\"{0}\" (ID={1}) has changed the user limit for tenant \"{2}\" (ID={3}) from {4} to {5}.";
    }

    public void logTenantAddedUser(User admin, User user, Tenant tenant) {
        this.logger.logInfo(MessageFormat.format(this.getUserAddedToTenantMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId(), tenant.getName(), tenant.getId()));
        Logger.logTenantAddedUser(admin, user, tenant);
    }

    private String getUserAddedToTenantMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has added local user \"{2}\" (ID={3}) with admin permissions to tenant \"{4}\" (ID={5}).";
            }
            return "\"{0}\" (ID={1}) has added local user \"{2}\" (ID={3}) to tenant \"{4}\" (ID={5}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has added user \"{2}\" (ID={3}) with admin permissions to tenant \"{4}\" (ID={5}).";
        }
        return "\"{0}\" (ID={1}) has added user \"{2}\" (ID={3}) to tenant \"{4}\" (ID={5}).";
    }

    public void logTenantDroppedUser(User admin, User user, Tenant tenant) {
        this.logger.logInfo(MessageFormat.format(this.getUserDroppedFromTenantMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId(), tenant.getName(), tenant.getId()));
        Logger.logTenantDroppedUser(admin, user, tenant);
    }

    private String getUserDroppedFromTenantMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has removed local user \"{2}\" (ID={3}) with admin permissions from tenant \"{4}\" (ID={5}).";
            }
            return "\"{0}\" (ID={1}) has removed local user \"{2}\" (ID={3}) from tenant \"{4}\" (ID={5}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has removed user \"{2}\" (ID={3}) with admin permissions from tenant \"{4}\" (ID={5}).";
        }
        return "\"{0}\" (ID={1}) has removed user \"{2}\" (ID={3}) from tenant \"{4}\" (ID={5}).";
    }

    public void logTenantGrantManagingUserPrivileges(User admin, User user, Tenant tenant) {
        this.logger.logInfo(MessageFormat.format(this.getTenantUserAddedToManagingUsersMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId(), tenant.getName(), tenant.getId()));
        Logger.logTenantGrantManagingUserPrivileges(admin, user, tenant);
    }

    private String getTenantUserAddedToManagingUsersMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has granted managing user privileges to local user \"{2}\" (ID={3}) with admin permissions for tenant \"{4}\" (ID={5}).";
            }
            return "\"{0}\" (ID={1}) has granted managing user privileges to local user \"{2}\" (ID={3}) for tenant \"{4}\" (ID={5}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has granted managing user privileges to user \"{2}\" (ID={3}) with admin permissions for tenant \"{4}\" (ID={5}).";
        }
        return "\"{0}\" (ID={1}) has granted managing user privileges to user \"{2}\" (ID={3}) for tenant \"{4}\" (ID={5}).";
    }

    public void logTenantRemoveManagingUserPrivileges(User admin, User user, Tenant tenant) {
        this.logger.logInfo(MessageFormat.format(this.getTenantUserRemovedFromManagingUsersMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId(), tenant.getName(), tenant.getId()));
        Logger.logTenantRemoveManagingUserPrivileges(admin, user, tenant);
    }

    private String getTenantUserRemovedFromManagingUsersMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has removed managing user privileges from local user \"{2}\" (ID={3}) with admin permissions for tenant \"{4}\" (ID={5}).";
            }
            return "\"{0}\" (ID={1}) has removed managing user privileges from local user \"{2}\" (ID={3}) for tenant \"{4}\" (ID={5}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has removed managing user privileges from user \"{2}\" (ID={3}) with admin permissions for tenant \"{4}\" (ID={5}).";
        }
        return "\"{0}\" (ID={1}) has removed managing user privileges from user \"{2}\" (ID={3}) for tenant \"{4}\" (ID={5}).";
    }

    public void logDeletedAllYubikeysForUser(User admin, User user) {
        this.logger.logInfo(MessageFormat.format(this.getDeleteAllYubikeysForUserMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logDeletedAllYubikeysForUser(admin, user);
    }

    private String getDeleteAllYubikeysForUserMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has removed all authentication keys for local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has removed all authentication keys for local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has removed all authentication keys for user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has removed all authentication keys for user \"{2}\" (ID={3}).";
    }

    public void logYubikeyAdded(User admin, User user, Yubikey yubikey) {
        this.logger.logInfo(MessageFormat.format(this.getYubikeyAddedMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logYubikeyAdded(admin, user, yubikey);
    }

    private String getYubikeyAddedMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has added an authentication key for local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has added an authentication key for local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has added an authentication key for user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has added an authentication key for user \"{2}\" (ID={3}).";
    }

    public void logYubikeyDeleted(User admin, User user, Yubikey yubikey) {
        this.logger.logInfo(MessageFormat.format(this.getYubikeyDeletedMessage(user), admin.getName(), admin.getId(), user.getName(), user.getId()));
        Logger.logYubikeyDeleted(admin, user, yubikey);
    }

    private String getYubikeyDeletedMessage(User user) {
        if (user.isLocalUser()) {
            if (user.isAdmin()) {
                return "\"{0}\" (ID={1}) has deleted an authentication key for local user \"{2}\" (ID={3}) with admin permissions.";
            }
            return "\"{0}\" (ID={1}) has deleted an authentication key for local user \"{2}\" (ID={3}).";
        }
        if (user.isAdmin()) {
            return "\"{0}\" (ID={1}) has deleted an authentication key for user \"{2}\" (ID={3}) with admin permissions.";
        }
        return "\"{0}\" (ID={1}) has deleted an authentication key for user \"{2}\" (ID={3}).";
    }

    public void logDirectoryScannerCreated(User admin, DirectoryScanner directoryScanner) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has created a directory scanner (ID={2}) for bank \"{3}\" (ID={4}) on directory \"{5}\".", admin.getName(), admin.getId(), directoryScanner.getId(), directoryScanner.getBank().getDisplayName(), directoryScanner.getBank().getBankId(), directoryScanner.getDirectory()));
        Logger.logDirectoryScannerCreated(admin, directoryScanner);
    }

    public void logDirectoryScannerDeleted(User admin, DirectoryScanner directoryScanner) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has deleted a directory scanner (ID={2}) for bank \"{3}\" (ID={4}) on directory \"{5}\".", admin.getName(), admin.getId(), directoryScanner.getId(), directoryScanner.getBank().getDisplayName(), directoryScanner.getBank().getBankId(), directoryScanner.getDirectory()));
        Logger.logDirectoryScannerDeleted(admin, directoryScanner);
    }

    public void logDirectoryScannerChangedBank(User admin, DirectoryScanner directoryScanner, BankSettings oldBank) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has modified a directory scanner (ID={2}) and changed the bank from \"{3}\" (ID={4}) to \"{5}\" (ID={6}).", admin.getName(), admin.getId(), directoryScanner.getId(), oldBank.getDisplayName(), oldBank.getBankId(), directoryScanner.getBank().getDisplayName(), directoryScanner.getBank().getBankId()));
        Logger.logDirectoryScannerChanged(admin, directoryScanner, Logger.DirectoryScannerField.BANK, oldBank.getDisplayName(), directoryScanner.getBank().getDisplayName());
    }

    public void logDirectoryScannerChangedDirectory(User admin, DirectoryScanner directoryScanner, String oldDirectory) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has modified a directory scanner (ID={2}) and changed the directory from \"{3}\" to \"{4}\".", admin.getName(), admin.getId(), directoryScanner.getId(), oldDirectory, directoryScanner.getDirectory()));
        Logger.logDirectoryScannerChanged(admin, directoryScanner, Logger.DirectoryScannerField.DIRECTORY, oldDirectory, directoryScanner.getDirectory());
    }

    public void logDirectoryScannerChangedRegex(User admin, DirectoryScanner directoryScanner, String oldRegex) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has modified a directory scanner (ID={2}) and changed the file regex from \"{3}\" to \"{4}\".", admin.getName(), admin.getId(), directoryScanner.getId(), oldRegex, directoryScanner.getRegEx()));
        Logger.logDirectoryScannerChanged(admin, directoryScanner, Logger.DirectoryScannerField.REG_EX, oldRegex, directoryScanner.getRegEx());
    }

    public void logDirectoryScannerChangedArchiveDir(User admin, DirectoryScanner directoryScanner, String oldArchiveDir) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has modified a directory scanner (ID={2}) and changed the archive directory from \"{3}\" to \"{4}\".", admin.getName(), admin.getId(), directoryScanner.getId(), oldArchiveDir, directoryScanner.getArchiveDirectory()));
        Logger.logDirectoryScannerChanged(admin, directoryScanner, Logger.DirectoryScannerField.ARCHIVE_DIR, oldArchiveDir, directoryScanner.getArchiveDirectory());
    }

    public void logDirectoryScannerChangedOrderOrFileType(User admin, DirectoryScanner directoryScanner, String oldOrderOrFileType) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has modified a directory scanner (ID={2}) and changed the order/file type from \"{3}\" to \"{4}\".", admin.getName(), admin.getId(), directoryScanner.getId(), oldOrderOrFileType, directoryScanner.getOrderOrFileType()));
        Logger.logDirectoryScannerChanged(admin, directoryScanner, Logger.DirectoryScannerField.ORDER_OR_FILE_TYPE, oldOrderOrFileType, directoryScanner.getOrderOrFileType());
    }

    public void logAccountModified(User admin, int accountId) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has modified the account with ID={2}.", admin.getName(), admin.getId(), accountId));
    }

    public void logPreferencesModified(User admin, int counter) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has modified {2} preference setting(s):", admin.getName(), admin.getId(), counter));
    }

    public void logPreferenceModifiedDetail(User admin, Tenant tenant, DatabasePreferenceConstant prefKey, String oldValue, String newValue) {
        if (tenant == null) {
            this.logPreferenceModifiedDetail(admin, prefKey, oldValue, newValue);
            return;
        }
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has set the value \"{2}\" for preference {3} for tenant \"{4}\" (ID={5}).", admin.getName(), admin.getId(), newValue, prefKey.toString(), tenant.getName(), tenant.getId()));
        Logger.logPreferenceModifiedDetail(admin, tenant, prefKey, oldValue, newValue);
    }

    public void logPreferenceModifiedDetail(User admin, DatabasePreferenceConstant prefKey, String oldValue, String newValue) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has set the value \"{2}\" for preference {3}.", admin.getName(), admin.getId(), newValue, prefKey.toString()));
        Logger.logPreferenceModifiedDetail(admin, prefKey, oldValue, newValue);
    }

    public void logPreferencesCleanedUpTransfers(User admin) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has executed a transfer data cleanup.", admin.getName(), admin.getId()));
        Logger.logPreferencesCleanedUpTransfers(admin);
    }

    public void logPreferencesCleanedUpDes(User admin) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has executed a EDS/VEU data cleanup.", admin.getName(), admin.getId()));
        Logger.logPreferencesCleanedUpDes(admin);
    }

    public void logPreferencesCleanedUpCm(User admin) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has executed a CM data cleanup.", admin.getName(), admin.getId()));
        Logger.logPreferencesCleanedUpCm(admin);
    }

    public void logDatabaseMigrationStarted(User admin, String dbTypeName, String url, String dbUserName) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has startet a database migration to {2} with URL \"{3}\" and database user \"{4}\".", admin.getName(), admin.getId(), dbTypeName, url, dbUserName));
        Logger.logDatabaseMigrationStarted(admin, dbTypeName, url, dbUserName);
    }

    public void logDatabaseMigrationFinishedError(User admin, String dbTypeName, String url, String dbUserName) {
        this.logger.logInfo(MessageFormat.format("Failed to complete database migration to {0} with URL \"{1}\" and database user \"{2}\" that was started by \"{3}\" (ID={4}).", dbTypeName, url, dbUserName, admin.getName(), admin.getId()));
        Logger.logDatabaseMigrationFinishedError(admin, dbTypeName, url, dbUserName);
    }

    public void logDatabaseMigrationFinishedSuccess(User admin, String dbTypeName, String url, String dbUserName) {
        this.logger.logInfo(MessageFormat.format("Successfully finished database migration to {0} with URL \"{1}\" and database user \"{2}\" that was started by \"{3}\" (ID={4}).", dbTypeName, url, dbUserName, admin.getName(), admin.getId()));
        Logger.logDatabaseMigrationFinishedSuccess(admin, dbTypeName, url, dbUserName);
    }

    public void logExecutedCustomSqlQuery(User admin, String query) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has executed a custom SQL query that changed no data: \"{2}\"", admin.getName(), admin.getId(), query));
        Logger.logExecutedCustomSqlQuery(admin, query);
    }

    public void logExecutedCustomSqlUpdate(User admin, String query, int nRowsModified) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has executed a custom SQL query that modified {2} table row(s): \"{3}\"", admin.getName(), admin.getId(), nRowsModified, query));
        Logger.logExecutedCustomSqlUpdate(admin, query, nRowsModified);
    }

    public void logDatabaseAccountsMerged(User admin) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has executed the automatic merging of accounts.", admin.getName(), admin.getId()));
        Logger.logDatabaseAccountsMerged(admin);
    }

    public void logSchedulerChangedBankUser(User admin, Scheduler scheduler, User oldUser, User newUser) {
        if (scheduler.getBankUser() != null) {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has changed the user for an automatic fetch scheduler (ID={2}) to \"{3}\" (ID={4}).", admin.getName(), admin.getId(), scheduler.getId(), scheduler.getBankUser().getUser().getName(), scheduler.getBankUser().getUser().getId()));
        } else {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has removed the user from an automatic fetch scheduler (ID={2}).", admin.getName(), admin.getId(), scheduler.getId()));
        }
        Logger.logSchedulerChangedBankUser(admin, scheduler, oldUser, newUser);
    }

    public void logSchedulerCreated(User admin, Scheduler scheduler) {
        if (scheduler.getBankUser() != null) {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has created an automatic fetch scheduler (ID={2}) for user \"{3}\" (ID={4}).", admin.getName(), admin.getId(), scheduler.getId(), scheduler.getBankUser().getUser().getName(), scheduler.getBankUser().getUser().getId()));
        } else {
            this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has created an automatic fetch scheduler (ID={2}).", admin.getName(), admin.getId(), scheduler.getId()));
        }
        Logger.logSchedulerCreated(admin, scheduler);
    }

    public void logSchedulerDeleted(User admin, Scheduler scheduler) {
        this.logger.logInfo(MessageFormat.format("\"{0}\" (ID={1}) has deleted an automatic fetch scheduler (ID={2}) for Bank {4} (ID={3}).", admin.getName(), admin.getId(), scheduler.getId(), scheduler.getBank().getBankId(), scheduler.getBank().getDisplayName()));
        Logger.logSchedulerDeleted(admin, scheduler);
    }
}

