/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.format.AddressData;
import de.businesslogics.util.StringUtils;
import java.util.List;
import java.util.Locale;

public class AddressUtil {
    private static AddressUtil myInstance;
    private CountriesLoader countriesLoader;

    private AddressUtil(Locale locale) {
        this.countriesLoader = CountriesLoader.getInstance(locale);
    }

    public static AddressUtil getInstance() {
        return AddressUtil.getInstance(Locale.getDefault());
    }

    public static AddressUtil getInstance(Locale locale) {
        if (myInstance == null) {
            myInstance = new AddressUtil(locale);
        }
        return myInstance;
    }

    @Deprecated
    public String getAddressInfo(List<String> address, String countryCode) {
        return this.getAddressInfo(null, address, countryCode);
    }

    @Deprecated
    public String getAddressInfo(String name, List<String> address, String countryCode) {
        int countLines;
        StringBuilder sb = null;
        if (name != null && name.length() > 0) {
            sb = new StringBuilder(name);
        }
        if (address != null && (countLines = address.size()) > 0) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append('\n');
            }
            for (int i = 0; i < countLines; ++i) {
                sb.append(address.get(i));
                if (i >= countLines - 1) continue;
                sb.append('\n');
            }
        }
        if (countryCode != null && countryCode.length() == 2) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append('\n');
            }
            String countryName = this.countriesLoader.getCountryName(countryCode);
            sb.append(countryName != null ? countryName : countryCode);
        }
        if (sb != null) {
            return sb.toString();
        }
        return null;
    }

    public String getAddressInfo(AddressData address, boolean displayCountry, Locale locale) {
        return this.getAddressInfo(null, address, displayCountry, locale);
    }

    public String getAddressInfo(String name, AddressData address, boolean displayCountry, Locale locale) {
        String countryCode;
        StringBuilder sb = new StringBuilder(StringUtils.checkNullAndTrim(name));
        if (address != null) {
            sb.append(address.getInformation(locale));
        }
        if (displayCountry && (countryCode = StringUtils.checkNullAndTrim(address.getCountry())).length() > 0) {
            String countryName;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append((countryName = this.countriesLoader.getCountryName(countryCode)) != null ? countryName : countryCode);
        }
        return sb.toString();
    }

    public String getCountryName(String countryCode) {
        String countryName = this.countriesLoader.getCountryName(countryCode);
        if (countryName != null) {
            return countryName;
        }
        return countryCode;
    }
}

