/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.ApplicationInfo;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.RSAPublicKey;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Database;
import io.ebean.Transaction;
import io.ebean.bean.EntityBean;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractUserImportRunner
implements Runnable {
    private static final byte[] BL_IMPORT_BYTES = "blimport".getBytes();
    private static final String IMPORT_SUB_DIRECTORY = "import";
    private final File sourceWorkspaceDir;
    private final File targetWorkspaceKeyDir;
    private final List<User> users;
    private final List<String> currentTenantNames;
    private Database source;
    private Map<BankUser, BankUser> importedBankUsers;
    private Integer remainingUserNumber;

    protected AbstractUserImportRunner(File sourceWorkspaceDir, File targetWorkspaceKeyDir, List<User> users) {
        this.sourceWorkspaceDir = sourceWorkspaceDir;
        this.targetWorkspaceKeyDir = targetWorkspaceKeyDir;
        this.users = users;
        this.currentTenantNames = new ArrayList<String>();
        for (Tenant t : this.getImportingUserTenants()) {
            this.currentTenantNames.add(t.getName());
        }
    }

    @Override
    public final void run() {
        this.importedBankUsers = new HashMap<BankUser, BankUser>();
        try (Transaction t = DB.beginTransaction();){
            for (User user : this.users) {
                User existingUser = User.getUser(user.getName());
                if (existingUser != null && !this.askUserOverwrite(user.getName())) continue;
                if (existingUser == null) {
                    if (!user.isLocalUser() && this.remainingUserNumber != null) {
                        Integer n = this.remainingUserNumber;
                        this.remainingUserNumber = this.remainingUserNumber - 1;
                        if (n < 0) continue;
                    }
                    existingUser = this.copyUser(user);
                    this.getTargetKeyDirectory(existingUser, false, this.targetWorkspaceKeyDir);
                    Util.checkKeyDirUnique(existingUser);
                } else {
                    existingUser.setEncryptionKey(user.getEncryptionKey());
                    for (Tenant tenant : this.findCorrespondingTenants(user.getTenants())) {
                        if (existingUser.getTenants().contains(tenant)) continue;
                        existingUser.getTenants().add(tenant);
                    }
                    if (existingUser.isAdmin()) {
                        existingUser.setManagedTenants(this.findCorrespondingTenants(user.getManagedTenants()));
                    }
                }
                existingUser.save();
                this.checkBanksForUser(existingUser, user);
            }
            ApplicationInfo applicationInfo = (ApplicationInfo)this.source.find(ApplicationInfo.class, (Object)ApplicationInfo.PropKey.DATA_ENC_KEY.name());
            applicationInfo.setPropName(ApplicationInfo.getNextImportedEncKeyPropName());
            DB.byName("bl").insert((Object)applicationInfo);
            t.commit();
        }
        catch (Throwable t2) {
            this.handleThrowable(t2);
        }
    }

    public final void setSource(Database source) {
        this.source = source;
    }

    protected final File getWorkspaceDir() {
        return this.sourceWorkspaceDir;
    }

    public final Map<BankUser, BankUser> getImportedBankUsers() {
        return this.importedBankUsers;
    }

    public boolean setRemainingUserNumber(int remainingUserNumber) {
        if (this.remainingUserNumber == null || this.remainingUserNumber < remainingUserNumber) {
            this.remainingUserNumber = remainingUserNumber;
            return true;
        }
        return false;
    }

    protected abstract List<Tenant> getImportingUserTenants();

    protected abstract boolean askUserOverwrite(String var1);

    protected abstract void handleThrowable(Throwable var1);

    private User copyUser(User user) {
        User toBeImported = this.loadAllFields(User.class, user.getId());
        License l = this.checkLicense(toBeImported.getLicense());
        toBeImported.setLicense(l);
        l = this.checkLicense(toBeImported.getWebLicense());
        toBeImported.setWebLicense(l);
        List<Tenant> tenants = this.findCorrespondingTenants(toBeImported.getTenants());
        toBeImported.setTenants(tenants);
        if (toBeImported.isAdmin()) {
            tenants = this.findCorrespondingTenants(toBeImported.getManagedTenants());
            toBeImported.setManagedTenants(tenants);
        }
        toBeImported.setId(null);
        byte[] oldEncKey = toBeImported.getEncryptionKey();
        byte[] tempEncKey = new byte[BL_IMPORT_BYTES.length + oldEncKey.length];
        System.arraycopy(BL_IMPORT_BYTES, 0, tempEncKey, 0, BL_IMPORT_BYTES.length);
        System.arraycopy(oldEncKey, 0, tempEncKey, BL_IMPORT_BYTES.length, oldEncKey.length);
        toBeImported.setEncryptionKey(tempEncKey);
        DB.byName("bl").insert((Object)toBeImported);
        return toBeImported;
    }

    public static byte[] getImportedUserEncKey(byte[] encKey) {
        byte[] firstBytes;
        if (encKey != null && encKey.length > BL_IMPORT_BYTES.length && Arrays.equals(BL_IMPORT_BYTES, firstBytes = Arrays.copyOfRange(encKey, 0, BL_IMPORT_BYTES.length))) {
            return Arrays.copyOfRange(encKey, BL_IMPORT_BYTES.length, encKey.length);
        }
        return null;
    }

    private License checkLicense(License license) {
        if (license != null) {
            License existingLicense = License.findById(license.getId());
            if (existingLicense == null) {
                existingLicense = this.loadAllFields(License.class, license.getId());
                DB.byName("bl").insert((Object)existingLicense);
            }
            return existingLicense;
        }
        return null;
    }

    protected List<Tenant> findCorrespondingTenants(List<Tenant> tenants) {
        if (tenants.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> importTenantNames = new ArrayList<String>();
        for (Tenant t : tenants) {
            importTenantNames.add(t.getName());
        }
        return DB.find(Tenant.class).where().in("name", this.currentTenantNames).in("name", importTenantNames).findList();
    }

    protected File getSourceKeyDirectory(User sourceUser) {
        if (sourceUser == null || sourceUser.getKeyDirectory() == null) {
            return null;
        }
        File sourceKeyDirectory = new File(sourceUser.getKeyDirectory());
        if (sourceKeyDirectory.isAbsolute()) {
            return sourceKeyDirectory;
        }
        return new File(this.sourceWorkspaceDir, sourceUser.getKeyDirectory());
    }

    protected File getTargetKeyDirectory(User user, boolean createDir, File applicationKeyDir) throws IOException {
        File result = Util.getKeyDirectory(user);
        if (result == null && applicationKeyDir != null) {
            String workspacePath;
            Object toSave = applicationKeyDir.getAbsolutePath();
            if (((String)toSave).startsWith(workspacePath = this.sourceWorkspaceDir.getAbsolutePath())) {
                toSave = "." + ((String)toSave).substring(workspacePath.length());
            }
            user.setKeyDirectory((String)toSave);
            result = Util.getKeyDirectory(user);
        }
        if (createDir && result != null && !result.isDirectory()) {
            result.mkdirs();
        }
        return result;
    }

    private void checkBanksForUser(User existingUser, User user) throws IOException {
        List<Tenant> existingTenants = this.findCorrespondingTenants(user.getTenants());
        for (BankUser bankUser : this.source.find(BankUser.class).where().eq("user", (Object)user).findList()) {
            if (!this.currentTenantNames.contains(bankUser.getBank().getTenant().getName())) continue;
            BankUser existingBankUser = (BankUser)DB.find(BankUser.class).where().eq("defaultUser", (Object)bankUser.getDefaultUser()).eq("bank.url", (Object)bankUser.getBank().getUrl()).eq("bank.hostId", (Object)bankUser.getBank().getHostId()).eq("bank.customerId", (Object)bankUser.getBank().getCustomerId()).in("bank.tenant", existingTenants).setMaxRows(1).findOne();
            if (existingBankUser != null) {
                if (bankUser.getState() == BankUser.UserState.READY && bankUser.getState() != existingBankUser.getState()) {
                    existingBankUser = this.overwriteBankUser(bankUser, existingBankUser);
                }
            } else {
                BankSettings existingBankSettings;
                List existingBankSettingsList = DB.find(BankSettings.class).where().eq("url", (Object)bankUser.getBank().getUrl()).eq("hostId", (Object)bankUser.getBank().getHostId()).eq("customerId", (Object)bankUser.getBank().getCustomerId()).in("tenant", existingTenants).findList();
                if (existingBankSettingsList.isEmpty()) {
                    existingBankSettings = this.copyBank(bankUser.getBank());
                } else {
                    existingBankSettings = null;
                    Iterator banksIterator = existingBankSettingsList.iterator();
                    while (banksIterator.hasNext()) {
                        BankSettings bank = (BankSettings)banksIterator.next();
                        if (BankUser.findBankUser(bank, existingUser) != null) {
                            banksIterator.remove();
                            continue;
                        }
                        if (!bankUser.getBank().getDisplayName().equalsIgnoreCase(bank.getDisplayName())) continue;
                        existingBankSettings = bank;
                        break;
                    }
                    if (existingBankSettings == null) {
                        existingBankSettings = existingBankSettingsList.size() > 0 ? (BankSettings)existingBankSettingsList.get(0) : this.copyBank(bankUser.getBank());
                    }
                }
                existingBankUser = this.copyBankUser(bankUser, existingBankSettings, existingUser);
                this.importedBankUsers.put(bankUser, existingBankUser);
            }
            this.copyBankFiles(existingBankUser, bankUser);
        }
        this.moveFilesFromSubDir(existingUser);
    }

    private BankUser overwriteBankUser(BankUser bankUser, BankUser existingBankUser) {
        BankUser toBeImported = this.loadAllFields(BankUser.class, bankUser.getId());
        toBeImported.setBank(existingBankUser.getBank());
        toBeImported.setUser(existingBankUser.getUser());
        toBeImported.setId(existingBankUser.getId());
        EntityBean bean = toBeImported;
        bean._ebean_getIntercept().setNewBeanForUpdate();
        DB.update(toBeImported);
        return toBeImported;
    }

    private BankSettings copyBank(BankSettings sourceBank) {
        BankSettings toBeImported = this.loadAllFields(BankSettings.class, sourceBank.getBankId());
        RSAPublicKey pubKey = this.copyRSAPublicKey(sourceBank.getE001Key());
        if (pubKey != null) {
            DB.save(pubKey);
        }
        toBeImported.setE001Key(pubKey);
        pubKey = this.copyRSAPublicKey(sourceBank.getE002Key());
        if (pubKey != null) {
            DB.save(pubKey);
        }
        toBeImported.setE002Key(pubKey);
        pubKey = this.copyRSAPublicKey(sourceBank.getX001Key());
        if (pubKey != null) {
            DB.save(pubKey);
        }
        toBeImported.setX001Key(pubKey);
        pubKey = this.copyRSAPublicKey(sourceBank.getX002Key());
        if (pubKey != null) {
            DB.save(pubKey);
        }
        toBeImported.setX002Key(pubKey);
        List<Tenant> tenants = this.findCorrespondingTenants(Collections.singletonList(sourceBank.getTenant()));
        if (tenants != null && tenants.size() == 1) {
            toBeImported.setTenant(tenants.get(0));
        } else {
            toBeImported.setTenant((Tenant)DB.find(Tenant.class).where().eq("name", (Object)sourceBank.getTenant().getName()).findOne());
        }
        toBeImported.setBankId(null);
        DB.byName("bl").insert((Object)toBeImported);
        return toBeImported;
    }

    private RSAPublicKey copyRSAPublicKey(RSAPublicKey rsaKey) {
        if (rsaKey == null) {
            return null;
        }
        RSAPublicKey toBeImported = this.loadAllFields(RSAPublicKey.class, rsaKey.getKeyId());
        toBeImported.setKeyId(null);
        DB.byName("bl").insert((Object)toBeImported);
        return toBeImported;
    }

    private BankUser copyBankUser(BankUser bankUser, BankSettings bank, User user) {
        BankUser toBeImported = this.loadAllFields(BankUser.class, bankUser.getId());
        toBeImported.setBank(bank);
        toBeImported.setUser(user);
        toBeImported.setId(null);
        DB.byName("bl").insert((Object)toBeImported);
        return toBeImported;
    }

    private void copyBankFiles(BankUser existingBankUser, BankUser bankUser) throws IOException {
        File sourceUserKeyDir = this.getSourceKeyDirectory(bankUser.getUser());
        if (sourceUserKeyDir == null) {
            return;
        }
        File targetUserKeyDir = this.getTargetKeyDirectory(existingBankUser.getUser(), true, this.targetWorkspaceKeyDir);
        if (targetUserKeyDir == null) {
            throw new RuntimeException("No key directory for user '" + existingBankUser.getUser().getName() + "' defined!");
        }
        targetUserKeyDir = new File(targetUserKeyDir, IMPORT_SUB_DIRECTORY);
        String sourceBankFilePrefix = String.valueOf(bankUser.getBank().getBankId() - 1) + ".";
        String targetBankFilePrefix = String.valueOf(existingBankUser.getBank().getBankId() - 1) + ".";
        File[] keyDirFiles = sourceUserKeyDir.listFiles();
        if (keyDirFiles != null && keyDirFiles.length > 0) {
            for (File keyDirFile : keyDirFiles) {
                String filename = keyDirFile.getName();
                if (!filename.startsWith(sourceBankFilePrefix)) continue;
                this.copyFile(keyDirFile, new File(targetUserKeyDir, targetBankFilePrefix + filename.substring(sourceBankFilePrefix.length())), false);
            }
        }
    }

    private void moveFilesFromSubDir(User user) throws IOException {
        if (user == null) {
            return;
        }
        File targetUserKeyDir = this.getTargetKeyDirectory(user, true, this.targetWorkspaceKeyDir);
        if (targetUserKeyDir == null) {
            throw new RuntimeException("No key directory for user '" + user.getName() + "' defined!");
        }
        File subDir = new File(targetUserKeyDir, IMPORT_SUB_DIRECTORY);
        File[] files = subDir.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                this.copyFile(file, new File(targetUserKeyDir, file.getName()), true);
            }
        }
        subDir.delete();
    }

    private void copyFile(File sourceFile, File targetFile, boolean move) throws IOException {
        if (sourceFile == null || targetFile == null) {
            return;
        }
        if (!targetFile.getParentFile().isDirectory()) {
            targetFile.getParentFile().mkdirs();
        }
        if (!sourceFile.getAbsolutePath().equals(targetFile.getAbsolutePath())) {
            CopyOption[] options = new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            if (move) {
                Files.move(sourceFile.toPath(), targetFile.toPath(), options);
            } else {
                Files.copy(sourceFile.toPath(), targetFile.toPath(), options);
            }
        }
    }

    private <T> T loadAllFields(Class<T> c, Object id) {
        return (T)this.source.find(c).select("*").where().eq("id", id).findOne();
    }
}

