/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.ebics.client.BTFTranslator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractPermissionChecker {
    protected abstract boolean checkAccountPermissions();

    protected abstract void noAccountPermission(int var1);

    protected abstract void noBankPermission();

    protected abstract void noAccountPermissionInOrder();

    protected abstract void noBankPermissionInOrder(int var1);

    public boolean hasAccountPermissions(User user, Send sendVO) {
        BankSettings bank = sendVO.getBank();
        boolean isEbics30Bank = BankUtils.isProtocolH005OrNewer(bank.getProtocolVersion());
        boolean hasPermission = false;
        if (isEbics30Bank) {
            if (sendVO.getFileTypeOrBTF() != null) {
                hasPermission = this.checkAccountPermission(user, bank, sendVO.getFileTypeOrBTF(), sendVO.getAccounts(), false);
            }
            if (!hasPermission) {
                hasPermission = this.checkAccountPermission(user, bank, this.getOrderType(sendVO), sendVO.getAccounts());
            }
        } else {
            hasPermission = this.checkAccountPermission(user, sendVO.getBank(), this.getOrderType(sendVO), sendVO.getAccounts(), sendVO.getFileTypeOrBTF() == null);
            if (!hasPermission && sendVO.getFileTypeOrBTF() != null) {
                hasPermission = this.checkAccountPermission(user, bank, sendVO.getFileTypeOrBTF(), sendVO.getAccounts());
            }
        }
        return hasPermission;
    }

    private String getOrderType(Send sendVO) {
        String orderType = sendVO.getOrderType();
        if ("BTU".equals(orderType)) {
            return SendParameters.getOrderType(sendVO.getBank(), sendVO.getPmtType());
        }
        return orderType;
    }

    private boolean checkAccountPermission(User user, BankSettings bank, String generalizedOrderType, Collection<Account> accounts) {
        return this.checkAccountPermission(user, bank, generalizedOrderType, accounts, true);
    }

    private boolean checkAccountPermission(User user, BankSettings bank, String generalizedOrderType, Collection<Account> accounts, boolean withCallback) {
        if (!this.checkAccountPermissions()) {
            return true;
        }
        Iterator<Account> accountsIterator = accounts.iterator();
        while (accountsIterator.hasNext()) {
            Account account = accountsIterator.next();
            if (account != null) continue;
            accountsIterator.remove();
        }
        if (accounts == null || accounts.size() == 0) {
            return true;
        }
        BankUser bankUser = BankUser.findBankUser(bank, user);
        if (bankUser != null) {
            List<UserPermission> list = UserPermission.findUserPermission(bankUser, OrderType.TransferType.SEND, generalizedOrderType);
            for (Account account : accounts) {
                if (AccountPermission.findAccountPermissionForBank(bankUser, account) == null) {
                    if (withCallback) {
                        this.noAccountPermission(accounts.size());
                    }
                    return false;
                }
                if (account.getType() != Account.Type.HTD) continue;
                boolean foundUP = false;
                for (UserPermission up : list) {
                    if (up.getAccountPermission() == null) {
                        foundUP = true;
                        break;
                    }
                    if (!((Object)up.getAccountPermission().getAccount()).equals(account)) continue;
                    foundUP = true;
                    break;
                }
                if (foundUP) continue;
                if (withCallback) {
                    this.noAccountPermission(accounts.size());
                }
                return false;
            }
            return true;
        }
        if (withCallback) {
            this.noBankPermission();
        }
        return false;
    }

    public boolean hasAccountPermissions(User user, Collection<Send> sendVOs) {
        if (!this.checkAccountPermissions()) {
            return true;
        }
        if (sendVOs.size() == 1) {
            return this.hasAccountPermissions(user, sendVOs.iterator().next());
        }
        HashMap<BankSettings, HashSet<Account>> bankAccounts = new HashMap<BankSettings, HashSet<Account>>();
        for (Send sendVO : sendVOs) {
            BankSettings bank = sendVO.getBank();
            if (bankAccounts.containsKey(bank)) {
                ((Set)bankAccounts.get(bank)).addAll(sendVO.getAccounts());
                continue;
            }
            HashSet<Account> accounts = new HashSet<Account>(sendVO.getAccounts());
            bankAccounts.put(bank, accounts);
        }
        for (BankSettings bank : bankAccounts.keySet()) {
            BankUser bankUser = BankUser.findBankUser(bank, user);
            if (bankUser != null) {
                for (Account account : (Set)bankAccounts.get(bank)) {
                    if (AccountPermission.findAccountPermissionForBank(bankUser, account) != null) continue;
                    this.noAccountPermissionInOrder();
                    return false;
                }
                continue;
            }
            this.noBankPermissionInOrder(bankAccounts.size());
            return false;
        }
        return true;
    }

    public boolean hasAccountPermissions(User user, DsOrderDetails dsOrderDetails) {
        PaymentTransferType.PmtType type;
        boolean toReturn = this.checkAccountPermission(user, dsOrderDetails.getBank(), dsOrderDetails.getFileType(), dsOrderDetails.getAccounts(), false);
        if (!toReturn && (type = dsOrderDetails.getPmtType()) != null) {
            if (BTFTranslator.isBTFString(dsOrderDetails.getFileType())) {
                String orderType = SendParameters.getOrderType(dsOrderDetails.getBank(), type);
                return this.checkAccountPermission(user, dsOrderDetails.getBank(), orderType, dsOrderDetails.getAccounts());
            }
            String btf = SendParameters.getBTF(dsOrderDetails.getBank(), type);
            return this.checkAccountPermission(user, dsOrderDetails.getBank(), btf, dsOrderDetails.getAccounts());
        }
        return toReturn;
    }

    public boolean hasAccountPermissions(User user, DsOpenOrder dsOpenOrder, Collection<Account> accounts) {
        return this.checkAccountPermission(user, dsOpenOrder.getBankUser().getBank(), dsOpenOrder.getFileType(), accounts);
    }
}

