/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.io.Streams;
import de.businesslogics.license.NoLicenseException;
import de.businesslogics.license.UnsignedJarLicense;
import de.businesslogics.util.BLLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;

public abstract class AbstractLicenseHandler {
    private static AbstractLicenseHandler instance;
    private final BLLogger logger;

    public static AbstractLicenseHandler getInstance() {
        return instance;
    }

    protected AbstractLicenseHandler(BLLogger logger) {
        this.logger = logger;
        UnsignedJarLicense.setRSAPublicKeyModulus(new BigInteger("140091788165492555277874837521546003860913363273652596940577117015584945609747230941336381053953691509368857284402133196136905389731754867238735290076920624741518907351505118958355805661747375320172901973626023956261877141323644906922957787370202984163177388748303488933698037830287107854582013261093100714389"));
        instance = this;
    }

    public final LicenseCheckResult checkLicense(User user) {
        License vo = this.getLicense(user);
        if (vo == null) {
            return LicenseCheckResult.NOT_SET;
        }
        return this.checkLicense(vo);
    }

    public final LicenseCheckResult checkLicense(License vo) {
        LicenseCheckResult result = this.parseLicense(vo.getContent());
        if (result != LicenseCheckResult.OK) {
            try {
                byte[] b = this.downloadLicense(vo.getId());
                result = this.parseLicense(b);
                if (result == LicenseCheckResult.OK) {
                    vo.setContent(b);
                    vo.save();
                }
            }
            catch (IOException e) {
                this.logger.logError("Failed to download license " + vo.getId(), e);
                return LicenseCheckResult.UNKNOWN;
            }
        }
        return result;
    }

    public final LicenseCheckResult downloadLicense(License license) {
        try {
            byte[] b = this.downloadLicense(license.getId());
            LicenseCheckResult result = this.parseLicense(b);
            if (result == LicenseCheckResult.OK) {
                license.setContent(b);
                license.save();
            }
            return result;
        }
        catch (IOException e) {
            this.logger.logError("Failed to download license " + license.getId(), e);
            return LicenseCheckResult.UNKNOWN;
        }
    }

    public final UnsignedJarLicense getLicenseProperties(User user) throws IOException {
        License vo = this.getLicense(user);
        return this.getLicenceProperties(vo);
    }

    public final UnsignedJarLicense getLicenceProperties(License vo) throws IOException {
        if (vo != null && vo.getContent() != null) {
            return new UnsignedJarLicense(new ByteArrayInputStream(vo.getContent()));
        }
        return null;
    }

    private LicenseCheckResult parseLicense(byte[] b) {
        try {
            UnsignedJarLicense unsigned = new UnsignedJarLicense(new ByteArrayInputStream(b));
            unsigned.checkValid();
            String product = this.getLicenseProduct();
            if (product != null && !product.equalsIgnoreCase(unsigned.getProperty("PRODUCT"))) {
                return LicenseCheckResult.WRONG_PRODUCT;
            }
            return LicenseCheckResult.OK;
        }
        catch (NoLicenseException e) {
            return LicenseCheckResult.EXPIRED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] downloadLicense(String licenseCode) throws IOException {
        byte[] byArray;
        InputStream in = null;
        try {
            URL url = new URL(System.getProperty("licenseServer", "https://www.blbanking.de/license/download/") + licenseCode);
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            EbicsHttpEngineImpl.setSSLSocketFactory(con);
            in = con.getInputStream();
            byArray = Streams.readAll(in);
        }
        catch (Throwable throwable) {
            Util.closeStream(in);
            throw throwable;
        }
        Util.closeStream(in);
        return byArray;
    }

    protected abstract License getLicense(User var1);

    protected abstract String getLicenseProduct();

    public static enum LicenseCheckResult {
        OK(null),
        NOT_SET("License.unknown"),
        UNKNOWN("License.unknown"),
        EXPIRED("License.expired"),
        WRONG_PRODUCT("License.wrongProduct");

        private final String messageKey;

        private LicenseCheckResult(String messageKey) {
            this.messageKey = messageKey;
        }

        public String getMessage(Locale locale) {
            if (this.messageKey != null) {
                return BankingApiMessages.getString(locale, this.messageKey, new Object[0]);
            }
            return null;
        }
    }
}

