/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking.api;

import de.businesslogics.util.Currency;
import de.businesslogics.validation.RegularExpressions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Locale;

public abstract class AbstractCsvExport<DataType> {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String COLUMN_SEPARATOR = ";";
    private int column;

    public static boolean isInputCsvInjection(String input, boolean isNumber) {
        if (isNumber) {
            return !RegularExpressions.NUMBER_OR_DECIMALS.getPattern().matcher(input.trim()).matches();
        }
        return RegularExpressions.INJECTION_CSV.getPattern().matcher(input.trim()).matches();
    }

    public static String prepareInputForCSV(String input, boolean isNumber) {
        Object goodInput = input;
        if (isNumber) {
            goodInput = input.replaceAll("[A-Za-z]", "").replaceAll("\\p{Space}", "").replaceAll("[!\"#$%&'()*/:;<=>?@\\^_`{|}~]", "");
            if (((String)(goodInput = ((String)goodInput).replace("[", "").replace("]", "").replace("\\", ""))).length() > 1) {
                String newGoodInput = ((String)goodInput).substring(1).replaceAll("[+-]", "");
                goodInput = ((String)goodInput).substring(0, 1) + newGoodInput;
            }
        } else {
            goodInput = input.replace("\"", "\"\"");
            goodInput = "\"'" + (String)goodInput + "\"";
        }
        return goodInput;
    }

    public static String correctInputForCSV(String input, boolean isNumber) {
        if (AbstractCsvExport.isInputCsvInjection(input, isNumber)) {
            return AbstractCsvExport.prepareInputForCSV(input, isNumber);
        }
        return input;
    }

    public final void write(File file, Iterable<DataType> items) throws IOException {
        try (PrintWriter writer = new PrintWriter(file);){
            this.write(writer, items);
        }
    }

    public final void write(OutputStream outputStream, Iterable<DataType> items) throws IOException {
        this.write(new OutputStreamWriter(outputStream), items);
    }

    public final void write(Writer writer, Iterable<DataType> items) throws IOException {
        if (this.writeHeader(writer)) {
            this.startNewLine(writer);
        }
        boolean firstLine = true;
        for (DataType item : items) {
            if (!firstLine) {
                writer.append(LINE_SEPARATOR);
            }
            if (this.writeItem(writer, item)) {
                this.column = 0;
            }
            firstLine = false;
        }
        writer.flush();
    }

    protected final void startNewLine(Writer writer) throws IOException {
        writer.append(LINE_SEPARATOR);
        this.column = 0;
    }

    protected final String formatDate(Date date, Locale locale) throws IOException {
        if (date != null) {
            return DateFormat.getDateInstance(2, locale).format(date);
        }
        return null;
    }

    protected final String formatAmount(BigDecimal amount, Currency currency, Locale locale) throws IOException {
        if (amount != null) {
            NumberFormat nf = NumberFormat.getInstance(locale);
            if (currency != null) {
                nf.setMinimumFractionDigits(currency.getDefaultFractionDigits());
            } else {
                nf.setMinimumFractionDigits(2);
            }
            return nf.format(amount);
        }
        return null;
    }

    protected final void addCell(Writer writer, String info) throws IOException {
        this.addCell(writer, info, false);
    }

    protected final void addCell(Writer writer, String info, boolean isNumber) throws IOException {
        if (this.column > 0) {
            writer.append(COLUMN_SEPARATOR);
        }
        if (info != null) {
            if (AbstractCsvExport.isInputCsvInjection(info, isNumber)) {
                writer.append(AbstractCsvExport.prepareInputForCSV(info, isNumber));
            } else {
                String repInfo = info.replace("\"", "\"\"");
                if (repInfo.contains(COLUMN_SEPARATOR)) {
                    writer.append('\"').append(repInfo).append('\"');
                } else {
                    writer.append(repInfo);
                }
            }
        }
        ++this.column;
    }

    protected abstract boolean writeHeader(Writer var1) throws IOException;

    protected abstract boolean writeItem(Writer var1, DataType var2) throws IOException;
}

