/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.banking;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    public static Messages DEFAULT = new Messages(Locale.getDefault());
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("de.businesslogics.banking.messages");
    private final Locale locale;

    public Messages(Locale locale) {
        this.locale = locale;
    }

    public String get(String key) {
        if (this == DEFAULT) {
            return Messages.getString(key, new Object[0]);
        }
        return Messages.getString(this.locale, key, new Object[0]);
    }

    public static boolean contains(String key) {
        try {
            RESOURCE_BUNDLE.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getString(String key, Object ... params) {
        try {
            String message = RESOURCE_BUNDLE.getString(key);
            if (params != null && params.length > 0) {
                return MessageFormat.format(message, params);
            }
            return message;
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String getString(Locale locale, String key, Object ... params) {
        try {
            String message = ResourceBundle.getBundle("de.businesslogics.banking.messages", locale).getString(key);
            if (params != null && params.length > 0) {
                return new MessageFormat(message, locale).format(params);
            }
            return message;
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }
}

