/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.AccountCheckAlgorithm;
import de.businesslogics.account.BankInfo;
import de.businesslogics.account.Result;
import de.businesslogics.account.iban.Converter0000_00;
import de.businesslogics.account.iban.Converter0001_00;
import de.businesslogics.account.iban.Converter0002_00;
import de.businesslogics.account.iban.Converter0003_00;
import de.businesslogics.account.iban.Converter0004_00;
import de.businesslogics.account.iban.Converter0005_00;
import de.businesslogics.account.iban.Converter0006_00;
import de.businesslogics.account.iban.Converter0007_00;
import de.businesslogics.account.iban.Converter0008_00;
import de.businesslogics.account.iban.Converter0009_00;
import de.businesslogics.account.iban.Converter0010_00;
import de.businesslogics.account.iban.Converter0011_00;
import de.businesslogics.account.iban.Converter0012_00;
import de.businesslogics.account.iban.Converter0013_00;
import de.businesslogics.account.iban.Converter0014_00;
import de.businesslogics.account.iban.Converter0015_00;
import de.businesslogics.account.iban.Converter0016_00;
import de.businesslogics.account.iban.Converter0017_00;
import de.businesslogics.account.iban.Converter0018_00;
import de.businesslogics.account.iban.Converter0019_00;
import de.businesslogics.account.iban.Converter0020_00;
import de.businesslogics.account.iban.Converter0020_01;
import de.businesslogics.account.iban.Converter0021_00;
import de.businesslogics.account.iban.Converter0022_00;
import de.businesslogics.account.iban.Converter0023_00;
import de.businesslogics.account.iban.Converter0024_00;
import de.businesslogics.account.iban.Converter0025_00;
import de.businesslogics.account.iban.Converter0026_00;
import de.businesslogics.account.iban.Converter0027_00;
import de.businesslogics.account.iban.Converter0028_00;
import de.businesslogics.account.iban.Converter0029_00;
import de.businesslogics.account.iban.Converter0030_00;
import de.businesslogics.account.iban.Converter0031_00;
import de.businesslogics.account.iban.Converter0032_00;
import de.businesslogics.account.iban.Converter0033_00;
import de.businesslogics.account.iban.Converter0034_00;
import de.businesslogics.account.iban.Converter0035_00;
import de.businesslogics.account.iban.Converter0036_00;
import de.businesslogics.account.iban.Converter0037_00;
import de.businesslogics.account.iban.Converter0038_00;
import de.businesslogics.account.iban.Converter0039_00;
import de.businesslogics.account.iban.Converter0040_00;
import de.businesslogics.account.iban.Converter0041_00;
import de.businesslogics.account.iban.Converter0042_00;
import de.businesslogics.account.iban.Converter0043_00;
import de.businesslogics.account.iban.Converter0044_00;
import de.businesslogics.account.iban.Converter0045_00;
import de.businesslogics.account.iban.Converter0046_00;
import de.businesslogics.account.iban.Converter0047_00;
import de.businesslogics.account.iban.Converter0048_00;
import de.businesslogics.account.iban.Converter0049_00;
import de.businesslogics.account.iban.Converter0049_01;
import de.businesslogics.account.iban.Converter0050_00;
import de.businesslogics.account.iban.Converter0051_00;
import de.businesslogics.account.iban.Converter0052_00;
import de.businesslogics.account.iban.Converter0053_00;
import de.businesslogics.account.iban.Converter0054_00;
import de.businesslogics.account.iban.Converter0055_00;
import de.businesslogics.account.iban.Converter0056_00;
import de.businesslogics.account.iban.Converter0057_00;
import de.businesslogics.iban.IbanUtil;
import java.util.HashMap;
import java.util.Set;

public abstract class IBANConverter {
    private static final String BASE_VERSION = "00";
    private static HashMap<String, Class<? extends IBANConverter>> CONVERTER = new HashMap();
    public static SimpleCache BLZ_CACHE;
    protected Integer resultCode = null;
    private static String ZERO_FILLER;

    public static IBANConverter getWithBLZCache(String blz) {
        if (BLZ_CACHE == null) {
            return null;
        }
        BankInfo i = BLZ_CACHE.getBankInfo(blz);
        if (i == null) {
            return null;
        }
        return IBANConverter.get(i.getIBANRule());
    }

    public static Class<? extends IBANConverter> getClass(String rule) {
        if (rule == null || rule.length() < 6) {
            return null;
        }
        Class<? extends IBANConverter> converter = CONVERTER.get(rule);
        if (converter != null) {
            return converter;
        }
        String version = rule.substring(4);
        rule = rule.substring(0, 4);
        while (converter == null && !BASE_VERSION.equals(version)) {
            version = IBANConverter.getPreviousVersion(version);
            converter = CONVERTER.get(rule + version);
        }
        return converter;
    }

    private static String getPreviousVersion(String version) {
        int v = 0;
        try {
            v = Integer.parseInt(version);
        }
        catch (Exception e) {
            return BASE_VERSION;
        }
        if (v > 0) {
            --v;
        }
        if (v >= 10) {
            return Integer.toString(v);
        }
        return "0" + v;
    }

    public static IBANConverter get(String rule) {
        block4: {
            Class<? extends IBANConverter> c = IBANConverter.getClass(rule);
            if (c != null) {
                try {
                    return c.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    break block4;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    break block4;
                }
            }
            return new Converter0000_00();
        }
        return null;
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    protected String mod0000_00(String blz, String kto) {
        AccountCheckAlgorithm checkAlgorithm = this.getCheckAlgorithm(blz = this.updateBLZ(blz));
        if (checkAlgorithm != null) {
            Result res = checkAlgorithm.check(kto, blz);
            if (res.equals((Object)Result.VALID) || res.equals((Object)Result.UNKNOWN)) {
                return this.calculateGermanIban(kto, blz);
            }
            return null;
        }
        return null;
    }

    protected String mod0000_00(String blz, String kto, Set<String> uncheckedAccountNumbers) {
        kto = IBANConverter.trimAccount(kto);
        if (uncheckedAccountNumbers != null && uncheckedAccountNumbers.contains(kto)) {
            return this.calculateGermanIban(kto, blz);
        }
        return this.mod0000_00(blz, kto);
    }

    private String updateBLZ(String blz) {
        if (BLZ_CACHE != null) {
            BankInfo i = BLZ_CACHE.getBankInfo(blz);
            if (i == null) {
                return blz;
            }
            if (i.hasNextBankCode()) {
                return i.getNextBankCode();
            }
            return i.getBankCode();
        }
        return blz;
    }

    protected AccountCheckAlgorithm getCheckAlgorithm(String blz) {
        BankInfo i;
        if (BLZ_CACHE != null && (i = BLZ_CACHE.getBankInfo(blz)) != null) {
            return AccountCheckAlgorithm.get(i.getCheckDigit());
        }
        return null;
    }

    protected boolean isBankConnectionValid(String blz, String kto) {
        AccountCheckAlgorithm checkAlgorithm = this.getCheckAlgorithm(blz);
        if (checkAlgorithm != null) {
            Result res = checkAlgorithm.check(kto, blz);
            return res.equals((Object)Result.VALID);
        }
        return false;
    }

    protected boolean isBankConnectionValidOrUnknown(String blz, String kto) {
        Result res;
        AccountCheckAlgorithm checkAlgorithm = this.getCheckAlgorithm(blz);
        return checkAlgorithm != null && ((res = checkAlgorithm.check(kto, blz)).equals((Object)Result.VALID) || res.equals((Object)Result.UNKNOWN));
    }

    protected String calculateGermanIban(String kto, String blz) {
        return IbanUtil.calculateUncheckedGermanIban(kto, blz);
    }

    protected static String mod0001_00() {
        return null;
    }

    public static String normalizeAccount(String kto) {
        if (kto == null) {
            throw new NullPointerException("null not allowed as account number");
        }
        if (kto.length() == 10) {
            return kto;
        }
        if (kto.length() < 10) {
            return ZERO_FILLER.substring(kto.length()) + kto;
        }
        for (int i = 0; i < kto.length() - 10; ++i) {
            if (kto.charAt(i) == '0') continue;
            throw new IllegalArgumentException("non leading zeros in account number '" + kto + "'");
        }
        return kto.substring(kto.length() - 10);
    }

    public static String trimAccount(String kto) {
        int skip = 0;
        for (int i = 0; i < kto.length() && kto.charAt(i) == '0'; ++i) {
            ++skip;
        }
        if (skip != 0) {
            return kto.substring(skip);
        }
        return kto;
    }

    public abstract String convert(String var1, String var2);

    public static void main(String[] args) {
        System.out.println("normalized: " + IBANConverter.normalizeAccount("1234"));
        System.out.println("normalized: " + IBANConverter.normalizeAccount("123400"));
        System.out.println("normalized: " + IBANConverter.normalizeAccount("0000000123400"));
        System.out.println("trim: " + IBANConverter.trimAccount("1234"));
        System.out.println("trim: " + IBANConverter.trimAccount("123400"));
        System.out.println("trim: " + IBANConverter.trimAccount("0000000123400"));
    }

    static {
        CONVERTER.put("000000", Converter0000_00.class);
        CONVERTER.put("000100", Converter0001_00.class);
        CONVERTER.put("000200", Converter0002_00.class);
        CONVERTER.put("000300", Converter0003_00.class);
        CONVERTER.put("000400", Converter0004_00.class);
        CONVERTER.put("000500", Converter0005_00.class);
        CONVERTER.put("000600", Converter0006_00.class);
        CONVERTER.put("000700", Converter0007_00.class);
        CONVERTER.put("000800", Converter0008_00.class);
        CONVERTER.put("000900", Converter0009_00.class);
        CONVERTER.put("001000", Converter0010_00.class);
        CONVERTER.put("001100", Converter0011_00.class);
        CONVERTER.put("001200", Converter0012_00.class);
        CONVERTER.put("001300", Converter0013_00.class);
        CONVERTER.put("001400", Converter0014_00.class);
        CONVERTER.put("001500", Converter0015_00.class);
        CONVERTER.put("001600", Converter0016_00.class);
        CONVERTER.put("001700", Converter0017_00.class);
        CONVERTER.put("001800", Converter0018_00.class);
        CONVERTER.put("001900", Converter0019_00.class);
        CONVERTER.put("002000", Converter0020_00.class);
        CONVERTER.put("002001", Converter0020_01.class);
        CONVERTER.put("002100", Converter0021_00.class);
        CONVERTER.put("002200", Converter0022_00.class);
        CONVERTER.put("002300", Converter0023_00.class);
        CONVERTER.put("002400", Converter0024_00.class);
        CONVERTER.put("002500", Converter0025_00.class);
        CONVERTER.put("002600", Converter0026_00.class);
        CONVERTER.put("002700", Converter0027_00.class);
        CONVERTER.put("002800", Converter0028_00.class);
        CONVERTER.put("002900", Converter0029_00.class);
        CONVERTER.put("003000", Converter0030_00.class);
        CONVERTER.put("003100", Converter0031_00.class);
        CONVERTER.put("003200", Converter0032_00.class);
        CONVERTER.put("003300", Converter0033_00.class);
        CONVERTER.put("003400", Converter0034_00.class);
        CONVERTER.put("003500", Converter0035_00.class);
        CONVERTER.put("003600", Converter0036_00.class);
        CONVERTER.put("003700", Converter0037_00.class);
        CONVERTER.put("003800", Converter0038_00.class);
        CONVERTER.put("003900", Converter0039_00.class);
        CONVERTER.put("004000", Converter0040_00.class);
        CONVERTER.put("004100", Converter0041_00.class);
        CONVERTER.put("004200", Converter0042_00.class);
        CONVERTER.put("004300", Converter0043_00.class);
        CONVERTER.put("004400", Converter0044_00.class);
        CONVERTER.put("004500", Converter0045_00.class);
        CONVERTER.put("004600", Converter0046_00.class);
        CONVERTER.put("004700", Converter0047_00.class);
        CONVERTER.put("004800", Converter0048_00.class);
        CONVERTER.put("004900", Converter0049_00.class);
        CONVERTER.put("004901", Converter0049_01.class);
        CONVERTER.put("005000", Converter0050_00.class);
        CONVERTER.put("005100", Converter0051_00.class);
        CONVERTER.put("005200", Converter0052_00.class);
        CONVERTER.put("005300", Converter0053_00.class);
        CONVERTER.put("005400", Converter0054_00.class);
        CONVERTER.put("005500", Converter0055_00.class);
        CONVERTER.put("005600", Converter0056_00.class);
        CONVERTER.put("005700", Converter0057_00.class);
        BLZ_CACHE = null;
        ZERO_FILLER = "0000000000";
    }

    public static interface SimpleCache {
        public BankInfo getBankInfo(String var1);
    }
}

