/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.Reverse;

@Reverse
public class Converter0042_00
extends IBANConverter {
    @Override
    public String convert(String blz, String kto) {
        String accNumber = IBANConverter.trimAccount(kto);
        if (accNumber.length() != 8 && accNumber.length() != 10) {
            return null;
        }
        if (accNumber.length() == 8) {
            char c5;
            if (accNumber.charAt(3) == '0' && accNumber.charAt(4) != '0') {
                return this.mod0000_00(blz, kto);
            }
            if (accNumber.startsWith("5046") && ((c5 = accNumber.charAt(4)) == '2' || c5 == '3' || c5 == '9')) {
                return this.mod0000_00(blz, kto);
            }
        }
        if (accNumber.length() == 10 && accNumber.charAt(3) == '4' && accNumber.charAt(4) == '4' && !accNumber.substring(5).equals("00000")) {
            return this.mod0000_00(blz, kto);
        }
        return null;
    }
}

