/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.Reverse;

@Reverse(blz=false)
public class Converter0036_00
extends IBANConverter {
    @Override
    public String convert(String blz, String kto) {
        if (!this.isBankConnectionValidOrUnknown(blz, kto)) {
            return null;
        }
        String accNumber = IBANConverter.trimAccount(kto);
        int length = accNumber.length();
        char firstChar = accNumber.charAt(0);
        if (length == 6 && firstChar != '9') {
            return this.calculateGermanIban("0" + accNumber + "000", "21050000");
        }
        if (length == 8 && (firstChar == '3' || firstChar == '4' || firstChar == '5')) {
            return this.calculateGermanIban("00" + accNumber, "21050000");
        }
        if (length == 9 && firstChar != '9') {
            return this.calculateGermanIban("0" + accNumber, "21050000");
        }
        if (length == 10) {
            if (firstChar == '1' || firstChar == '9') {
                return this.calculateGermanIban(accNumber, "21050000");
            }
            int leadingTwoDigits = Integer.parseInt(accNumber.substring(0, 2));
            if (leadingTwoDigits >= 30 && leadingTwoDigits < 71 || leadingTwoDigits == 85) {
                return this.calculateGermanIban(accNumber, "21050000");
            }
        }
        return null;
    }
}

