/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.account.iban;

import de.businesslogics.account.iban.BICConverter;
import de.businesslogics.account.iban.IBANConverter;
import de.businesslogics.account.iban.Reverse;
import de.businesslogics.account.iban.SEPABankConnection;
import de.businesslogics.account.iban.UCConverter;

@Reverse(blz=false)
public class Converter0035_00
extends BICConverter {
    @Override
    public SEPABankConnection convertAll(String blz, String kto) {
        String accNumber = IBANConverter.trimAccount(kto);
        String iban = null;
        if (accNumber.equals("9696")) {
            return new SEPABankConnection("HYVEDEMM455", "DE29790200761490196966");
        }
        if (accNumber.length() == 9 && accNumber.charAt(0) == '8') {
            return null;
        }
        if (!this.isBankConnectionValid(blz, accNumber)) {
            return null;
        }
        if (accNumber.length() == 10 && (blz = UCConverter.getBlz(accNumber.substring(0, 3))) == null) {
            return null;
        }
        iban = this.calculateGermanIban(accNumber, blz);
        if (iban == null) {
            return null;
        }
        return this.resultWithBLZ(iban, iban.substring(4, 12));
    }
}

